<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "lock_status" table
 */
#[Entity]
#[Table(name: "lock_status")]
class LockStatus extends AbstractEntity
{
    public static array $propertyNames = [
        'LockStatus' => 'lockStatus',
        'LockStatusDesc' => 'lockStatusDesc',
    ];

    #[Id]
    #[Column(name: "LockStatus", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $lockStatus;

    #[Column(name: "LockStatusDesc", type: "string")]
    private string $lockStatusDesc;

    public function getLockStatus(): int
    {
        return $this->lockStatus;
    }

    public function setLockStatus(int $value): static
    {
        $this->lockStatus = $value;
        return $this;
    }

    public function getLockStatusDesc(): string
    {
        return HtmlDecode($this->lockStatusDesc);
    }

    public function setLockStatusDesc(string $value): static
    {
        $this->lockStatusDesc = RemoveXss($value);
        return $this;
    }
}
