<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "inspection_view" table
 */
#[Entity]
#[Table(name: "inspection_view")]
class InspectionView extends AbstractEntity
{
    public static array $propertyNames = [
        'Latitude' => 'latitude',
        'Longitude' => 'longitude',
        'FieldType' => 'fieldType',
        'Ownership' => 'ownership',
        'FarmSize' => 'farmSize',
        'FarmSizeEstimated' => 'farmSizeEstimated',
        'TreesPlantedEstimated' => 'treesPlantedEstimated',
        'FarmSizeVerified' => 'farmSizeVerified',
        'TreesPlantedVerified' => 'treesPlantedVerified',
        'FarmNo' => 'farmNo',
        'NRC' => 'nrc',
        'FarmerName' => 'farmerName',
        'DOB' => 'dob',
        'Age' => 'age',
        'Gender' => 'gender',
        'MaritalStatus' => 'maritalStatus',
        'PhoneNo' => 'phoneNo',
        'Email' => 'email',
        'Dependants' => 'dependants',
        'MaleChildren' => 'maleChildren',
        'FemaleChildren' => 'femaleChildren',
        'HouseholdHead' => 'householdHead',
        'FarmerOrg' => 'farmerOrg',
        'FarmerOrgPosition' => 'farmerOrgPosition',
        'JoiningDate' => 'joiningDate',
        'CampName' => 'campName',
        'DistrictName' => 'districtName',
        'InspectionTransNo' => 'inspectionTransNo',
        'PlantsDead' => 'plantsDead',
        'PlantsVerifiedNo' => 'plantsVerifiedNo',
        'PlantsReplaced' => 'plantsReplaced',
        'FungicidesReceived' => 'fungicidesReceived',
        'PescticidesReceived' => 'pescticidesReceived',
        'DiseasePresence' => 'diseasePresence',
        'AvailableLand' => 'availableLand',
        'LandForCashewCleared' => 'landForCashewCleared',
        'HolesDug' => 'holesDug',
        'VerifiedSeedlingArea' => 'verifiedSeedlingArea',
        'OldTreesNo' => 'oldTreesNo',
        'InspectionReport' => 'inspectionReport',
        'InspectionDate' => 'inspectionDate',
        'InspectedBy' => 'inspectedBy',
        'AuthorisedBy' => 'authorisedBy',
    ];

    #[Column(name: "Latitude", type: "decimal")]
    private string $latitude;

    #[Column(name: "Longitude", type: "decimal")]
    private string $longitude;

    #[Column(name: "FieldType", type: "boolean", nullable: true)]
    private ?bool $fieldType;

    #[Column(name: "Ownership", type: "boolean", nullable: true)]
    private ?bool $ownership;

    #[Column(name: "FarmSize", type: "string", nullable: true)]
    private ?string $farmSize;

    #[Column(name: "FarmSizeEstimated", type: "float", nullable: true)]
    private ?float $farmSizeEstimated;

    #[Column(name: "TreesPlantedEstimated", type: "float", nullable: true)]
    private ?float $treesPlantedEstimated;

    #[Column(name: "FarmSizeVerified", type: "float", nullable: true)]
    private ?float $farmSizeVerified;

    #[Column(name: "TreesPlantedVerified", type: "float", nullable: true)]
    private ?float $treesPlantedVerified;

    #[Id]
    #[Column(name: "FarmNo", type: "integer")]
    #[GeneratedValue]
    private int $farmNo;

    #[Column(name: "NRC", type: "string")]
    private string $nrc;

    #[Column(name: "FarmerName", type: "string")]
    private string $farmerName;

    #[Column(name: "DOB", type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(name: "Age", type: "float", nullable: true)]
    private ?float $age;

    #[Column(name: "Gender", type: "string", nullable: true)]
    private ?string $gender;

    #[Column(name: "MaritalStatus", type: "boolean", nullable: true)]
    private ?bool $maritalStatus;

    #[Column(name: "PhoneNo", type: "string", nullable: true)]
    private ?string $phoneNo;

    #[Column(name: "Email", type: "string", nullable: true)]
    private ?string $email;

    #[Column(name: "Dependants", type: "boolean", nullable: true)]
    private ?bool $dependants;

    #[Column(name: "MaleChildren", type: "boolean", nullable: true)]
    private ?bool $maleChildren;

    #[Column(name: "FemaleChildren", type: "boolean", nullable: true)]
    private ?bool $femaleChildren;

    #[Column(name: "HouseholdHead", type: "boolean", nullable: true)]
    private ?bool $householdHead;

    #[Column(name: "FarmerOrg", type: "string", nullable: true)]
    private ?string $farmerOrg;

    #[Column(name: "FarmerOrgPosition", type: "string", nullable: true)]
    private ?string $farmerOrgPosition;

    #[Column(name: "JoiningDate", type: "date", nullable: true)]
    private ?DateTime $joiningDate;

    #[Column(name: "CampName", type: "string", nullable: true)]
    private ?string $campName;

    #[Column(name: "DistrictName", type: "string")]
    private string $districtName;

    #[Id]
    #[Column(name: "InspectionTransNo", type: "integer")]
    #[GeneratedValue]
    private int $inspectionTransNo;

    #[Column(name: "PlantsDead", type: "integer", nullable: true)]
    private ?int $plantsDead;

    #[Column(name: "PlantsVerifiedNo", type: "integer", nullable: true)]
    private ?int $plantsVerifiedNo;

    #[Column(name: "PlantsReplaced", type: "integer", nullable: true)]
    private ?int $plantsReplaced;

    #[Column(name: "FungicidesReceived", type: "float", nullable: true)]
    private ?float $fungicidesReceived;

    #[Column(name: "PescticidesReceived", type: "float", nullable: true)]
    private ?float $pescticidesReceived;

    #[Column(name: "DiseasePresence", type: "string", nullable: true)]
    private ?string $diseasePresence;

    #[Column(name: "AvailableLand", type: "float", nullable: true)]
    private ?float $availableLand;

    #[Column(name: "LandForCashewCleared", type: "float", nullable: true)]
    private ?float $landForCashewCleared;

    #[Column(name: "HolesDug", type: "integer", nullable: true)]
    private ?int $holesDug;

    #[Column(name: "VerifiedSeedlingArea", type: "float", nullable: true)]
    private ?float $verifiedSeedlingArea;

    #[Column(name: "OldTreesNo", type: "integer", nullable: true)]
    private ?int $oldTreesNo;

    #[Column(name: "InspectionReport", type: "text", nullable: true)]
    private ?string $inspectionReport;

    #[Column(name: "InspectionDate", type: "date")]
    private DateTime $inspectionDate;

    #[Column(name: "InspectedBy", type: "string")]
    private string $inspectedBy;

    #[Column(name: "AuthorisedBy", type: "string")]
    private string $authorisedBy;

    public function __construct(int $farmNo, int $inspectionTransNo)
    {
        $this->farmNo = $farmNo;
        $this->inspectionTransNo = $inspectionTransNo;
    }

    public function getLatitude(): string
    {
        return $this->latitude;
    }

    public function setLatitude(string $value): static
    {
        $this->latitude = $value;
        return $this;
    }

    public function getLongitude(): string
    {
        return $this->longitude;
    }

    public function setLongitude(string $value): static
    {
        $this->longitude = $value;
        return $this;
    }

    public function getFieldType(): ?bool
    {
        return $this->fieldType;
    }

    public function setFieldType(?bool $value): static
    {
        $this->fieldType = $value;
        return $this;
    }

    public function getOwnership(): ?bool
    {
        return $this->ownership;
    }

    public function setOwnership(?bool $value): static
    {
        $this->ownership = $value;
        return $this;
    }

    public function getFarmSize(): ?string
    {
        return HtmlDecode($this->farmSize);
    }

    public function setFarmSize(?string $value): static
    {
        $this->farmSize = RemoveXss($value);
        return $this;
    }

    public function getFarmSizeEstimated(): ?float
    {
        return $this->farmSizeEstimated;
    }

    public function setFarmSizeEstimated(?float $value): static
    {
        $this->farmSizeEstimated = $value;
        return $this;
    }

    public function getTreesPlantedEstimated(): ?float
    {
        return $this->treesPlantedEstimated;
    }

    public function setTreesPlantedEstimated(?float $value): static
    {
        $this->treesPlantedEstimated = $value;
        return $this;
    }

    public function getFarmSizeVerified(): ?float
    {
        return $this->farmSizeVerified;
    }

    public function setFarmSizeVerified(?float $value): static
    {
        $this->farmSizeVerified = $value;
        return $this;
    }

    public function getTreesPlantedVerified(): ?float
    {
        return $this->treesPlantedVerified;
    }

    public function setTreesPlantedVerified(?float $value): static
    {
        $this->treesPlantedVerified = $value;
        return $this;
    }

    public function getFarmNo(): int
    {
        return $this->farmNo;
    }

    public function setFarmNo(int $value): static
    {
        $this->farmNo = $value;
        return $this;
    }

    public function getNrc(): string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getFarmerName(): string
    {
        return HtmlDecode($this->farmerName);
    }

    public function setFarmerName(string $value): static
    {
        $this->farmerName = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getAge(): ?float
    {
        return $this->age;
    }

    public function setAge(?float $value): static
    {
        $this->age = $value;
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getMaritalStatus(): ?bool
    {
        return $this->maritalStatus;
    }

    public function setMaritalStatus(?bool $value): static
    {
        $this->maritalStatus = $value;
        return $this;
    }

    public function getPhoneNo(): ?string
    {
        return HtmlDecode($this->phoneNo);
    }

    public function setPhoneNo(?string $value): static
    {
        $this->phoneNo = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getDependants(): ?bool
    {
        return $this->dependants;
    }

    public function setDependants(?bool $value): static
    {
        $this->dependants = $value;
        return $this;
    }

    public function getMaleChildren(): ?bool
    {
        return $this->maleChildren;
    }

    public function setMaleChildren(?bool $value): static
    {
        $this->maleChildren = $value;
        return $this;
    }

    public function getFemaleChildren(): ?bool
    {
        return $this->femaleChildren;
    }

    public function setFemaleChildren(?bool $value): static
    {
        $this->femaleChildren = $value;
        return $this;
    }

    public function getHouseholdHead(): ?bool
    {
        return $this->householdHead;
    }

    public function setHouseholdHead(?bool $value): static
    {
        $this->householdHead = $value;
        return $this;
    }

    public function getFarmerOrg(): ?string
    {
        return HtmlDecode($this->farmerOrg);
    }

    public function setFarmerOrg(?string $value): static
    {
        $this->farmerOrg = RemoveXss($value);
        return $this;
    }

    public function getFarmerOrgPosition(): ?string
    {
        return HtmlDecode($this->farmerOrgPosition);
    }

    public function setFarmerOrgPosition(?string $value): static
    {
        $this->farmerOrgPosition = RemoveXss($value);
        return $this;
    }

    public function getJoiningDate(): ?DateTime
    {
        return $this->joiningDate;
    }

    public function setJoiningDate(?DateTime $value): static
    {
        $this->joiningDate = $value;
        return $this;
    }

    public function getCampName(): ?string
    {
        return HtmlDecode($this->campName);
    }

    public function setCampName(?string $value): static
    {
        $this->campName = RemoveXss($value);
        return $this;
    }

    public function getDistrictName(): string
    {
        return HtmlDecode($this->districtName);
    }

    public function setDistrictName(string $value): static
    {
        $this->districtName = RemoveXss($value);
        return $this;
    }

    public function getInspectionTransNo(): int
    {
        return $this->inspectionTransNo;
    }

    public function setInspectionTransNo(int $value): static
    {
        $this->inspectionTransNo = $value;
        return $this;
    }

    public function getPlantsDead(): ?int
    {
        return $this->plantsDead;
    }

    public function setPlantsDead(?int $value): static
    {
        $this->plantsDead = $value;
        return $this;
    }

    public function getPlantsVerifiedNo(): ?int
    {
        return $this->plantsVerifiedNo;
    }

    public function setPlantsVerifiedNo(?int $value): static
    {
        $this->plantsVerifiedNo = $value;
        return $this;
    }

    public function getPlantsReplaced(): ?int
    {
        return $this->plantsReplaced;
    }

    public function setPlantsReplaced(?int $value): static
    {
        $this->plantsReplaced = $value;
        return $this;
    }

    public function getFungicidesReceived(): ?float
    {
        return $this->fungicidesReceived;
    }

    public function setFungicidesReceived(?float $value): static
    {
        $this->fungicidesReceived = $value;
        return $this;
    }

    public function getPescticidesReceived(): ?float
    {
        return $this->pescticidesReceived;
    }

    public function setPescticidesReceived(?float $value): static
    {
        $this->pescticidesReceived = $value;
        return $this;
    }

    public function getDiseasePresence(): ?string
    {
        return HtmlDecode($this->diseasePresence);
    }

    public function setDiseasePresence(?string $value): static
    {
        $this->diseasePresence = RemoveXss($value);
        return $this;
    }

    public function getAvailableLand(): ?float
    {
        return $this->availableLand;
    }

    public function setAvailableLand(?float $value): static
    {
        $this->availableLand = $value;
        return $this;
    }

    public function getLandForCashewCleared(): ?float
    {
        return $this->landForCashewCleared;
    }

    public function setLandForCashewCleared(?float $value): static
    {
        $this->landForCashewCleared = $value;
        return $this;
    }

    public function getHolesDug(): ?int
    {
        return $this->holesDug;
    }

    public function setHolesDug(?int $value): static
    {
        $this->holesDug = $value;
        return $this;
    }

    public function getVerifiedSeedlingArea(): ?float
    {
        return $this->verifiedSeedlingArea;
    }

    public function setVerifiedSeedlingArea(?float $value): static
    {
        $this->verifiedSeedlingArea = $value;
        return $this;
    }

    public function getOldTreesNo(): ?int
    {
        return $this->oldTreesNo;
    }

    public function setOldTreesNo(?int $value): static
    {
        $this->oldTreesNo = $value;
        return $this;
    }

    public function getInspectionReport(): ?string
    {
        return HtmlDecode($this->inspectionReport);
    }

    public function setInspectionReport(?string $value): static
    {
        $this->inspectionReport = RemoveXss($value);
        return $this;
    }

    public function getInspectionDate(): DateTime
    {
        return $this->inspectionDate;
    }

    public function setInspectionDate(DateTime $value): static
    {
        $this->inspectionDate = $value;
        return $this;
    }

    public function getInspectedBy(): string
    {
        return HtmlDecode($this->inspectedBy);
    }

    public function setInspectedBy(string $value): static
    {
        $this->inspectedBy = RemoveXss($value);
        return $this;
    }

    public function getAuthorisedBy(): string
    {
        return HtmlDecode($this->authorisedBy);
    }

    public function setAuthorisedBy(string $value): static
    {
        $this->authorisedBy = RemoveXss($value);
        return $this;
    }
}
