<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "grn_view" table
 */
#[Entity]
#[Table(name: "grn_view")]
class GrnView extends AbstractEntity
{
    public static array $propertyNames = [
        'ProvinceName' => 'provinceName',
        'DistrictName' => 'districtName',
        'SeedlingsReceived' => 'seedlingsReceived',
        'SeedsReceived' => 'seedsReceived',
        'SeedType' => 'seedType',
        'GRN' => 'grn',
        'FarmingSeason' => 'farmingSeason',
    ];

    #[Column(name: "ProvinceName", type: "string")]
    private string $provinceName;

    #[Column(name: "DistrictName", type: "string")]
    private string $districtName;

    #[Column(name: "SeedlingsReceived", type: "float")]
    private float $seedlingsReceived;

    #[Column(name: "SeedsReceived", type: "float", nullable: true)]
    private ?float $seedsReceived;

    #[Column(name: "SeedType", type: "string")]
    private string $seedType;

    #[Id]
    #[Column(name: "GRN", type: "string")]
    private string $grn;

    #[Column(name: "FarmingSeason", type: "smallint")]
    private int $farmingSeason;

    public function getProvinceName(): string
    {
        return HtmlDecode($this->provinceName);
    }

    public function setProvinceName(string $value): static
    {
        $this->provinceName = RemoveXss($value);
        return $this;
    }

    public function getDistrictName(): string
    {
        return HtmlDecode($this->districtName);
    }

    public function setDistrictName(string $value): static
    {
        $this->districtName = RemoveXss($value);
        return $this;
    }

    public function getSeedlingsReceived(): float
    {
        return $this->seedlingsReceived;
    }

    public function setSeedlingsReceived(float $value): static
    {
        $this->seedlingsReceived = $value;
        return $this;
    }

    public function getSeedsReceived(): ?float
    {
        return $this->seedsReceived;
    }

    public function setSeedsReceived(?float $value): static
    {
        $this->seedsReceived = $value;
        return $this;
    }

    public function getSeedType(): string
    {
        return HtmlDecode($this->seedType);
    }

    public function setSeedType(string $value): static
    {
        $this->seedType = RemoveXss($value);
        return $this;
    }

    public function getGrn(): string
    {
        return $this->grn;
    }

    public function setGrn(string $value): static
    {
        $this->grn = $value;
        return $this;
    }

    public function getFarmingSeason(): int
    {
        return $this->farmingSeason;
    }

    public function setFarmingSeason(int $value): static
    {
        $this->farmingSeason = $value;
        return $this;
    }
}
