<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "grant_beneficiary" table
 */
#[Entity]
#[Table(name: "grant_beneficiary")]
class GrantBeneficiary extends AbstractEntity
{
    public static array $propertyNames = [
        'GrantNo' => 'grantNo',
        'NRC' => 'nrc',
        'AmountDisbursed' => 'amountDisbursed',
        'ApplicationDate' => 'applicationDate',
        'AmountAppliedFor' => 'amountAppliedFor',
        'ReplyDate' => 'replyDate',
        'Approved' => 'approved',
        'ReasonsForRejection' => 'reasonsForRejection',
        'Purpose' => 'purpose',
    ];

    #[Column(name: "GrantNo", type: "integer")]
    private int $grantNo;

    #[Column(name: "NRC", type: "string")]
    private string $nrc;

    #[Column(name: "AmountDisbursed", type: "float", nullable: true)]
    private ?float $amountDisbursed;

    #[Column(name: "ApplicationDate", type: "date", nullable: true)]
    private ?DateTime $applicationDate;

    #[Column(name: "AmountAppliedFor", type: "float", nullable: true)]
    private ?float $amountAppliedFor;

    #[Column(name: "ReplyDate", type: "date", nullable: true)]
    private ?DateTime $replyDate;

    #[Column(name: "Approved", type: "boolean", nullable: true)]
    private ?bool $approved;

    #[Column(name: "ReasonsForRejection", type: "string", nullable: true)]
    private ?string $reasonsForRejection;

    #[Column(name: "Purpose", type: "string", nullable: true)]
    private ?string $purpose;

    public function getGrantNo(): int
    {
        return $this->grantNo;
    }

    public function setGrantNo(int $value): static
    {
        $this->grantNo = $value;
        return $this;
    }

    public function getNrc(): string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getAmountDisbursed(): ?float
    {
        return $this->amountDisbursed;
    }

    public function setAmountDisbursed(?float $value): static
    {
        $this->amountDisbursed = $value;
        return $this;
    }

    public function getApplicationDate(): ?DateTime
    {
        return $this->applicationDate;
    }

    public function setApplicationDate(?DateTime $value): static
    {
        $this->applicationDate = $value;
        return $this;
    }

    public function getAmountAppliedFor(): ?float
    {
        return $this->amountAppliedFor;
    }

    public function setAmountAppliedFor(?float $value): static
    {
        $this->amountAppliedFor = $value;
        return $this;
    }

    public function getReplyDate(): ?DateTime
    {
        return $this->replyDate;
    }

    public function setReplyDate(?DateTime $value): static
    {
        $this->replyDate = $value;
        return $this;
    }

    public function getApproved(): ?bool
    {
        return $this->approved;
    }

    public function setApproved(?bool $value): static
    {
        $this->approved = $value;
        return $this;
    }

    public function getReasonsForRejection(): ?string
    {
        return HtmlDecode($this->reasonsForRejection);
    }

    public function setReasonsForRejection(?string $value): static
    {
        $this->reasonsForRejection = RemoveXss($value);
        return $this;
    }

    public function getPurpose(): ?string
    {
        return HtmlDecode($this->purpose);
    }

    public function setPurpose(?string $value): static
    {
        $this->purpose = RemoveXss($value);
        return $this;
    }
}
