<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "grant" table
 */
#[Entity]
#[Table(name: "`grant`")]
class Grant extends AbstractEntity
{
    public static array $propertyNames = [
        'GrantNo' => 'grantNo',
        'GrantRef' => 'grantRef',
        'SourceOfFunding' => 'sourceOfFunding',
        'GrantAmount' => 'grantAmount',
        'DisbursementDate' => 'disbursementDate',
    ];

    #[Column(name: "GrantNo", type: "integer")]
    private int $grantNo;

    #[Column(name: "GrantRef", type: "string", nullable: true)]
    private ?string $grantRef;

    #[Column(name: "SourceOfFunding", type: "string", nullable: true)]
    private ?string $sourceOfFunding;

    #[Column(name: "GrantAmount", type: "float", nullable: true)]
    private ?float $grantAmount;

    #[Column(name: "DisbursementDate", type: "date", nullable: true)]
    private ?DateTime $disbursementDate;

    public function getGrantNo(): int
    {
        return $this->grantNo;
    }

    public function setGrantNo(int $value): static
    {
        $this->grantNo = $value;
        return $this;
    }

    public function getGrantRef(): ?string
    {
        return HtmlDecode($this->grantRef);
    }

    public function setGrantRef(?string $value): static
    {
        $this->grantRef = RemoveXss($value);
        return $this;
    }

    public function getSourceOfFunding(): ?string
    {
        return HtmlDecode($this->sourceOfFunding);
    }

    public function setSourceOfFunding(?string $value): static
    {
        $this->sourceOfFunding = RemoveXss($value);
        return $this;
    }

    public function getGrantAmount(): ?float
    {
        return $this->grantAmount;
    }

    public function setGrantAmount(?float $value): static
    {
        $this->grantAmount = $value;
        return $this;
    }

    public function getDisbursementDate(): ?DateTime
    {
        return $this->disbursementDate;
    }

    public function setDisbursementDate(?DateTime $value): static
    {
        $this->disbursementDate = $value;
        return $this;
    }
}
