<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "goods_received_note" table
 */
#[Entity]
#[Table(name: "goods_received_note")]
class GoodsReceivedNote extends AbstractEntity
{
    public static array $propertyNames = [
        'SupplierCode' => 'supplierCode',
        'GRN' => 'grn',
        'District' => 'district',
        'FarmingSeason' => 'farmingSeason',
        'SeedlingsReceived' => 'seedlingsReceived',
        'SeedsReceived' => 'seedsReceived',
        'SeedType' => 'seedType',
        'GoodsDescription' => 'goodsDescription',
        'DateReceived' => 'dateReceived',
        'ReceivedBy' => 'receivedBy',
        'AuthorizedBy' => 'authorizedBy',
        'GoodsReceived' => 'goodsReceived',
    ];

    #[Id]
    #[Column(name: "SupplierCode", type: "integer")]
    private int $supplierCode;

    #[Id]
    #[Column(name: "GRN", type: "string")]
    private string $grn;

    #[Column(name: "District", type: "boolean", nullable: true)]
    private ?bool $district;

    #[Column(name: "FarmingSeason", type: "smallint")]
    private int $farmingSeason;

    #[Column(name: "SeedlingsReceived", type: "float")]
    private float $seedlingsReceived;

    #[Column(name: "SeedsReceived", type: "float", nullable: true)]
    private ?float $seedsReceived;

    #[Column(name: "SeedType", type: "string")]
    private string $seedType;

    #[Column(name: "GoodsDescription", type: "string", nullable: true)]
    private ?string $goodsDescription;

    #[Column(name: "DateReceived", type: "date")]
    private DateTime $dateReceived;

    #[Column(name: "ReceivedBy", type: "string")]
    private string $receivedBy;

    #[Column(name: "AuthorizedBy", type: "string")]
    private string $authorizedBy;

    #[Column(name: "GoodsReceived", type: "text", nullable: true)]
    private ?string $goodsReceived;

    public function __construct(int $supplierCode, string $grn)
    {
        $this->supplierCode = $supplierCode;
        $this->grn = $grn;
    }

    public function getSupplierCode(): int
    {
        return $this->supplierCode;
    }

    public function setSupplierCode(int $value): static
    {
        $this->supplierCode = $value;
        return $this;
    }

    public function getGrn(): string
    {
        return $this->grn;
    }

    public function setGrn(string $value): static
    {
        $this->grn = $value;
        return $this;
    }

    public function getDistrict(): ?bool
    {
        return $this->district;
    }

    public function setDistrict(?bool $value): static
    {
        $this->district = $value;
        return $this;
    }

    public function getFarmingSeason(): int
    {
        return $this->farmingSeason;
    }

    public function setFarmingSeason(int $value): static
    {
        $this->farmingSeason = $value;
        return $this;
    }

    public function getSeedlingsReceived(): float
    {
        return $this->seedlingsReceived;
    }

    public function setSeedlingsReceived(float $value): static
    {
        $this->seedlingsReceived = $value;
        return $this;
    }

    public function getSeedsReceived(): ?float
    {
        return $this->seedsReceived;
    }

    public function setSeedsReceived(?float $value): static
    {
        $this->seedsReceived = $value;
        return $this;
    }

    public function getSeedType(): string
    {
        return HtmlDecode($this->seedType);
    }

    public function setSeedType(string $value): static
    {
        $this->seedType = RemoveXss($value);
        return $this;
    }

    public function getGoodsDescription(): ?string
    {
        return HtmlDecode($this->goodsDescription);
    }

    public function setGoodsDescription(?string $value): static
    {
        $this->goodsDescription = RemoveXss($value);
        return $this;
    }

    public function getDateReceived(): DateTime
    {
        return $this->dateReceived;
    }

    public function setDateReceived(DateTime $value): static
    {
        $this->dateReceived = $value;
        return $this;
    }

    public function getReceivedBy(): string
    {
        return HtmlDecode($this->receivedBy);
    }

    public function setReceivedBy(string $value): static
    {
        $this->receivedBy = RemoveXss($value);
        return $this;
    }

    public function getAuthorizedBy(): string
    {
        return HtmlDecode($this->authorizedBy);
    }

    public function setAuthorizedBy(string $value): static
    {
        $this->authorizedBy = RemoveXss($value);
        return $this;
    }

    public function getGoodsReceived(): ?string
    {
        return HtmlDecode($this->goodsReceived);
    }

    public function setGoodsReceived(?string $value): static
    {
        $this->goodsReceived = RemoveXss($value);
        return $this;
    }
}
