<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "farmer_type" table
 */
#[Entity]
#[Table(name: "farmer_type")]
class FarmerType extends AbstractEntity
{
    public static array $propertyNames = [
        'FarmerType' => 'farmerType',
        'FarmerTypeName' => 'farmerTypeName',
    ];

    #[Id]
    #[Column(name: "FarmerType", type: "boolean", unique: true)]
    #[GeneratedValue]
    private bool $farmerType;

    #[Column(name: "FarmerTypeName", type: "string")]
    private string $farmerTypeName;

    public function getFarmerType(): bool
    {
        return $this->farmerType;
    }

    public function setFarmerType(bool $value): static
    {
        $this->farmerType = $value;
        return $this;
    }

    public function getFarmerTypeName(): string
    {
        return HtmlDecode($this->farmerTypeName);
    }

    public function setFarmerTypeName(string $value): static
    {
        $this->farmerTypeName = RemoveXss($value);
        return $this;
    }
}
