<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "farmer_organisation" table
 */
#[Entity]
#[Table(name: "farmer_organisation")]
class FarmerOrganisation extends AbstractEntity
{
    public static array $propertyNames = [
        'ProvinceCode' => 'provinceCode',
        'DistrictCode' => 'districtCode',
        'OrgCode' => 'orgCode',
        'FarmerOrganisation' => 'farmerOrganisation',
        'FOType' => 'foType',
        'PhysicalAddress' => 'physicalAddress',
        'PostalAddress' => 'postalAddress',
        'Phone' => 'phone',
        'Email' => 'email',
        'ID' => 'id',
    ];

    #[Column(name: "ProvinceCode", type: "integer")]
    private int $provinceCode = 0;

    #[Column(name: "DistrictCode", type: "integer")]
    private int $districtCode = 0;

    #[Column(name: "OrgCode", type: "integer")]
    private int $orgCode;

    #[Column(name: "FarmerOrganisation", type: "string", nullable: true)]
    private ?string $farmerOrganisation;

    #[Column(name: "FOType", type: "string", nullable: true)]
    private ?string $foType;

    #[Column(name: "PhysicalAddress", type: "string", nullable: true)]
    private ?string $physicalAddress;

    #[Column(name: "PostalAddress", type: "string", nullable: true)]
    private ?string $postalAddress;

    #[Column(name: "Phone", type: "string", nullable: true)]
    private ?string $phone;

    #[Column(name: "Email", type: "string", nullable: true)]
    private ?string $email;

    #[Id]
    #[Column(name: "ID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    public function getProvinceCode(): int
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(int $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getOrgCode(): int
    {
        return $this->orgCode;
    }

    public function setOrgCode(int $value): static
    {
        $this->orgCode = $value;
        return $this;
    }

    public function getFarmerOrganisation(): ?string
    {
        return HtmlDecode($this->farmerOrganisation);
    }

    public function setFarmerOrganisation(?string $value): static
    {
        $this->farmerOrganisation = RemoveXss($value);
        return $this;
    }

    public function getFoType(): ?string
    {
        return HtmlDecode($this->foType);
    }

    public function setFoType(?string $value): static
    {
        $this->foType = RemoveXss($value);
        return $this;
    }

    public function getPhysicalAddress(): ?string
    {
        return HtmlDecode($this->physicalAddress);
    }

    public function setPhysicalAddress(?string $value): static
    {
        $this->physicalAddress = RemoveXss($value);
        return $this;
    }

    public function getPostalAddress(): ?string
    {
        return HtmlDecode($this->postalAddress);
    }

    public function setPostalAddress(?string $value): static
    {
        $this->postalAddress = RemoveXss($value);
        return $this;
    }

    public function getPhone(): ?string
    {
        return HtmlDecode($this->phone);
    }

    public function setPhone(?string $value): static
    {
        $this->phone = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }
}
