<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "farmers" table
 */
#[Entity]
#[Table(name: "farmers")]
class Farmer extends AbstractEntity
{
    public static array $propertyNames = [
        'ProvinceCode' => 'provinceCode',
        'DistrictCode' => 'districtCode',
        'CampCode' => 'campCode',
        'VillageCode' => 'villageCode',
        'FarmerNo' => 'farmerNo',
        'NRC' => 'nrc',
        'FarmerName' => 'farmerName',
        'FarmerType' => 'farmerType',
        'DOB' => 'dob',
        'Age' => 'age',
        'Gender' => 'gender',
        'MaritalStatus' => 'maritalStatus',
        'PhoneNo' => 'phoneNo',
        'Email' => 'email',
        'Dependants' => 'dependants',
        'MaleChildren' => 'maleChildren',
        'FemaleChildren' => 'femaleChildren',
        'HouseholdHead' => 'householdHead',
        'FarmerOrg' => 'farmerOrg',
        'FarmerOrgPosition' => 'farmerOrgPosition',
        'JoiningDate' => 'joiningDate',
        'Comments' => 'comments',
    ];

    #[Column(name: "ProvinceCode", type: "integer")]
    private int $provinceCode = 0;

    #[Column(name: "DistrictCode", type: "integer")]
    private int $districtCode = 0;

    #[Column(name: "CampCode", type: "integer", nullable: true)]
    private ?int $campCode;

    #[Column(name: "VillageCode", type: "integer", nullable: true)]
    private ?int $villageCode;

    #[Column(name: "FarmerNo", type: "integer")]
    private int $farmerNo = 0;

    #[Column(name: "NRC", type: "string")]
    private string $nrc;

    #[Column(name: "FarmerName", type: "string", nullable: true)]
    private ?string $farmerName;

    #[Column(name: "FarmerType", type: "boolean", nullable: true)]
    private ?bool $farmerType = true;

    #[Column(name: "DOB", type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(name: "Age", type: "float", nullable: true)]
    private ?float $age;

    #[Column(name: "Gender", type: "string", nullable: true)]
    private ?string $gender;

    #[Column(name: "MaritalStatus", type: "boolean", nullable: true)]
    private ?bool $maritalStatus;

    #[Column(name: "PhoneNo", type: "string", nullable: true)]
    private ?string $phoneNo;

    #[Column(name: "Email", type: "string", nullable: true)]
    private ?string $email;

    #[Column(name: "Dependants", type: "boolean", nullable: true)]
    private ?bool $dependants;

    #[Column(name: "MaleChildren", type: "boolean", nullable: true)]
    private ?bool $maleChildren;

    #[Column(name: "FemaleChildren", type: "boolean", nullable: true)]
    private ?bool $femaleChildren;

    #[Column(name: "HouseholdHead", type: "boolean", nullable: true)]
    private ?bool $householdHead;

    #[Column(name: "FarmerOrg", type: "string", nullable: true)]
    private ?string $farmerOrg;

    #[Column(name: "FarmerOrgPosition", type: "string", nullable: true)]
    private ?string $farmerOrgPosition;

    #[Column(name: "JoiningDate", type: "date", nullable: true)]
    private ?DateTime $joiningDate;

    #[Column(name: "Comments", type: "string", nullable: true)]
    private ?string $comments;

    public function getProvinceCode(): int
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(int $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getCampCode(): ?int
    {
        return $this->campCode;
    }

    public function setCampCode(?int $value): static
    {
        $this->campCode = $value;
        return $this;
    }

    public function getVillageCode(): ?int
    {
        return $this->villageCode;
    }

    public function setVillageCode(?int $value): static
    {
        $this->villageCode = $value;
        return $this;
    }

    public function getFarmerNo(): int
    {
        return $this->farmerNo;
    }

    public function setFarmerNo(int $value): static
    {
        $this->farmerNo = $value;
        return $this;
    }

    public function getNrc(): string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getFarmerName(): ?string
    {
        return HtmlDecode($this->farmerName);
    }

    public function setFarmerName(?string $value): static
    {
        $this->farmerName = RemoveXss($value);
        return $this;
    }

    public function getFarmerType(): ?bool
    {
        return $this->farmerType;
    }

    public function setFarmerType(?bool $value): static
    {
        $this->farmerType = $value;
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getAge(): ?float
    {
        return $this->age;
    }

    public function setAge(?float $value): static
    {
        $this->age = $value;
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getMaritalStatus(): ?bool
    {
        return $this->maritalStatus;
    }

    public function setMaritalStatus(?bool $value): static
    {
        $this->maritalStatus = $value;
        return $this;
    }

    public function getPhoneNo(): ?string
    {
        return HtmlDecode($this->phoneNo);
    }

    public function setPhoneNo(?string $value): static
    {
        $this->phoneNo = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getDependants(): ?bool
    {
        return $this->dependants;
    }

    public function setDependants(?bool $value): static
    {
        $this->dependants = $value;
        return $this;
    }

    public function getMaleChildren(): ?bool
    {
        return $this->maleChildren;
    }

    public function setMaleChildren(?bool $value): static
    {
        $this->maleChildren = $value;
        return $this;
    }

    public function getFemaleChildren(): ?bool
    {
        return $this->femaleChildren;
    }

    public function setFemaleChildren(?bool $value): static
    {
        $this->femaleChildren = $value;
        return $this;
    }

    public function getHouseholdHead(): ?bool
    {
        return $this->householdHead;
    }

    public function setHouseholdHead(?bool $value): static
    {
        $this->householdHead = $value;
        return $this;
    }

    public function getFarmerOrg(): ?string
    {
        return HtmlDecode($this->farmerOrg);
    }

    public function setFarmerOrg(?string $value): static
    {
        $this->farmerOrg = RemoveXss($value);
        return $this;
    }

    public function getFarmerOrgPosition(): ?string
    {
        return HtmlDecode($this->farmerOrgPosition);
    }

    public function setFarmerOrgPosition(?string $value): static
    {
        $this->farmerOrgPosition = RemoveXss($value);
        return $this;
    }

    public function getJoiningDate(): ?DateTime
    {
        return $this->joiningDate;
    }

    public function setJoiningDate(?DateTime $value): static
    {
        $this->joiningDate = $value;
        return $this;
    }

    public function getComments(): ?string
    {
        return HtmlDecode($this->comments);
    }

    public function setComments(?string $value): static
    {
        $this->comments = RemoveXss($value);
        return $this;
    }
}
 $this;
    }
}
