<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "farm_view" table
 */
#[Entity]
#[Table(name: "farm_view")]
class FarmView extends AbstractEntity
{
    public static array $propertyNames = [
        'Age' => 'age',
        'Gender' => 'gender',
        'Province' => 'province',
        'District' => 'district',
        'NumberOfFields' => 'numberOfFields',
        'EstimatedTotalSize' => 'estimatedTotalSize',
        'VerifiedSize' => 'verifiedSize',
        'TreesPlantedEstimated' => 'treesPlantedEstimated',
        'TreesPlantedVerified' => 'treesPlantedVerified',
        'CampName' => 'campName',
    ];

    #[Column(name: "Age", type: "string", nullable: true)]
    private ?string $age;

    #[Column(name: "Gender", type: "string", nullable: true)]
    private ?string $gender;

    #[Column(name: "Province", type: "string")]
    private string $province;

    #[Column(name: "District", type: "string")]
    private string $district;

    #[Column(name: "NumberOfFields", type: "bigint")]
    private string $numberOfFields = "0";

    #[Column(name: "EstimatedTotalSize", type: "float", nullable: true)]
    private ?float $estimatedTotalSize;

    #[Column(name: "VerifiedSize", type: "float", nullable: true)]
    private ?float $verifiedSize;

    #[Column(name: "TreesPlantedEstimated", type: "float", nullable: true)]
    private ?float $treesPlantedEstimated;

    #[Column(name: "TreesPlantedVerified", type: "float", nullable: true)]
    private ?float $treesPlantedVerified;

    #[Column(name: "CampName", type: "string", nullable: true)]
    private ?string $campName;

    public function getAge(): ?string
    {
        return HtmlDecode($this->age);
    }

    public function setAge(?string $value): static
    {
        $this->age = RemoveXss($value);
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getProvince(): string
    {
        return HtmlDecode($this->province);
    }

    public function setProvince(string $value): static
    {
        $this->province = RemoveXss($value);
        return $this;
    }

    public function getDistrict(): string
    {
        return HtmlDecode($this->district);
    }

    public function setDistrict(string $value): static
    {
        $this->district = RemoveXss($value);
        return $this;
    }

    public function getNumberOfFields(): string
    {
        return $this->numberOfFields;
    }

    public function setNumberOfFields(string $value): static
    {
        $this->numberOfFields = $value;
        return $this;
    }

    public function getEstimatedTotalSize(): ?float
    {
        return $this->estimatedTotalSize;
    }

    public function setEstimatedTotalSize(?float $value): static
    {
        $this->estimatedTotalSize = $value;
        return $this;
    }

    public function getVerifiedSize(): ?float
    {
        return $this->verifiedSize;
    }

    public function setVerifiedSize(?float $value): static
    {
        $this->verifiedSize = $value;
        return $this;
    }

    public function getTreesPlantedEstimated(): ?float
    {
        return $this->treesPlantedEstimated;
    }

    public function setTreesPlantedEstimated(?float $value): static
    {
        $this->treesPlantedEstimated = $value;
        return $this;
    }

    public function getTreesPlantedVerified(): ?float
    {
        return $this->treesPlantedVerified;
    }

    public function setTreesPlantedVerified(?float $value): static
    {
        $this->treesPlantedVerified = $value;
        return $this;
    }

    public function getCampName(): ?string
    {
        return HtmlDecode($this->campName);
    }

    public function setCampName(?string $value): static
    {
        $this->campName = RemoveXss($value);
        return $this;
    }
}
