<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "farm_seed_delivered" table
 */
#[Entity]
#[Table(name: "farm_seed_delivered")]
class FarmSeedDelivered extends AbstractEntity
{
    public static array $propertyNames = [
        'ProvinceCode' => 'provinceCode',
        'DistrictCode' => 'districtCode',
        'CampCode' => 'campCode',
        'VillageCode' => 'villageCode',
        'NRC' => 'nrc',
        'FarmerNo' => 'farmerNo',
        'FarmNo' => 'farmNo',
        'TransDeliveryNo' => 'transDeliveryNo',
        'TreesDelivered' => 'treesDelivered',
        'SeedType' => 'seedType',
        'SourcesOfSeedlings' => 'sourcesOfSeedlings',
        'DeliveryDate' => 'deliveryDate',
        'PreparedBy' => 'preparedBy',
        'AuthorisedBy' => 'authorisedBy',
        'BatchNo' => 'batchNo',
    ];

    #[Column(name: "ProvinceCode", type: "integer")]
    private int $provinceCode = 0;

    #[Column(name: "DistrictCode", type: "integer")]
    private int $districtCode = 0;

    #[Column(name: "CampCode", type: "integer", nullable: true)]
    private ?int $campCode;

    #[Column(name: "VillageCode", type: "integer", nullable: true)]
    private ?int $villageCode;

    #[Column(name: "NRC", type: "string", nullable: true)]
    private ?string $nrc;

    #[Column(name: "FarmerNo", type: "integer", nullable: true)]
    private ?int $farmerNo;

    #[Column(name: "FarmNo", type: "integer")]
    private int $farmNo;

    #[Id]
    #[Column(name: "TransDeliveryNo", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $transDeliveryNo;

    #[Column(name: "TreesDelivered", type: "float")]
    private float $treesDelivered;

    #[Column(name: "SeedType", type: "string")]
    private string $seedType;

    #[Column(name: "SourcesOfSeedlings", type: "integer", nullable: true)]
    private ?int $sourcesOfSeedlings;

    #[Column(name: "DeliveryDate", type: "date")]
    private DateTime $deliveryDate;

    #[Column(name: "PreparedBy", type: "string")]
    private string $preparedBy;

    #[Column(name: "AuthorisedBy", type: "string")]
    private string $authorisedBy;

    #[Column(name: "BatchNo", type: "string", nullable: true)]
    private ?string $batchNo;

    public function getProvinceCode(): int
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(int $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getCampCode(): ?int
    {
        return $this->campCode;
    }

    public function setCampCode(?int $value): static
    {
        $this->campCode = $value;
        return $this;
    }

    public function getVillageCode(): ?int
    {
        return $this->villageCode;
    }

    public function setVillageCode(?int $value): static
    {
        $this->villageCode = $value;
        return $this;
    }

    public function getNrc(): ?string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(?string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getFarmerNo(): ?int
    {
        return $this->farmerNo;
    }

    public function setFarmerNo(?int $value): static
    {
        $this->farmerNo = $value;
        return $this;
    }

    public function getFarmNo(): int
    {
        return $this->farmNo;
    }

    public function setFarmNo(int $value): static
    {
        $this->farmNo = $value;
        return $this;
    }

    public function getTransDeliveryNo(): int
    {
        return $this->transDeliveryNo;
    }

    public function setTransDeliveryNo(int $value): static
    {
        $this->transDeliveryNo = $value;
        return $this;
    }

    public function getTreesDelivered(): float
    {
        return $this->treesDelivered;
    }

    public function setTreesDelivered(float $value): static
    {
        $this->treesDelivered = $value;
        return $this;
    }

    public function getSeedType(): string
    {
        return HtmlDecode($this->seedType);
    }

    public function setSeedType(string $value): static
    {
        $this->seedType = RemoveXss($value);
        return $this;
    }

    public function getSourcesOfSeedlings(): ?int
    {
        return $this->sourcesOfSeedlings;
    }

    public function setSourcesOfSeedlings(?int $value): static
    {
        $this->sourcesOfSeedlings = $value;
        return $this;
    }

    public function getDeliveryDate(): DateTime
    {
        return $this->deliveryDate;
    }

    public function setDeliveryDate(DateTime $value): static
    {
        $this->deliveryDate = $value;
        return $this;
    }

    public function getPreparedBy(): string
    {
        return HtmlDecode($this->preparedBy);
    }

    public function setPreparedBy(string $value): static
    {
        $this->preparedBy = RemoveXss($value);
        return $this;
    }

    public function getAuthorisedBy(): string
    {
        return HtmlDecode($this->authorisedBy);
    }

    public function setAuthorisedBy(string $value): static
    {
        $this->authorisedBy = RemoveXss($value);
        return $this;
    }

    public function getBatchNo(): ?string
    {
        return HtmlDecode($this->batchNo);
    }

    public function setBatchNo(?string $value): static
    {
        $this->batchNo = RemoveXss($value);
        return $this;
    }
}
