<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "farm_inspection" table
 */
#[Entity]
#[Table(name: "farm_inspection")]
class FarmInspection extends AbstractEntity
{
    public static array $propertyNames = [
        'ProvinceCode' => 'provinceCode',
        'DistrictCode' => 'districtCode',
        'CampCode' => 'campCode',
        'VillageCode' => 'villageCode',
        'NRC' => 'nrc',
        'FarmerNo' => 'farmerNo',
        'FarmNo' => 'farmNo',
        'InspectionTransNo' => 'inspectionTransNo',
        'PlantsDead' => 'plantsDead',
        'PlantsVerifiedNo' => 'plantsVerifiedNo',
        'PlantsReplaced' => 'plantsReplaced',
        'FungicidesReceived' => 'fungicidesReceived',
        'PescticidesReceived' => 'pescticidesReceived',
        'DiseasePresence' => 'diseasePresence',
        'AvailableLand' => 'availableLand',
        'LandForCashewCleared' => 'landForCashewCleared',
        'HolesDug' => 'holesDug',
        'VerifiedSeedlingArea' => 'verifiedSeedlingArea',
        'OldTreesNo' => 'oldTreesNo',
        'InspectionReport' => 'inspectionReport',
        'InspectionDate' => 'inspectionDate',
        'InspectedBy' => 'inspectedBy',
        'AuthorisedBy' => 'authorisedBy',
    ];

    #[Column(name: "ProvinceCode", type: "integer")]
    private int $provinceCode = 0;

    #[Column(name: "DistrictCode", type: "integer")]
    private int $districtCode = 0;

    #[Column(name: "CampCode", type: "integer", nullable: true)]
    private ?int $campCode;

    #[Column(name: "VillageCode", type: "integer", nullable: true)]
    private ?int $villageCode;

    #[Column(name: "NRC", type: "string", nullable: true)]
    private ?string $nrc;

    #[Column(name: "FarmerNo", type: "integer", nullable: true)]
    private ?int $farmerNo;

    #[Column(name: "FarmNo", type: "integer")]
    private int $farmNo;

    #[Id]
    #[Column(name: "InspectionTransNo", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $inspectionTransNo;

    #[Column(name: "PlantsDead", type: "integer", nullable: true)]
    private ?int $plantsDead;

    #[Column(name: "PlantsVerifiedNo", type: "integer", nullable: true)]
    private ?int $plantsVerifiedNo;

    #[Column(name: "PlantsReplaced", type: "integer", nullable: true)]
    private ?int $plantsReplaced;

    #[Column(name: "FungicidesReceived", type: "float", nullable: true)]
    private ?float $fungicidesReceived;

    #[Column(name: "PescticidesReceived", type: "float", nullable: true)]
    private ?float $pescticidesReceived;

    #[Column(name: "DiseasePresence", type: "string", nullable: true)]
    private ?string $diseasePresence;

    #[Column(name: "AvailableLand", type: "float", nullable: true)]
    private ?float $availableLand;

    #[Column(name: "LandForCashewCleared", type: "float", nullable: true)]
    private ?float $landForCashewCleared;

    #[Column(name: "HolesDug", type: "integer", nullable: true)]
    private ?int $holesDug;

    #[Column(name: "VerifiedSeedlingArea", type: "float", nullable: true)]
    private ?float $verifiedSeedlingArea;

    #[Column(name: "OldTreesNo", type: "integer", nullable: true)]
    private ?int $oldTreesNo;

    #[Column(name: "InspectionReport", type: "text", nullable: true)]
    private ?string $inspectionReport;

    #[Column(name: "InspectionDate", type: "date")]
    private DateTime $inspectionDate;

    #[Column(name: "InspectedBy", type: "string")]
    private string $inspectedBy;

    #[Column(name: "AuthorisedBy", type: "string")]
    private string $authorisedBy;

    public function getProvinceCode(): int
    {
        return $this->provinceCode;
    }

    public function setProvinceCode(int $value): static
    {
        $this->provinceCode = $value;
        return $this;
    }

    public function getDistrictCode(): int
    {
        return $this->districtCode;
    }

    public function setDistrictCode(int $value): static
    {
        $this->districtCode = $value;
        return $this;
    }

    public function getCampCode(): ?int
    {
        return $this->campCode;
    }

    public function setCampCode(?int $value): static
    {
        $this->campCode = $value;
        return $this;
    }

    public function getVillageCode(): ?int
    {
        return $this->villageCode;
    }

    public function setVillageCode(?int $value): static
    {
        $this->villageCode = $value;
        return $this;
    }

    public function getNrc(): ?string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(?string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getFarmerNo(): ?int
    {
        return $this->farmerNo;
    }

    public function setFarmerNo(?int $value): static
    {
        $this->farmerNo = $value;
        return $this;
    }

    public function getFarmNo(): int
    {
        return $this->farmNo;
    }

    public function setFarmNo(int $value): static
    {
        $this->farmNo = $value;
        return $this;
    }

    public function getInspectionTransNo(): int
    {
        return $this->inspectionTransNo;
    }

    public function setInspectionTransNo(int $value): static
    {
        $this->inspectionTransNo = $value;
        return $this;
    }

    public function getPlantsDead(): ?int
    {
        return $this->plantsDead;
    }

    public function setPlantsDead(?int $value): static
    {
        $this->plantsDead = $value;
        return $this;
    }

    public function getPlantsVerifiedNo(): ?int
    {
        return $this->plantsVerifiedNo;
    }

    public function setPlantsVerifiedNo(?int $value): static
    {
        $this->plantsVerifiedNo = $value;
        return $this;
    }

    public function getPlantsReplaced(): ?int
    {
        return $this->plantsReplaced;
    }

    public function setPlantsReplaced(?int $value): static
    {
        $this->plantsReplaced = $value;
        return $this;
    }

    public function getFungicidesReceived(): ?float
    {
        return $this->fungicidesReceived;
    }

    public function setFungicidesReceived(?float $value): static
    {
        $this->fungicidesReceived = $value;
        return $this;
    }

    public function getPescticidesReceived(): ?float
    {
        return $this->pescticidesReceived;
    }

    public function setPescticidesReceived(?float $value): static
    {
        $this->pescticidesReceived = $value;
        return $this;
    }

    public function getDiseasePresence(): ?string
    {
        return HtmlDecode($this->diseasePresence);
    }

    public function setDiseasePresence(?string $value): static
    {
        $this->diseasePresence = RemoveXss($value);
        return $this;
    }

    public function getAvailableLand(): ?float
    {
        return $this->availableLand;
    }

    public function setAvailableLand(?float $value): static
    {
        $this->availableLand = $value;
        return $this;
    }

    public function getLandForCashewCleared(): ?float
    {
        return $this->landForCashewCleared;
    }

    public function setLandForCashewCleared(?float $value): static
    {
        $this->landForCashewCleared = $value;
        return $this;
    }

    public function getHolesDug(): ?int
    {
        return $this->holesDug;
    }

    public function setHolesDug(?int $value): static
    {
        $this->holesDug = $value;
        return $this;
    }

    public function getVerifiedSeedlingArea(): ?float
    {
        return $this->verifiedSeedlingArea;
    }

    public function setVerifiedSeedlingArea(?float $value): static
    {
        $this->verifiedSeedlingArea = $value;
        return $this;
    }

    public function getOldTreesNo(): ?int
    {
        return $this->oldTreesNo;
    }

    public function setOldTreesNo(?int $value): static
    {
        $this->oldTreesNo = $value;
        return $this;
    }

    public function getInspectionReport(): ?string
    {
        return HtmlDecode($this->inspectionReport);
    }

    public function setInspectionReport(?string $value): static
    {
        $this->inspectionReport = RemoveXss($value);
        return $this;
    }

    public function getInspectionDate(): DateTime
    {
        return $this->inspectionDate;
    }

    public function setInspectionDate(DateTime $value): static
    {
        $this->inspectionDate = $value;
        return $this;
    }

    public function getInspectedBy(): string
    {
        return HtmlDecode($this->inspectedBy);
    }

    public function setInspectedBy(string $value): static
    {
        $this->inspectedBy = RemoveXss($value);
        return $this;
    }

    public function getAuthorisedBy(): string
    {
        return HtmlDecode($this->authorisedBy);
    }

    public function setAuthorisedBy(string $value): static
    {
        $this->authorisedBy = RemoveXss($value);
        return $this;
    }
}
