<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "current_ref" table
 */
#[Entity]
#[Table(name: "current_ref")]
class CurrentRef extends AbstractEntity
{
    public static array $propertyNames = [
        'ID' => 'id',
        'PlanYear' => 'planYear',
        'PlanMonth' => 'planMonth',
        'DaysAfterMonthEnd' => 'daysAfterMonthEnd',
        'PlanClosingDate' => 'planClosingDate',
        'CurrentMonthClosingDate' => 'currentMonthClosingDate',
    ];

    #[Id]
    #[Column(name: "ID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "PlanYear", type: "smallint")]
    private int $planYear;

    #[Column(name: "PlanMonth", type: "boolean")]
    private bool $planMonth;

    #[Column(name: "DaysAfterMonthEnd", type: "integer", nullable: true)]
    private ?int $daysAfterMonthEnd;

    #[Column(name: "PlanClosingDate", type: "date", nullable: true)]
    private ?DateTime $planClosingDate;

    #[Column(name: "CurrentMonthClosingDate", type: "date")]
    private DateTime $currentMonthClosingDate;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPlanYear(): int
    {
        return $this->planYear;
    }

    public function setPlanYear(int $value): static
    {
        $this->planYear = $value;
        return $this;
    }

    public function getPlanMonth(): bool
    {
        return $this->planMonth;
    }

    public function setPlanMonth(bool $value): static
    {
        $this->planMonth = $value;
        return $this;
    }

    public function getDaysAfterMonthEnd(): ?int
    {
        return $this->daysAfterMonthEnd;
    }

    public function setDaysAfterMonthEnd(?int $value): static
    {
        $this->daysAfterMonthEnd = $value;
        return $this;
    }

    public function getPlanClosingDate(): ?DateTime
    {
        return $this->planClosingDate;
    }

    public function setPlanClosingDate(?DateTime $value): static
    {
        $this->planClosingDate = $value;
        return $this;
    }

    public function getCurrentMonthClosingDate(): DateTime
    {
        return $this->currentMonthClosingDate;
    }

    public function setCurrentMonthClosingDate(DateTime $value): static
    {
        $this->currentMonthClosingDate = $value;
        return $this;
    }
}
