<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "beneficiary_by_supplier" table
 */
#[Entity]
#[Table(name: "beneficiary_by_supplier")]
class BeneficiaryBySupplier extends AbstractEntity
{
    public static array $propertyNames = [
        'DistrictName' => 'districtName',
        'NoOfBeneficiaries' => 'noOfBeneficiaries',
        'GRN' => 'grn',
        'Seedlings' => 'seedlings',
        'FarmingSeason' => 'farmingSeason',
        'SeedType' => 'seedType',
        'NurseryName' => 'nurseryName',
        'Age' => 'age',
        'Gender' => 'gender',
    ];

    #[Column(name: "DistrictName", type: "string")]
    private string $districtName;

    #[Column(name: "NoOfBeneficiaries", type: "bigint")]
    private string $noOfBeneficiaries = "0";

    #[Column(name: "GRN", type: "string", nullable: true)]
    private ?string $grn;

    #[Column(name: "Seedlings", type: "float", nullable: true)]
    private ?float $seedlings;

    #[Column(name: "FarmingSeason", type: "smallint", nullable: true)]
    private ?int $farmingSeason;

    #[Column(name: "SeedType", type: "string", nullable: true)]
    private ?string $seedType;

    #[Column(name: "NurseryName", type: "string", nullable: true)]
    private ?string $nurseryName;

    #[Column(name: "Age", type: "string", nullable: true)]
    private ?string $age;

    #[Column(name: "Gender", type: "string", nullable: true)]
    private ?string $gender;

    public function getDistrictName(): string
    {
        return HtmlDecode($this->districtName);
    }

    public function setDistrictName(string $value): static
    {
        $this->districtName = RemoveXss($value);
        return $this;
    }

    public function getNoOfBeneficiaries(): string
    {
        return $this->noOfBeneficiaries;
    }

    public function setNoOfBeneficiaries(string $value): static
    {
        $this->noOfBeneficiaries = $value;
        return $this;
    }

    public function getGrn(): ?string
    {
        return HtmlDecode($this->grn);
    }

    public function setGrn(?string $value): static
    {
        $this->grn = RemoveXss($value);
        return $this;
    }

    public function getSeedlings(): ?float
    {
        return $this->seedlings;
    }

    public function setSeedlings(?float $value): static
    {
        $this->seedlings = $value;
        return $this;
    }

    public function getFarmingSeason(): ?int
    {
        return $this->farmingSeason;
    }

    public function setFarmingSeason(?int $value): static
    {
        $this->farmingSeason = $value;
        return $this;
    }

    public function getSeedType(): ?string
    {
        return HtmlDecode($this->seedType);
    }

    public function setSeedType(?string $value): static
    {
        $this->seedType = RemoveXss($value);
        return $this;
    }

    public function getNurseryName(): ?string
    {
        return HtmlDecode($this->nurseryName);
    }

    public function setNurseryName(?string $value): static
    {
        $this->nurseryName = RemoveXss($value);
        return $this;
    }

    public function getAge(): ?string
    {
        return HtmlDecode($this->age);
    }

    public function setAge(?string $value): static
    {
        $this->age = RemoveXss($value);
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }
}
