<?php

namespace PHPMaker2024\cidp24\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\cidp24\AbstractEntity;
use PHPMaker2024\cidp24\AdvancedSecurity;
use PHPMaker2024\cidp24\UserProfile;
use function PHPMaker2024\cidp24\Config;
use function PHPMaker2024\cidp24\EntityManager;
use function PHPMaker2024\cidp24\RemoveXss;
use function PHPMaker2024\cidp24\HtmlDecode;
use function PHPMaker2024\cidp24\EncryptPassword;

/**
 * Entity class for "beneficiary_by_gender_view" table
 */
#[Entity]
#[Table(name: "beneficiary_by_gender_view")]
class BeneficiaryByGenderView extends AbstractEntity
{
    public static array $propertyNames = [
        'DistrictName' => 'districtName',
        'FarmerNo' => 'farmerNo',
        'NRC' => 'nrc',
        'FarmerName' => 'farmerName',
        'FarmerType' => 'farmerType',
        'DOB' => 'dob',
        'Age' => 'age',
        'Gender' => 'gender',
        'MaritalStatus' => 'maritalStatus',
        'FarmerOrganisation' => 'farmerOrganisation',
        'FarmNo' => 'farmNo',
        'FieldType' => 'fieldType',
        'FarmSizeEstimated' => 'farmSizeEstimated',
        'TreesPlantedEstimated' => 'treesPlantedEstimated',
        'TreesPlantedVerified' => 'treesPlantedVerified',
        'FarmSizeVerified' => 'farmSizeVerified',
        'TransNo' => 'transNo',
        'GRN' => 'grn',
        'TreesAllocated' => 'treesAllocated',
        'EstimatedLandSizePlanted' => 'estimatedLandSizePlanted',
        'FarmingSeason' => 'farmingSeason',
        'SeedType' => 'seedType',
        'SourcesOfSeedlings' => 'sourcesOfSeedlings',
        'FarmerTypeName' => 'farmerTypeName',
        'NurseryName' => 'nurseryName',
    ];

    #[Column(name: "DistrictName", type: "string")]
    private string $districtName;

    #[Id]
    #[Column(name: "FarmerNo", type: "integer")]
    #[GeneratedValue]
    private int $farmerNo;

    #[Column(name: "NRC", type: "string")]
    private string $nrc;

    #[Column(name: "FarmerName", type: "string")]
    private string $farmerName;

    #[Column(name: "FarmerType", type: "boolean")]
    private bool $farmerType = true;

    #[Column(name: "DOB", type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(name: "Age", type: "string", nullable: true)]
    private ?string $age;

    #[Column(name: "Gender", type: "string", nullable: true)]
    private ?string $gender;

    #[Column(name: "MaritalStatus", type: "boolean", nullable: true)]
    private ?bool $maritalStatus;

    #[Column(name: "FarmerOrganisation", type: "string", nullable: true)]
    private ?string $farmerOrganisation;

    #[Id]
    #[Column(name: "FarmNo", type: "integer")]
    #[GeneratedValue]
    private int $farmNo;

    #[Column(name: "FieldType", type: "boolean", nullable: true)]
    private ?bool $fieldType;

    #[Column(name: "FarmSizeEstimated", type: "float", nullable: true)]
    private ?float $farmSizeEstimated;

    #[Column(name: "TreesPlantedEstimated", type: "float", nullable: true)]
    private ?float $treesPlantedEstimated;

    #[Column(name: "TreesPlantedVerified", type: "float", nullable: true)]
    private ?float $treesPlantedVerified;

    #[Column(name: "FarmSizeVerified", type: "float", nullable: true)]
    private ?float $farmSizeVerified;

    #[Id]
    #[Column(name: "TransNo", type: "integer")]
    #[GeneratedValue]
    private int $transNo;

    #[Column(name: "GRN", type: "string", nullable: true)]
    private ?string $grn;

    #[Column(name: "TreesAllocated", type: "string", nullable: true)]
    private ?string $treesAllocated;

    #[Column(name: "EstimatedLandSizePlanted", type: "float", nullable: true)]
    private ?float $estimatedLandSizePlanted;

    #[Column(name: "FarmingSeason", type: "smallint", nullable: true)]
    private ?int $farmingSeason;

    #[Column(name: "SeedType", type: "string", nullable: true)]
    private ?string $seedType;

    #[Column(name: "SourcesOfSeedlings", type: "integer", nullable: true)]
    private ?int $sourcesOfSeedlings;

    #[Column(name: "FarmerTypeName", type: "string")]
    private string $farmerTypeName;

    #[Column(name: "NurseryName", type: "string", nullable: true)]
    private ?string $nurseryName;

    public function __construct(int $farmerNo, int $farmNo, int $transNo)
    {
        $this->farmerNo = $farmerNo;
        $this->farmNo = $farmNo;
        $this->transNo = $transNo;
    }

    public function getDistrictName(): string
    {
        return HtmlDecode($this->districtName);
    }

    public function setDistrictName(string $value): static
    {
        $this->districtName = RemoveXss($value);
        return $this;
    }

    public function getFarmerNo(): int
    {
        return $this->farmerNo;
    }

    public function setFarmerNo(int $value): static
    {
        $this->farmerNo = $value;
        return $this;
    }

    public function getNrc(): string
    {
        return HtmlDecode($this->nrc);
    }

    public function setNrc(string $value): static
    {
        $this->nrc = RemoveXss($value);
        return $this;
    }

    public function getFarmerName(): string
    {
        return HtmlDecode($this->farmerName);
    }

    public function setFarmerName(string $value): static
    {
        $this->farmerName = RemoveXss($value);
        return $this;
    }

    public function getFarmerType(): bool
    {
        return $this->farmerType;
    }

    public function setFarmerType(bool $value): static
    {
        $this->farmerType = $value;
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getAge(): ?string
    {
        return HtmlDecode($this->age);
    }

    public function setAge(?string $value): static
    {
        $this->age = RemoveXss($value);
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getMaritalStatus(): ?bool
    {
        return $this->maritalStatus;
    }

    public function setMaritalStatus(?bool $value): static
    {
        $this->maritalStatus = $value;
        return $this;
    }

    public function getFarmerOrganisation(): ?string
    {
        return HtmlDecode($this->farmerOrganisation);
    }

    public function setFarmerOrganisation(?string $value): static
    {
        $this->farmerOrganisation = RemoveXss($value);
        return $this;
    }

    public function getFarmNo(): int
    {
        return $this->farmNo;
    }

    public function setFarmNo(int $value): static
    {
        $this->farmNo = $value;
        return $this;
    }

    public function getFieldType(): ?bool
    {
        return $this->fieldType;
    }

    public function setFieldType(?bool $value): static
    {
        $this->fieldType = $value;
        return $this;
    }

    public function getFarmSizeEstimated(): ?float
    {
        return $this->farmSizeEstimated;
    }

    public function setFarmSizeEstimated(?float $value): static
    {
        $this->farmSizeEstimated = $value;
        return $this;
    }

    public function getTreesPlantedEstimated(): ?float
    {
        return $this->treesPlantedEstimated;
    }

    public function setTreesPlantedEstimated(?float $value): static
    {
        $this->treesPlantedEstimated = $value;
        return $this;
    }

    public function getTreesPlantedVerified(): ?float
    {
        return $this->treesPlantedVerified;
    }

    public function setTreesPlantedVerified(?float $value): static
    {
        $this->treesPlantedVerified = $value;
        return $this;
    }

    public function getFarmSizeVerified(): ?float
    {
        return $this->farmSizeVerified;
    }

    public function setFarmSizeVerified(?float $value): static
    {
        $this->farmSizeVerified = $value;
        return $this;
    }

    public function getTransNo(): int
    {
        return $this->transNo;
    }

    public function setTransNo(int $value): static
    {
        $this->transNo = $value;
        return $this;
    }

    public function getGrn(): ?string
    {
        return HtmlDecode($this->grn);
    }

    public function setGrn(?string $value): static
    {
        $this->grn = RemoveXss($value);
        return $this;
    }

    public function getTreesAllocated(): ?string
    {
        return HtmlDecode($this->treesAllocated);
    }

    public function setTreesAllocated(?string $value): static
    {
        $this->treesAllocated = RemoveXss($value);
        return $this;
    }

    public function getEstimatedLandSizePlanted(): ?float
    {
        return $this->estimatedLandSizePlanted;
    }

    public function setEstimatedLandSizePlanted(?float $value): static
    {
        $this->estimatedLandSizePlanted = $value;
        return $this;
    }

    public function getFarmingSeason(): ?int
    {
        return $this->farmingSeason;
    }

    public function setFarmingSeason(?int $value): static
    {
        $this->farmingSeason = $value;
        return $this;
    }

    public function getSeedType(): ?string
    {
        return HtmlDecode($this->seedType);
    }

    public function setSeedType(?string $value): static
    {
        $this->seedType = RemoveXss($value);
        return $this;
    }

    public function getSourcesOfSeedlings(): ?int
    {
        return $this->sourcesOfSeedlings;
    }

    public function setSourcesOfSeedlings(?int $value): static
    {
        $this->sourcesOfSeedlings = $value;
        return $this;
    }

    public function getFarmerTypeName(): string
    {
        return HtmlDecode($this->farmerTypeName);
    }

    public function setFarmerTypeName(string $value): static
    {
        $this->farmerTypeName = RemoveXss($value);
        return $this;
    }

    public function getNurseryName(): ?string
    {
        return HtmlDecode($this->nurseryName);
    }

    public function setNurseryName(?string $value): static
    {
        $this->nurseryName = RemoveXss($value);
        return $this;
    }
}
