<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for SummaryFarmActivity
 */
class SummaryFarmActivity extends ReportTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";
    public $ShowGroupHeaderAsRow = false;
    public $ShowCompactSummaryFooter = true;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $FarmerNo;
    public $NRC;
    public $FarmerName;
    public $Age;
    public $Gender;
    public $MaritalStatus;
    public $PhoneNo;
    public $_Email;
    public $Dependants;
    public $MaleChildren;
    public $FemaleChildren;
    public $HouseholdHead;
    public $FarmerOrg;
    public $FarmerOrgPosition;
    public $JoiningDate;
    public $Comments;
    public $ProvinceCode;
    public $DistrictCode;
    public $CampCode;
    public $VillageCode;
    public $FarmNo;
    public $Coordinates;
    public $Latitude;
    public $Longitude;
    public $FieldType;
    public $Ownership;
    public $FarmSize;
    public $TreesPlantedEstimated;
    public $FarmSizeVerified;
    public $TreesPlantedVerified;
    public $SourcesOfSeedlings;
    public $InspecationReport;
    public $ClearedLand;
    public $SeedlingsAllocated;
    public $OldTrees;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "SummaryFarmActivity";
        $this->TableName = 'SummaryFarmActivity';
        $this->TableType = "REPORT";
        $this->TableReportType = "summary"; // Report Type
        $this->ReportSourceTable = 'famer_farm_view'; // Report source table
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (report only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions

        // FarmerNo
        $this->FarmerNo = new ReportField(
            $this, // Table
            'x_FarmerNo', // Variable name
            'FarmerNo', // Name
            '`FarmerNo`', // Expression
            '`FarmerNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->FarmerNo->InputTextType = "text";
        $this->FarmerNo->Raw = true;
        $this->FarmerNo->IsAutoIncrement = true; // Autoincrement field
        $this->FarmerNo->IsPrimaryKey = true; // Primary key field
        $this->FarmerNo->Nullable = false; // NOT NULL field
        $this->FarmerNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmerNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->FarmerNo->SourceTableVar = 'famer_farm_view';
        $this->Fields['FarmerNo'] = &$this->FarmerNo;

        // NRC
        $this->NRC = new ReportField(
            $this, // Table
            'x_NRC', // Variable name
            'NRC', // Name
            '`NRC`', // Expression
            '`NRC`', // Basic search expression
            200, // Type
            13, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NRC`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NRC->InputTextType = "text";
        $this->NRC->Nullable = false; // NOT NULL field
        $this->NRC->Required = true; // Required field
        $this->NRC->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->NRC->SourceTableVar = 'famer_farm_view';
        $this->Fields['NRC'] = &$this->NRC;

        // FarmerName
        $this->FarmerName = new ReportField(
            $this, // Table
            'x_FarmerName', // Variable name
            'FarmerName', // Name
            '`FarmerName`', // Expression
            '`FarmerName`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerName->InputTextType = "text";
        $this->FarmerName->Nullable = false; // NOT NULL field
        $this->FarmerName->Required = true; // Required field
        $this->FarmerName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->FarmerName->SourceTableVar = 'famer_farm_view';
        $this->Fields['FarmerName'] = &$this->FarmerName;

        // Age
        $this->Age = new ReportField(
            $this, // Table
            'x_Age', // Variable name
            'Age', // Name
            '`Age`', // Expression
            '`Age`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Age`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Age->InputTextType = "text";
        $this->Age->Raw = true;
        $this->Age->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Age->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Age->SourceTableVar = 'famer_farm_view';
        $this->Fields['Age'] = &$this->Age;

        // Gender
        $this->Gender = new ReportField(
            $this, // Table
            'x_Gender', // Variable name
            'Gender', // Name
            '`Gender`', // Expression
            '`Gender`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Gender`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Gender->InputTextType = "text";
        $this->Gender->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Gender->SourceTableVar = 'famer_farm_view';
        $this->Fields['Gender'] = &$this->Gender;

        // MaritalStatus
        $this->MaritalStatus = new ReportField(
            $this, // Table
            'x_MaritalStatus', // Variable name
            'MaritalStatus', // Name
            '`MaritalStatus`', // Expression
            '`MaritalStatus`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`MaritalStatus`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->MaritalStatus->InputTextType = "text";
        $this->MaritalStatus->Raw = true;
        $this->MaritalStatus->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MaritalStatus->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->MaritalStatus->SourceTableVar = 'famer_farm_view';
        $this->Fields['MaritalStatus'] = &$this->MaritalStatus;

        // PhoneNo
        $this->PhoneNo = new ReportField(
            $this, // Table
            'x_PhoneNo', // Variable name
            'PhoneNo', // Name
            '`PhoneNo`', // Expression
            '`PhoneNo`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PhoneNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PhoneNo->InputTextType = "text";
        $this->PhoneNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->PhoneNo->SourceTableVar = 'famer_farm_view';
        $this->Fields['PhoneNo'] = &$this->PhoneNo;

        // Email
        $this->_Email = new ReportField(
            $this, // Table
            'x__Email', // Variable name
            'Email', // Name
            '`Email`', // Expression
            '`Email`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_Email->InputTextType = "text";
        $this->_Email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->_Email->SourceTableVar = 'famer_farm_view';
        $this->Fields['Email'] = &$this->_Email;

        // Dependants
        $this->Dependants = new ReportField(
            $this, // Table
            'x_Dependants', // Variable name
            'Dependants', // Name
            '`Dependants`', // Expression
            '`Dependants`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Dependants`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Dependants->InputTextType = "text";
        $this->Dependants->Raw = true;
        $this->Dependants->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Dependants->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Dependants->SourceTableVar = 'famer_farm_view';
        $this->Fields['Dependants'] = &$this->Dependants;

        // MaleChildren
        $this->MaleChildren = new ReportField(
            $this, // Table
            'x_MaleChildren', // Variable name
            'MaleChildren', // Name
            '`MaleChildren`', // Expression
            '`MaleChildren`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`MaleChildren`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->MaleChildren->InputTextType = "text";
        $this->MaleChildren->Raw = true;
        $this->MaleChildren->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MaleChildren->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->MaleChildren->SourceTableVar = 'famer_farm_view';
        $this->Fields['MaleChildren'] = &$this->MaleChildren;

        // FemaleChildren
        $this->FemaleChildren = new ReportField(
            $this, // Table
            'x_FemaleChildren', // Variable name
            'FemaleChildren', // Name
            '`FemaleChildren`', // Expression
            '`FemaleChildren`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FemaleChildren`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FemaleChildren->InputTextType = "text";
        $this->FemaleChildren->Raw = true;
        $this->FemaleChildren->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FemaleChildren->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->FemaleChildren->SourceTableVar = 'famer_farm_view';
        $this->Fields['FemaleChildren'] = &$this->FemaleChildren;

        // HouseholdHead
        $this->HouseholdHead = new ReportField(
            $this, // Table
            'x_HouseholdHead', // Variable name
            'HouseholdHead', // Name
            '`HouseholdHead`', // Expression
            '`HouseholdHead`', // Basic search expression
            16, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`HouseholdHead`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->HouseholdHead->InputTextType = "text";
        $this->HouseholdHead->Raw = true;
        $this->HouseholdHead->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->HouseholdHead->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->HouseholdHead->SourceTableVar = 'famer_farm_view';
        $this->Fields['HouseholdHead'] = &$this->HouseholdHead;

        // FarmerOrg
        $this->FarmerOrg = new ReportField(
            $this, // Table
            'x_FarmerOrg', // Variable name
            'FarmerOrg', // Name
            '`FarmerOrg`', // Expression
            '`FarmerOrg`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerOrg`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerOrg->InputTextType = "text";
        $this->FarmerOrg->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->FarmerOrg->SourceTableVar = 'famer_farm_view';
        $this->Fields['FarmerOrg'] = &$this->FarmerOrg;

        // FarmerOrgPosition
        $this->FarmerOrgPosition = new ReportField(
            $this, // Table
            'x_FarmerOrgPosition', // Variable name
            'FarmerOrgPosition', // Name
            '`FarmerOrgPosition`', // Expression
            '`FarmerOrgPosition`', // Basic search expression
            200, // Type
            40, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerOrgPosition`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerOrgPosition->InputTextType = "text";
        $this->FarmerOrgPosition->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->FarmerOrgPosition->SourceTableVar = 'famer_farm_view';
        $this->Fields['FarmerOrgPosition'] = &$this->FarmerOrgPosition;

        // JoiningDate
        $this->JoiningDate = new ReportField(
            $this, // Table
            'x_JoiningDate', // Variable name
            'JoiningDate', // Name
            '`JoiningDate`', // Expression
            CastDateFieldForLike("`JoiningDate`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`JoiningDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->JoiningDate->InputTextType = "text";
        $this->JoiningDate->Raw = true;
        $this->JoiningDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->JoiningDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->JoiningDate->SourceTableVar = 'famer_farm_view';
        $this->Fields['JoiningDate'] = &$this->JoiningDate;

        // Comments
        $this->Comments = new ReportField(
            $this, // Table
            'x_Comments', // Variable name
            'Comments', // Name
            '`Comments`', // Expression
            '`Comments`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Comments`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Comments->InputTextType = "text";
        $this->Comments->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Comments->SourceTableVar = 'famer_farm_view';
        $this->Fields['Comments'] = &$this->Comments;

        // ProvinceCode
        $this->ProvinceCode = new ReportField(
            $this, // Table
            'x_ProvinceCode', // Variable name
            'ProvinceCode', // Name
            '`ProvinceCode`', // Expression
            '`ProvinceCode`', // Basic search expression
            3, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProvinceCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ProvinceCode->addMethod("getDefault", fn() => 0);
        $this->ProvinceCode->InputTextType = "text";
        $this->ProvinceCode->Raw = true;
        $this->ProvinceCode->Nullable = false; // NOT NULL field
        $this->ProvinceCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ProvinceCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->ProvinceCode->SourceTableVar = 'famer_farm_view';
        $this->Fields['ProvinceCode'] = &$this->ProvinceCode;

        // DistrictCode
        $this->DistrictCode = new ReportField(
            $this, // Table
            'x_DistrictCode', // Variable name
            'DistrictCode', // Name
            '`DistrictCode`', // Expression
            '`DistrictCode`', // Basic search expression
            3, // Type
            2, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`DistrictCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DistrictCode->addMethod("getDefault", fn() => 0);
        $this->DistrictCode->InputTextType = "text";
        $this->DistrictCode->Raw = true;
        $this->DistrictCode->Nullable = false; // NOT NULL field
        $this->DistrictCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->DistrictCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->DistrictCode->SourceTableVar = 'famer_farm_view';
        $this->Fields['DistrictCode'] = &$this->DistrictCode;

        // CampCode
        $this->CampCode = new ReportField(
            $this, // Table
            'x_CampCode', // Variable name
            'CampCode', // Name
            '`CampCode`', // Expression
            '`CampCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`CampCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->CampCode->InputTextType = "text";
        $this->CampCode->Raw = true;
        $this->CampCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->CampCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->CampCode->SourceTableVar = 'famer_farm_view';
        $this->Fields['CampCode'] = &$this->CampCode;

        // VillageCode
        $this->VillageCode = new ReportField(
            $this, // Table
            'x_VillageCode', // Variable name
            'VillageCode', // Name
            '`VillageCode`', // Expression
            '`VillageCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`VillageCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->VillageCode->InputTextType = "text";
        $this->VillageCode->Raw = true;
        $this->VillageCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->VillageCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->VillageCode->SourceTableVar = 'famer_farm_view';
        $this->Fields['VillageCode'] = &$this->VillageCode;

        // FarmNo
        $this->FarmNo = new ReportField(
            $this, // Table
            'x_FarmNo', // Variable name
            'FarmNo', // Name
            '`FarmNo`', // Expression
            '`FarmNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->FarmNo->InputTextType = "text";
        $this->FarmNo->Raw = true;
        $this->FarmNo->IsAutoIncrement = true; // Autoincrement field
        $this->FarmNo->IsPrimaryKey = true; // Primary key field
        $this->FarmNo->Nullable = false; // NOT NULL field
        $this->FarmNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->FarmNo->SourceTableVar = 'famer_farm_view';
        $this->Fields['FarmNo'] = &$this->FarmNo;

        // Coordinates
        $this->Coordinates = new ReportField(
            $this, // Table
            'x_Coordinates', // Variable name
            'Coordinates', // Name
            '`Coordinates`', // Expression
            '`Coordinates`', // Basic search expression
            200, // Type
            0, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Coordinates`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Coordinates->InputTextType = "text";
        $this->Coordinates->Raw = true;
        $this->Coordinates->CustomDataType = new GeometryType();
        $this->Coordinates->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Coordinates->SourceTableVar = 'famer_farm_view';
        $this->Fields['Coordinates'] = &$this->Coordinates;

        // Latitude
        $this->Latitude = new ReportField(
            $this, // Table
            'x_Latitude', // Variable name
            'Latitude', // Name
            '`Latitude`', // Expression
            '`Latitude`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Latitude`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Latitude->InputTextType = "text";
        $this->Latitude->Raw = true;
        $this->Latitude->Nullable = false; // NOT NULL field
        $this->Latitude->Required = true; // Required field
        $this->Latitude->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Latitude->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Latitude->SourceTableVar = 'famer_farm_view';
        $this->Fields['Latitude'] = &$this->Latitude;

        // Longitude
        $this->Longitude = new ReportField(
            $this, // Table
            'x_Longitude', // Variable name
            'Longitude', // Name
            '`Longitude`', // Expression
            '`Longitude`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Longitude`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Longitude->InputTextType = "text";
        $this->Longitude->Raw = true;
        $this->Longitude->Nullable = false; // NOT NULL field
        $this->Longitude->Required = true; // Required field
        $this->Longitude->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Longitude->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Longitude->SourceTableVar = 'famer_farm_view';
        $this->Fields['Longitude'] = &$this->Longitude;

        // FieldType
        $this->FieldType = new ReportField(
            $this, // Table
            'x_FieldType', // Variable name
            'FieldType', // Name
            '`FieldType`', // Expression
            '`FieldType`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FieldType`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FieldType->InputTextType = "text";
        $this->FieldType->Raw = true;
        $this->FieldType->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FieldType->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->FieldType->SourceTableVar = 'famer_farm_view';
        $this->Fields['FieldType'] = &$this->FieldType;

        // Ownership
        $this->Ownership = new ReportField(
            $this, // Table
            'x_Ownership', // Variable name
            'Ownership', // Name
            '`Ownership`', // Expression
            '`Ownership`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Ownership`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Ownership->InputTextType = "text";
        $this->Ownership->Raw = true;
        $this->Ownership->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Ownership->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Ownership->SourceTableVar = 'famer_farm_view';
        $this->Fields['Ownership'] = &$this->Ownership;

        // FarmSize
        $this->FarmSize = new ReportField(
            $this, // Table
            'x_FarmSize', // Variable name
            'FarmSize', // Name
            '`FarmSize`', // Expression
            '`FarmSize`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSize`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSize->InputTextType = "text";
        $this->FarmSize->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->FarmSize->SourceTableVar = 'famer_farm_view';
        $this->Fields['FarmSize'] = &$this->FarmSize;

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated = new ReportField(
            $this, // Table
            'x_TreesPlantedEstimated', // Variable name
            'TreesPlantedEstimated', // Name
            '`TreesPlantedEstimated`', // Expression
            '`TreesPlantedEstimated`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TreesPlantedEstimated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TreesPlantedEstimated->InputTextType = "text";
        $this->TreesPlantedEstimated->Raw = true;
        $this->TreesPlantedEstimated->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->TreesPlantedEstimated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->TreesPlantedEstimated->SourceTableVar = 'famer_farm_view';
        $this->Fields['TreesPlantedEstimated'] = &$this->TreesPlantedEstimated;

        // FarmSizeVerified
        $this->FarmSizeVerified = new ReportField(
            $this, // Table
            'x_FarmSizeVerified', // Variable name
            'FarmSizeVerified', // Name
            '`FarmSizeVerified`', // Expression
            '`FarmSizeVerified`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSizeVerified`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSizeVerified->InputTextType = "text";
        $this->FarmSizeVerified->Raw = true;
        $this->FarmSizeVerified->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->FarmSizeVerified->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->FarmSizeVerified->SourceTableVar = 'famer_farm_view';
        $this->Fields['FarmSizeVerified'] = &$this->FarmSizeVerified;

        // TreesPlantedVerified
        $this->TreesPlantedVerified = new ReportField(
            $this, // Table
            'x_TreesPlantedVerified', // Variable name
            'TreesPlantedVerified', // Name
            '`TreesPlantedVerified`', // Expression
            '`TreesPlantedVerified`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TreesPlantedVerified`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TreesPlantedVerified->InputTextType = "text";
        $this->TreesPlantedVerified->Raw = true;
        $this->TreesPlantedVerified->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->TreesPlantedVerified->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->TreesPlantedVerified->SourceTableVar = 'famer_farm_view';
        $this->Fields['TreesPlantedVerified'] = &$this->TreesPlantedVerified;

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings = new ReportField(
            $this, // Table
            'x_SourcesOfSeedlings', // Variable name
            'SourcesOfSeedlings', // Name
            '`SourcesOfSeedlings`', // Expression
            '`SourcesOfSeedlings`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SourcesOfSeedlings`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SourcesOfSeedlings->InputTextType = "text";
        $this->SourcesOfSeedlings->Raw = true;
        $this->SourcesOfSeedlings->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->SourcesOfSeedlings->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->SourcesOfSeedlings->SourceTableVar = 'famer_farm_view';
        $this->Fields['SourcesOfSeedlings'] = &$this->SourcesOfSeedlings;

        // InspecationReport
        $this->InspecationReport = new ReportField(
            $this, // Table
            'x_InspecationReport', // Variable name
            'InspecationReport', // Name
            '`InspecationReport`', // Expression
            '`InspecationReport`', // Basic search expression
            201, // Type
            2147483647, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`InspecationReport`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->InspecationReport->InputTextType = "text";
        $this->InspecationReport->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->InspecationReport->SourceTableVar = 'famer_farm_view';
        $this->Fields['InspecationReport'] = &$this->InspecationReport;

        // ClearedLand
        $this->ClearedLand = new ReportField(
            $this, // Table
            'x_ClearedLand', // Variable name
            'ClearedLand', // Name
            '`ClearedLand`', // Expression
            '`ClearedLand`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ClearedLand`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ClearedLand->InputTextType = "text";
        $this->ClearedLand->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->ClearedLand->SourceTableVar = 'famer_farm_view';
        $this->Fields['ClearedLand'] = &$this->ClearedLand;

        // SeedlingsAllocated
        $this->SeedlingsAllocated = new ReportField(
            $this, // Table
            'x_SeedlingsAllocated', // Variable name
            'SeedlingsAllocated', // Name
            '`SeedlingsAllocated`', // Expression
            '`SeedlingsAllocated`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SeedlingsAllocated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SeedlingsAllocated->InputTextType = "text";
        $this->SeedlingsAllocated->Raw = true;
        $this->SeedlingsAllocated->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->SeedlingsAllocated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->SeedlingsAllocated->SourceTableVar = 'famer_farm_view';
        $this->Fields['SeedlingsAllocated'] = &$this->SeedlingsAllocated;

        // OldTrees
        $this->OldTrees = new ReportField(
            $this, // Table
            'x_OldTrees', // Variable name
            'OldTrees', // Name
            '`OldTrees`', // Expression
            '`OldTrees`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`OldTrees`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->OldTrees->InputTextType = "text";
        $this->OldTrees->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->OldTrees->SourceTableVar = 'famer_farm_view';
        $this->Fields['OldTrees'] = &$this->OldTrees;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Single column sort
    protected function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($fld->GroupingFieldId == 0) {
                $this->setDetailOrderBy($curOrderBy); // Save to Session
            }
        } else {
            if ($fld->GroupingFieldId == 0) {
                $fld->setSort("");
            }
        }
    }

    // Get Sort SQL
    protected function sortSql()
    {
        $dtlSortSql = $this->getDetailOrderBy(); // Get ORDER BY for detail fields from session
        $argrps = [];
        foreach ($this->Fields as $fld) {
            if (in_array($fld->getSort(), ["ASC", "DESC"])) {
                $fldsql = $fld->Expression;
                if ($fld->GroupingFieldId > 0) {
                    if ($fld->GroupSql != "") {
                        $argrps[$fld->GroupingFieldId] = str_replace("%s", $fldsql, $fld->GroupSql) . " " . $fld->getSort();
                    } else {
                        $argrps[$fld->GroupingFieldId] = $fldsql . " " . $fld->getSort();
                    }
                }
            }
        }
        $sortSql = "";
        foreach ($argrps as $grp) {
            if ($sortSql != "") {
                $sortSql .= ", ";
            }
            $sortSql .= $grp;
        }
        if ($dtlSortSql != "") {
            if ($sortSql != "") {
                $sortSql .= ", ";
            }
            $sortSql .= $dtlSortSql;
        }
        return $sortSql;
    }

    // Summary properties
    private $sqlSelectAggregate = null;
    private $sqlAggregatePrefix = "";
    private $sqlAggregateSuffix = "";
    private $sqlSelectCount = null;

    // Select Aggregate
    public function getSqlSelectAggregate()
    {
        return $this->sqlSelectAggregate ?? $this->getQueryBuilder()->select("*");
    }

    public function setSqlSelectAggregate($v)
    {
        $this->sqlSelectAggregate = $v;
    }

    // Aggregate Prefix
    public function getSqlAggregatePrefix()
    {
        return ($this->sqlAggregatePrefix != "") ? $this->sqlAggregatePrefix : "";
    }

    public function setSqlAggregatePrefix($v)
    {
        $this->sqlAggregatePrefix = $v;
    }

    // Aggregate Suffix
    public function getSqlAggregateSuffix()
    {
        return ($this->sqlAggregateSuffix != "") ? $this->sqlAggregateSuffix : "";
    }

    public function setSqlAggregateSuffix($v)
    {
        $this->sqlAggregateSuffix = $v;
    }

    // Select Count
    public function getSqlSelectCount()
    {
        return $this->sqlSelectCount ?? $this->getQueryBuilder()->select("COUNT(*)");
    }

    public function setSqlSelectCount($v)
    {
        $this->sqlSelectCount = $v;
    }

    // Render for lookup
    public function renderLookup()
    {
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "famer_farm_view";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect()
    {
        if ($this->SqlSelect) {
            return $this->SqlSelect;
        }
        $select = $this->getQueryBuilder()->select($this->sqlSelectFields());
        return $select;
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD) == Allow::ADD;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT) == Allow::EDIT;
            case "delete":
                return ($allow & Allow::DELETE) == Allow::DELETE;
            case "view":
                return ($allow & Allow::VIEW) == Allow::VIEW;
            case "search":
                return ($allow & Allow::SEARCH) == Allow::SEARCH;
            case "lookup":
                return ($allow & Allow::LOOKUP) == Allow::LOOKUP;
            default:
                return ($allow & Allow::LIST) == Allow::LIST;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`FarmerNo` = @FarmerNo@ AND `FarmNo` = @FarmNo@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->FarmerNo->CurrentValue : $this->FarmerNo->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $val = $current ? $this->FarmNo->CurrentValue : $this->FarmNo->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 2) {
            if ($current) {
                $this->FarmerNo->CurrentValue = $keys[0];
            } else {
                $this->FarmerNo->OldValue = $keys[0];
            }
            if ($current) {
                $this->FarmNo->CurrentValue = $keys[1];
            } else {
                $this->FarmNo->OldValue = $keys[1];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('FarmerNo', $row) ? $row['FarmerNo'] : null;
        } else {
            $val = !EmptyValue($this->FarmerNo->OldValue) && !$current ? $this->FarmerNo->OldValue : $this->FarmerNo->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@FarmerNo@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        if (is_array($row)) {
            $val = array_key_exists('FarmNo', $row) ? $row['FarmNo'] : null;
        } else {
            $val = !EmptyValue($this->FarmNo->OldValue) && !$current ? $this->FarmNo->OldValue : $this->FarmNo->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@FarmNo@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "" => $Language->phrase("View"),
            "" => $Language->phrase("Edit"),
            "" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "SummaryFarmActivity";
    }

    // API page name
    public function getApiPageName($action)
    {
        return "SummaryFarmActivitySummary";
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("", $parm);
        } else {
            $url = $this->keyUrl("", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "?" . $parm;
        } else {
            $url = "";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"FarmerNo\":" . VarToJson($this->FarmerNo->CurrentValue, "number");
        $json .= ",\"FarmNo\":" . VarToJson($this->FarmNo->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->FarmerNo->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->FarmerNo->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($this->FarmNo->CurrentValue !== null) {
            $url .= $this->RouteCompositeKeySeparator . $this->encodeKeyValue($this->FarmNo->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            $this->DrillDown ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
            for ($i = 0; $i < $cnt; $i++) {
                $arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
            }
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 1))) // Other API
                : []; // Non-API
            if (($keyValue = Param("FarmerNo") ?? Route("FarmerNo")) !== null) {
                $arKey[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKey[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
            if (($keyValue = Param("FarmNo") ?? Route("FarmNo")) !== null) {
                $arKey[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(1) ?? $keyValues[1] ?? null) !== null)) {
                $arKey[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
            $arKeys[] = $arKey;
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_array($key) || count($key) != 2) {
                    continue; // Just skip so other keys will still work
                }
                if (!is_numeric($key[0])) { // FarmerNo
                    continue;
                }
                if (!is_numeric($key[1])) { // FarmNo
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->FarmerNo->CurrentValue = $key[0];
            } else {
                $this->FarmerNo->OldValue = $key[0];
            }
            if ($setCurrent) {
                $this->FarmNo->CurrentValue = $key[1];
            } else {
                $this->FarmNo->OldValue = $key[1];
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
