<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SeedAllocateViewList extends SeedAllocateView
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SeedAllocateViewList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fseed_allocate_viewlist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "SeedAllocateViewList";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->DistrictName->setVisibility();
        $this->CampName->setVisibility();
        $this->Village->setVisibility();
        $this->FieldType->setVisibility();
        $this->Ownership->setVisibility();
        $this->FarmSize->setVisibility();
        $this->FarmSizeEstimated->setVisibility();
        $this->TreesPlantedEstimated->setVisibility();
        $this->FarmSizeVerified->setVisibility();
        $this->TreesPlantedVerified->setVisibility();
        $this->FarmNo->setVisibility();
        $this->TransNo->setVisibility();
        $this->GRN->setVisibility();
        $this->TreesAllocated->setVisibility();
        $this->FarmingSeason->setVisibility();
        $this->SeedType->setVisibility();
        $this->SourcesOfSeedlings->setVisibility();
        $this->TransDate->setVisibility();
        $this->PreparedBy->setVisibility();
        $this->AuthorisedBy->setVisibility();
        $this->NRC->setVisibility();
        $this->FarmerName->setVisibility();
        $this->DOB->setVisibility();
        $this->Age->setVisibility();
        $this->Gender->setVisibility();
        $this->MaritalStatus->setVisibility();
        $this->PhoneNo->setVisibility();
        $this->_Email->setVisibility();
        $this->Dependants->setVisibility();
        $this->MaleChildren->setVisibility();
        $this->FemaleChildren->setVisibility();
        $this->HouseholdHead->setVisibility();
        $this->FarmerOrg->setVisibility();
        $this->FarmerOrgPosition->setVisibility();
        $this->JoiningDate->setVisibility();
        $this->NurseryName->setVisibility();
        $this->NurseryType->setVisibility();
        $this->NurseryOwnership->setVisibility();
        $this->NumberOfMembers->setVisibility();
        $this->Longitude->setVisibility();
        $this->Latitude->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'seed_allocate_view';
        $this->TableName = 'seed_allocate_view';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (seed_allocate_view)
        if (!isset($GLOBALS["seed_allocate_view"]) || $GLOBALS["seed_allocate_view"]::class == PROJECT_NAMESPACE . "seed_allocate_view") {
            $GLOBALS["seed_allocate_view"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "SeedAllocateViewAdd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "SeedAllocateViewDelete";
        $this->MultiUpdateUrl = "SeedAllocateViewUpdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'seed_allocate_view');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "SeedAllocateViewView"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['FarmNo'] . Config("COMPOSITE_KEY_SEPARATOR");
            $key .= @$ar['TransNo'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->FarmNo->Visible = false;
        }
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->TransNo->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = ""; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fseed_allocate_viewgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fseed_allocate_viewsrch");
        }
        $filterList = Concat($filterList, $this->DistrictName->AdvancedSearch->toJson(), ","); // Field DistrictName
        $filterList = Concat($filterList, $this->CampName->AdvancedSearch->toJson(), ","); // Field CampName
        $filterList = Concat($filterList, $this->Village->AdvancedSearch->toJson(), ","); // Field Village
        $filterList = Concat($filterList, $this->FieldType->AdvancedSearch->toJson(), ","); // Field FieldType
        $filterList = Concat($filterList, $this->Ownership->AdvancedSearch->toJson(), ","); // Field Ownership
        $filterList = Concat($filterList, $this->FarmSize->AdvancedSearch->toJson(), ","); // Field FarmSize
        $filterList = Concat($filterList, $this->FarmSizeEstimated->AdvancedSearch->toJson(), ","); // Field FarmSizeEstimated
        $filterList = Concat($filterList, $this->TreesPlantedEstimated->AdvancedSearch->toJson(), ","); // Field TreesPlantedEstimated
        $filterList = Concat($filterList, $this->FarmSizeVerified->AdvancedSearch->toJson(), ","); // Field FarmSizeVerified
        $filterList = Concat($filterList, $this->TreesPlantedVerified->AdvancedSearch->toJson(), ","); // Field TreesPlantedVerified
        $filterList = Concat($filterList, $this->FarmNo->AdvancedSearch->toJson(), ","); // Field FarmNo
        $filterList = Concat($filterList, $this->TransNo->AdvancedSearch->toJson(), ","); // Field TransNo
        $filterList = Concat($filterList, $this->GRN->AdvancedSearch->toJson(), ","); // Field GRN
        $filterList = Concat($filterList, $this->TreesAllocated->AdvancedSearch->toJson(), ","); // Field TreesAllocated
        $filterList = Concat($filterList, $this->FarmingSeason->AdvancedSearch->toJson(), ","); // Field FarmingSeason
        $filterList = Concat($filterList, $this->SeedType->AdvancedSearch->toJson(), ","); // Field SeedType
        $filterList = Concat($filterList, $this->SourcesOfSeedlings->AdvancedSearch->toJson(), ","); // Field SourcesOfSeedlings
        $filterList = Concat($filterList, $this->TransDate->AdvancedSearch->toJson(), ","); // Field TransDate
        $filterList = Concat($filterList, $this->PreparedBy->AdvancedSearch->toJson(), ","); // Field PreparedBy
        $filterList = Concat($filterList, $this->AuthorisedBy->AdvancedSearch->toJson(), ","); // Field AuthorisedBy
        $filterList = Concat($filterList, $this->NRC->AdvancedSearch->toJson(), ","); // Field NRC
        $filterList = Concat($filterList, $this->FarmerName->AdvancedSearch->toJson(), ","); // Field FarmerName
        $filterList = Concat($filterList, $this->DOB->AdvancedSearch->toJson(), ","); // Field DOB
        $filterList = Concat($filterList, $this->Age->AdvancedSearch->toJson(), ","); // Field Age
        $filterList = Concat($filterList, $this->Gender->AdvancedSearch->toJson(), ","); // Field Gender
        $filterList = Concat($filterList, $this->MaritalStatus->AdvancedSearch->toJson(), ","); // Field MaritalStatus
        $filterList = Concat($filterList, $this->PhoneNo->AdvancedSearch->toJson(), ","); // Field PhoneNo
        $filterList = Concat($filterList, $this->_Email->AdvancedSearch->toJson(), ","); // Field Email
        $filterList = Concat($filterList, $this->Dependants->AdvancedSearch->toJson(), ","); // Field Dependants
        $filterList = Concat($filterList, $this->MaleChildren->AdvancedSearch->toJson(), ","); // Field MaleChildren
        $filterList = Concat($filterList, $this->FemaleChildren->AdvancedSearch->toJson(), ","); // Field FemaleChildren
        $filterList = Concat($filterList, $this->HouseholdHead->AdvancedSearch->toJson(), ","); // Field HouseholdHead
        $filterList = Concat($filterList, $this->FarmerOrg->AdvancedSearch->toJson(), ","); // Field FarmerOrg
        $filterList = Concat($filterList, $this->FarmerOrgPosition->AdvancedSearch->toJson(), ","); // Field FarmerOrgPosition
        $filterList = Concat($filterList, $this->JoiningDate->AdvancedSearch->toJson(), ","); // Field JoiningDate
        $filterList = Concat($filterList, $this->NurseryName->AdvancedSearch->toJson(), ","); // Field NurseryName
        $filterList = Concat($filterList, $this->NurseryType->AdvancedSearch->toJson(), ","); // Field NurseryType
        $filterList = Concat($filterList, $this->NurseryOwnership->AdvancedSearch->toJson(), ","); // Field NurseryOwnership
        $filterList = Concat($filterList, $this->NumberOfMembers->AdvancedSearch->toJson(), ","); // Field NumberOfMembers
        $filterList = Concat($filterList, $this->Longitude->AdvancedSearch->toJson(), ","); // Field Longitude
        $filterList = Concat($filterList, $this->Latitude->AdvancedSearch->toJson(), ","); // Field Latitude
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fseed_allocate_viewsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field DistrictName
        $this->DistrictName->AdvancedSearch->SearchValue = @$filter["x_DistrictName"];
        $this->DistrictName->AdvancedSearch->SearchOperator = @$filter["z_DistrictName"];
        $this->DistrictName->AdvancedSearch->SearchCondition = @$filter["v_DistrictName"];
        $this->DistrictName->AdvancedSearch->SearchValue2 = @$filter["y_DistrictName"];
        $this->DistrictName->AdvancedSearch->SearchOperator2 = @$filter["w_DistrictName"];
        $this->DistrictName->AdvancedSearch->save();

        // Field CampName
        $this->CampName->AdvancedSearch->SearchValue = @$filter["x_CampName"];
        $this->CampName->AdvancedSearch->SearchOperator = @$filter["z_CampName"];
        $this->CampName->AdvancedSearch->SearchCondition = @$filter["v_CampName"];
        $this->CampName->AdvancedSearch->SearchValue2 = @$filter["y_CampName"];
        $this->CampName->AdvancedSearch->SearchOperator2 = @$filter["w_CampName"];
        $this->CampName->AdvancedSearch->save();

        // Field Village
        $this->Village->AdvancedSearch->SearchValue = @$filter["x_Village"];
        $this->Village->AdvancedSearch->SearchOperator = @$filter["z_Village"];
        $this->Village->AdvancedSearch->SearchCondition = @$filter["v_Village"];
        $this->Village->AdvancedSearch->SearchValue2 = @$filter["y_Village"];
        $this->Village->AdvancedSearch->SearchOperator2 = @$filter["w_Village"];
        $this->Village->AdvancedSearch->save();

        // Field FieldType
        $this->FieldType->AdvancedSearch->SearchValue = @$filter["x_FieldType"];
        $this->FieldType->AdvancedSearch->SearchOperator = @$filter["z_FieldType"];
        $this->FieldType->AdvancedSearch->SearchCondition = @$filter["v_FieldType"];
        $this->FieldType->AdvancedSearch->SearchValue2 = @$filter["y_FieldType"];
        $this->FieldType->AdvancedSearch->SearchOperator2 = @$filter["w_FieldType"];
        $this->FieldType->AdvancedSearch->save();

        // Field Ownership
        $this->Ownership->AdvancedSearch->SearchValue = @$filter["x_Ownership"];
        $this->Ownership->AdvancedSearch->SearchOperator = @$filter["z_Ownership"];
        $this->Ownership->AdvancedSearch->SearchCondition = @$filter["v_Ownership"];
        $this->Ownership->AdvancedSearch->SearchValue2 = @$filter["y_Ownership"];
        $this->Ownership->AdvancedSearch->SearchOperator2 = @$filter["w_Ownership"];
        $this->Ownership->AdvancedSearch->save();

        // Field FarmSize
        $this->FarmSize->AdvancedSearch->SearchValue = @$filter["x_FarmSize"];
        $this->FarmSize->AdvancedSearch->SearchOperator = @$filter["z_FarmSize"];
        $this->FarmSize->AdvancedSearch->SearchCondition = @$filter["v_FarmSize"];
        $this->FarmSize->AdvancedSearch->SearchValue2 = @$filter["y_FarmSize"];
        $this->FarmSize->AdvancedSearch->SearchOperator2 = @$filter["w_FarmSize"];
        $this->FarmSize->AdvancedSearch->save();

        // Field FarmSizeEstimated
        $this->FarmSizeEstimated->AdvancedSearch->SearchValue = @$filter["x_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->SearchOperator = @$filter["z_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->SearchCondition = @$filter["v_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->SearchValue2 = @$filter["y_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->SearchOperator2 = @$filter["w_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->save();

        // Field TreesPlantedEstimated
        $this->TreesPlantedEstimated->AdvancedSearch->SearchValue = @$filter["x_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->SearchOperator = @$filter["z_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->SearchCondition = @$filter["v_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->SearchValue2 = @$filter["y_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->SearchOperator2 = @$filter["w_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->save();

        // Field FarmSizeVerified
        $this->FarmSizeVerified->AdvancedSearch->SearchValue = @$filter["x_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->SearchOperator = @$filter["z_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->SearchCondition = @$filter["v_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->SearchValue2 = @$filter["y_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->SearchOperator2 = @$filter["w_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->save();

        // Field TreesPlantedVerified
        $this->TreesPlantedVerified->AdvancedSearch->SearchValue = @$filter["x_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->SearchOperator = @$filter["z_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->SearchCondition = @$filter["v_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->SearchValue2 = @$filter["y_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->SearchOperator2 = @$filter["w_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->save();

        // Field FarmNo
        $this->FarmNo->AdvancedSearch->SearchValue = @$filter["x_FarmNo"];
        $this->FarmNo->AdvancedSearch->SearchOperator = @$filter["z_FarmNo"];
        $this->FarmNo->AdvancedSearch->SearchCondition = @$filter["v_FarmNo"];
        $this->FarmNo->AdvancedSearch->SearchValue2 = @$filter["y_FarmNo"];
        $this->FarmNo->AdvancedSearch->SearchOperator2 = @$filter["w_FarmNo"];
        $this->FarmNo->AdvancedSearch->save();

        // Field TransNo
        $this->TransNo->AdvancedSearch->SearchValue = @$filter["x_TransNo"];
        $this->TransNo->AdvancedSearch->SearchOperator = @$filter["z_TransNo"];
        $this->TransNo->AdvancedSearch->SearchCondition = @$filter["v_TransNo"];
        $this->TransNo->AdvancedSearch->SearchValue2 = @$filter["y_TransNo"];
        $this->TransNo->AdvancedSearch->SearchOperator2 = @$filter["w_TransNo"];
        $this->TransNo->AdvancedSearch->save();

        // Field GRN
        $this->GRN->AdvancedSearch->SearchValue = @$filter["x_GRN"];
        $this->GRN->AdvancedSearch->SearchOperator = @$filter["z_GRN"];
        $this->GRN->AdvancedSearch->SearchCondition = @$filter["v_GRN"];
        $this->GRN->AdvancedSearch->SearchValue2 = @$filter["y_GRN"];
        $this->GRN->AdvancedSearch->SearchOperator2 = @$filter["w_GRN"];
        $this->GRN->AdvancedSearch->save();

        // Field TreesAllocated
        $this->TreesAllocated->AdvancedSearch->SearchValue = @$filter["x_TreesAllocated"];
        $this->TreesAllocated->AdvancedSearch->SearchOperator = @$filter["z_TreesAllocated"];
        $this->TreesAllocated->AdvancedSearch->SearchCondition = @$filter["v_TreesAllocated"];
        $this->TreesAllocated->AdvancedSearch->SearchValue2 = @$filter["y_TreesAllocated"];
        $this->TreesAllocated->AdvancedSearch->SearchOperator2 = @$filter["w_TreesAllocated"];
        $this->TreesAllocated->AdvancedSearch->save();

        // Field FarmingSeason
        $this->FarmingSeason->AdvancedSearch->SearchValue = @$filter["x_FarmingSeason"];
        $this->FarmingSeason->AdvancedSearch->SearchOperator = @$filter["z_FarmingSeason"];
        $this->FarmingSeason->AdvancedSearch->SearchCondition = @$filter["v_FarmingSeason"];
        $this->FarmingSeason->AdvancedSearch->SearchValue2 = @$filter["y_FarmingSeason"];
        $this->FarmingSeason->AdvancedSearch->SearchOperator2 = @$filter["w_FarmingSeason"];
        $this->FarmingSeason->AdvancedSearch->save();

        // Field SeedType
        $this->SeedType->AdvancedSearch->SearchValue = @$filter["x_SeedType"];
        $this->SeedType->AdvancedSearch->SearchOperator = @$filter["z_SeedType"];
        $this->SeedType->AdvancedSearch->SearchCondition = @$filter["v_SeedType"];
        $this->SeedType->AdvancedSearch->SearchValue2 = @$filter["y_SeedType"];
        $this->SeedType->AdvancedSearch->SearchOperator2 = @$filter["w_SeedType"];
        $this->SeedType->AdvancedSearch->save();

        // Field SourcesOfSeedlings
        $this->SourcesOfSeedlings->AdvancedSearch->SearchValue = @$filter["x_SourcesOfSeedlings"];
        $this->SourcesOfSeedlings->AdvancedSearch->SearchOperator = @$filter["z_SourcesOfSeedlings"];
        $this->SourcesOfSeedlings->AdvancedSearch->SearchCondition = @$filter["v_SourcesOfSeedlings"];
        $this->SourcesOfSeedlings->AdvancedSearch->SearchValue2 = @$filter["y_SourcesOfSeedlings"];
        $this->SourcesOfSeedlings->AdvancedSearch->SearchOperator2 = @$filter["w_SourcesOfSeedlings"];
        $this->SourcesOfSeedlings->AdvancedSearch->save();

        // Field TransDate
        $this->TransDate->AdvancedSearch->SearchValue = @$filter["x_TransDate"];
        $this->TransDate->AdvancedSearch->SearchOperator = @$filter["z_TransDate"];
        $this->TransDate->AdvancedSearch->SearchCondition = @$filter["v_TransDate"];
        $this->TransDate->AdvancedSearch->SearchValue2 = @$filter["y_TransDate"];
        $this->TransDate->AdvancedSearch->SearchOperator2 = @$filter["w_TransDate"];
        $this->TransDate->AdvancedSearch->save();

        // Field PreparedBy
        $this->PreparedBy->AdvancedSearch->SearchValue = @$filter["x_PreparedBy"];
        $this->PreparedBy->AdvancedSearch->SearchOperator = @$filter["z_PreparedBy"];
        $this->PreparedBy->AdvancedSearch->SearchCondition = @$filter["v_PreparedBy"];
        $this->PreparedBy->AdvancedSearch->SearchValue2 = @$filter["y_PreparedBy"];
        $this->PreparedBy->AdvancedSearch->SearchOperator2 = @$filter["w_PreparedBy"];
        $this->PreparedBy->AdvancedSearch->save();

        // Field AuthorisedBy
        $this->AuthorisedBy->AdvancedSearch->SearchValue = @$filter["x_AuthorisedBy"];
        $this->AuthorisedBy->AdvancedSearch->SearchOperator = @$filter["z_AuthorisedBy"];
        $this->AuthorisedBy->AdvancedSearch->SearchCondition = @$filter["v_AuthorisedBy"];
        $this->AuthorisedBy->AdvancedSearch->SearchValue2 = @$filter["y_AuthorisedBy"];
        $this->AuthorisedBy->AdvancedSearch->SearchOperator2 = @$filter["w_AuthorisedBy"];
        $this->AuthorisedBy->AdvancedSearch->save();

        // Field NRC
        $this->NRC->AdvancedSearch->SearchValue = @$filter["x_NRC"];
        $this->NRC->AdvancedSearch->SearchOperator = @$filter["z_NRC"];
        $this->NRC->AdvancedSearch->SearchCondition = @$filter["v_NRC"];
        $this->NRC->AdvancedSearch->SearchValue2 = @$filter["y_NRC"];
        $this->NRC->AdvancedSearch->SearchOperator2 = @$filter["w_NRC"];
        $this->NRC->AdvancedSearch->save();

        // Field FarmerName
        $this->FarmerName->AdvancedSearch->SearchValue = @$filter["x_FarmerName"];
        $this->FarmerName->AdvancedSearch->SearchOperator = @$filter["z_FarmerName"];
        $this->FarmerName->AdvancedSearch->SearchCondition = @$filter["v_FarmerName"];
        $this->FarmerName->AdvancedSearch->SearchValue2 = @$filter["y_FarmerName"];
        $this->FarmerName->AdvancedSearch->SearchOperator2 = @$filter["w_FarmerName"];
        $this->FarmerName->AdvancedSearch->save();

        // Field DOB
        $this->DOB->AdvancedSearch->SearchValue = @$filter["x_DOB"];
        $this->DOB->AdvancedSearch->SearchOperator = @$filter["z_DOB"];
        $this->DOB->AdvancedSearch->SearchCondition = @$filter["v_DOB"];
        $this->DOB->AdvancedSearch->SearchValue2 = @$filter["y_DOB"];
        $this->DOB->AdvancedSearch->SearchOperator2 = @$filter["w_DOB"];
        $this->DOB->AdvancedSearch->save();

        // Field Age
        $this->Age->AdvancedSearch->SearchValue = @$filter["x_Age"];
        $this->Age->AdvancedSearch->SearchOperator = @$filter["z_Age"];
        $this->Age->AdvancedSearch->SearchCondition = @$filter["v_Age"];
        $this->Age->AdvancedSearch->SearchValue2 = @$filter["y_Age"];
        $this->Age->AdvancedSearch->SearchOperator2 = @$filter["w_Age"];
        $this->Age->AdvancedSearch->save();

        // Field Gender
        $this->Gender->AdvancedSearch->SearchValue = @$filter["x_Gender"];
        $this->Gender->AdvancedSearch->SearchOperator = @$filter["z_Gender"];
        $this->Gender->AdvancedSearch->SearchCondition = @$filter["v_Gender"];
        $this->Gender->AdvancedSearch->SearchValue2 = @$filter["y_Gender"];
        $this->Gender->AdvancedSearch->SearchOperator2 = @$filter["w_Gender"];
        $this->Gender->AdvancedSearch->save();

        // Field MaritalStatus
        $this->MaritalStatus->AdvancedSearch->SearchValue = @$filter["x_MaritalStatus"];
        $this->MaritalStatus->AdvancedSearch->SearchOperator = @$filter["z_MaritalStatus"];
        $this->MaritalStatus->AdvancedSearch->SearchCondition = @$filter["v_MaritalStatus"];
        $this->MaritalStatus->AdvancedSearch->SearchValue2 = @$filter["y_MaritalStatus"];
        $this->MaritalStatus->AdvancedSearch->SearchOperator2 = @$filter["w_MaritalStatus"];
        $this->MaritalStatus->AdvancedSearch->save();

        // Field PhoneNo
        $this->PhoneNo->AdvancedSearch->SearchValue = @$filter["x_PhoneNo"];
        $this->PhoneNo->AdvancedSearch->SearchOperator = @$filter["z_PhoneNo"];
        $this->PhoneNo->AdvancedSearch->SearchCondition = @$filter["v_PhoneNo"];
        $this->PhoneNo->AdvancedSearch->SearchValue2 = @$filter["y_PhoneNo"];
        $this->PhoneNo->AdvancedSearch->SearchOperator2 = @$filter["w_PhoneNo"];
        $this->PhoneNo->AdvancedSearch->save();

        // Field Email
        $this->_Email->AdvancedSearch->SearchValue = @$filter["x__Email"];
        $this->_Email->AdvancedSearch->SearchOperator = @$filter["z__Email"];
        $this->_Email->AdvancedSearch->SearchCondition = @$filter["v__Email"];
        $this->_Email->AdvancedSearch->SearchValue2 = @$filter["y__Email"];
        $this->_Email->AdvancedSearch->SearchOperator2 = @$filter["w__Email"];
        $this->_Email->AdvancedSearch->save();

        // Field Dependants
        $this->Dependants->AdvancedSearch->SearchValue = @$filter["x_Dependants"];
        $this->Dependants->AdvancedSearch->SearchOperator = @$filter["z_Dependants"];
        $this->Dependants->AdvancedSearch->SearchCondition = @$filter["v_Dependants"];
        $this->Dependants->AdvancedSearch->SearchValue2 = @$filter["y_Dependants"];
        $this->Dependants->AdvancedSearch->SearchOperator2 = @$filter["w_Dependants"];
        $this->Dependants->AdvancedSearch->save();

        // Field MaleChildren
        $this->MaleChildren->AdvancedSearch->SearchValue = @$filter["x_MaleChildren"];
        $this->MaleChildren->AdvancedSearch->SearchOperator = @$filter["z_MaleChildren"];
        $this->MaleChildren->AdvancedSearch->SearchCondition = @$filter["v_MaleChildren"];
        $this->MaleChildren->AdvancedSearch->SearchValue2 = @$filter["y_MaleChildren"];
        $this->MaleChildren->AdvancedSearch->SearchOperator2 = @$filter["w_MaleChildren"];
        $this->MaleChildren->AdvancedSearch->save();

        // Field FemaleChildren
        $this->FemaleChildren->AdvancedSearch->SearchValue = @$filter["x_FemaleChildren"];
        $this->FemaleChildren->AdvancedSearch->SearchOperator = @$filter["z_FemaleChildren"];
        $this->FemaleChildren->AdvancedSearch->SearchCondition = @$filter["v_FemaleChildren"];
        $this->FemaleChildren->AdvancedSearch->SearchValue2 = @$filter["y_FemaleChildren"];
        $this->FemaleChildren->AdvancedSearch->SearchOperator2 = @$filter["w_FemaleChildren"];
        $this->FemaleChildren->AdvancedSearch->save();

        // Field HouseholdHead
        $this->HouseholdHead->AdvancedSearch->SearchValue = @$filter["x_HouseholdHead"];
        $this->HouseholdHead->AdvancedSearch->SearchOperator = @$filter["z_HouseholdHead"];
        $this->HouseholdHead->AdvancedSearch->SearchCondition = @$filter["v_HouseholdHead"];
        $this->HouseholdHead->AdvancedSearch->SearchValue2 = @$filter["y_HouseholdHead"];
        $this->HouseholdHead->AdvancedSearch->SearchOperator2 = @$filter["w_HouseholdHead"];
        $this->HouseholdHead->AdvancedSearch->save();

        // Field FarmerOrg
        $this->FarmerOrg->AdvancedSearch->SearchValue = @$filter["x_FarmerOrg"];
        $this->FarmerOrg->AdvancedSearch->SearchOperator = @$filter["z_FarmerOrg"];
        $this->FarmerOrg->AdvancedSearch->SearchCondition = @$filter["v_FarmerOrg"];
        $this->FarmerOrg->AdvancedSearch->SearchValue2 = @$filter["y_FarmerOrg"];
        $this->FarmerOrg->AdvancedSearch->SearchOperator2 = @$filter["w_FarmerOrg"];
        $this->FarmerOrg->AdvancedSearch->save();

        // Field FarmerOrgPosition
        $this->FarmerOrgPosition->AdvancedSearch->SearchValue = @$filter["x_FarmerOrgPosition"];
        $this->FarmerOrgPosition->AdvancedSearch->SearchOperator = @$filter["z_FarmerOrgPosition"];
        $this->FarmerOrgPosition->AdvancedSearch->SearchCondition = @$filter["v_FarmerOrgPosition"];
        $this->FarmerOrgPosition->AdvancedSearch->SearchValue2 = @$filter["y_FarmerOrgPosition"];
        $this->FarmerOrgPosition->AdvancedSearch->SearchOperator2 = @$filter["w_FarmerOrgPosition"];
        $this->FarmerOrgPosition->AdvancedSearch->save();

        // Field JoiningDate
        $this->JoiningDate->AdvancedSearch->SearchValue = @$filter["x_JoiningDate"];
        $this->JoiningDate->AdvancedSearch->SearchOperator = @$filter["z_JoiningDate"];
        $this->JoiningDate->AdvancedSearch->SearchCondition = @$filter["v_JoiningDate"];
        $this->JoiningDate->AdvancedSearch->SearchValue2 = @$filter["y_JoiningDate"];
        $this->JoiningDate->AdvancedSearch->SearchOperator2 = @$filter["w_JoiningDate"];
        $this->JoiningDate->AdvancedSearch->save();

        // Field NurseryName
        $this->NurseryName->AdvancedSearch->SearchValue = @$filter["x_NurseryName"];
        $this->NurseryName->AdvancedSearch->SearchOperator = @$filter["z_NurseryName"];
        $this->NurseryName->AdvancedSearch->SearchCondition = @$filter["v_NurseryName"];
        $this->NurseryName->AdvancedSearch->SearchValue2 = @$filter["y_NurseryName"];
        $this->NurseryName->AdvancedSearch->SearchOperator2 = @$filter["w_NurseryName"];
        $this->NurseryName->AdvancedSearch->save();

        // Field NurseryType
        $this->NurseryType->AdvancedSearch->SearchValue = @$filter["x_NurseryType"];
        $this->NurseryType->AdvancedSearch->SearchOperator = @$filter["z_NurseryType"];
        $this->NurseryType->AdvancedSearch->SearchCondition = @$filter["v_NurseryType"];
        $this->NurseryType->AdvancedSearch->SearchValue2 = @$filter["y_NurseryType"];
        $this->NurseryType->AdvancedSearch->SearchOperator2 = @$filter["w_NurseryType"];
        $this->NurseryType->AdvancedSearch->save();

        // Field NurseryOwnership
        $this->NurseryOwnership->AdvancedSearch->SearchValue = @$filter["x_NurseryOwnership"];
        $this->NurseryOwnership->AdvancedSearch->SearchOperator = @$filter["z_NurseryOwnership"];
        $this->NurseryOwnership->AdvancedSearch->SearchCondition = @$filter["v_NurseryOwnership"];
        $this->NurseryOwnership->AdvancedSearch->SearchValue2 = @$filter["y_NurseryOwnership"];
        $this->NurseryOwnership->AdvancedSearch->SearchOperator2 = @$filter["w_NurseryOwnership"];
        $this->NurseryOwnership->AdvancedSearch->save();

        // Field NumberOfMembers
        $this->NumberOfMembers->AdvancedSearch->SearchValue = @$filter["x_NumberOfMembers"];
        $this->NumberOfMembers->AdvancedSearch->SearchOperator = @$filter["z_NumberOfMembers"];
        $this->NumberOfMembers->AdvancedSearch->SearchCondition = @$filter["v_NumberOfMembers"];
        $this->NumberOfMembers->AdvancedSearch->SearchValue2 = @$filter["y_NumberOfMembers"];
        $this->NumberOfMembers->AdvancedSearch->SearchOperator2 = @$filter["w_NumberOfMembers"];
        $this->NumberOfMembers->AdvancedSearch->save();

        // Field Longitude
        $this->Longitude->AdvancedSearch->SearchValue = @$filter["x_Longitude"];
        $this->Longitude->AdvancedSearch->SearchOperator = @$filter["z_Longitude"];
        $this->Longitude->AdvancedSearch->SearchCondition = @$filter["v_Longitude"];
        $this->Longitude->AdvancedSearch->SearchValue2 = @$filter["y_Longitude"];
        $this->Longitude->AdvancedSearch->SearchOperator2 = @$filter["w_Longitude"];
        $this->Longitude->AdvancedSearch->save();

        // Field Latitude
        $this->Latitude->AdvancedSearch->SearchValue = @$filter["x_Latitude"];
        $this->Latitude->AdvancedSearch->SearchOperator = @$filter["z_Latitude"];
        $this->Latitude->AdvancedSearch->SearchCondition = @$filter["v_Latitude"];
        $this->Latitude->AdvancedSearch->SearchValue2 = @$filter["y_Latitude"];
        $this->Latitude->AdvancedSearch->SearchOperator2 = @$filter["w_Latitude"];
        $this->Latitude->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->DistrictName, $default, false); // DistrictName
        $this->buildSearchSql($where, $this->CampName, $default, false); // CampName
        $this->buildSearchSql($where, $this->Village, $default, false); // Village
        $this->buildSearchSql($where, $this->FieldType, $default, false); // FieldType
        $this->buildSearchSql($where, $this->Ownership, $default, false); // Ownership
        $this->buildSearchSql($where, $this->FarmSize, $default, false); // FarmSize
        $this->buildSearchSql($where, $this->FarmSizeEstimated, $default, false); // FarmSizeEstimated
        $this->buildSearchSql($where, $this->TreesPlantedEstimated, $default, false); // TreesPlantedEstimated
        $this->buildSearchSql($where, $this->FarmSizeVerified, $default, false); // FarmSizeVerified
        $this->buildSearchSql($where, $this->TreesPlantedVerified, $default, false); // TreesPlantedVerified
        $this->buildSearchSql($where, $this->FarmNo, $default, false); // FarmNo
        $this->buildSearchSql($where, $this->TransNo, $default, false); // TransNo
        $this->buildSearchSql($where, $this->GRN, $default, false); // GRN
        $this->buildSearchSql($where, $this->TreesAllocated, $default, false); // TreesAllocated
        $this->buildSearchSql($where, $this->FarmingSeason, $default, false); // FarmingSeason
        $this->buildSearchSql($where, $this->SeedType, $default, false); // SeedType
        $this->buildSearchSql($where, $this->SourcesOfSeedlings, $default, false); // SourcesOfSeedlings
        $this->buildSearchSql($where, $this->TransDate, $default, false); // TransDate
        $this->buildSearchSql($where, $this->PreparedBy, $default, false); // PreparedBy
        $this->buildSearchSql($where, $this->AuthorisedBy, $default, false); // AuthorisedBy
        $this->buildSearchSql($where, $this->NRC, $default, false); // NRC
        $this->buildSearchSql($where, $this->FarmerName, $default, false); // FarmerName
        $this->buildSearchSql($where, $this->DOB, $default, false); // DOB
        $this->buildSearchSql($where, $this->Age, $default, false); // Age
        $this->buildSearchSql($where, $this->Gender, $default, false); // Gender
        $this->buildSearchSql($where, $this->MaritalStatus, $default, false); // MaritalStatus
        $this->buildSearchSql($where, $this->PhoneNo, $default, false); // PhoneNo
        $this->buildSearchSql($where, $this->_Email, $default, false); // Email
        $this->buildSearchSql($where, $this->Dependants, $default, false); // Dependants
        $this->buildSearchSql($where, $this->MaleChildren, $default, false); // MaleChildren
        $this->buildSearchSql($where, $this->FemaleChildren, $default, false); // FemaleChildren
        $this->buildSearchSql($where, $this->HouseholdHead, $default, false); // HouseholdHead
        $this->buildSearchSql($where, $this->FarmerOrg, $default, false); // FarmerOrg
        $this->buildSearchSql($where, $this->FarmerOrgPosition, $default, false); // FarmerOrgPosition
        $this->buildSearchSql($where, $this->JoiningDate, $default, false); // JoiningDate
        $this->buildSearchSql($where, $this->NurseryName, $default, false); // NurseryName
        $this->buildSearchSql($where, $this->NurseryType, $default, false); // NurseryType
        $this->buildSearchSql($where, $this->NurseryOwnership, $default, false); // NurseryOwnership
        $this->buildSearchSql($where, $this->NumberOfMembers, $default, false); // NumberOfMembers
        $this->buildSearchSql($where, $this->Longitude, $default, false); // Longitude
        $this->buildSearchSql($where, $this->Latitude, $default, false); // Latitude

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->DistrictName->AdvancedSearch->save(); // DistrictName
            $this->CampName->AdvancedSearch->save(); // CampName
            $this->Village->AdvancedSearch->save(); // Village
            $this->FieldType->AdvancedSearch->save(); // FieldType
            $this->Ownership->AdvancedSearch->save(); // Ownership
            $this->FarmSize->AdvancedSearch->save(); // FarmSize
            $this->FarmSizeEstimated->AdvancedSearch->save(); // FarmSizeEstimated
            $this->TreesPlantedEstimated->AdvancedSearch->save(); // TreesPlantedEstimated
            $this->FarmSizeVerified->AdvancedSearch->save(); // FarmSizeVerified
            $this->TreesPlantedVerified->AdvancedSearch->save(); // TreesPlantedVerified
            $this->FarmNo->AdvancedSearch->save(); // FarmNo
            $this->TransNo->AdvancedSearch->save(); // TransNo
            $this->GRN->AdvancedSearch->save(); // GRN
            $this->TreesAllocated->AdvancedSearch->save(); // TreesAllocated
            $this->FarmingSeason->AdvancedSearch->save(); // FarmingSeason
            $this->SeedType->AdvancedSearch->save(); // SeedType
            $this->SourcesOfSeedlings->AdvancedSearch->save(); // SourcesOfSeedlings
            $this->TransDate->AdvancedSearch->save(); // TransDate
            $this->PreparedBy->AdvancedSearch->save(); // PreparedBy
            $this->AuthorisedBy->AdvancedSearch->save(); // AuthorisedBy
            $this->NRC->AdvancedSearch->save(); // NRC
            $this->FarmerName->AdvancedSearch->save(); // FarmerName
            $this->DOB->AdvancedSearch->save(); // DOB
            $this->Age->AdvancedSearch->save(); // Age
            $this->Gender->AdvancedSearch->save(); // Gender
            $this->MaritalStatus->AdvancedSearch->save(); // MaritalStatus
            $this->PhoneNo->AdvancedSearch->save(); // PhoneNo
            $this->_Email->AdvancedSearch->save(); // Email
            $this->Dependants->AdvancedSearch->save(); // Dependants
            $this->MaleChildren->AdvancedSearch->save(); // MaleChildren
            $this->FemaleChildren->AdvancedSearch->save(); // FemaleChildren
            $this->HouseholdHead->AdvancedSearch->save(); // HouseholdHead
            $this->FarmerOrg->AdvancedSearch->save(); // FarmerOrg
            $this->FarmerOrgPosition->AdvancedSearch->save(); // FarmerOrgPosition
            $this->JoiningDate->AdvancedSearch->save(); // JoiningDate
            $this->NurseryName->AdvancedSearch->save(); // NurseryName
            $this->NurseryType->AdvancedSearch->save(); // NurseryType
            $this->NurseryOwnership->AdvancedSearch->save(); // NurseryOwnership
            $this->NumberOfMembers->AdvancedSearch->save(); // NumberOfMembers
            $this->Longitude->AdvancedSearch->save(); // Longitude
            $this->Latitude->AdvancedSearch->save(); // Latitude

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field DistrictName
        $filter = $this->queryBuilderWhere("DistrictName");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->DistrictName, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->DistrictName->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field CampName
        $filter = $this->queryBuilderWhere("CampName");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->CampName, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->CampName->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Village
        $filter = $this->queryBuilderWhere("Village");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Village, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Village->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field FieldType
        $filter = $this->queryBuilderWhere("FieldType");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->FieldType, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->FieldType->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Ownership
        $filter = $this->queryBuilderWhere("Ownership");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Ownership, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Ownership->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field FarmSize
        $filter = $this->queryBuilderWhere("FarmSize");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->FarmSize, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->FarmSize->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field FarmSizeEstimated
        $filter = $this->queryBuilderWhere("FarmSizeEstimated");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->FarmSizeEstimated, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->FarmSizeEstimated->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field TreesPlantedEstimated
        $filter = $this->queryBuilderWhere("TreesPlantedEstimated");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->TreesPlantedEstimated, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->TreesPlantedEstimated->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field FarmSizeVerified
        $filter = $this->queryBuilderWhere("FarmSizeVerified");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->FarmSizeVerified, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->FarmSizeVerified->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field TreesPlantedVerified
        $filter = $this->queryBuilderWhere("TreesPlantedVerified");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->TreesPlantedVerified, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->TreesPlantedVerified->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field FarmNo
        $filter = $this->queryBuilderWhere("FarmNo");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->FarmNo, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->FarmNo->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field TransNo
        $filter = $this->queryBuilderWhere("TransNo");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->TransNo, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->TransNo->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field GRN
        $filter = $this->queryBuilderWhere("GRN");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->GRN, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->GRN->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field TreesAllocated
        $filter = $this->queryBuilderWhere("TreesAllocated");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->TreesAllocated, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->TreesAllocated->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field FarmingSeason
        $filter = $this->queryBuilderWhere("FarmingSeason");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->FarmingSeason, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->FarmingSeason->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field SeedType
        $filter = $this->queryBuilderWhere("SeedType");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->SeedType, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->SeedType->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field SourcesOfSeedlings
        $filter = $this->queryBuilderWhere("SourcesOfSeedlings");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->SourcesOfSeedlings, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->SourcesOfSeedlings->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field TransDate
        $filter = $this->queryBuilderWhere("TransDate");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->TransDate, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->TransDate->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field PreparedBy
        $filter = $this->queryBuilderWhere("PreparedBy");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->PreparedBy, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->PreparedBy->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field AuthorisedBy
        $filter = $this->queryBuilderWhere("AuthorisedBy");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->AuthorisedBy, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->AuthorisedBy->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field NRC
        $filter = $this->queryBuilderWhere("NRC");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->NRC, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->NRC->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field FarmerName
        $filter = $this->queryBuilderWhere("FarmerName");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->FarmerName, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->FarmerName->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field DOB
        $filter = $this->queryBuilderWhere("DOB");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->DOB, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->DOB->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Age
        $filter = $this->queryBuilderWhere("Age");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Age, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Age->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Gender
        $filter = $this->queryBuilderWhere("Gender");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Gender, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Gender->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field MaritalStatus
        $filter = $this->queryBuilderWhere("MaritalStatus");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->MaritalStatus, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->MaritalStatus->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field PhoneNo
        $filter = $this->queryBuilderWhere("PhoneNo");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->PhoneNo, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->PhoneNo->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Email
        $filter = $this->queryBuilderWhere("Email");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_Email, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_Email->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Dependants
        $filter = $this->queryBuilderWhere("Dependants");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Dependants, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Dependants->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field MaleChildren
        $filter = $this->queryBuilderWhere("MaleChildren");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->MaleChildren, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->MaleChildren->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field FemaleChildren
        $filter = $this->queryBuilderWhere("FemaleChildren");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->FemaleChildren, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->FemaleChildren->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field HouseholdHead
        $filter = $this->queryBuilderWhere("HouseholdHead");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->HouseholdHead, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->HouseholdHead->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field FarmerOrg
        $filter = $this->queryBuilderWhere("FarmerOrg");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->FarmerOrg, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->FarmerOrg->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field FarmerOrgPosition
        $filter = $this->queryBuilderWhere("FarmerOrgPosition");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->FarmerOrgPosition, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->FarmerOrgPosition->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field JoiningDate
        $filter = $this->queryBuilderWhere("JoiningDate");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->JoiningDate, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->JoiningDate->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field NurseryName
        $filter = $this->queryBuilderWhere("NurseryName");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->NurseryName, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->NurseryName->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field NurseryType
        $filter = $this->queryBuilderWhere("NurseryType");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->NurseryType, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->NurseryType->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field NurseryOwnership
        $filter = $this->queryBuilderWhere("NurseryOwnership");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->NurseryOwnership, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->NurseryOwnership->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field NumberOfMembers
        $filter = $this->queryBuilderWhere("NumberOfMembers");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->NumberOfMembers, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->NumberOfMembers->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Longitude
        $filter = $this->queryBuilderWhere("Longitude");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Longitude, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Longitude->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Latitude
        $filter = $this->queryBuilderWhere("Latitude");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Latitude, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Latitude->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->DistrictName;
        $searchFlds[] = &$this->CampName;
        $searchFlds[] = &$this->Village;
        $searchFlds[] = &$this->FarmSize;
        $searchFlds[] = &$this->GRN;
        $searchFlds[] = &$this->SeedType;
        $searchFlds[] = &$this->PreparedBy;
        $searchFlds[] = &$this->AuthorisedBy;
        $searchFlds[] = &$this->NRC;
        $searchFlds[] = &$this->FarmerName;
        $searchFlds[] = &$this->Gender;
        $searchFlds[] = &$this->PhoneNo;
        $searchFlds[] = &$this->_Email;
        $searchFlds[] = &$this->FarmerOrg;
        $searchFlds[] = &$this->FarmerOrgPosition;
        $searchFlds[] = &$this->NurseryName;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->DistrictName->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->CampName->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Village->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FieldType->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Ownership->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FarmSize->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FarmSizeEstimated->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->TreesPlantedEstimated->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FarmSizeVerified->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->TreesPlantedVerified->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FarmNo->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->TransNo->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->GRN->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->TreesAllocated->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FarmingSeason->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->SeedType->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->SourcesOfSeedlings->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->TransDate->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->PreparedBy->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->AuthorisedBy->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->NRC->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FarmerName->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->DOB->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Age->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Gender->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->MaritalStatus->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->PhoneNo->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_Email->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Dependants->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->MaleChildren->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FemaleChildren->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->HouseholdHead->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FarmerOrg->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->FarmerOrgPosition->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->JoiningDate->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->NurseryName->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->NurseryType->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->NurseryOwnership->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->NumberOfMembers->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Longitude->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Latitude->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->DistrictName->AdvancedSearch->unsetSession();
        $this->CampName->AdvancedSearch->unsetSession();
        $this->Village->AdvancedSearch->unsetSession();
        $this->FieldType->AdvancedSearch->unsetSession();
        $this->Ownership->AdvancedSearch->unsetSession();
        $this->FarmSize->AdvancedSearch->unsetSession();
        $this->FarmSizeEstimated->AdvancedSearch->unsetSession();
        $this->TreesPlantedEstimated->AdvancedSearch->unsetSession();
        $this->FarmSizeVerified->AdvancedSearch->unsetSession();
        $this->TreesPlantedVerified->AdvancedSearch->unsetSession();
        $this->FarmNo->AdvancedSearch->unsetSession();
        $this->TransNo->AdvancedSearch->unsetSession();
        $this->GRN->AdvancedSearch->unsetSession();
        $this->TreesAllocated->AdvancedSearch->unsetSession();
        $this->FarmingSeason->AdvancedSearch->unsetSession();
        $this->SeedType->AdvancedSearch->unsetSession();
        $this->SourcesOfSeedlings->AdvancedSearch->unsetSession();
        $this->TransDate->AdvancedSearch->unsetSession();
        $this->PreparedBy->AdvancedSearch->unsetSession();
        $this->AuthorisedBy->AdvancedSearch->unsetSession();
        $this->NRC->AdvancedSearch->unsetSession();
        $this->FarmerName->AdvancedSearch->unsetSession();
        $this->DOB->AdvancedSearch->unsetSession();
        $this->Age->AdvancedSearch->unsetSession();
        $this->Gender->AdvancedSearch->unsetSession();
        $this->MaritalStatus->AdvancedSearch->unsetSession();
        $this->PhoneNo->AdvancedSearch->unsetSession();
        $this->_Email->AdvancedSearch->unsetSession();
        $this->Dependants->AdvancedSearch->unsetSession();
        $this->MaleChildren->AdvancedSearch->unsetSession();
        $this->FemaleChildren->AdvancedSearch->unsetSession();
        $this->HouseholdHead->AdvancedSearch->unsetSession();
        $this->FarmerOrg->AdvancedSearch->unsetSession();
        $this->FarmerOrgPosition->AdvancedSearch->unsetSession();
        $this->JoiningDate->AdvancedSearch->unsetSession();
        $this->NurseryName->AdvancedSearch->unsetSession();
        $this->NurseryType->AdvancedSearch->unsetSession();
        $this->NurseryOwnership->AdvancedSearch->unsetSession();
        $this->NumberOfMembers->AdvancedSearch->unsetSession();
        $this->Longitude->AdvancedSearch->unsetSession();
        $this->Latitude->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->DistrictName->AdvancedSearch->load();
        $this->CampName->AdvancedSearch->load();
        $this->Village->AdvancedSearch->load();
        $this->FieldType->AdvancedSearch->load();
        $this->Ownership->AdvancedSearch->load();
        $this->FarmSize->AdvancedSearch->load();
        $this->FarmSizeEstimated->AdvancedSearch->load();
        $this->TreesPlantedEstimated->AdvancedSearch->load();
        $this->FarmSizeVerified->AdvancedSearch->load();
        $this->TreesPlantedVerified->AdvancedSearch->load();
        $this->FarmNo->AdvancedSearch->load();
        $this->TransNo->AdvancedSearch->load();
        $this->GRN->AdvancedSearch->load();
        $this->TreesAllocated->AdvancedSearch->load();
        $this->FarmingSeason->AdvancedSearch->load();
        $this->SeedType->AdvancedSearch->load();
        $this->SourcesOfSeedlings->AdvancedSearch->load();
        $this->TransDate->AdvancedSearch->load();
        $this->PreparedBy->AdvancedSearch->load();
        $this->AuthorisedBy->AdvancedSearch->load();
        $this->NRC->AdvancedSearch->load();
        $this->FarmerName->AdvancedSearch->load();
        $this->DOB->AdvancedSearch->load();
        $this->Age->AdvancedSearch->load();
        $this->Gender->AdvancedSearch->load();
        $this->MaritalStatus->AdvancedSearch->load();
        $this->PhoneNo->AdvancedSearch->load();
        $this->_Email->AdvancedSearch->load();
        $this->Dependants->AdvancedSearch->load();
        $this->MaleChildren->AdvancedSearch->load();
        $this->FemaleChildren->AdvancedSearch->load();
        $this->HouseholdHead->AdvancedSearch->load();
        $this->FarmerOrg->AdvancedSearch->load();
        $this->FarmerOrgPosition->AdvancedSearch->load();
        $this->JoiningDate->AdvancedSearch->load();
        $this->NurseryName->AdvancedSearch->load();
        $this->NurseryType->AdvancedSearch->load();
        $this->NurseryOwnership->AdvancedSearch->load();
        $this->NumberOfMembers->AdvancedSearch->load();
        $this->Longitude->AdvancedSearch->load();
        $this->Latitude->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->DistrictName); // DistrictName
            $this->updateSort($this->CampName); // CampName
            $this->updateSort($this->Village); // Village
            $this->updateSort($this->FieldType); // FieldType
            $this->updateSort($this->Ownership); // Ownership
            $this->updateSort($this->FarmSize); // FarmSize
            $this->updateSort($this->FarmSizeEstimated); // FarmSizeEstimated
            $this->updateSort($this->TreesPlantedEstimated); // TreesPlantedEstimated
            $this->updateSort($this->FarmSizeVerified); // FarmSizeVerified
            $this->updateSort($this->TreesPlantedVerified); // TreesPlantedVerified
            $this->updateSort($this->FarmNo); // FarmNo
            $this->updateSort($this->TransNo); // TransNo
            $this->updateSort($this->GRN); // GRN
            $this->updateSort($this->TreesAllocated); // TreesAllocated
            $this->updateSort($this->FarmingSeason); // FarmingSeason
            $this->updateSort($this->SeedType); // SeedType
            $this->updateSort($this->SourcesOfSeedlings); // SourcesOfSeedlings
            $this->updateSort($this->TransDate); // TransDate
            $this->updateSort($this->PreparedBy); // PreparedBy
            $this->updateSort($this->AuthorisedBy); // AuthorisedBy
            $this->updateSort($this->NRC); // NRC
            $this->updateSort($this->FarmerName); // FarmerName
            $this->updateSort($this->DOB); // DOB
            $this->updateSort($this->Age); // Age
            $this->updateSort($this->Gender); // Gender
            $this->updateSort($this->MaritalStatus); // MaritalStatus
            $this->updateSort($this->PhoneNo); // PhoneNo
            $this->updateSort($this->_Email); // Email
            $this->updateSort($this->Dependants); // Dependants
            $this->updateSort($this->MaleChildren); // MaleChildren
            $this->updateSort($this->FemaleChildren); // FemaleChildren
            $this->updateSort($this->HouseholdHead); // HouseholdHead
            $this->updateSort($this->FarmerOrg); // FarmerOrg
            $this->updateSort($this->FarmerOrgPosition); // FarmerOrgPosition
            $this->updateSort($this->JoiningDate); // JoiningDate
            $this->updateSort($this->NurseryName); // NurseryName
            $this->updateSort($this->NurseryType); // NurseryType
            $this->updateSort($this->NurseryOwnership); // NurseryOwnership
            $this->updateSort($this->NumberOfMembers); // NumberOfMembers
            $this->updateSort($this->Longitude); // Longitude
            $this->updateSort($this->Latitude); // Latitude
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->DistrictName->setSort("");
                $this->CampName->setSort("");
                $this->Village->setSort("");
                $this->FieldType->setSort("");
                $this->Ownership->setSort("");
                $this->FarmSize->setSort("");
                $this->FarmSizeEstimated->setSort("");
                $this->TreesPlantedEstimated->setSort("");
                $this->FarmSizeVerified->setSort("");
                $this->TreesPlantedVerified->setSort("");
                $this->FarmNo->setSort("");
                $this->TransNo->setSort("");
                $this->GRN->setSort("");
                $this->TreesAllocated->setSort("");
                $this->FarmingSeason->setSort("");
                $this->SeedType->setSort("");
                $this->SourcesOfSeedlings->setSort("");
                $this->TransDate->setSort("");
                $this->PreparedBy->setSort("");
                $this->AuthorisedBy->setSort("");
                $this->NRC->setSort("");
                $this->FarmerName->setSort("");
                $this->DOB->setSort("");
                $this->Age->setSort("");
                $this->Gender->setSort("");
                $this->MaritalStatus->setSort("");
                $this->PhoneNo->setSort("");
                $this->_Email->setSort("");
                $this->Dependants->setSort("");
                $this->MaleChildren->setSort("");
                $this->FemaleChildren->setSort("");
                $this->HouseholdHead->setSort("");
                $this->FarmerOrg->setSort("");
                $this->FarmerOrgPosition->setSort("");
                $this->JoiningDate->setSort("");
                $this->NurseryName->setSort("");
                $this->NurseryType->setSort("");
                $this->NurseryOwnership->setSort("");
                $this->NumberOfMembers->setSort("");
                $this->Longitude->setSort("");
                $this->Latitude->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = true;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") { // Check view mode
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fseed_allocate_viewlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fseed_allocate_viewlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = "";
                foreach ($links as $link) {
                    $content .= "<li>" . $link . "</li>";
                }
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->FarmNo->CurrentValue . Config("COMPOSITE_KEY_SEPARATOR") . $this->TransNo->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "DistrictName");
            $this->createColumnOption($option, "CampName");
            $this->createColumnOption($option, "Village");
            $this->createColumnOption($option, "FieldType");
            $this->createColumnOption($option, "Ownership");
            $this->createColumnOption($option, "FarmSize");
            $this->createColumnOption($option, "FarmSizeEstimated");
            $this->createColumnOption($option, "TreesPlantedEstimated");
            $this->createColumnOption($option, "FarmSizeVerified");
            $this->createColumnOption($option, "TreesPlantedVerified");
            $this->createColumnOption($option, "FarmNo");
            $this->createColumnOption($option, "TransNo");
            $this->createColumnOption($option, "GRN");
            $this->createColumnOption($option, "TreesAllocated");
            $this->createColumnOption($option, "FarmingSeason");
            $this->createColumnOption($option, "SeedType");
            $this->createColumnOption($option, "SourcesOfSeedlings");
            $this->createColumnOption($option, "TransDate");
            $this->createColumnOption($option, "PreparedBy");
            $this->createColumnOption($option, "AuthorisedBy");
            $this->createColumnOption($option, "NRC");
            $this->createColumnOption($option, "FarmerName");
            $this->createColumnOption($option, "DOB");
            $this->createColumnOption($option, "Age");
            $this->createColumnOption($option, "Gender");
            $this->createColumnOption($option, "MaritalStatus");
            $this->createColumnOption($option, "PhoneNo");
            $this->createColumnOption($option, "Email");
            $this->createColumnOption($option, "Dependants");
            $this->createColumnOption($option, "MaleChildren");
            $this->createColumnOption($option, "FemaleChildren");
            $this->createColumnOption($option, "HouseholdHead");
            $this->createColumnOption($option, "FarmerOrg");
            $this->createColumnOption($option, "FarmerOrgPosition");
            $this->createColumnOption($option, "JoiningDate");
            $this->createColumnOption($option, "NurseryName");
            $this->createColumnOption($option, "NurseryType");
            $this->createColumnOption($option, "NurseryOwnership");
            $this->createColumnOption($option, "NumberOfMembers");
            $this->createColumnOption($option, "Longitude");
            $this->createColumnOption($option, "Latitude");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fseed_allocate_viewsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fseed_allocate_viewsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fseed_allocate_viewlist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_seed_allocate_view", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_seed_allocate_view",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // DistrictName
        if ($this->DistrictName->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->DistrictName->AdvancedSearch->SearchValue != "" || $this->DistrictName->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // CampName
        if ($this->CampName->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->CampName->AdvancedSearch->SearchValue != "" || $this->CampName->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Village
        if ($this->Village->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Village->AdvancedSearch->SearchValue != "" || $this->Village->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FieldType
        if ($this->FieldType->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FieldType->AdvancedSearch->SearchValue != "" || $this->FieldType->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Ownership
        if ($this->Ownership->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Ownership->AdvancedSearch->SearchValue != "" || $this->Ownership->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FarmSize
        if ($this->FarmSize->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FarmSize->AdvancedSearch->SearchValue != "" || $this->FarmSize->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FarmSizeEstimated
        if ($this->FarmSizeEstimated->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FarmSizeEstimated->AdvancedSearch->SearchValue != "" || $this->FarmSizeEstimated->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // TreesPlantedEstimated
        if ($this->TreesPlantedEstimated->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->TreesPlantedEstimated->AdvancedSearch->SearchValue != "" || $this->TreesPlantedEstimated->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FarmSizeVerified
        if ($this->FarmSizeVerified->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FarmSizeVerified->AdvancedSearch->SearchValue != "" || $this->FarmSizeVerified->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // TreesPlantedVerified
        if ($this->TreesPlantedVerified->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->TreesPlantedVerified->AdvancedSearch->SearchValue != "" || $this->TreesPlantedVerified->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FarmNo
        if ($this->FarmNo->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FarmNo->AdvancedSearch->SearchValue != "" || $this->FarmNo->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // TransNo
        if ($this->TransNo->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->TransNo->AdvancedSearch->SearchValue != "" || $this->TransNo->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // GRN
        if ($this->GRN->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->GRN->AdvancedSearch->SearchValue != "" || $this->GRN->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // TreesAllocated
        if ($this->TreesAllocated->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->TreesAllocated->AdvancedSearch->SearchValue != "" || $this->TreesAllocated->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FarmingSeason
        if ($this->FarmingSeason->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FarmingSeason->AdvancedSearch->SearchValue != "" || $this->FarmingSeason->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // SeedType
        if ($this->SeedType->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->SeedType->AdvancedSearch->SearchValue != "" || $this->SeedType->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // SourcesOfSeedlings
        if ($this->SourcesOfSeedlings->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->SourcesOfSeedlings->AdvancedSearch->SearchValue != "" || $this->SourcesOfSeedlings->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // TransDate
        if ($this->TransDate->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->TransDate->AdvancedSearch->SearchValue != "" || $this->TransDate->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // PreparedBy
        if ($this->PreparedBy->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->PreparedBy->AdvancedSearch->SearchValue != "" || $this->PreparedBy->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // AuthorisedBy
        if ($this->AuthorisedBy->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->AuthorisedBy->AdvancedSearch->SearchValue != "" || $this->AuthorisedBy->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // NRC
        if ($this->NRC->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->NRC->AdvancedSearch->SearchValue != "" || $this->NRC->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FarmerName
        if ($this->FarmerName->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FarmerName->AdvancedSearch->SearchValue != "" || $this->FarmerName->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // DOB
        if ($this->DOB->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->DOB->AdvancedSearch->SearchValue != "" || $this->DOB->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Age
        if ($this->Age->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Age->AdvancedSearch->SearchValue != "" || $this->Age->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Gender
        if ($this->Gender->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Gender->AdvancedSearch->SearchValue != "" || $this->Gender->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // MaritalStatus
        if ($this->MaritalStatus->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->MaritalStatus->AdvancedSearch->SearchValue != "" || $this->MaritalStatus->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // PhoneNo
        if ($this->PhoneNo->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->PhoneNo->AdvancedSearch->SearchValue != "" || $this->PhoneNo->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Email
        if ($this->_Email->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_Email->AdvancedSearch->SearchValue != "" || $this->_Email->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Dependants
        if ($this->Dependants->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Dependants->AdvancedSearch->SearchValue != "" || $this->Dependants->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // MaleChildren
        if ($this->MaleChildren->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->MaleChildren->AdvancedSearch->SearchValue != "" || $this->MaleChildren->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FemaleChildren
        if ($this->FemaleChildren->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FemaleChildren->AdvancedSearch->SearchValue != "" || $this->FemaleChildren->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // HouseholdHead
        if ($this->HouseholdHead->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->HouseholdHead->AdvancedSearch->SearchValue != "" || $this->HouseholdHead->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FarmerOrg
        if ($this->FarmerOrg->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FarmerOrg->AdvancedSearch->SearchValue != "" || $this->FarmerOrg->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // FarmerOrgPosition
        if ($this->FarmerOrgPosition->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->FarmerOrgPosition->AdvancedSearch->SearchValue != "" || $this->FarmerOrgPosition->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // JoiningDate
        if ($this->JoiningDate->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->JoiningDate->AdvancedSearch->SearchValue != "" || $this->JoiningDate->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // NurseryName
        if ($this->NurseryName->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->NurseryName->AdvancedSearch->SearchValue != "" || $this->NurseryName->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // NurseryType
        if ($this->NurseryType->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->NurseryType->AdvancedSearch->SearchValue != "" || $this->NurseryType->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // NurseryOwnership
        if ($this->NurseryOwnership->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->NurseryOwnership->AdvancedSearch->SearchValue != "" || $this->NurseryOwnership->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // NumberOfMembers
        if ($this->NumberOfMembers->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->NumberOfMembers->AdvancedSearch->SearchValue != "" || $this->NumberOfMembers->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Longitude
        if ($this->Longitude->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Longitude->AdvancedSearch->SearchValue != "" || $this->Longitude->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Latitude
        if ($this->Latitude->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Latitude->AdvancedSearch->SearchValue != "" || $this->Latitude->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->DistrictName->setDbValue($row['DistrictName']);
        $this->CampName->setDbValue($row['CampName']);
        $this->Village->setDbValue($row['Village']);
        $this->FieldType->setDbValue($row['FieldType']);
        $this->Ownership->setDbValue($row['Ownership']);
        $this->FarmSize->setDbValue($row['FarmSize']);
        $this->FarmSizeEstimated->setDbValue($row['FarmSizeEstimated']);
        $this->TreesPlantedEstimated->setDbValue($row['TreesPlantedEstimated']);
        $this->FarmSizeVerified->setDbValue($row['FarmSizeVerified']);
        $this->TreesPlantedVerified->setDbValue($row['TreesPlantedVerified']);
        $this->FarmNo->setDbValue($row['FarmNo']);
        $this->TransNo->setDbValue($row['TransNo']);
        $this->GRN->setDbValue($row['GRN']);
        $this->TreesAllocated->setDbValue($row['TreesAllocated']);
        $this->FarmingSeason->setDbValue($row['FarmingSeason']);
        $this->SeedType->setDbValue($row['SeedType']);
        $this->SourcesOfSeedlings->setDbValue($row['SourcesOfSeedlings']);
        $this->TransDate->setDbValue($row['TransDate']);
        $this->PreparedBy->setDbValue($row['PreparedBy']);
        $this->AuthorisedBy->setDbValue($row['AuthorisedBy']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmerName->setDbValue($row['FarmerName']);
        $this->DOB->setDbValue($row['DOB']);
        $this->Age->setDbValue($row['Age']);
        $this->Gender->setDbValue($row['Gender']);
        $this->MaritalStatus->setDbValue($row['MaritalStatus']);
        $this->PhoneNo->setDbValue($row['PhoneNo']);
        $this->_Email->setDbValue($row['Email']);
        $this->Dependants->setDbValue($row['Dependants']);
        $this->MaleChildren->setDbValue($row['MaleChildren']);
        $this->FemaleChildren->setDbValue($row['FemaleChildren']);
        $this->HouseholdHead->setDbValue($row['HouseholdHead']);
        $this->FarmerOrg->setDbValue($row['FarmerOrg']);
        $this->FarmerOrgPosition->setDbValue($row['FarmerOrgPosition']);
        $this->JoiningDate->setDbValue($row['JoiningDate']);
        $this->NurseryName->setDbValue($row['NurseryName']);
        $this->NurseryType->setDbValue($row['NurseryType']);
        $this->NurseryOwnership->setDbValue($row['NurseryOwnership']);
        $this->NumberOfMembers->setDbValue($row['NumberOfMembers']);
        $this->Longitude->setDbValue($row['Longitude']);
        $this->Latitude->setDbValue($row['Latitude']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['DistrictName'] = $this->DistrictName->DefaultValue;
        $row['CampName'] = $this->CampName->DefaultValue;
        $row['Village'] = $this->Village->DefaultValue;
        $row['FieldType'] = $this->FieldType->DefaultValue;
        $row['Ownership'] = $this->Ownership->DefaultValue;
        $row['FarmSize'] = $this->FarmSize->DefaultValue;
        $row['FarmSizeEstimated'] = $this->FarmSizeEstimated->DefaultValue;
        $row['TreesPlantedEstimated'] = $this->TreesPlantedEstimated->DefaultValue;
        $row['FarmSizeVerified'] = $this->FarmSizeVerified->DefaultValue;
        $row['TreesPlantedVerified'] = $this->TreesPlantedVerified->DefaultValue;
        $row['FarmNo'] = $this->FarmNo->DefaultValue;
        $row['TransNo'] = $this->TransNo->DefaultValue;
        $row['GRN'] = $this->GRN->DefaultValue;
        $row['TreesAllocated'] = $this->TreesAllocated->DefaultValue;
        $row['FarmingSeason'] = $this->FarmingSeason->DefaultValue;
        $row['SeedType'] = $this->SeedType->DefaultValue;
        $row['SourcesOfSeedlings'] = $this->SourcesOfSeedlings->DefaultValue;
        $row['TransDate'] = $this->TransDate->DefaultValue;
        $row['PreparedBy'] = $this->PreparedBy->DefaultValue;
        $row['AuthorisedBy'] = $this->AuthorisedBy->DefaultValue;
        $row['NRC'] = $this->NRC->DefaultValue;
        $row['FarmerName'] = $this->FarmerName->DefaultValue;
        $row['DOB'] = $this->DOB->DefaultValue;
        $row['Age'] = $this->Age->DefaultValue;
        $row['Gender'] = $this->Gender->DefaultValue;
        $row['MaritalStatus'] = $this->MaritalStatus->DefaultValue;
        $row['PhoneNo'] = $this->PhoneNo->DefaultValue;
        $row['Email'] = $this->_Email->DefaultValue;
        $row['Dependants'] = $this->Dependants->DefaultValue;
        $row['MaleChildren'] = $this->MaleChildren->DefaultValue;
        $row['FemaleChildren'] = $this->FemaleChildren->DefaultValue;
        $row['HouseholdHead'] = $this->HouseholdHead->DefaultValue;
        $row['FarmerOrg'] = $this->FarmerOrg->DefaultValue;
        $row['FarmerOrgPosition'] = $this->FarmerOrgPosition->DefaultValue;
        $row['JoiningDate'] = $this->JoiningDate->DefaultValue;
        $row['NurseryName'] = $this->NurseryName->DefaultValue;
        $row['NurseryType'] = $this->NurseryType->DefaultValue;
        $row['NurseryOwnership'] = $this->NurseryOwnership->DefaultValue;
        $row['NumberOfMembers'] = $this->NumberOfMembers->DefaultValue;
        $row['Longitude'] = $this->Longitude->DefaultValue;
        $row['Latitude'] = $this->Latitude->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // DistrictName

        // CampName

        // Village

        // FieldType

        // Ownership

        // FarmSize

        // FarmSizeEstimated

        // TreesPlantedEstimated

        // FarmSizeVerified

        // TreesPlantedVerified

        // FarmNo

        // TransNo

        // GRN

        // TreesAllocated

        // FarmingSeason

        // SeedType

        // SourcesOfSeedlings

        // TransDate

        // PreparedBy

        // AuthorisedBy

        // NRC

        // FarmerName

        // DOB

        // Age

        // Gender

        // MaritalStatus

        // PhoneNo

        // Email

        // Dependants

        // MaleChildren

        // FemaleChildren

        // HouseholdHead

        // FarmerOrg

        // FarmerOrgPosition

        // JoiningDate

        // NurseryName

        // NurseryType

        // NurseryOwnership

        // NumberOfMembers

        // Longitude

        // Latitude

        // View row
        if ($this->RowType == RowType::VIEW) {
            // DistrictName
            $this->DistrictName->ViewValue = $this->DistrictName->CurrentValue;

            // CampName
            $this->CampName->ViewValue = $this->CampName->CurrentValue;

            // Village
            $this->Village->ViewValue = $this->Village->CurrentValue;

            // FieldType
            $this->FieldType->ViewValue = $this->FieldType->CurrentValue;

            // Ownership
            $this->Ownership->ViewValue = $this->Ownership->CurrentValue;

            // FarmSize
            $this->FarmSize->ViewValue = $this->FarmSize->CurrentValue;

            // FarmSizeEstimated
            $this->FarmSizeEstimated->ViewValue = $this->FarmSizeEstimated->CurrentValue;
            $this->FarmSizeEstimated->ViewValue = FormatNumber($this->FarmSizeEstimated->ViewValue, $this->FarmSizeEstimated->formatPattern());

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->ViewValue = $this->TreesPlantedEstimated->CurrentValue;
            $this->TreesPlantedEstimated->ViewValue = FormatNumber($this->TreesPlantedEstimated->ViewValue, $this->TreesPlantedEstimated->formatPattern());

            // FarmSizeVerified
            $this->FarmSizeVerified->ViewValue = $this->FarmSizeVerified->CurrentValue;
            $this->FarmSizeVerified->ViewValue = FormatNumber($this->FarmSizeVerified->ViewValue, $this->FarmSizeVerified->formatPattern());

            // TreesPlantedVerified
            $this->TreesPlantedVerified->ViewValue = $this->TreesPlantedVerified->CurrentValue;
            $this->TreesPlantedVerified->ViewValue = FormatNumber($this->TreesPlantedVerified->ViewValue, $this->TreesPlantedVerified->formatPattern());

            // FarmNo
            $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;

            // TransNo
            $this->TransNo->ViewValue = $this->TransNo->CurrentValue;

            // GRN
            $this->GRN->ViewValue = $this->GRN->CurrentValue;

            // TreesAllocated
            $this->TreesAllocated->ViewValue = $this->TreesAllocated->CurrentValue;

            // FarmingSeason
            $this->FarmingSeason->ViewValue = $this->FarmingSeason->CurrentValue;

            // SeedType
            $this->SeedType->ViewValue = $this->SeedType->CurrentValue;

            // SourcesOfSeedlings
            $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->CurrentValue;

            // TransDate
            $this->TransDate->ViewValue = $this->TransDate->CurrentValue;
            $this->TransDate->ViewValue = FormatDateTime($this->TransDate->ViewValue, $this->TransDate->formatPattern());

            // PreparedBy
            $this->PreparedBy->ViewValue = $this->PreparedBy->CurrentValue;

            // AuthorisedBy
            $this->AuthorisedBy->ViewValue = $this->AuthorisedBy->CurrentValue;

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;

            // FarmerName
            $this->FarmerName->ViewValue = $this->FarmerName->CurrentValue;

            // DOB
            $this->DOB->ViewValue = $this->DOB->CurrentValue;
            $this->DOB->ViewValue = FormatDateTime($this->DOB->ViewValue, $this->DOB->formatPattern());

            // Age
            $this->Age->ViewValue = $this->Age->CurrentValue;
            $this->Age->ViewValue = FormatNumber($this->Age->ViewValue, $this->Age->formatPattern());

            // Gender
            $this->Gender->ViewValue = $this->Gender->CurrentValue;

            // MaritalStatus
            $this->MaritalStatus->ViewValue = $this->MaritalStatus->CurrentValue;

            // PhoneNo
            $this->PhoneNo->ViewValue = $this->PhoneNo->CurrentValue;

            // Email
            $this->_Email->ViewValue = $this->_Email->CurrentValue;

            // Dependants
            $this->Dependants->ViewValue = $this->Dependants->CurrentValue;

            // MaleChildren
            $this->MaleChildren->ViewValue = $this->MaleChildren->CurrentValue;

            // FemaleChildren
            $this->FemaleChildren->ViewValue = $this->FemaleChildren->CurrentValue;

            // HouseholdHead
            $this->HouseholdHead->ViewValue = $this->HouseholdHead->CurrentValue;

            // FarmerOrg
            $this->FarmerOrg->ViewValue = $this->FarmerOrg->CurrentValue;

            // FarmerOrgPosition
            $this->FarmerOrgPosition->ViewValue = $this->FarmerOrgPosition->CurrentValue;

            // JoiningDate
            $this->JoiningDate->ViewValue = $this->JoiningDate->CurrentValue;
            $this->JoiningDate->ViewValue = FormatDateTime($this->JoiningDate->ViewValue, $this->JoiningDate->formatPattern());

            // NurseryName
            $this->NurseryName->ViewValue = $this->NurseryName->CurrentValue;

            // NurseryType
            $this->NurseryType->ViewValue = $this->NurseryType->CurrentValue;

            // NurseryOwnership
            $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->CurrentValue;

            // NumberOfMembers
            $this->NumberOfMembers->ViewValue = $this->NumberOfMembers->CurrentValue;

            // Longitude
            $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
            $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());

            // Latitude
            $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
            $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());

            // DistrictName
            $this->DistrictName->HrefValue = "";
            $this->DistrictName->TooltipValue = "";

            // CampName
            $this->CampName->HrefValue = "";
            $this->CampName->TooltipValue = "";

            // Village
            $this->Village->HrefValue = "";
            $this->Village->TooltipValue = "";

            // FieldType
            $this->FieldType->HrefValue = "";
            $this->FieldType->TooltipValue = "";

            // Ownership
            $this->Ownership->HrefValue = "";
            $this->Ownership->TooltipValue = "";

            // FarmSize
            $this->FarmSize->HrefValue = "";
            $this->FarmSize->TooltipValue = "";

            // FarmSizeEstimated
            $this->FarmSizeEstimated->HrefValue = "";
            $this->FarmSizeEstimated->TooltipValue = "";

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->HrefValue = "";
            $this->TreesPlantedEstimated->TooltipValue = "";

            // FarmSizeVerified
            $this->FarmSizeVerified->HrefValue = "";
            $this->FarmSizeVerified->TooltipValue = "";

            // TreesPlantedVerified
            $this->TreesPlantedVerified->HrefValue = "";
            $this->TreesPlantedVerified->TooltipValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";
            $this->FarmNo->TooltipValue = "";

            // TransNo
            $this->TransNo->HrefValue = "";
            $this->TransNo->TooltipValue = "";

            // GRN
            $this->GRN->HrefValue = "";
            $this->GRN->TooltipValue = "";

            // TreesAllocated
            $this->TreesAllocated->HrefValue = "";
            $this->TreesAllocated->TooltipValue = "";

            // FarmingSeason
            $this->FarmingSeason->HrefValue = "";
            $this->FarmingSeason->TooltipValue = "";

            // SeedType
            $this->SeedType->HrefValue = "";
            $this->SeedType->TooltipValue = "";

            // SourcesOfSeedlings
            $this->SourcesOfSeedlings->HrefValue = "";
            $this->SourcesOfSeedlings->TooltipValue = "";

            // TransDate
            $this->TransDate->HrefValue = "";
            $this->TransDate->TooltipValue = "";

            // PreparedBy
            $this->PreparedBy->HrefValue = "";
            $this->PreparedBy->TooltipValue = "";

            // AuthorisedBy
            $this->AuthorisedBy->HrefValue = "";
            $this->AuthorisedBy->TooltipValue = "";

            // NRC
            $this->NRC->HrefValue = "";
            $this->NRC->TooltipValue = "";

            // FarmerName
            $this->FarmerName->HrefValue = "";
            $this->FarmerName->TooltipValue = "";

            // DOB
            $this->DOB->HrefValue = "";
            $this->DOB->TooltipValue = "";

            // Age
            $this->Age->HrefValue = "";
            $this->Age->TooltipValue = "";

            // Gender
            $this->Gender->HrefValue = "";
            $this->Gender->TooltipValue = "";

            // MaritalStatus
            $this->MaritalStatus->HrefValue = "";
            $this->MaritalStatus->TooltipValue = "";

            // PhoneNo
            $this->PhoneNo->HrefValue = "";
            $this->PhoneNo->TooltipValue = "";

            // Email
            $this->_Email->HrefValue = "";
            $this->_Email->TooltipValue = "";

            // Dependants
            $this->Dependants->HrefValue = "";
            $this->Dependants->TooltipValue = "";

            // MaleChildren
            $this->MaleChildren->HrefValue = "";
            $this->MaleChildren->TooltipValue = "";

            // FemaleChildren
            $this->FemaleChildren->HrefValue = "";
            $this->FemaleChildren->TooltipValue = "";

            // HouseholdHead
            $this->HouseholdHead->HrefValue = "";
            $this->HouseholdHead->TooltipValue = "";

            // FarmerOrg
            $this->FarmerOrg->HrefValue = "";
            $this->FarmerOrg->TooltipValue = "";

            // FarmerOrgPosition
            $this->FarmerOrgPosition->HrefValue = "";
            $this->FarmerOrgPosition->TooltipValue = "";

            // JoiningDate
            $this->JoiningDate->HrefValue = "";
            $this->JoiningDate->TooltipValue = "";

            // NurseryName
            $this->NurseryName->HrefValue = "";
            $this->NurseryName->TooltipValue = "";

            // NurseryType
            $this->NurseryType->HrefValue = "";
            $this->NurseryType->TooltipValue = "";

            // NurseryOwnership
            $this->NurseryOwnership->HrefValue = "";
            $this->NurseryOwnership->TooltipValue = "";

            // NumberOfMembers
            $this->NumberOfMembers->HrefValue = "";
            $this->NumberOfMembers->TooltipValue = "";

            // Longitude
            $this->Longitude->HrefValue = "";
            $this->Longitude->TooltipValue = "";

            // Latitude
            $this->Latitude->HrefValue = "";
            $this->Latitude->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // DistrictName
            $this->DistrictName->setupEditAttributes();
            if (!$this->DistrictName->Raw) {
                $this->DistrictName->AdvancedSearch->SearchValue = HtmlDecode($this->DistrictName->AdvancedSearch->SearchValue);
            }
            $this->DistrictName->EditValue = HtmlEncode($this->DistrictName->AdvancedSearch->SearchValue);
            $this->DistrictName->PlaceHolder = RemoveHtml($this->DistrictName->caption());

            // CampName
            $this->CampName->setupEditAttributes();
            if (!$this->CampName->Raw) {
                $this->CampName->AdvancedSearch->SearchValue = HtmlDecode($this->CampName->AdvancedSearch->SearchValue);
            }
            $this->CampName->EditValue = HtmlEncode($this->CampName->AdvancedSearch->SearchValue);
            $this->CampName->PlaceHolder = RemoveHtml($this->CampName->caption());

            // Village
            $this->Village->setupEditAttributes();
            if (!$this->Village->Raw) {
                $this->Village->AdvancedSearch->SearchValue = HtmlDecode($this->Village->AdvancedSearch->SearchValue);
            }
            $this->Village->EditValue = HtmlEncode($this->Village->AdvancedSearch->SearchValue);
            $this->Village->PlaceHolder = RemoveHtml($this->Village->caption());

            // FieldType
            $this->FieldType->setupEditAttributes();
            $this->FieldType->EditValue = $this->FieldType->AdvancedSearch->SearchValue;
            $this->FieldType->PlaceHolder = RemoveHtml($this->FieldType->caption());

            // Ownership
            $this->Ownership->setupEditAttributes();
            $this->Ownership->EditValue = $this->Ownership->AdvancedSearch->SearchValue;
            $this->Ownership->PlaceHolder = RemoveHtml($this->Ownership->caption());

            // FarmSize
            $this->FarmSize->setupEditAttributes();
            if (!$this->FarmSize->Raw) {
                $this->FarmSize->AdvancedSearch->SearchValue = HtmlDecode($this->FarmSize->AdvancedSearch->SearchValue);
            }
            $this->FarmSize->EditValue = HtmlEncode($this->FarmSize->AdvancedSearch->SearchValue);
            $this->FarmSize->PlaceHolder = RemoveHtml($this->FarmSize->caption());

            // FarmSizeEstimated
            $this->FarmSizeEstimated->setupEditAttributes();
            $this->FarmSizeEstimated->EditValue = $this->FarmSizeEstimated->AdvancedSearch->SearchValue;
            $this->FarmSizeEstimated->PlaceHolder = RemoveHtml($this->FarmSizeEstimated->caption());

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->setupEditAttributes();
            $this->TreesPlantedEstimated->EditValue = $this->TreesPlantedEstimated->AdvancedSearch->SearchValue;
            $this->TreesPlantedEstimated->PlaceHolder = RemoveHtml($this->TreesPlantedEstimated->caption());

            // FarmSizeVerified
            $this->FarmSizeVerified->setupEditAttributes();
            $this->FarmSizeVerified->EditValue = $this->FarmSizeVerified->AdvancedSearch->SearchValue;
            $this->FarmSizeVerified->PlaceHolder = RemoveHtml($this->FarmSizeVerified->caption());

            // TreesPlantedVerified
            $this->TreesPlantedVerified->setupEditAttributes();
            $this->TreesPlantedVerified->EditValue = $this->TreesPlantedVerified->AdvancedSearch->SearchValue;
            $this->TreesPlantedVerified->PlaceHolder = RemoveHtml($this->TreesPlantedVerified->caption());

            // FarmNo
            $this->FarmNo->setupEditAttributes();
            $this->FarmNo->EditValue = $this->FarmNo->AdvancedSearch->SearchValue;
            $this->FarmNo->PlaceHolder = RemoveHtml($this->FarmNo->caption());

            // TransNo
            $this->TransNo->setupEditAttributes();
            $this->TransNo->EditValue = $this->TransNo->AdvancedSearch->SearchValue;
            $this->TransNo->PlaceHolder = RemoveHtml($this->TransNo->caption());

            // GRN
            $this->GRN->setupEditAttributes();
            if (!$this->GRN->Raw) {
                $this->GRN->AdvancedSearch->SearchValue = HtmlDecode($this->GRN->AdvancedSearch->SearchValue);
            }
            $this->GRN->EditValue = HtmlEncode($this->GRN->AdvancedSearch->SearchValue);
            $this->GRN->PlaceHolder = RemoveHtml($this->GRN->caption());

            // TreesAllocated
            $this->TreesAllocated->setupEditAttributes();
            if (!$this->TreesAllocated->Raw) {
                $this->TreesAllocated->AdvancedSearch->SearchValue = HtmlDecode($this->TreesAllocated->AdvancedSearch->SearchValue);
            }
            $this->TreesAllocated->EditValue = HtmlEncode($this->TreesAllocated->AdvancedSearch->SearchValue);
            $this->TreesAllocated->PlaceHolder = RemoveHtml($this->TreesAllocated->caption());

            // FarmingSeason
            $this->FarmingSeason->setupEditAttributes();
            $this->FarmingSeason->EditValue = $this->FarmingSeason->AdvancedSearch->SearchValue;
            $this->FarmingSeason->PlaceHolder = RemoveHtml($this->FarmingSeason->caption());

            // SeedType
            $this->SeedType->setupEditAttributes();
            if (!$this->SeedType->Raw) {
                $this->SeedType->AdvancedSearch->SearchValue = HtmlDecode($this->SeedType->AdvancedSearch->SearchValue);
            }
            $this->SeedType->EditValue = HtmlEncode($this->SeedType->AdvancedSearch->SearchValue);
            $this->SeedType->PlaceHolder = RemoveHtml($this->SeedType->caption());

            // SourcesOfSeedlings
            $this->SourcesOfSeedlings->setupEditAttributes();
            $this->SourcesOfSeedlings->EditValue = $this->SourcesOfSeedlings->AdvancedSearch->SearchValue;
            $this->SourcesOfSeedlings->PlaceHolder = RemoveHtml($this->SourcesOfSeedlings->caption());

            // TransDate
            $this->TransDate->setupEditAttributes();
            $this->TransDate->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->TransDate->AdvancedSearch->SearchValue, $this->TransDate->formatPattern()), $this->TransDate->formatPattern()));
            $this->TransDate->PlaceHolder = RemoveHtml($this->TransDate->caption());

            // PreparedBy
            $this->PreparedBy->setupEditAttributes();
            if (!$this->PreparedBy->Raw) {
                $this->PreparedBy->AdvancedSearch->SearchValue = HtmlDecode($this->PreparedBy->AdvancedSearch->SearchValue);
            }
            $this->PreparedBy->EditValue = HtmlEncode($this->PreparedBy->AdvancedSearch->SearchValue);
            $this->PreparedBy->PlaceHolder = RemoveHtml($this->PreparedBy->caption());

            // AuthorisedBy
            $this->AuthorisedBy->setupEditAttributes();
            if (!$this->AuthorisedBy->Raw) {
                $this->AuthorisedBy->AdvancedSearch->SearchValue = HtmlDecode($this->AuthorisedBy->AdvancedSearch->SearchValue);
            }
            $this->AuthorisedBy->EditValue = HtmlEncode($this->AuthorisedBy->AdvancedSearch->SearchValue);
            $this->AuthorisedBy->PlaceHolder = RemoveHtml($this->AuthorisedBy->caption());

            // NRC
            $this->NRC->setupEditAttributes();
            if (!$this->NRC->Raw) {
                $this->NRC->AdvancedSearch->SearchValue = HtmlDecode($this->NRC->AdvancedSearch->SearchValue);
            }
            $this->NRC->EditValue = HtmlEncode($this->NRC->AdvancedSearch->SearchValue);
            $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

            // FarmerName
            $this->FarmerName->setupEditAttributes();
            if (!$this->FarmerName->Raw) {
                $this->FarmerName->AdvancedSearch->SearchValue = HtmlDecode($this->FarmerName->AdvancedSearch->SearchValue);
            }
            $this->FarmerName->EditValue = HtmlEncode($this->FarmerName->AdvancedSearch->SearchValue);
            $this->FarmerName->PlaceHolder = RemoveHtml($this->FarmerName->caption());

            // DOB
            $this->DOB->setupEditAttributes();
            $this->DOB->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->DOB->AdvancedSearch->SearchValue, $this->DOB->formatPattern()), $this->DOB->formatPattern()));
            $this->DOB->PlaceHolder = RemoveHtml($this->DOB->caption());

            // Age
            $this->Age->setupEditAttributes();
            $this->Age->EditValue = $this->Age->AdvancedSearch->SearchValue;
            $this->Age->PlaceHolder = RemoveHtml($this->Age->caption());

            // Gender
            $this->Gender->setupEditAttributes();
            if (!$this->Gender->Raw) {
                $this->Gender->AdvancedSearch->SearchValue = HtmlDecode($this->Gender->AdvancedSearch->SearchValue);
            }
            $this->Gender->EditValue = HtmlEncode($this->Gender->AdvancedSearch->SearchValue);
            $this->Gender->PlaceHolder = RemoveHtml($this->Gender->caption());

            // MaritalStatus
            $this->MaritalStatus->setupEditAttributes();
            $this->MaritalStatus->EditValue = $this->MaritalStatus->AdvancedSearch->SearchValue;
            $this->MaritalStatus->PlaceHolder = RemoveHtml($this->MaritalStatus->caption());

            // PhoneNo
            $this->PhoneNo->setupEditAttributes();
            if (!$this->PhoneNo->Raw) {
                $this->PhoneNo->AdvancedSearch->SearchValue = HtmlDecode($this->PhoneNo->AdvancedSearch->SearchValue);
            }
            $this->PhoneNo->EditValue = HtmlEncode($this->PhoneNo->AdvancedSearch->SearchValue);
            $this->PhoneNo->PlaceHolder = RemoveHtml($this->PhoneNo->caption());

            // Email
            $this->_Email->setupEditAttributes();
            if (!$this->_Email->Raw) {
                $this->_Email->AdvancedSearch->SearchValue = HtmlDecode($this->_Email->AdvancedSearch->SearchValue);
            }
            $this->_Email->EditValue = HtmlEncode($this->_Email->AdvancedSearch->SearchValue);
            $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

            // Dependants
            $this->Dependants->setupEditAttributes();
            $this->Dependants->EditValue = $this->Dependants->AdvancedSearch->SearchValue;
            $this->Dependants->PlaceHolder = RemoveHtml($this->Dependants->caption());

            // MaleChildren
            $this->MaleChildren->setupEditAttributes();
            $this->MaleChildren->EditValue = $this->MaleChildren->AdvancedSearch->SearchValue;
            $this->MaleChildren->PlaceHolder = RemoveHtml($this->MaleChildren->caption());

            // FemaleChildren
            $this->FemaleChildren->setupEditAttributes();
            $this->FemaleChildren->EditValue = $this->FemaleChildren->AdvancedSearch->SearchValue;
            $this->FemaleChildren->PlaceHolder = RemoveHtml($this->FemaleChildren->caption());

            // HouseholdHead
            $this->HouseholdHead->setupEditAttributes();
            $this->HouseholdHead->EditValue = $this->HouseholdHead->AdvancedSearch->SearchValue;
            $this->HouseholdHead->PlaceHolder = RemoveHtml($this->HouseholdHead->caption());

            // FarmerOrg
            $this->FarmerOrg->setupEditAttributes();
            if (!$this->FarmerOrg->Raw) {
                $this->FarmerOrg->AdvancedSearch->SearchValue = HtmlDecode($this->FarmerOrg->AdvancedSearch->SearchValue);
            }
            $this->FarmerOrg->EditValue = HtmlEncode($this->FarmerOrg->AdvancedSearch->SearchValue);
            $this->FarmerOrg->PlaceHolder = RemoveHtml($this->FarmerOrg->caption());

            // FarmerOrgPosition
            $this->FarmerOrgPosition->setupEditAttributes();
            if (!$this->FarmerOrgPosition->Raw) {
                $this->FarmerOrgPosition->AdvancedSearch->SearchValue = HtmlDecode($this->FarmerOrgPosition->AdvancedSearch->SearchValue);
            }
            $this->FarmerOrgPosition->EditValue = HtmlEncode($this->FarmerOrgPosition->AdvancedSearch->SearchValue);
            $this->FarmerOrgPosition->PlaceHolder = RemoveHtml($this->FarmerOrgPosition->caption());

            // JoiningDate
            $this->JoiningDate->setupEditAttributes();
            $this->JoiningDate->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->JoiningDate->AdvancedSearch->SearchValue, $this->JoiningDate->formatPattern()), $this->JoiningDate->formatPattern()));
            $this->JoiningDate->PlaceHolder = RemoveHtml($this->JoiningDate->caption());

            // NurseryName
            $this->NurseryName->setupEditAttributes();
            if (!$this->NurseryName->Raw) {
                $this->NurseryName->AdvancedSearch->SearchValue = HtmlDecode($this->NurseryName->AdvancedSearch->SearchValue);
            }
            $this->NurseryName->EditValue = HtmlEncode($this->NurseryName->AdvancedSearch->SearchValue);
            $this->NurseryName->PlaceHolder = RemoveHtml($this->NurseryName->caption());

            // NurseryType
            $this->NurseryType->setupEditAttributes();
            $this->NurseryType->EditValue = $this->NurseryType->AdvancedSearch->SearchValue;
            $this->NurseryType->PlaceHolder = RemoveHtml($this->NurseryType->caption());

            // NurseryOwnership
            $this->NurseryOwnership->setupEditAttributes();
            $this->NurseryOwnership->EditValue = $this->NurseryOwnership->AdvancedSearch->SearchValue;
            $this->NurseryOwnership->PlaceHolder = RemoveHtml($this->NurseryOwnership->caption());

            // NumberOfMembers
            $this->NumberOfMembers->setupEditAttributes();
            $this->NumberOfMembers->EditValue = $this->NumberOfMembers->AdvancedSearch->SearchValue;
            $this->NumberOfMembers->PlaceHolder = RemoveHtml($this->NumberOfMembers->caption());

            // Longitude
            $this->Longitude->setupEditAttributes();
            $this->Longitude->EditValue = $this->Longitude->AdvancedSearch->SearchValue;
            $this->Longitude->PlaceHolder = RemoveHtml($this->Longitude->caption());

            // Latitude
            $this->Latitude->setupEditAttributes();
            $this->Latitude->EditValue = $this->Latitude->AdvancedSearch->SearchValue;
            $this->Latitude->PlaceHolder = RemoveHtml($this->Latitude->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->DistrictName->AdvancedSearch->load();
        $this->CampName->AdvancedSearch->load();
        $this->Village->AdvancedSearch->load();
        $this->FieldType->AdvancedSearch->load();
        $this->Ownership->AdvancedSearch->load();
        $this->FarmSize->AdvancedSearch->load();
        $this->FarmSizeEstimated->AdvancedSearch->load();
        $this->TreesPlantedEstimated->AdvancedSearch->load();
        $this->FarmSizeVerified->AdvancedSearch->load();
        $this->TreesPlantedVerified->AdvancedSearch->load();
        $this->FarmNo->AdvancedSearch->load();
        $this->TransNo->AdvancedSearch->load();
        $this->GRN->AdvancedSearch->load();
        $this->TreesAllocated->AdvancedSearch->load();
        $this->FarmingSeason->AdvancedSearch->load();
        $this->SeedType->AdvancedSearch->load();
        $this->SourcesOfSeedlings->AdvancedSearch->load();
        $this->TransDate->AdvancedSearch->load();
        $this->PreparedBy->AdvancedSearch->load();
        $this->AuthorisedBy->AdvancedSearch->load();
        $this->NRC->AdvancedSearch->load();
        $this->FarmerName->AdvancedSearch->load();
        $this->DOB->AdvancedSearch->load();
        $this->Age->AdvancedSearch->load();
        $this->Gender->AdvancedSearch->load();
        $this->MaritalStatus->AdvancedSearch->load();
        $this->PhoneNo->AdvancedSearch->load();
        $this->_Email->AdvancedSearch->load();
        $this->Dependants->AdvancedSearch->load();
        $this->MaleChildren->AdvancedSearch->load();
        $this->FemaleChildren->AdvancedSearch->load();
        $this->HouseholdHead->AdvancedSearch->load();
        $this->FarmerOrg->AdvancedSearch->load();
        $this->FarmerOrgPosition->AdvancedSearch->load();
        $this->JoiningDate->AdvancedSearch->load();
        $this->NurseryName->AdvancedSearch->load();
        $this->NurseryType->AdvancedSearch->load();
        $this->NurseryOwnership->AdvancedSearch->load();
        $this->NumberOfMembers->AdvancedSearch->load();
        $this->Longitude->AdvancedSearch->load();
        $this->Latitude->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fseed_allocate_viewlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fseed_allocate_viewlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fseed_allocate_viewlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fseed_allocate_viewlist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = true;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = false;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fseed_allocate_viewsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && ($rule["value"] ?? false) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        ConvertSearchValue($fldVal, $fldOpr, $fld), // $fldVal
                                        $fldOpr,
                                        "", // $fldCond not used
                                        ConvertSearchValue($fldVal2, $fldOpr, $fld), // $fldVal2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
