<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for security_matrix
 */
class SecurityMatrix extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $UserCode;
    public $PeriodCode;
    public $Security_number;
    public $ValidFrom;
    public $ValidTo;
    public $ApproveLevel;
    public $ProvinceCode;
    public $DistrictCode;
    public $CampCode;
    public $VillageCode;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "security_matrix";
        $this->TableName = 'security_matrix';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "security_matrix";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // UserCode
        $this->UserCode = new DbField(
            $this, // Table
            'x_UserCode', // Variable name
            'UserCode', // Name
            '`UserCode`', // Expression
            '`UserCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`UserCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->UserCode->InputTextType = "text";
        $this->UserCode->Raw = true;
        $this->UserCode->IsForeignKey = true; // Foreign key field
        $this->UserCode->Nullable = false; // NOT NULL field
        $this->UserCode->Required = true; // Required field
        $this->UserCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->UserCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['UserCode'] = &$this->UserCode;

        // PeriodCode
        $this->PeriodCode = new DbField(
            $this, // Table
            'x_PeriodCode', // Variable name
            'PeriodCode', // Name
            '`PeriodCode`', // Expression
            '`PeriodCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PeriodCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PeriodCode->InputTextType = "text";
        $this->PeriodCode->Raw = true;
        $this->PeriodCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->PeriodCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['PeriodCode'] = &$this->PeriodCode;

        // Security_number
        $this->Security_number = new DbField(
            $this, // Table
            'x_Security_number', // Variable name
            'Security_number', // Name
            '`Security_number`', // Expression
            '`Security_number`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Security_number`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->Security_number->InputTextType = "text";
        $this->Security_number->Raw = true;
        $this->Security_number->IsAutoIncrement = true; // Autoincrement field
        $this->Security_number->IsPrimaryKey = true; // Primary key field
        $this->Security_number->Nullable = false; // NOT NULL field
        $this->Security_number->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Security_number->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Security_number'] = &$this->Security_number;

        // ValidFrom
        $this->ValidFrom = new DbField(
            $this, // Table
            'x_ValidFrom', // Variable name
            'ValidFrom', // Name
            '`ValidFrom`', // Expression
            CastDateFieldForLike("`ValidFrom`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            0, // Date/Time format
            false, // Is upload field
            '`ValidFrom`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ValidFrom->InputTextType = "text";
        $this->ValidFrom->Raw = true;
        $this->ValidFrom->Nullable = false; // NOT NULL field
        $this->ValidFrom->Required = true; // Required field
        $this->ValidFrom->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->ValidFrom->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ValidFrom'] = &$this->ValidFrom;

        // ValidTo
        $this->ValidTo = new DbField(
            $this, // Table
            'x_ValidTo', // Variable name
            'ValidTo', // Name
            '`ValidTo`', // Expression
            CastDateFieldForLike("`ValidTo`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            0, // Date/Time format
            false, // Is upload field
            '`ValidTo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ValidTo->InputTextType = "text";
        $this->ValidTo->Raw = true;
        $this->ValidTo->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->ValidTo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ValidTo'] = &$this->ValidTo;

        // ApproveLevel
        $this->ApproveLevel = new DbField(
            $this, // Table
            'x_ApproveLevel', // Variable name
            'ApproveLevel', // Name
            '`ApproveLevel`', // Expression
            '`ApproveLevel`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ApproveLevel`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ApproveLevel->InputTextType = "text";
        $this->ApproveLevel->Raw = true;
        $this->ApproveLevel->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ApproveLevel->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ApproveLevel'] = &$this->ApproveLevel;

        // ProvinceCode
        $this->ProvinceCode = new DbField(
            $this, // Table
            'x_ProvinceCode', // Variable name
            'ProvinceCode', // Name
            '`ProvinceCode`', // Expression
            '`ProvinceCode`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProvinceCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ProvinceCode->InputTextType = "text";
        $this->ProvinceCode->Raw = true;
        $this->ProvinceCode->Nullable = false; // NOT NULL field
        $this->ProvinceCode->Required = true; // Required field
        $this->ProvinceCode->setSelectMultiple(false); // Select one
        $this->ProvinceCode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ProvinceCode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ProvinceCode->Lookup = new Lookup($this->ProvinceCode, 'province', false, 'ProvinceCode', ["ProvinceName","","",""], '', '', [], ["x_DistrictCode"], [], [], [], [], false, '', '', "`ProvinceName`");
        $this->ProvinceCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ProvinceCode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ProvinceCode'] = &$this->ProvinceCode;

        // DistrictCode
        $this->DistrictCode = new DbField(
            $this, // Table
            'x_DistrictCode', // Variable name
            'DistrictCode', // Name
            '`DistrictCode`', // Expression
            '`DistrictCode`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`DistrictCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->DistrictCode->InputTextType = "text";
        $this->DistrictCode->Raw = true;
        $this->DistrictCode->setSelectMultiple(false); // Select one
        $this->DistrictCode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->DistrictCode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->DistrictCode->Lookup = new Lookup($this->DistrictCode, 'district', false, 'DistrictCode', ["DistrictName","","",""], '', '', ["x_ProvinceCode"], ["x_CampCode"], ["ProvinceCode"], ["x_ProvinceCode"], [], [], false, '', '', "`DistrictName`");
        $this->DistrictCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->DistrictCode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['DistrictCode'] = &$this->DistrictCode;

        // CampCode
        $this->CampCode = new DbField(
            $this, // Table
            'x_CampCode', // Variable name
            'CampCode', // Name
            '`CampCode`', // Expression
            '`CampCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`CampCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->CampCode->InputTextType = "text";
        $this->CampCode->Raw = true;
        $this->CampCode->setSelectMultiple(false); // Select one
        $this->CampCode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->CampCode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->CampCode->Lookup = new Lookup($this->CampCode, 'camp', false, 'CampCode', ["CampName","","",""], '', '', ["x_DistrictCode"], ["x_VillageCode"], ["DistrictCode"], ["x_DistrictCode"], [], [], false, '', '', "`CampName`");
        $this->CampCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->CampCode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['CampCode'] = &$this->CampCode;

        // VillageCode
        $this->VillageCode = new DbField(
            $this, // Table
            'x_VillageCode', // Variable name
            'VillageCode', // Name
            '`VillageCode`', // Expression
            '`VillageCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`VillageCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->VillageCode->InputTextType = "text";
        $this->VillageCode->Raw = true;
        $this->VillageCode->setSelectMultiple(false); // Select one
        $this->VillageCode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->VillageCode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->VillageCode->Lookup = new Lookup($this->VillageCode, 'village', false, 'VillageCode', ["Village","","",""], '', '', ["x_CampCode"], [], ["CampCode"], ["x_CampCode"], [], [], false, '', '', "`Village`");
        $this->VillageCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->VillageCode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['VillageCode'] = &$this->VillageCode;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current master table name
    public function getCurrentMasterTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE"));
    }

    public function setCurrentMasterTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
    }

    // Get master WHERE clause from session values
    public function getMasterFilterFromSession()
    {
        // Master filter
        $masterFilter = "";
        if ($this->getCurrentMasterTable() == "musers") {
            $masterTable = Container("musers");
            if ($this->UserCode->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->UserCode, $this->UserCode->getSessionValue(), $masterTable->UserCode->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        return $masterFilter;
    }

    // Get detail WHERE clause from session values
    public function getDetailFilterFromSession()
    {
        // Detail filter
        $detailFilter = "";
        if ($this->getCurrentMasterTable() == "musers") {
            $masterTable = Container("musers");
            if ($this->UserCode->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->UserCode, $this->UserCode->getSessionValue(), $masterTable->UserCode->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        return $detailFilter;
    }

    /**
     * Get master filter
     *
     * @param object $masterTable Master Table
     * @param array $keys Detail Keys
     * @return mixed NULL is returned if all keys are empty, Empty string is returned if some keys are empty and is required
     */
    public function getMasterFilter($masterTable, $keys)
    {
        $validKeys = true;
        switch ($masterTable->TableVar) {
            case "musers":
                $key = $keys["UserCode"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->UserCode->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->UserCode, $keys["UserCode"], $this->UserCode->DataType, $this->Dbid);
                }
                break;
        }
        return null; // All null values and no required fields
    }

    // Get detail filter
    public function getDetailFilter($masterTable)
    {
        switch ($masterTable->TableVar) {
            case "musers":
                return GetKeyFilter($this->UserCode, $masterTable->UserCode->DbValue, $masterTable->UserCode->DataType, $masterTable->Dbid);
        }
        return "";
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "security_matrix";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "`ProvinceCode`= 9";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        global $Security;
        // Add User ID filter
        if ($Security->currentUserID() != "" && !$Security->isAdmin()) { // Non system admin
            if ($this->getCurrentMasterTable() == "musers" || $this->getCurrentMasterTable() == "") {
                $filter = $this->addDetailUserIDFilter($filter, "musers"); // Add detail User ID filter
            }
        }
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD) == Allow::ADD;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT) == Allow::EDIT;
            case "delete":
                return ($allow & Allow::DELETE) == Allow::DELETE;
            case "view":
                return ($allow & Allow::VIEW) == Allow::VIEW;
            case "search":
                return ($allow & Allow::SEARCH) == Allow::SEARCH;
            case "lookup":
                return ($allow & Allow::LOOKUP) == Allow::LOOKUP;
            default:
                return ($allow & Allow::LIST) == Allow::LIST;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->Security_number->setDbValue($conn->lastInsertId());
            $rs['Security_number'] = $this->Security_number->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['Security_number']) && !EmptyValue($this->Security_number->CurrentValue)) {
                $rs['Security_number'] = $this->Security_number->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('Security_number', $rs)) {
                AddFilter($where, QuotedName('Security_number', $this->Dbid) . '=' . QuotedValue($rs['Security_number'], $this->Security_number->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->UserCode->DbValue = $row['UserCode'];
        $this->PeriodCode->DbValue = $row['PeriodCode'];
        $this->Security_number->DbValue = $row['Security_number'];
        $this->ValidFrom->DbValue = $row['ValidFrom'];
        $this->ValidTo->DbValue = $row['ValidTo'];
        $this->ApproveLevel->DbValue = $row['ApproveLevel'];
        $this->ProvinceCode->DbValue = $row['ProvinceCode'];
        $this->DistrictCode->DbValue = $row['DistrictCode'];
        $this->CampCode->DbValue = $row['CampCode'];
        $this->VillageCode->DbValue = $row['VillageCode'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`Security_number` = @Security_number@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->Security_number->CurrentValue : $this->Security_number->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->Security_number->CurrentValue = $keys[0];
            } else {
                $this->Security_number->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('Security_number', $row) ? $row['Security_number'] : null;
        } else {
            $val = !EmptyValue($this->Security_number->OldValue) && !$current ? $this->Security_number->OldValue : $this->Security_number->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@Security_number@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("SecurityMatrixList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "SecurityMatrixView" => $Language->phrase("View"),
            "SecurityMatrixEdit" => $Language->phrase("Edit"),
            "SecurityMatrixAdd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "SecurityMatrixList";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "SecurityMatrixView",
            Config("API_ADD_ACTION") => "SecurityMatrixAdd",
            Config("API_EDIT_ACTION") => "SecurityMatrixEdit",
            Config("API_DELETE_ACTION") => "SecurityMatrixDelete",
            Config("API_LIST_ACTION") => "SecurityMatrixList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "SecurityMatrixList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("SecurityMatrixView", $parm);
        } else {
            $url = $this->keyUrl("SecurityMatrixView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "SecurityMatrixAdd?" . $parm;
        } else {
            $url = "SecurityMatrixAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("SecurityMatrixEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("SecurityMatrixList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("SecurityMatrixAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("SecurityMatrixList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("SecurityMatrixDelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        if ($this->getCurrentMasterTable() == "musers" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_UserCode", $this->UserCode->getSessionValue()); // Use Session Value
        }
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"Security_number\":" . VarToJson($this->Security_number->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->Security_number->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->Security_number->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("Security_number") ?? Route("Security_number")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->Security_number->CurrentValue = $key;
            } else {
                $this->Security_number->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->UserCode->setDbValue($row['UserCode']);
        $this->PeriodCode->setDbValue($row['PeriodCode']);
        $this->Security_number->setDbValue($row['Security_number']);
        $this->ValidFrom->setDbValue($row['ValidFrom']);
        $this->ValidTo->setDbValue($row['ValidTo']);
        $this->ApproveLevel->setDbValue($row['ApproveLevel']);
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->VillageCode->setDbValue($row['VillageCode']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "SecurityMatrixList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // UserCode

        // PeriodCode

        // Security_number

        // ValidFrom

        // ValidTo

        // ApproveLevel

        // ProvinceCode

        // DistrictCode

        // CampCode

        // VillageCode

        // UserCode
        $this->UserCode->ViewValue = $this->UserCode->CurrentValue;

        // PeriodCode
        $this->PeriodCode->ViewValue = $this->PeriodCode->CurrentValue;

        // Security_number
        $this->Security_number->ViewValue = $this->Security_number->CurrentValue;

        // ValidFrom
        $this->ValidFrom->ViewValue = $this->ValidFrom->CurrentValue;
        $this->ValidFrom->ViewValue = FormatDateTime($this->ValidFrom->ViewValue, $this->ValidFrom->formatPattern());

        // ValidTo
        $this->ValidTo->ViewValue = $this->ValidTo->CurrentValue;
        $this->ValidTo->ViewValue = FormatDateTime($this->ValidTo->ViewValue, $this->ValidTo->formatPattern());

        // ApproveLevel
        $this->ApproveLevel->ViewValue = $this->ApproveLevel->CurrentValue;

        // ProvinceCode
        $curVal = strval($this->ProvinceCode->CurrentValue);
        if ($curVal != "") {
            $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
            if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                } else {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                }
            }
        } else {
            $this->ProvinceCode->ViewValue = null;
        }

        // DistrictCode
        $curVal = strval($this->DistrictCode->CurrentValue);
        if ($curVal != "") {
            $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
            if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                    $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                } else {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                }
            }
        } else {
            $this->DistrictCode->ViewValue = null;
        }

        // CampCode
        $curVal = strval($this->CampCode->CurrentValue);
        if ($curVal != "") {
            $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
            if ($this->CampCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                    $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                } else {
                    $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                }
            }
        } else {
            $this->CampCode->ViewValue = null;
        }

        // VillageCode
        $curVal = strval($this->VillageCode->CurrentValue);
        if ($curVal != "") {
            $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
            if ($this->VillageCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                    $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                } else {
                    $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                }
            }
        } else {
            $this->VillageCode->ViewValue = null;
        }

        // UserCode
        $this->UserCode->HrefValue = "";
        $this->UserCode->TooltipValue = "";

        // PeriodCode
        $this->PeriodCode->HrefValue = "";
        $this->PeriodCode->TooltipValue = "";

        // Security_number
        $this->Security_number->HrefValue = "";
        $this->Security_number->TooltipValue = "";

        // ValidFrom
        $this->ValidFrom->HrefValue = "";
        $this->ValidFrom->TooltipValue = "";

        // ValidTo
        $this->ValidTo->HrefValue = "";
        $this->ValidTo->TooltipValue = "";

        // ApproveLevel
        $this->ApproveLevel->HrefValue = "";
        $this->ApproveLevel->TooltipValue = "";

        // ProvinceCode
        $this->ProvinceCode->HrefValue = "";
        $this->ProvinceCode->TooltipValue = "";

        // DistrictCode
        $this->DistrictCode->HrefValue = "";
        $this->DistrictCode->TooltipValue = "";

        // CampCode
        $this->CampCode->HrefValue = "";
        $this->CampCode->TooltipValue = "";

        // VillageCode
        $this->VillageCode->HrefValue = "";
        $this->VillageCode->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // UserCode
        $this->UserCode->setupEditAttributes();
        if ($this->UserCode->getSessionValue() != "") {
            $this->UserCode->CurrentValue = GetForeignKeyValue($this->UserCode->getSessionValue());
            $this->UserCode->ViewValue = $this->UserCode->CurrentValue;
        } else {
            $this->UserCode->EditValue = $this->UserCode->CurrentValue;
            $this->UserCode->PlaceHolder = RemoveHtml($this->UserCode->caption());
            if (strval($this->UserCode->EditValue) != "" && is_numeric($this->UserCode->EditValue)) {
                $this->UserCode->EditValue = $this->UserCode->EditValue;
            }
        }

        // PeriodCode
        $this->PeriodCode->setupEditAttributes();
        $this->PeriodCode->EditValue = $this->PeriodCode->CurrentValue;
        $this->PeriodCode->PlaceHolder = RemoveHtml($this->PeriodCode->caption());
        if (strval($this->PeriodCode->EditValue) != "" && is_numeric($this->PeriodCode->EditValue)) {
            $this->PeriodCode->EditValue = $this->PeriodCode->EditValue;
        }

        // Security_number
        $this->Security_number->setupEditAttributes();
        $this->Security_number->EditValue = $this->Security_number->CurrentValue;

        // ValidFrom
        $this->ValidFrom->setupEditAttributes();
        $this->ValidFrom->EditValue = FormatDateTime($this->ValidFrom->CurrentValue, $this->ValidFrom->formatPattern());
        $this->ValidFrom->PlaceHolder = RemoveHtml($this->ValidFrom->caption());

        // ValidTo
        $this->ValidTo->setupEditAttributes();
        $this->ValidTo->EditValue = FormatDateTime($this->ValidTo->CurrentValue, $this->ValidTo->formatPattern());
        $this->ValidTo->PlaceHolder = RemoveHtml($this->ValidTo->caption());

        // ApproveLevel
        $this->ApproveLevel->setupEditAttributes();
        $this->ApproveLevel->EditValue = $this->ApproveLevel->CurrentValue;
        $this->ApproveLevel->PlaceHolder = RemoveHtml($this->ApproveLevel->caption());
        if (strval($this->ApproveLevel->EditValue) != "" && is_numeric($this->ApproveLevel->EditValue)) {
            $this->ApproveLevel->EditValue = $this->ApproveLevel->EditValue;
        }

        // ProvinceCode
        $this->ProvinceCode->setupEditAttributes();
        $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());

        // DistrictCode
        $this->DistrictCode->setupEditAttributes();
        $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());

        // CampCode
        $this->CampCode->setupEditAttributes();
        $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());

        // VillageCode
        $this->VillageCode->setupEditAttributes();
        $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->UserCode);
                    $doc->exportCaption($this->Security_number);
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->CampCode);
                    $doc->exportCaption($this->VillageCode);
                } else {
                    $doc->exportCaption($this->UserCode);
                    $doc->exportCaption($this->Security_number);
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->CampCode);
                    $doc->exportCaption($this->VillageCode);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->UserCode);
                        $doc->exportField($this->Security_number);
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->CampCode);
                        $doc->exportField($this->VillageCode);
                    } else {
                        $doc->exportField($this->UserCode);
                        $doc->exportField($this->Security_number);
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->CampCode);
                        $doc->exportField($this->VillageCode);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Add master User ID filter
    public function addMasterUserIDFilter($filter, $currentMasterTable)
    {
        $filterWrk = $filter;
        if ($currentMasterTable == "musers") {
            $filterWrk = Container("musers")->addUserIDFilter($filterWrk);
        }
        return $filterWrk;
    }

    // Add detail User ID filter
    public function addDetailUserIDFilter($filter, $currentMasterTable)
    {
        $filterWrk = $filter;
        if ($currentMasterTable == "musers") {
            $mastertable = Container("musers");
            if (!$mastertable->userIDAllow()) {
                $subqueryWrk = $mastertable->getUserIDSubquery($this->UserCode, $mastertable->UserCode);
                AddFilter($filterWrk, $subqueryWrk);
            }
        }
        return $filterWrk;
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
