<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class Season1920Search extends Season1920
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "Season1920Search";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "Season1920Search";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->SerialNo->setVisibility();
        $this->IPC->setVisibility();
        $this->PageNo->setVisibility();
        $this->Activity->setVisibility();
        $this->District->setVisibility();
        $this->Block->setVisibility();
        $this->Camp->setVisibility();
        $this->NurseryArea->setVisibility();
        $this->Zone->setVisibility();
        $this->ChiefArea->setVisibility();
        $this->Date->setVisibility();
        $this->Village->setVisibility();
        $this->NameOfFarmer->setVisibility();
        $this->YearOfBirth->setVisibility();
        $this->Gender->setVisibility();
        $this->NRC->setVisibility();
        $this->Contact->setVisibility();
        $this->FieldType->setVisibility();
        $this->SeedlingsReceived19_20->setVisibility();
        $this->Hectorage->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'season19_20';
        $this->TableName = 'season19_20';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (season19_20)
        if (!isset($GLOBALS["season19_20"]) || $GLOBALS["season19_20"]::class == PROJECT_NAMESPACE . "season19_20") {
            $GLOBALS["season19_20"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'season19_20');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "Season1920View"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "Season1920List" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->SerialNo); // SerialNo
        $this->buildSearchUrl($srchUrl, $this->IPC); // IPC
        $this->buildSearchUrl($srchUrl, $this->PageNo); // PageNo
        $this->buildSearchUrl($srchUrl, $this->Activity); // Activity
        $this->buildSearchUrl($srchUrl, $this->District); // District
        $this->buildSearchUrl($srchUrl, $this->Block); // Block
        $this->buildSearchUrl($srchUrl, $this->Camp); // Camp
        $this->buildSearchUrl($srchUrl, $this->NurseryArea); // NurseryArea
        $this->buildSearchUrl($srchUrl, $this->Zone); // Zone
        $this->buildSearchUrl($srchUrl, $this->ChiefArea); // ChiefArea
        $this->buildSearchUrl($srchUrl, $this->Date); // Date
        $this->buildSearchUrl($srchUrl, $this->Village); // Village
        $this->buildSearchUrl($srchUrl, $this->NameOfFarmer); // NameOfFarmer
        $this->buildSearchUrl($srchUrl, $this->YearOfBirth); // YearOfBirth
        $this->buildSearchUrl($srchUrl, $this->Gender); // Gender
        $this->buildSearchUrl($srchUrl, $this->NRC); // NRC
        $this->buildSearchUrl($srchUrl, $this->Contact); // Contact
        $this->buildSearchUrl($srchUrl, $this->FieldType); // FieldType
        $this->buildSearchUrl($srchUrl, $this->SeedlingsReceived19_20); // SeedlingsReceived19_20
        $this->buildSearchUrl($srchUrl, $this->Hectorage); // Hectorage
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // SerialNo
        if ($this->SerialNo->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // IPC
        if ($this->IPC->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // PageNo
        if ($this->PageNo->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Activity
        if ($this->Activity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // District
        if ($this->District->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Block
        if ($this->Block->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Camp
        if ($this->Camp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // NurseryArea
        if ($this->NurseryArea->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Zone
        if ($this->Zone->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ChiefArea
        if ($this->ChiefArea->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Date
        if ($this->Date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Village
        if ($this->Village->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // NameOfFarmer
        if ($this->NameOfFarmer->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // YearOfBirth
        if ($this->YearOfBirth->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Gender
        if ($this->Gender->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // NRC
        if ($this->NRC->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Contact
        if ($this->Contact->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // FieldType
        if ($this->FieldType->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // SeedlingsReceived19_20
        if ($this->SeedlingsReceived19_20->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Hectorage
        if ($this->Hectorage->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // SerialNo
        $this->SerialNo->RowCssClass = "row";

        // IPC
        $this->IPC->RowCssClass = "row";

        // PageNo
        $this->PageNo->RowCssClass = "row";

        // Activity
        $this->Activity->RowCssClass = "row";

        // District
        $this->District->RowCssClass = "row";

        // Block
        $this->Block->RowCssClass = "row";

        // Camp
        $this->Camp->RowCssClass = "row";

        // NurseryArea
        $this->NurseryArea->RowCssClass = "row";

        // Zone
        $this->Zone->RowCssClass = "row";

        // ChiefArea
        $this->ChiefArea->RowCssClass = "row";

        // Date
        $this->Date->RowCssClass = "row";

        // Village
        $this->Village->RowCssClass = "row";

        // NameOfFarmer
        $this->NameOfFarmer->RowCssClass = "row";

        // YearOfBirth
        $this->YearOfBirth->RowCssClass = "row";

        // Gender
        $this->Gender->RowCssClass = "row";

        // NRC
        $this->NRC->RowCssClass = "row";

        // Contact
        $this->Contact->RowCssClass = "row";

        // FieldType
        $this->FieldType->RowCssClass = "row";

        // SeedlingsReceived19_20
        $this->SeedlingsReceived19_20->RowCssClass = "row";

        // Hectorage
        $this->Hectorage->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // SerialNo
            $this->SerialNo->ViewValue = $this->SerialNo->CurrentValue;
            $this->SerialNo->ViewValue = FormatNumber($this->SerialNo->ViewValue, $this->SerialNo->formatPattern());

            // IPC
            $this->IPC->ViewValue = $this->IPC->CurrentValue;

            // PageNo
            $this->PageNo->ViewValue = $this->PageNo->CurrentValue;
            $this->PageNo->ViewValue = FormatNumber($this->PageNo->ViewValue, $this->PageNo->formatPattern());

            // Activity
            $this->Activity->ViewValue = $this->Activity->CurrentValue;

            // District
            $this->District->ViewValue = $this->District->CurrentValue;

            // Block
            $this->Block->ViewValue = $this->Block->CurrentValue;

            // Camp
            $this->Camp->ViewValue = $this->Camp->CurrentValue;

            // NurseryArea
            $this->NurseryArea->ViewValue = $this->NurseryArea->CurrentValue;

            // Zone
            $this->Zone->ViewValue = $this->Zone->CurrentValue;

            // ChiefArea
            $this->ChiefArea->ViewValue = $this->ChiefArea->CurrentValue;

            // Date
            $this->Date->ViewValue = $this->Date->CurrentValue;

            // Village
            $this->Village->ViewValue = $this->Village->CurrentValue;

            // NameOfFarmer
            $this->NameOfFarmer->ViewValue = $this->NameOfFarmer->CurrentValue;

            // YearOfBirth
            $this->YearOfBirth->ViewValue = $this->YearOfBirth->CurrentValue;

            // Gender
            $this->Gender->ViewValue = $this->Gender->CurrentValue;

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;

            // Contact
            $this->Contact->ViewValue = $this->Contact->CurrentValue;

            // FieldType
            $this->FieldType->ViewValue = $this->FieldType->CurrentValue;

            // SeedlingsReceived19_20
            $this->SeedlingsReceived19_20->ViewValue = $this->SeedlingsReceived19_20->CurrentValue;
            $this->SeedlingsReceived19_20->ViewValue = FormatNumber($this->SeedlingsReceived19_20->ViewValue, $this->SeedlingsReceived19_20->formatPattern());

            // Hectorage
            $this->Hectorage->ViewValue = $this->Hectorage->CurrentValue;
            $this->Hectorage->ViewValue = FormatNumber($this->Hectorage->ViewValue, $this->Hectorage->formatPattern());

            // SerialNo
            $this->SerialNo->HrefValue = "";
            $this->SerialNo->TooltipValue = "";

            // IPC
            $this->IPC->HrefValue = "";
            $this->IPC->TooltipValue = "";

            // PageNo
            $this->PageNo->HrefValue = "";
            $this->PageNo->TooltipValue = "";

            // Activity
            $this->Activity->HrefValue = "";
            $this->Activity->TooltipValue = "";

            // District
            $this->District->HrefValue = "";
            $this->District->TooltipValue = "";

            // Block
            $this->Block->HrefValue = "";
            $this->Block->TooltipValue = "";

            // Camp
            $this->Camp->HrefValue = "";
            $this->Camp->TooltipValue = "";

            // NurseryArea
            $this->NurseryArea->HrefValue = "";
            $this->NurseryArea->TooltipValue = "";

            // Zone
            $this->Zone->HrefValue = "";
            $this->Zone->TooltipValue = "";

            // ChiefArea
            $this->ChiefArea->HrefValue = "";
            $this->ChiefArea->TooltipValue = "";

            // Date
            $this->Date->HrefValue = "";
            $this->Date->TooltipValue = "";

            // Village
            $this->Village->HrefValue = "";
            $this->Village->TooltipValue = "";

            // NameOfFarmer
            $this->NameOfFarmer->HrefValue = "";
            $this->NameOfFarmer->TooltipValue = "";

            // YearOfBirth
            $this->YearOfBirth->HrefValue = "";
            $this->YearOfBirth->TooltipValue = "";

            // Gender
            $this->Gender->HrefValue = "";
            $this->Gender->TooltipValue = "";

            // NRC
            $this->NRC->HrefValue = "";
            $this->NRC->TooltipValue = "";

            // Contact
            $this->Contact->HrefValue = "";
            $this->Contact->TooltipValue = "";

            // FieldType
            $this->FieldType->HrefValue = "";
            $this->FieldType->TooltipValue = "";

            // SeedlingsReceived19_20
            $this->SeedlingsReceived19_20->HrefValue = "";
            $this->SeedlingsReceived19_20->TooltipValue = "";

            // Hectorage
            $this->Hectorage->HrefValue = "";
            $this->Hectorage->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // SerialNo
            $this->SerialNo->setupEditAttributes();
            $this->SerialNo->EditValue = $this->SerialNo->AdvancedSearch->SearchValue;
            $this->SerialNo->PlaceHolder = RemoveHtml($this->SerialNo->caption());

            // IPC
            $this->IPC->setupEditAttributes();
            if (!$this->IPC->Raw) {
                $this->IPC->AdvancedSearch->SearchValue = HtmlDecode($this->IPC->AdvancedSearch->SearchValue);
            }
            $this->IPC->EditValue = HtmlEncode($this->IPC->AdvancedSearch->SearchValue);
            $this->IPC->PlaceHolder = RemoveHtml($this->IPC->caption());

            // PageNo
            $this->PageNo->setupEditAttributes();
            $this->PageNo->EditValue = $this->PageNo->AdvancedSearch->SearchValue;
            $this->PageNo->PlaceHolder = RemoveHtml($this->PageNo->caption());

            // Activity
            $this->Activity->setupEditAttributes();
            if (!$this->Activity->Raw) {
                $this->Activity->AdvancedSearch->SearchValue = HtmlDecode($this->Activity->AdvancedSearch->SearchValue);
            }
            $this->Activity->EditValue = HtmlEncode($this->Activity->AdvancedSearch->SearchValue);
            $this->Activity->PlaceHolder = RemoveHtml($this->Activity->caption());

            // District
            $this->District->setupEditAttributes();
            if (!$this->District->Raw) {
                $this->District->AdvancedSearch->SearchValue = HtmlDecode($this->District->AdvancedSearch->SearchValue);
            }
            $this->District->EditValue = HtmlEncode($this->District->AdvancedSearch->SearchValue);
            $this->District->PlaceHolder = RemoveHtml($this->District->caption());

            // Block
            $this->Block->setupEditAttributes();
            if (!$this->Block->Raw) {
                $this->Block->AdvancedSearch->SearchValue = HtmlDecode($this->Block->AdvancedSearch->SearchValue);
            }
            $this->Block->EditValue = HtmlEncode($this->Block->AdvancedSearch->SearchValue);
            $this->Block->PlaceHolder = RemoveHtml($this->Block->caption());

            // Camp
            $this->Camp->setupEditAttributes();
            if (!$this->Camp->Raw) {
                $this->Camp->AdvancedSearch->SearchValue = HtmlDecode($this->Camp->AdvancedSearch->SearchValue);
            }
            $this->Camp->EditValue = HtmlEncode($this->Camp->AdvancedSearch->SearchValue);
            $this->Camp->PlaceHolder = RemoveHtml($this->Camp->caption());

            // NurseryArea
            $this->NurseryArea->setupEditAttributes();
            if (!$this->NurseryArea->Raw) {
                $this->NurseryArea->AdvancedSearch->SearchValue = HtmlDecode($this->NurseryArea->AdvancedSearch->SearchValue);
            }
            $this->NurseryArea->EditValue = HtmlEncode($this->NurseryArea->AdvancedSearch->SearchValue);
            $this->NurseryArea->PlaceHolder = RemoveHtml($this->NurseryArea->caption());

            // Zone
            $this->Zone->setupEditAttributes();
            if (!$this->Zone->Raw) {
                $this->Zone->AdvancedSearch->SearchValue = HtmlDecode($this->Zone->AdvancedSearch->SearchValue);
            }
            $this->Zone->EditValue = HtmlEncode($this->Zone->AdvancedSearch->SearchValue);
            $this->Zone->PlaceHolder = RemoveHtml($this->Zone->caption());

            // ChiefArea
            $this->ChiefArea->setupEditAttributes();
            if (!$this->ChiefArea->Raw) {
                $this->ChiefArea->AdvancedSearch->SearchValue = HtmlDecode($this->ChiefArea->AdvancedSearch->SearchValue);
            }
            $this->ChiefArea->EditValue = HtmlEncode($this->ChiefArea->AdvancedSearch->SearchValue);
            $this->ChiefArea->PlaceHolder = RemoveHtml($this->ChiefArea->caption());

            // Date
            $this->Date->setupEditAttributes();
            if (!$this->Date->Raw) {
                $this->Date->AdvancedSearch->SearchValue = HtmlDecode($this->Date->AdvancedSearch->SearchValue);
            }
            $this->Date->EditValue = HtmlEncode($this->Date->AdvancedSearch->SearchValue);
            $this->Date->PlaceHolder = RemoveHtml($this->Date->caption());

            // Village
            $this->Village->setupEditAttributes();
            if (!$this->Village->Raw) {
                $this->Village->AdvancedSearch->SearchValue = HtmlDecode($this->Village->AdvancedSearch->SearchValue);
            }
            $this->Village->EditValue = HtmlEncode($this->Village->AdvancedSearch->SearchValue);
            $this->Village->PlaceHolder = RemoveHtml($this->Village->caption());

            // NameOfFarmer
            $this->NameOfFarmer->setupEditAttributes();
            if (!$this->NameOfFarmer->Raw) {
                $this->NameOfFarmer->AdvancedSearch->SearchValue = HtmlDecode($this->NameOfFarmer->AdvancedSearch->SearchValue);
            }
            $this->NameOfFarmer->EditValue = HtmlEncode($this->NameOfFarmer->AdvancedSearch->SearchValue);
            $this->NameOfFarmer->PlaceHolder = RemoveHtml($this->NameOfFarmer->caption());

            // YearOfBirth
            $this->YearOfBirth->setupEditAttributes();
            $this->YearOfBirth->EditValue = $this->YearOfBirth->AdvancedSearch->SearchValue;
            $this->YearOfBirth->PlaceHolder = RemoveHtml($this->YearOfBirth->caption());

            // Gender
            $this->Gender->setupEditAttributes();
            if (!$this->Gender->Raw) {
                $this->Gender->AdvancedSearch->SearchValue = HtmlDecode($this->Gender->AdvancedSearch->SearchValue);
            }
            $this->Gender->EditValue = HtmlEncode($this->Gender->AdvancedSearch->SearchValue);
            $this->Gender->PlaceHolder = RemoveHtml($this->Gender->caption());

            // NRC
            $this->NRC->setupEditAttributes();
            if (!$this->NRC->Raw) {
                $this->NRC->AdvancedSearch->SearchValue = HtmlDecode($this->NRC->AdvancedSearch->SearchValue);
            }
            $this->NRC->EditValue = HtmlEncode($this->NRC->AdvancedSearch->SearchValue);
            $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

            // Contact
            $this->Contact->setupEditAttributes();
            if (!$this->Contact->Raw) {
                $this->Contact->AdvancedSearch->SearchValue = HtmlDecode($this->Contact->AdvancedSearch->SearchValue);
            }
            $this->Contact->EditValue = HtmlEncode($this->Contact->AdvancedSearch->SearchValue);
            $this->Contact->PlaceHolder = RemoveHtml($this->Contact->caption());

            // FieldType
            $this->FieldType->setupEditAttributes();
            if (!$this->FieldType->Raw) {
                $this->FieldType->AdvancedSearch->SearchValue = HtmlDecode($this->FieldType->AdvancedSearch->SearchValue);
            }
            $this->FieldType->EditValue = HtmlEncode($this->FieldType->AdvancedSearch->SearchValue);
            $this->FieldType->PlaceHolder = RemoveHtml($this->FieldType->caption());

            // SeedlingsReceived19_20
            $this->SeedlingsReceived19_20->setupEditAttributes();
            $this->SeedlingsReceived19_20->EditValue = $this->SeedlingsReceived19_20->AdvancedSearch->SearchValue;
            $this->SeedlingsReceived19_20->PlaceHolder = RemoveHtml($this->SeedlingsReceived19_20->caption());

            // Hectorage
            $this->Hectorage->setupEditAttributes();
            $this->Hectorage->EditValue = $this->Hectorage->AdvancedSearch->SearchValue;
            $this->Hectorage->PlaceHolder = RemoveHtml($this->Hectorage->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->SerialNo->AdvancedSearch->SearchValue)) {
            $this->SerialNo->addErrorMessage($this->SerialNo->getErrorMessage(false));
        }
        if (!CheckInteger($this->PageNo->AdvancedSearch->SearchValue)) {
            $this->PageNo->addErrorMessage($this->PageNo->getErrorMessage(false));
        }
        if (!CheckInteger($this->YearOfBirth->AdvancedSearch->SearchValue)) {
            $this->YearOfBirth->addErrorMessage($this->YearOfBirth->getErrorMessage(false));
        }
        if (!CheckInteger($this->SeedlingsReceived19_20->AdvancedSearch->SearchValue)) {
            $this->SeedlingsReceived19_20->addErrorMessage($this->SeedlingsReceived19_20->getErrorMessage(false));
        }
        if (!CheckNumber($this->Hectorage->AdvancedSearch->SearchValue)) {
            $this->Hectorage->addErrorMessage($this->Hectorage->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->SerialNo->AdvancedSearch->load();
        $this->IPC->AdvancedSearch->load();
        $this->PageNo->AdvancedSearch->load();
        $this->Activity->AdvancedSearch->load();
        $this->District->AdvancedSearch->load();
        $this->Block->AdvancedSearch->load();
        $this->Camp->AdvancedSearch->load();
        $this->NurseryArea->AdvancedSearch->load();
        $this->Zone->AdvancedSearch->load();
        $this->ChiefArea->AdvancedSearch->load();
        $this->Date->AdvancedSearch->load();
        $this->Village->AdvancedSearch->load();
        $this->NameOfFarmer->AdvancedSearch->load();
        $this->YearOfBirth->AdvancedSearch->load();
        $this->Gender->AdvancedSearch->load();
        $this->NRC->AdvancedSearch->load();
        $this->Contact->AdvancedSearch->load();
        $this->FieldType->AdvancedSearch->load();
        $this->SeedlingsReceived19_20->AdvancedSearch->load();
        $this->Hectorage->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("Season1920List"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
