<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class GrantBeneficiaryAdd extends GrantBeneficiary
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "GrantBeneficiaryAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "GrantBeneficiaryAdd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->GrantNo->setVisibility();
        $this->NRC->setVisibility();
        $this->AmountDisbursed->setVisibility();
        $this->ApplicationDate->setVisibility();
        $this->AmountAppliedFor->setVisibility();
        $this->ReplyDate->setVisibility();
        $this->Approved->setVisibility();
        $this->ReasonsForRejection->setVisibility();
        $this->Purpose->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'grant_beneficiary';
        $this->TableName = 'grant_beneficiary';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (grant_beneficiary)
        if (!isset($GLOBALS["grant_beneficiary"]) || $GLOBALS["grant_beneficiary"]::class == PROJECT_NAMESPACE . "grant_beneficiary") {
            $GLOBALS["grant_beneficiary"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'grant_beneficiary');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "GrantBeneficiaryView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->NRC);
        $this->setupLookupOptions($this->Approved);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else { // Not post back
            $this->CopyRecord = false;
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Set up master/detail parameters
        // NOTE: Must be after loadOldRecord to prevent master key values being overwritten
        $this->setupMasterParms();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("GrantBeneficiaryList"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "GrantBeneficiaryList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "GrantBeneficiaryView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "GrantBeneficiaryList") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "GrantBeneficiaryList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'GrantNo' first before field var 'x_GrantNo'
        $val = $CurrentForm->hasValue("GrantNo") ? $CurrentForm->getValue("GrantNo") : $CurrentForm->getValue("x_GrantNo");
        if (!$this->GrantNo->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->GrantNo->Visible = false; // Disable update for API request
            } else {
                $this->GrantNo->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'NRC' first before field var 'x_NRC'
        $val = $CurrentForm->hasValue("NRC") ? $CurrentForm->getValue("NRC") : $CurrentForm->getValue("x_NRC");
        if (!$this->NRC->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NRC->Visible = false; // Disable update for API request
            } else {
                $this->NRC->setFormValue($val);
            }
        }

        // Check field name 'AmountDisbursed' first before field var 'x_AmountDisbursed'
        $val = $CurrentForm->hasValue("AmountDisbursed") ? $CurrentForm->getValue("AmountDisbursed") : $CurrentForm->getValue("x_AmountDisbursed");
        if (!$this->AmountDisbursed->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->AmountDisbursed->Visible = false; // Disable update for API request
            } else {
                $this->AmountDisbursed->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ApplicationDate' first before field var 'x_ApplicationDate'
        $val = $CurrentForm->hasValue("ApplicationDate") ? $CurrentForm->getValue("ApplicationDate") : $CurrentForm->getValue("x_ApplicationDate");
        if (!$this->ApplicationDate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ApplicationDate->Visible = false; // Disable update for API request
            } else {
                $this->ApplicationDate->setFormValue($val, true, $validate);
            }
            $this->ApplicationDate->CurrentValue = UnFormatDateTime($this->ApplicationDate->CurrentValue, $this->ApplicationDate->formatPattern());
        }

        // Check field name 'AmountAppliedFor' first before field var 'x_AmountAppliedFor'
        $val = $CurrentForm->hasValue("AmountAppliedFor") ? $CurrentForm->getValue("AmountAppliedFor") : $CurrentForm->getValue("x_AmountAppliedFor");
        if (!$this->AmountAppliedFor->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->AmountAppliedFor->Visible = false; // Disable update for API request
            } else {
                $this->AmountAppliedFor->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'ReplyDate' first before field var 'x_ReplyDate'
        $val = $CurrentForm->hasValue("ReplyDate") ? $CurrentForm->getValue("ReplyDate") : $CurrentForm->getValue("x_ReplyDate");
        if (!$this->ReplyDate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ReplyDate->Visible = false; // Disable update for API request
            } else {
                $this->ReplyDate->setFormValue($val, true, $validate);
            }
            $this->ReplyDate->CurrentValue = UnFormatDateTime($this->ReplyDate->CurrentValue, $this->ReplyDate->formatPattern());
        }

        // Check field name 'Approved' first before field var 'x_Approved'
        $val = $CurrentForm->hasValue("Approved") ? $CurrentForm->getValue("Approved") : $CurrentForm->getValue("x_Approved");
        if (!$this->Approved->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Approved->Visible = false; // Disable update for API request
            } else {
                $this->Approved->setFormValue($val);
            }
        }

        // Check field name 'ReasonsForRejection' first before field var 'x_ReasonsForRejection'
        $val = $CurrentForm->hasValue("ReasonsForRejection") ? $CurrentForm->getValue("ReasonsForRejection") : $CurrentForm->getValue("x_ReasonsForRejection");
        if (!$this->ReasonsForRejection->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ReasonsForRejection->Visible = false; // Disable update for API request
            } else {
                $this->ReasonsForRejection->setFormValue($val);
            }
        }

        // Check field name 'Purpose' first before field var 'x_Purpose'
        $val = $CurrentForm->hasValue("Purpose") ? $CurrentForm->getValue("Purpose") : $CurrentForm->getValue("x_Purpose");
        if (!$this->Purpose->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Purpose->Visible = false; // Disable update for API request
            } else {
                $this->Purpose->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->GrantNo->CurrentValue = $this->GrantNo->FormValue;
        $this->NRC->CurrentValue = $this->NRC->FormValue;
        $this->AmountDisbursed->CurrentValue = $this->AmountDisbursed->FormValue;
        $this->ApplicationDate->CurrentValue = $this->ApplicationDate->FormValue;
        $this->ApplicationDate->CurrentValue = UnFormatDateTime($this->ApplicationDate->CurrentValue, $this->ApplicationDate->formatPattern());
        $this->AmountAppliedFor->CurrentValue = $this->AmountAppliedFor->FormValue;
        $this->ReplyDate->CurrentValue = $this->ReplyDate->FormValue;
        $this->ReplyDate->CurrentValue = UnFormatDateTime($this->ReplyDate->CurrentValue, $this->ReplyDate->formatPattern());
        $this->Approved->CurrentValue = $this->Approved->FormValue;
        $this->ReasonsForRejection->CurrentValue = $this->ReasonsForRejection->FormValue;
        $this->Purpose->CurrentValue = $this->Purpose->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->GrantNo->setDbValue($row['GrantNo']);
        $this->NRC->setDbValue($row['NRC']);
        $this->AmountDisbursed->setDbValue($row['AmountDisbursed']);
        $this->ApplicationDate->setDbValue($row['ApplicationDate']);
        $this->AmountAppliedFor->setDbValue($row['AmountAppliedFor']);
        $this->ReplyDate->setDbValue($row['ReplyDate']);
        $this->Approved->setDbValue($row['Approved']);
        $this->ReasonsForRejection->setDbValue($row['ReasonsForRejection']);
        $this->Purpose->setDbValue($row['Purpose']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['GrantNo'] = $this->GrantNo->DefaultValue;
        $row['NRC'] = $this->NRC->DefaultValue;
        $row['AmountDisbursed'] = $this->AmountDisbursed->DefaultValue;
        $row['ApplicationDate'] = $this->ApplicationDate->DefaultValue;
        $row['AmountAppliedFor'] = $this->AmountAppliedFor->DefaultValue;
        $row['ReplyDate'] = $this->ReplyDate->DefaultValue;
        $row['Approved'] = $this->Approved->DefaultValue;
        $row['ReasonsForRejection'] = $this->ReasonsForRejection->DefaultValue;
        $row['Purpose'] = $this->Purpose->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // GrantNo
        $this->GrantNo->RowCssClass = "row";

        // NRC
        $this->NRC->RowCssClass = "row";

        // AmountDisbursed
        $this->AmountDisbursed->RowCssClass = "row";

        // ApplicationDate
        $this->ApplicationDate->RowCssClass = "row";

        // AmountAppliedFor
        $this->AmountAppliedFor->RowCssClass = "row";

        // ReplyDate
        $this->ReplyDate->RowCssClass = "row";

        // Approved
        $this->Approved->RowCssClass = "row";

        // ReasonsForRejection
        $this->ReasonsForRejection->RowCssClass = "row";

        // Purpose
        $this->Purpose->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // GrantNo
            $this->GrantNo->ViewValue = $this->GrantNo->CurrentValue;

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;
            $curVal = strval($this->NRC->CurrentValue);
            if ($curVal != "") {
                $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->ViewValue = $this->NRC->CurrentValue;
                    }
                }
            } else {
                $this->NRC->ViewValue = null;
            }

            // AmountDisbursed
            $this->AmountDisbursed->ViewValue = $this->AmountDisbursed->CurrentValue;
            $this->AmountDisbursed->ViewValue = FormatNumber($this->AmountDisbursed->ViewValue, $this->AmountDisbursed->formatPattern());

            // ApplicationDate
            $this->ApplicationDate->ViewValue = $this->ApplicationDate->CurrentValue;
            $this->ApplicationDate->ViewValue = FormatDateTime($this->ApplicationDate->ViewValue, $this->ApplicationDate->formatPattern());

            // AmountAppliedFor
            $this->AmountAppliedFor->ViewValue = $this->AmountAppliedFor->CurrentValue;
            $this->AmountAppliedFor->ViewValue = FormatNumber($this->AmountAppliedFor->ViewValue, $this->AmountAppliedFor->formatPattern());

            // ReplyDate
            $this->ReplyDate->ViewValue = $this->ReplyDate->CurrentValue;
            $this->ReplyDate->ViewValue = FormatDateTime($this->ReplyDate->ViewValue, $this->ReplyDate->formatPattern());

            // Approved
            $curVal = strval($this->Approved->CurrentValue);
            if ($curVal != "") {
                $this->Approved->ViewValue = $this->Approved->lookupCacheOption($curVal);
                if ($this->Approved->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Approved->Lookup->getTable()->Fields["ChoiceCode"]->searchExpression(), "=", $curVal, $this->Approved->Lookup->getTable()->Fields["ChoiceCode"]->searchDataType(), "");
                    $sqlWrk = $this->Approved->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Approved->Lookup->renderViewRow($rswrk[0]);
                        $this->Approved->ViewValue = $this->Approved->displayValue($arwrk);
                    } else {
                        $this->Approved->ViewValue = $this->Approved->CurrentValue;
                    }
                }
            } else {
                $this->Approved->ViewValue = null;
            }

            // ReasonsForRejection
            $this->ReasonsForRejection->ViewValue = $this->ReasonsForRejection->CurrentValue;

            // Purpose
            $this->Purpose->ViewValue = $this->Purpose->CurrentValue;

            // GrantNo
            $this->GrantNo->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // AmountDisbursed
            $this->AmountDisbursed->HrefValue = "";

            // ApplicationDate
            $this->ApplicationDate->HrefValue = "";

            // AmountAppliedFor
            $this->AmountAppliedFor->HrefValue = "";

            // ReplyDate
            $this->ReplyDate->HrefValue = "";

            // Approved
            $this->Approved->HrefValue = "";

            // ReasonsForRejection
            $this->ReasonsForRejection->HrefValue = "";

            // Purpose
            $this->Purpose->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // GrantNo
            $this->GrantNo->setupEditAttributes();
            if ($this->GrantNo->getSessionValue() != "") {
                $this->GrantNo->CurrentValue = GetForeignKeyValue($this->GrantNo->getSessionValue());
                $this->GrantNo->ViewValue = $this->GrantNo->CurrentValue;
            } else {
                $this->GrantNo->EditValue = $this->GrantNo->CurrentValue;
                $this->GrantNo->PlaceHolder = RemoveHtml($this->GrantNo->caption());
                if (strval($this->GrantNo->EditValue) != "" && is_numeric($this->GrantNo->EditValue)) {
                    $this->GrantNo->EditValue = $this->GrantNo->EditValue;
                }
            }

            // NRC
            $this->NRC->setupEditAttributes();
            if (!$this->NRC->Raw) {
                $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
            }
            $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
            $curVal = strval($this->NRC->CurrentValue);
            if ($curVal != "") {
                $this->NRC->EditValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->EditValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
                    }
                }
            } else {
                $this->NRC->EditValue = null;
            }
            $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

            // AmountDisbursed
            $this->AmountDisbursed->setupEditAttributes();
            $this->AmountDisbursed->EditValue = $this->AmountDisbursed->CurrentValue;
            $this->AmountDisbursed->PlaceHolder = RemoveHtml($this->AmountDisbursed->caption());
            if (strval($this->AmountDisbursed->EditValue) != "" && is_numeric($this->AmountDisbursed->EditValue)) {
                $this->AmountDisbursed->EditValue = FormatNumber($this->AmountDisbursed->EditValue, null);
            }

            // ApplicationDate
            $this->ApplicationDate->setupEditAttributes();
            $this->ApplicationDate->EditValue = HtmlEncode(FormatDateTime($this->ApplicationDate->CurrentValue, $this->ApplicationDate->formatPattern()));
            $this->ApplicationDate->PlaceHolder = RemoveHtml($this->ApplicationDate->caption());

            // AmountAppliedFor
            $this->AmountAppliedFor->setupEditAttributes();
            $this->AmountAppliedFor->EditValue = $this->AmountAppliedFor->CurrentValue;
            $this->AmountAppliedFor->PlaceHolder = RemoveHtml($this->AmountAppliedFor->caption());
            if (strval($this->AmountAppliedFor->EditValue) != "" && is_numeric($this->AmountAppliedFor->EditValue)) {
                $this->AmountAppliedFor->EditValue = FormatNumber($this->AmountAppliedFor->EditValue, null);
            }

            // ReplyDate
            $this->ReplyDate->setupEditAttributes();
            $this->ReplyDate->EditValue = HtmlEncode(FormatDateTime($this->ReplyDate->CurrentValue, $this->ReplyDate->formatPattern()));
            $this->ReplyDate->PlaceHolder = RemoveHtml($this->ReplyDate->caption());

            // Approved
            $curVal = trim(strval($this->Approved->CurrentValue));
            if ($curVal != "") {
                $this->Approved->ViewValue = $this->Approved->lookupCacheOption($curVal);
            } else {
                $this->Approved->ViewValue = $this->Approved->Lookup !== null && is_array($this->Approved->lookupOptions()) && count($this->Approved->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Approved->ViewValue !== null) { // Load from cache
                $this->Approved->EditValue = array_values($this->Approved->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Approved->Lookup->getTable()->Fields["ChoiceCode"]->searchExpression(), "=", $this->Approved->CurrentValue, $this->Approved->Lookup->getTable()->Fields["ChoiceCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->Approved->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Approved->EditValue = $arwrk;
            }
            $this->Approved->PlaceHolder = RemoveHtml($this->Approved->caption());

            // ReasonsForRejection
            $this->ReasonsForRejection->setupEditAttributes();
            if (!$this->ReasonsForRejection->Raw) {
                $this->ReasonsForRejection->CurrentValue = HtmlDecode($this->ReasonsForRejection->CurrentValue);
            }
            $this->ReasonsForRejection->EditValue = HtmlEncode($this->ReasonsForRejection->CurrentValue);
            $this->ReasonsForRejection->PlaceHolder = RemoveHtml($this->ReasonsForRejection->caption());

            // Purpose
            $this->Purpose->setupEditAttributes();
            if (!$this->Purpose->Raw) {
                $this->Purpose->CurrentValue = HtmlDecode($this->Purpose->CurrentValue);
            }
            $this->Purpose->EditValue = HtmlEncode($this->Purpose->CurrentValue);
            $this->Purpose->PlaceHolder = RemoveHtml($this->Purpose->caption());

            // Add refer script

            // GrantNo
            $this->GrantNo->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // AmountDisbursed
            $this->AmountDisbursed->HrefValue = "";

            // ApplicationDate
            $this->ApplicationDate->HrefValue = "";

            // AmountAppliedFor
            $this->AmountAppliedFor->HrefValue = "";

            // ReplyDate
            $this->ReplyDate->HrefValue = "";

            // Approved
            $this->Approved->HrefValue = "";

            // ReasonsForRejection
            $this->ReasonsForRejection->HrefValue = "";

            // Purpose
            $this->Purpose->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->GrantNo->Visible && $this->GrantNo->Required) {
                if (!$this->GrantNo->IsDetailKey && EmptyValue($this->GrantNo->FormValue)) {
                    $this->GrantNo->addErrorMessage(str_replace("%s", $this->GrantNo->caption(), $this->GrantNo->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->GrantNo->FormValue)) {
                $this->GrantNo->addErrorMessage($this->GrantNo->getErrorMessage(false));
            }
            if ($this->NRC->Visible && $this->NRC->Required) {
                if (!$this->NRC->IsDetailKey && EmptyValue($this->NRC->FormValue)) {
                    $this->NRC->addErrorMessage(str_replace("%s", $this->NRC->caption(), $this->NRC->RequiredErrorMessage));
                }
            }
            if ($this->AmountDisbursed->Visible && $this->AmountDisbursed->Required) {
                if (!$this->AmountDisbursed->IsDetailKey && EmptyValue($this->AmountDisbursed->FormValue)) {
                    $this->AmountDisbursed->addErrorMessage(str_replace("%s", $this->AmountDisbursed->caption(), $this->AmountDisbursed->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->AmountDisbursed->FormValue)) {
                $this->AmountDisbursed->addErrorMessage($this->AmountDisbursed->getErrorMessage(false));
            }
            if ($this->ApplicationDate->Visible && $this->ApplicationDate->Required) {
                if (!$this->ApplicationDate->IsDetailKey && EmptyValue($this->ApplicationDate->FormValue)) {
                    $this->ApplicationDate->addErrorMessage(str_replace("%s", $this->ApplicationDate->caption(), $this->ApplicationDate->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->ApplicationDate->FormValue, $this->ApplicationDate->formatPattern())) {
                $this->ApplicationDate->addErrorMessage($this->ApplicationDate->getErrorMessage(false));
            }
            if ($this->AmountAppliedFor->Visible && $this->AmountAppliedFor->Required) {
                if (!$this->AmountAppliedFor->IsDetailKey && EmptyValue($this->AmountAppliedFor->FormValue)) {
                    $this->AmountAppliedFor->addErrorMessage(str_replace("%s", $this->AmountAppliedFor->caption(), $this->AmountAppliedFor->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->AmountAppliedFor->FormValue)) {
                $this->AmountAppliedFor->addErrorMessage($this->AmountAppliedFor->getErrorMessage(false));
            }
            if ($this->ReplyDate->Visible && $this->ReplyDate->Required) {
                if (!$this->ReplyDate->IsDetailKey && EmptyValue($this->ReplyDate->FormValue)) {
                    $this->ReplyDate->addErrorMessage(str_replace("%s", $this->ReplyDate->caption(), $this->ReplyDate->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->ReplyDate->FormValue, $this->ReplyDate->formatPattern())) {
                $this->ReplyDate->addErrorMessage($this->ReplyDate->getErrorMessage(false));
            }
            if ($this->Approved->Visible && $this->Approved->Required) {
                if ($this->Approved->FormValue == "") {
                    $this->Approved->addErrorMessage(str_replace("%s", $this->Approved->caption(), $this->Approved->RequiredErrorMessage));
                }
            }
            if ($this->ReasonsForRejection->Visible && $this->ReasonsForRejection->Required) {
                if (!$this->ReasonsForRejection->IsDetailKey && EmptyValue($this->ReasonsForRejection->FormValue)) {
                    $this->ReasonsForRejection->addErrorMessage(str_replace("%s", $this->ReasonsForRejection->caption(), $this->ReasonsForRejection->RequiredErrorMessage));
                }
            }
            if ($this->Purpose->Visible && $this->Purpose->Required) {
                if (!$this->Purpose->IsDetailKey && EmptyValue($this->Purpose->FormValue)) {
                    $this->Purpose->addErrorMessage(str_replace("%s", $this->Purpose->caption(), $this->Purpose->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check referential integrity for master table 'grant_beneficiary'
        $validMasterRecord = true;
        $detailKeys = [];
        $detailKeys["GrantNo"] = $this->GrantNo->CurrentValue;
        $masterTable = Container("grant");
        $masterFilter = $this->getMasterFilter($masterTable, $detailKeys);
        if (!EmptyValue($masterFilter)) {
            $rsmaster = $masterTable->loadRs($masterFilter)->fetch();
            $validMasterRecord = $rsmaster !== false;
        } else { // Allow null value if not required field
            $validMasterRecord = $masterFilter === null;
        }
        if (!$validMasterRecord) {
            $relatedRecordMsg = str_replace("%t", "grant", $Language->phrase("RelatedRecordRequired"));
            $this->setFailureMessage($relatedRecordMsg);
            return false;
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // GrantNo
        $this->GrantNo->setDbValueDef($rsnew, $this->GrantNo->CurrentValue, false);

        // NRC
        $this->NRC->setDbValueDef($rsnew, $this->NRC->CurrentValue, false);

        // AmountDisbursed
        $this->AmountDisbursed->setDbValueDef($rsnew, $this->AmountDisbursed->CurrentValue, false);

        // ApplicationDate
        $this->ApplicationDate->setDbValueDef($rsnew, UnFormatDateTime($this->ApplicationDate->CurrentValue, $this->ApplicationDate->formatPattern()), false);

        // AmountAppliedFor
        $this->AmountAppliedFor->setDbValueDef($rsnew, $this->AmountAppliedFor->CurrentValue, false);

        // ReplyDate
        $this->ReplyDate->setDbValueDef($rsnew, UnFormatDateTime($this->ReplyDate->CurrentValue, $this->ReplyDate->formatPattern()), false);

        // Approved
        $this->Approved->setDbValueDef($rsnew, strval($this->Approved->CurrentValue) == "1" ? "1" : "0", false);

        // ReasonsForRejection
        $this->ReasonsForRejection->setDbValueDef($rsnew, $this->ReasonsForRejection->CurrentValue, false);

        // Purpose
        $this->Purpose->setDbValueDef($rsnew, $this->Purpose->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['GrantNo'])) { // GrantNo
            $this->GrantNo->setFormValue($row['GrantNo']);
        }
        if (isset($row['NRC'])) { // NRC
            $this->NRC->setFormValue($row['NRC']);
        }
        if (isset($row['AmountDisbursed'])) { // AmountDisbursed
            $this->AmountDisbursed->setFormValue($row['AmountDisbursed']);
        }
        if (isset($row['ApplicationDate'])) { // ApplicationDate
            $this->ApplicationDate->setFormValue($row['ApplicationDate']);
        }
        if (isset($row['AmountAppliedFor'])) { // AmountAppliedFor
            $this->AmountAppliedFor->setFormValue($row['AmountAppliedFor']);
        }
        if (isset($row['ReplyDate'])) { // ReplyDate
            $this->ReplyDate->setFormValue($row['ReplyDate']);
        }
        if (isset($row['Approved'])) { // Approved
            $this->Approved->setFormValue($row['Approved']);
        }
        if (isset($row['ReasonsForRejection'])) { // ReasonsForRejection
            $this->ReasonsForRejection->setFormValue($row['ReasonsForRejection']);
        }
        if (isset($row['Purpose'])) { // Purpose
            $this->Purpose->setFormValue($row['Purpose']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "grant") {
                $validMaster = true;
                $masterTbl = Container("grant");
                if (($parm = Get("fk_GrantNo", Get("GrantNo"))) !== null) {
                    $masterTbl->GrantNo->setQueryStringValue($parm);
                    $this->GrantNo->QueryStringValue = $masterTbl->GrantNo->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->GrantNo->setSessionValue($this->GrantNo->QueryStringValue);
                    $foreignKeys["GrantNo"] = $this->GrantNo->QueryStringValue;
                    if (!is_numeric($masterTbl->GrantNo->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "grant") {
                $validMaster = true;
                $masterTbl = Container("grant");
                if (($parm = Post("fk_GrantNo", Post("GrantNo"))) !== null) {
                    $masterTbl->GrantNo->setFormValue($parm);
                    $this->GrantNo->FormValue = $masterTbl->GrantNo->FormValue;
                    $this->GrantNo->setSessionValue($this->GrantNo->FormValue);
                    $foreignKeys["GrantNo"] = $this->GrantNo->FormValue;
                    if (!is_numeric($masterTbl->GrantNo->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "grant") {
                if (!array_key_exists("GrantNo", $foreignKeys)) { // Not current foreign key
                    $this->GrantNo->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("GrantBeneficiaryList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_NRC":
                    break;
                case "x_Approved":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
