<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for Field Inspection Report
 */
class FieldInspectionReport extends ReportTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";
    public $ShowGroupHeaderAsRow = false;
    public $ShowCompactSummaryFooter = true;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $Latitude;
    public $Longitude;
    public $FieldType;
    public $Ownership;
    public $FarmSize;
    public $FarmSizeEstimated;
    public $TreesPlantedEstimated;
    public $FarmSizeVerified;
    public $TreesPlantedVerified;
    public $FarmNo;
    public $NRC;
    public $FarmerName;
    public $DOB;
    public $Age;
    public $Gender;
    public $MaritalStatus;
    public $PhoneNo;
    public $_Email;
    public $Dependants;
    public $MaleChildren;
    public $FemaleChildren;
    public $HouseholdHead;
    public $FarmerOrg;
    public $FarmerOrgPosition;
    public $JoiningDate;
    public $CampName;
    public $DistrictName;
    public $InspectionTransNo;
    public $PlantsDead;
    public $PlantsVerifiedNo;
    public $PlantsReplaced;
    public $FungicidesReceived;
    public $PescticidesReceived;
    public $DiseasePresence;
    public $AvailableLand;
    public $LandForCashewCleared;
    public $HolesDug;
    public $VerifiedSeedlingArea;
    public $OldTreesNo;
    public $InspectionReport;
    public $InspectionDate;
    public $InspectedBy;
    public $AuthorisedBy;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "Field_Inspection_Report";
        $this->TableName = 'Field Inspection Report';
        $this->TableType = "REPORT";
        $this->TableReportType = "summary"; // Report Type
        $this->ReportSourceTable = 'inspection_view'; // Report source table
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (report only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions

        // Latitude
        $this->Latitude = new ReportField(
            $this, // Table
            'x_Latitude', // Variable name
            'Latitude', // Name
            '`Latitude`', // Expression
            '`Latitude`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Latitude`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Latitude->InputTextType = "text";
        $this->Latitude->Raw = true;
        $this->Latitude->Nullable = false; // NOT NULL field
        $this->Latitude->Required = true; // Required field
        $this->Latitude->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Latitude->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Latitude->SourceTableVar = 'inspection_view';
        $this->Fields['Latitude'] = &$this->Latitude;

        // Longitude
        $this->Longitude = new ReportField(
            $this, // Table
            'x_Longitude', // Variable name
            'Longitude', // Name
            '`Longitude`', // Expression
            '`Longitude`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Longitude`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Longitude->InputTextType = "text";
        $this->Longitude->Raw = true;
        $this->Longitude->Nullable = false; // NOT NULL field
        $this->Longitude->Required = true; // Required field
        $this->Longitude->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Longitude->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Longitude->SourceTableVar = 'inspection_view';
        $this->Fields['Longitude'] = &$this->Longitude;

        // FieldType
        $this->FieldType = new ReportField(
            $this, // Table
            'x_FieldType', // Variable name
            'FieldType', // Name
            '`FieldType`', // Expression
            '`FieldType`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FieldType`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FieldType->InputTextType = "text";
        $this->FieldType->Raw = true;
        $this->FieldType->UseFilter = true; // Table header filter
        $this->FieldType->Lookup = new Lookup($this->FieldType, 'Field_Inspection_Report', true, 'FieldType', ["FieldType","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->FieldType->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FieldType->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->FieldType->SourceTableVar = 'inspection_view';
        $this->FieldType->SearchType = "dropdown";
        $this->Fields['FieldType'] = &$this->FieldType;

        // Ownership
        $this->Ownership = new ReportField(
            $this, // Table
            'x_Ownership', // Variable name
            'Ownership', // Name
            '`Ownership`', // Expression
            '`Ownership`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Ownership`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Ownership->InputTextType = "text";
        $this->Ownership->Raw = true;
        $this->Ownership->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Ownership->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Ownership->SourceTableVar = 'inspection_view';
        $this->Fields['Ownership'] = &$this->Ownership;

        // FarmSize
        $this->FarmSize = new ReportField(
            $this, // Table
            'x_FarmSize', // Variable name
            'FarmSize', // Name
            '`FarmSize`', // Expression
            '`FarmSize`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSize`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSize->InputTextType = "text";
        $this->FarmSize->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->FarmSize->SourceTableVar = 'inspection_view';
        $this->Fields['FarmSize'] = &$this->FarmSize;

        // FarmSizeEstimated
        $this->FarmSizeEstimated = new ReportField(
            $this, // Table
            'x_FarmSizeEstimated', // Variable name
            'FarmSizeEstimated', // Name
            '`FarmSizeEstimated`', // Expression
            '`FarmSizeEstimated`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSizeEstimated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSizeEstimated->InputTextType = "text";
        $this->FarmSizeEstimated->Raw = true;
        $this->FarmSizeEstimated->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->FarmSizeEstimated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->FarmSizeEstimated->SourceTableVar = 'inspection_view';
        $this->Fields['FarmSizeEstimated'] = &$this->FarmSizeEstimated;

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated = new ReportField(
            $this, // Table
            'x_TreesPlantedEstimated', // Variable name
            'TreesPlantedEstimated', // Name
            '`TreesPlantedEstimated`', // Expression
            '`TreesPlantedEstimated`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TreesPlantedEstimated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TreesPlantedEstimated->InputTextType = "text";
        $this->TreesPlantedEstimated->Raw = true;
        $this->TreesPlantedEstimated->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->TreesPlantedEstimated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->TreesPlantedEstimated->SourceTableVar = 'inspection_view';
        $this->Fields['TreesPlantedEstimated'] = &$this->TreesPlantedEstimated;

        // FarmSizeVerified
        $this->FarmSizeVerified = new ReportField(
            $this, // Table
            'x_FarmSizeVerified', // Variable name
            'FarmSizeVerified', // Name
            '`FarmSizeVerified`', // Expression
            '`FarmSizeVerified`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSizeVerified`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSizeVerified->InputTextType = "text";
        $this->FarmSizeVerified->Raw = true;
        $this->FarmSizeVerified->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->FarmSizeVerified->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->FarmSizeVerified->SourceTableVar = 'inspection_view';
        $this->Fields['FarmSizeVerified'] = &$this->FarmSizeVerified;

        // TreesPlantedVerified
        $this->TreesPlantedVerified = new ReportField(
            $this, // Table
            'x_TreesPlantedVerified', // Variable name
            'TreesPlantedVerified', // Name
            '`TreesPlantedVerified`', // Expression
            '`TreesPlantedVerified`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TreesPlantedVerified`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TreesPlantedVerified->InputTextType = "text";
        $this->TreesPlantedVerified->Raw = true;
        $this->TreesPlantedVerified->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->TreesPlantedVerified->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->TreesPlantedVerified->SourceTableVar = 'inspection_view';
        $this->Fields['TreesPlantedVerified'] = &$this->TreesPlantedVerified;

        // FarmNo
        $this->FarmNo = new ReportField(
            $this, // Table
            'x_FarmNo', // Variable name
            'FarmNo', // Name
            '`FarmNo`', // Expression
            '`FarmNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->FarmNo->InputTextType = "text";
        $this->FarmNo->Raw = true;
        $this->FarmNo->GroupingFieldId = 1;
        $this->FarmNo->ShowGroupHeaderAsRow = $this->ShowGroupHeaderAsRow;
        $this->FarmNo->ShowCompactSummaryFooter = $this->ShowCompactSummaryFooter;
        $this->FarmNo->GroupByType = "";
        $this->FarmNo->GroupInterval = "0";
        $this->FarmNo->GroupSql = "";
        $this->FarmNo->IsAutoIncrement = true; // Autoincrement field
        $this->FarmNo->IsPrimaryKey = true; // Primary key field
        $this->FarmNo->Nullable = false; // NOT NULL field
        $this->FarmNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->FarmNo->SourceTableVar = 'inspection_view';
        $this->Fields['FarmNo'] = &$this->FarmNo;

        // NRC
        $this->NRC = new ReportField(
            $this, // Table
            'x_NRC', // Variable name
            'NRC', // Name
            '`NRC`', // Expression
            '`NRC`', // Basic search expression
            200, // Type
            13, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NRC`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NRC->InputTextType = "text";
        $this->NRC->Nullable = false; // NOT NULL field
        $this->NRC->Required = true; // Required field
        $this->NRC->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->NRC->SourceTableVar = 'inspection_view';
        $this->Fields['NRC'] = &$this->NRC;

        // FarmerName
        $this->FarmerName = new ReportField(
            $this, // Table
            'x_FarmerName', // Variable name
            'FarmerName', // Name
            '`FarmerName`', // Expression
            '`FarmerName`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerName->InputTextType = "text";
        $this->FarmerName->GroupingFieldId = 2;
        $this->FarmerName->ShowGroupHeaderAsRow = $this->ShowGroupHeaderAsRow;
        $this->FarmerName->ShowCompactSummaryFooter = $this->ShowCompactSummaryFooter;
        $this->FarmerName->GroupByType = "";
        $this->FarmerName->GroupInterval = "0";
        $this->FarmerName->GroupSql = "";
        $this->FarmerName->Nullable = false; // NOT NULL field
        $this->FarmerName->Required = true; // Required field
        $this->FarmerName->UseFilter = true; // Table header filter
        $this->FarmerName->Lookup = new Lookup($this->FarmerName, 'Field_Inspection_Report', true, 'FarmerName', ["FarmerName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->FarmerName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->FarmerName->SourceTableVar = 'inspection_view';
        $this->FarmerName->SearchType = "dropdown";
        $this->Fields['FarmerName'] = &$this->FarmerName;

        // DOB
        $this->DOB = new ReportField(
            $this, // Table
            'x_DOB', // Variable name
            'DOB', // Name
            '`DOB`', // Expression
            CastDateFieldForLike("`DOB`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`DOB`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DOB->InputTextType = "text";
        $this->DOB->Raw = true;
        $this->DOB->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->DOB->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->DOB->SourceTableVar = 'inspection_view';
        $this->Fields['DOB'] = &$this->DOB;

        // Age
        $this->Age = new ReportField(
            $this, // Table
            'x_Age', // Variable name
            'Age', // Name
            '`Age`', // Expression
            '`Age`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Age`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Age->InputTextType = "text";
        $this->Age->Raw = true;
        $this->Age->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Age->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Age->SourceTableVar = 'inspection_view';
        $this->Fields['Age'] = &$this->Age;

        // Gender
        $this->Gender = new ReportField(
            $this, // Table
            'x_Gender', // Variable name
            'Gender', // Name
            '`Gender`', // Expression
            '`Gender`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Gender`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Gender->InputTextType = "text";
        $this->Gender->UseFilter = true; // Table header filter
        $this->Gender->Lookup = new Lookup($this->Gender, 'Field_Inspection_Report', true, 'Gender', ["Gender","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->Gender->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Gender->SourceTableVar = 'inspection_view';
        $this->Gender->SearchType = "dropdown";
        $this->Fields['Gender'] = &$this->Gender;

        // MaritalStatus
        $this->MaritalStatus = new ReportField(
            $this, // Table
            'x_MaritalStatus', // Variable name
            'MaritalStatus', // Name
            '`MaritalStatus`', // Expression
            '`MaritalStatus`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`MaritalStatus`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->MaritalStatus->InputTextType = "text";
        $this->MaritalStatus->Raw = true;
        $this->MaritalStatus->UseFilter = true; // Table header filter
        $this->MaritalStatus->Lookup = new Lookup($this->MaritalStatus, 'Field_Inspection_Report', true, 'MaritalStatus', ["MaritalStatus","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->MaritalStatus->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MaritalStatus->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->MaritalStatus->SourceTableVar = 'inspection_view';
        $this->MaritalStatus->SearchType = "dropdown";
        $this->Fields['MaritalStatus'] = &$this->MaritalStatus;

        // PhoneNo
        $this->PhoneNo = new ReportField(
            $this, // Table
            'x_PhoneNo', // Variable name
            'PhoneNo', // Name
            '`PhoneNo`', // Expression
            '`PhoneNo`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PhoneNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PhoneNo->InputTextType = "text";
        $this->PhoneNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->PhoneNo->SourceTableVar = 'inspection_view';
        $this->Fields['PhoneNo'] = &$this->PhoneNo;

        // Email
        $this->_Email = new ReportField(
            $this, // Table
            'x__Email', // Variable name
            'Email', // Name
            '`Email`', // Expression
            '`Email`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_Email->InputTextType = "text";
        $this->_Email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->_Email->SourceTableVar = 'inspection_view';
        $this->Fields['Email'] = &$this->_Email;

        // Dependants
        $this->Dependants = new ReportField(
            $this, // Table
            'x_Dependants', // Variable name
            'Dependants', // Name
            '`Dependants`', // Expression
            '`Dependants`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Dependants`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Dependants->InputTextType = "text";
        $this->Dependants->Raw = true;
        $this->Dependants->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Dependants->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Dependants->SourceTableVar = 'inspection_view';
        $this->Fields['Dependants'] = &$this->Dependants;

        // MaleChildren
        $this->MaleChildren = new ReportField(
            $this, // Table
            'x_MaleChildren', // Variable name
            'MaleChildren', // Name
            '`MaleChildren`', // Expression
            '`MaleChildren`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`MaleChildren`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->MaleChildren->InputTextType = "text";
        $this->MaleChildren->Raw = true;
        $this->MaleChildren->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MaleChildren->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->MaleChildren->SourceTableVar = 'inspection_view';
        $this->Fields['MaleChildren'] = &$this->MaleChildren;

        // FemaleChildren
        $this->FemaleChildren = new ReportField(
            $this, // Table
            'x_FemaleChildren', // Variable name
            'FemaleChildren', // Name
            '`FemaleChildren`', // Expression
            '`FemaleChildren`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FemaleChildren`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FemaleChildren->InputTextType = "text";
        $this->FemaleChildren->Raw = true;
        $this->FemaleChildren->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FemaleChildren->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->FemaleChildren->SourceTableVar = 'inspection_view';
        $this->Fields['FemaleChildren'] = &$this->FemaleChildren;

        // HouseholdHead
        $this->HouseholdHead = new ReportField(
            $this, // Table
            'x_HouseholdHead', // Variable name
            'HouseholdHead', // Name
            '`HouseholdHead`', // Expression
            '`HouseholdHead`', // Basic search expression
            16, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`HouseholdHead`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->HouseholdHead->InputTextType = "text";
        $this->HouseholdHead->Raw = true;
        $this->HouseholdHead->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->HouseholdHead->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->HouseholdHead->SourceTableVar = 'inspection_view';
        $this->Fields['HouseholdHead'] = &$this->HouseholdHead;

        // FarmerOrg
        $this->FarmerOrg = new ReportField(
            $this, // Table
            'x_FarmerOrg', // Variable name
            'FarmerOrg', // Name
            '`FarmerOrg`', // Expression
            '`FarmerOrg`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerOrg`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerOrg->InputTextType = "text";
        $this->FarmerOrg->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->FarmerOrg->SourceTableVar = 'inspection_view';
        $this->Fields['FarmerOrg'] = &$this->FarmerOrg;

        // FarmerOrgPosition
        $this->FarmerOrgPosition = new ReportField(
            $this, // Table
            'x_FarmerOrgPosition', // Variable name
            'FarmerOrgPosition', // Name
            '`FarmerOrgPosition`', // Expression
            '`FarmerOrgPosition`', // Basic search expression
            200, // Type
            40, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerOrgPosition`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerOrgPosition->InputTextType = "text";
        $this->FarmerOrgPosition->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->FarmerOrgPosition->SourceTableVar = 'inspection_view';
        $this->Fields['FarmerOrgPosition'] = &$this->FarmerOrgPosition;

        // JoiningDate
        $this->JoiningDate = new ReportField(
            $this, // Table
            'x_JoiningDate', // Variable name
            'JoiningDate', // Name
            '`JoiningDate`', // Expression
            CastDateFieldForLike("`JoiningDate`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`JoiningDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->JoiningDate->InputTextType = "text";
        $this->JoiningDate->Raw = true;
        $this->JoiningDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->JoiningDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->JoiningDate->SourceTableVar = 'inspection_view';
        $this->Fields['JoiningDate'] = &$this->JoiningDate;

        // CampName
        $this->CampName = new ReportField(
            $this, // Table
            'x_CampName', // Variable name
            'CampName', // Name
            '`CampName`', // Expression
            '`CampName`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`CampName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->CampName->InputTextType = "text";
        $this->CampName->UseFilter = true; // Table header filter
        $this->CampName->Lookup = new Lookup($this->CampName, 'Field_Inspection_Report', true, 'CampName', ["CampName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->CampName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->CampName->SourceTableVar = 'inspection_view';
        $this->CampName->SearchType = "dropdown";
        $this->Fields['CampName'] = &$this->CampName;

        // DistrictName
        $this->DistrictName = new ReportField(
            $this, // Table
            'x_DistrictName', // Variable name
            'DistrictName', // Name
            '`DistrictName`', // Expression
            '`DistrictName`', // Basic search expression
            200, // Type
            40, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`DistrictName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DistrictName->InputTextType = "text";
        $this->DistrictName->Nullable = false; // NOT NULL field
        $this->DistrictName->Required = true; // Required field
        $this->DistrictName->UseFilter = true; // Table header filter
        $this->DistrictName->Lookup = new Lookup($this->DistrictName, 'Field_Inspection_Report', true, 'DistrictName', ["DistrictName","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->DistrictName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->DistrictName->SourceTableVar = 'inspection_view';
        $this->DistrictName->SearchType = "dropdown";
        $this->Fields['DistrictName'] = &$this->DistrictName;

        // InspectionTransNo
        $this->InspectionTransNo = new ReportField(
            $this, // Table
            'x_InspectionTransNo', // Variable name
            'InspectionTransNo', // Name
            '`InspectionTransNo`', // Expression
            '`InspectionTransNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`InspectionTransNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->InspectionTransNo->InputTextType = "text";
        $this->InspectionTransNo->Raw = true;
        $this->InspectionTransNo->IsAutoIncrement = true; // Autoincrement field
        $this->InspectionTransNo->IsPrimaryKey = true; // Primary key field
        $this->InspectionTransNo->Nullable = false; // NOT NULL field
        $this->InspectionTransNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->InspectionTransNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->InspectionTransNo->SourceTableVar = 'inspection_view';
        $this->Fields['InspectionTransNo'] = &$this->InspectionTransNo;

        // PlantsDead
        $this->PlantsDead = new ReportField(
            $this, // Table
            'x_PlantsDead', // Variable name
            'PlantsDead', // Name
            '`PlantsDead`', // Expression
            '`PlantsDead`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PlantsDead`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PlantsDead->InputTextType = "text";
        $this->PlantsDead->Raw = true;
        $this->PlantsDead->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->PlantsDead->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->PlantsDead->SourceTableVar = 'inspection_view';
        $this->Fields['PlantsDead'] = &$this->PlantsDead;

        // PlantsVerifiedNo
        $this->PlantsVerifiedNo = new ReportField(
            $this, // Table
            'x_PlantsVerifiedNo', // Variable name
            'PlantsVerifiedNo', // Name
            '`PlantsVerifiedNo`', // Expression
            '`PlantsVerifiedNo`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PlantsVerifiedNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PlantsVerifiedNo->InputTextType = "text";
        $this->PlantsVerifiedNo->Raw = true;
        $this->PlantsVerifiedNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->PlantsVerifiedNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->PlantsVerifiedNo->SourceTableVar = 'inspection_view';
        $this->Fields['PlantsVerifiedNo'] = &$this->PlantsVerifiedNo;

        // PlantsReplaced
        $this->PlantsReplaced = new ReportField(
            $this, // Table
            'x_PlantsReplaced', // Variable name
            'PlantsReplaced', // Name
            '`PlantsReplaced`', // Expression
            '`PlantsReplaced`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PlantsReplaced`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PlantsReplaced->InputTextType = "text";
        $this->PlantsReplaced->Raw = true;
        $this->PlantsReplaced->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->PlantsReplaced->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->PlantsReplaced->SourceTableVar = 'inspection_view';
        $this->Fields['PlantsReplaced'] = &$this->PlantsReplaced;

        // FungicidesReceived
        $this->FungicidesReceived = new ReportField(
            $this, // Table
            'x_FungicidesReceived', // Variable name
            'FungicidesReceived', // Name
            '`FungicidesReceived`', // Expression
            '`FungicidesReceived`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FungicidesReceived`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FungicidesReceived->InputTextType = "text";
        $this->FungicidesReceived->Raw = true;
        $this->FungicidesReceived->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->FungicidesReceived->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->FungicidesReceived->SourceTableVar = 'inspection_view';
        $this->Fields['FungicidesReceived'] = &$this->FungicidesReceived;

        // PescticidesReceived
        $this->PescticidesReceived = new ReportField(
            $this, // Table
            'x_PescticidesReceived', // Variable name
            'PescticidesReceived', // Name
            '`PescticidesReceived`', // Expression
            '`PescticidesReceived`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PescticidesReceived`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PescticidesReceived->InputTextType = "text";
        $this->PescticidesReceived->Raw = true;
        $this->PescticidesReceived->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->PescticidesReceived->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->PescticidesReceived->SourceTableVar = 'inspection_view';
        $this->Fields['PescticidesReceived'] = &$this->PescticidesReceived;

        // DiseasePresence
        $this->DiseasePresence = new ReportField(
            $this, // Table
            'x_DiseasePresence', // Variable name
            'DiseasePresence', // Name
            '`DiseasePresence`', // Expression
            '`DiseasePresence`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`DiseasePresence`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DiseasePresence->InputTextType = "text";
        $this->DiseasePresence->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->DiseasePresence->SourceTableVar = 'inspection_view';
        $this->Fields['DiseasePresence'] = &$this->DiseasePresence;

        // AvailableLand
        $this->AvailableLand = new ReportField(
            $this, // Table
            'x_AvailableLand', // Variable name
            'AvailableLand', // Name
            '`AvailableLand`', // Expression
            '`AvailableLand`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`AvailableLand`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->AvailableLand->InputTextType = "text";
        $this->AvailableLand->Raw = true;
        $this->AvailableLand->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->AvailableLand->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->AvailableLand->SourceTableVar = 'inspection_view';
        $this->Fields['AvailableLand'] = &$this->AvailableLand;

        // LandForCashewCleared
        $this->LandForCashewCleared = new ReportField(
            $this, // Table
            'x_LandForCashewCleared', // Variable name
            'LandForCashewCleared', // Name
            '`LandForCashewCleared`', // Expression
            '`LandForCashewCleared`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`LandForCashewCleared`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->LandForCashewCleared->InputTextType = "text";
        $this->LandForCashewCleared->Raw = true;
        $this->LandForCashewCleared->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->LandForCashewCleared->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->LandForCashewCleared->SourceTableVar = 'inspection_view';
        $this->Fields['LandForCashewCleared'] = &$this->LandForCashewCleared;

        // HolesDug
        $this->HolesDug = new ReportField(
            $this, // Table
            'x_HolesDug', // Variable name
            'HolesDug', // Name
            '`HolesDug`', // Expression
            '`HolesDug`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`HolesDug`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->HolesDug->InputTextType = "text";
        $this->HolesDug->Raw = true;
        $this->HolesDug->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->HolesDug->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->HolesDug->SourceTableVar = 'inspection_view';
        $this->Fields['HolesDug'] = &$this->HolesDug;

        // VerifiedSeedlingArea
        $this->VerifiedSeedlingArea = new ReportField(
            $this, // Table
            'x_VerifiedSeedlingArea', // Variable name
            'VerifiedSeedlingArea', // Name
            '`VerifiedSeedlingArea`', // Expression
            '`VerifiedSeedlingArea`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`VerifiedSeedlingArea`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->VerifiedSeedlingArea->InputTextType = "text";
        $this->VerifiedSeedlingArea->Raw = true;
        $this->VerifiedSeedlingArea->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->VerifiedSeedlingArea->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->VerifiedSeedlingArea->SourceTableVar = 'inspection_view';
        $this->Fields['VerifiedSeedlingArea'] = &$this->VerifiedSeedlingArea;

        // OldTreesNo
        $this->OldTreesNo = new ReportField(
            $this, // Table
            'x_OldTreesNo', // Variable name
            'OldTreesNo', // Name
            '`OldTreesNo`', // Expression
            '`OldTreesNo`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`OldTreesNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->OldTreesNo->InputTextType = "text";
        $this->OldTreesNo->Raw = true;
        $this->OldTreesNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->OldTreesNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->OldTreesNo->SourceTableVar = 'inspection_view';
        $this->Fields['OldTreesNo'] = &$this->OldTreesNo;

        // InspectionReport
        $this->InspectionReport = new ReportField(
            $this, // Table
            'x_InspectionReport', // Variable name
            'InspectionReport', // Name
            '`InspectionReport`', // Expression
            '`InspectionReport`', // Basic search expression
            201, // Type
            2147483647, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`InspectionReport`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->InspectionReport->InputTextType = "text";
        $this->InspectionReport->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->InspectionReport->SourceTableVar = 'inspection_view';
        $this->Fields['InspectionReport'] = &$this->InspectionReport;

        // InspectionDate
        $this->InspectionDate = new ReportField(
            $this, // Table
            'x_InspectionDate', // Variable name
            'InspectionDate', // Name
            '`InspectionDate`', // Expression
            CastDateFieldForLike("`InspectionDate`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`InspectionDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->InspectionDate->InputTextType = "text";
        $this->InspectionDate->Raw = true;
        $this->InspectionDate->Nullable = false; // NOT NULL field
        $this->InspectionDate->Required = true; // Required field
        $this->InspectionDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->InspectionDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->InspectionDate->SourceTableVar = 'inspection_view';
        $this->Fields['InspectionDate'] = &$this->InspectionDate;

        // InspectedBy
        $this->InspectedBy = new ReportField(
            $this, // Table
            'x_InspectedBy', // Variable name
            'InspectedBy', // Name
            '`InspectedBy`', // Expression
            '`InspectedBy`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`InspectedBy`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->InspectedBy->InputTextType = "text";
        $this->InspectedBy->Nullable = false; // NOT NULL field
        $this->InspectedBy->Required = true; // Required field
        $this->InspectedBy->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->InspectedBy->SourceTableVar = 'inspection_view';
        $this->Fields['InspectedBy'] = &$this->InspectedBy;

        // AuthorisedBy
        $this->AuthorisedBy = new ReportField(
            $this, // Table
            'x_AuthorisedBy', // Variable name
            'AuthorisedBy', // Name
            '`AuthorisedBy`', // Expression
            '`AuthorisedBy`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`AuthorisedBy`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->AuthorisedBy->InputTextType = "text";
        $this->AuthorisedBy->Nullable = false; // NOT NULL field
        $this->AuthorisedBy->Required = true; // Required field
        $this->AuthorisedBy->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->AuthorisedBy->SourceTableVar = 'inspection_view';
        $this->Fields['AuthorisedBy'] = &$this->AuthorisedBy;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Single column sort
    protected function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($fld->GroupingFieldId == 0) {
                $this->setDetailOrderBy($curOrderBy); // Save to Session
            }
        } else {
            if ($fld->GroupingFieldId == 0) {
                $fld->setSort("");
            }
        }
    }

    // Get Sort SQL
    protected function sortSql()
    {
        $dtlSortSql = $this->getDetailOrderBy(); // Get ORDER BY for detail fields from session
        $argrps = [];
        foreach ($this->Fields as $fld) {
            if (in_array($fld->getSort(), ["ASC", "DESC"])) {
                $fldsql = $fld->Expression;
                if ($fld->GroupingFieldId > 0) {
                    if ($fld->GroupSql != "") {
                        $argrps[$fld->GroupingFieldId] = str_replace("%s", $fldsql, $fld->GroupSql) . " " . $fld->getSort();
                    } else {
                        $argrps[$fld->GroupingFieldId] = $fldsql . " " . $fld->getSort();
                    }
                }
            }
        }
        $sortSql = "";
        foreach ($argrps as $grp) {
            if ($sortSql != "") {
                $sortSql .= ", ";
            }
            $sortSql .= $grp;
        }
        if ($dtlSortSql != "") {
            if ($sortSql != "") {
                $sortSql .= ", ";
            }
            $sortSql .= $dtlSortSql;
        }
        return $sortSql;
    }

    // Table Level Group SQL
    private $sqlFirstGroupField = "";
    private $sqlSelectGroup = null;
    private $sqlOrderByGroup = "";

    // First Group Field
    public function getSqlFirstGroupField($alias = false)
    {
        if ($this->sqlFirstGroupField != "") {
            return $this->sqlFirstGroupField;
        }
        $firstGroupField = &$this->FarmNo;
        $expr = $firstGroupField->Expression;
        if ($firstGroupField->GroupSql != "") {
            $expr = str_replace("%s", $firstGroupField->Expression, $firstGroupField->GroupSql);
            if ($alias) {
                $expr .= " AS " . QuotedName($firstGroupField->getGroupName(), $this->Dbid);
            }
        }
        return $expr;
    }

    public function setSqlFirstGroupField($v)
    {
        $this->sqlFirstGroupField = $v;
    }

    // Select Group
    public function getSqlSelectGroup()
    {
        return $this->sqlSelectGroup ?? $this->getQueryBuilder()->select($this->getSqlFirstGroupField(true))->distinct();
    }

    public function setSqlSelectGroup($v)
    {
        $this->sqlSelectGroup = $v;
    }

    // Order By Group
    public function getSqlOrderByGroup()
    {
        if ($this->sqlOrderByGroup != "") {
            return $this->sqlOrderByGroup;
        }
        return $this->getSqlFirstGroupField() . " ASC";
    }

    public function setSqlOrderByGroup($v)
    {
        $this->sqlOrderByGroup = $v;
    }

    // Summary properties
    private $sqlSelectAggregate = null;
    private $sqlAggregatePrefix = "";
    private $sqlAggregateSuffix = "";
    private $sqlSelectCount = null;

    // Select Aggregate
    public function getSqlSelectAggregate()
    {
        return $this->sqlSelectAggregate ?? $this->getQueryBuilder()->select("SUM(`FarmSizeEstimated`) AS sum_farmsizeestimated, SUM(`TreesPlantedEstimated`) AS sum_treesplantedestimated, SUM(`FarmSizeVerified`) AS sum_farmsizeverified, SUM(`TreesPlantedVerified`) AS sum_treesplantedverified, SUM(`PlantsReplaced`) AS sum_plantsreplaced, SUM(`FungicidesReceived`) AS sum_fungicidesreceived, SUM(`PescticidesReceived`) AS sum_pescticidesreceived, SUM(`OldTreesNo`) AS sum_oldtreesno");
    }

    public function setSqlSelectAggregate($v)
    {
        $this->sqlSelectAggregate = $v;
    }

    // Aggregate Prefix
    public function getSqlAggregatePrefix()
    {
        return ($this->sqlAggregatePrefix != "") ? $this->sqlAggregatePrefix : "";
    }

    public function setSqlAggregatePrefix($v)
    {
        $this->sqlAggregatePrefix = $v;
    }

    // Aggregate Suffix
    public function getSqlAggregateSuffix()
    {
        return ($this->sqlAggregateSuffix != "") ? $this->sqlAggregateSuffix : "";
    }

    public function setSqlAggregateSuffix($v)
    {
        $this->sqlAggregateSuffix = $v;
    }

    // Select Count
    public function getSqlSelectCount()
    {
        return $this->sqlSelectCount ?? $this->getQueryBuilder()->select("COUNT(*)");
    }

    public function setSqlSelectCount($v)
    {
        $this->sqlSelectCount = $v;
    }

    // Render for lookup
    public function renderLookup()
    {
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "inspection_view";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect()
    {
        if ($this->SqlSelect) {
            return $this->SqlSelect;
        }
        $select = $this->getQueryBuilder()->select($this->sqlSelectFields());
        $groupField = &$this->FarmNo;
        if ($groupField->GroupSql != "") {
            $expr = str_replace("%s", $groupField->Expression, $groupField->GroupSql) . " AS " . QuotedName($groupField->getGroupName(), $this->Dbid);
            $select->addSelect($expr);
        }
        $groupField = &$this->FarmerName;
        if ($groupField->GroupSql != "") {
            $expr = str_replace("%s", $groupField->Expression, $groupField->GroupSql) . " AS " . QuotedName($groupField->getGroupName(), $this->Dbid);
            $select->addSelect($expr);
        }
        return $select;
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD) == Allow::ADD;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT) == Allow::EDIT;
            case "delete":
                return ($allow & Allow::DELETE) == Allow::DELETE;
            case "view":
                return ($allow & Allow::VIEW) == Allow::VIEW;
            case "search":
                return ($allow & Allow::SEARCH) == Allow::SEARCH;
            case "lookup":
                return ($allow & Allow::LOOKUP) == Allow::LOOKUP;
            default:
                return ($allow & Allow::LIST) == Allow::LIST;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`FarmNo` = @FarmNo@ AND `InspectionTransNo` = @InspectionTransNo@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->FarmNo->CurrentValue : $this->FarmNo->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $val = $current ? $this->InspectionTransNo->CurrentValue : $this->InspectionTransNo->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 2) {
            if ($current) {
                $this->FarmNo->CurrentValue = $keys[0];
            } else {
                $this->FarmNo->OldValue = $keys[0];
            }
            if ($current) {
                $this->InspectionTransNo->CurrentValue = $keys[1];
            } else {
                $this->InspectionTransNo->OldValue = $keys[1];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('FarmNo', $row) ? $row['FarmNo'] : null;
        } else {
            $val = !EmptyValue($this->FarmNo->OldValue) && !$current ? $this->FarmNo->OldValue : $this->FarmNo->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@FarmNo@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        if (is_array($row)) {
            $val = array_key_exists('InspectionTransNo', $row) ? $row['InspectionTransNo'] : null;
        } else {
            $val = !EmptyValue($this->InspectionTransNo->OldValue) && !$current ? $this->InspectionTransNo->OldValue : $this->InspectionTransNo->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@InspectionTransNo@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "" => $Language->phrase("View"),
            "" => $Language->phrase("Edit"),
            "" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "FieldInspectionReport";
    }

    // API page name
    public function getApiPageName($action)
    {
        return "FieldInspectionReportSummary";
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("", $parm);
        } else {
            $url = $this->keyUrl("", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "?" . $parm;
        } else {
            $url = "";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"FarmNo\":" . VarToJson($this->FarmNo->CurrentValue, "number");
        $json .= ",\"InspectionTransNo\":" . VarToJson($this->InspectionTransNo->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->FarmNo->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->FarmNo->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($this->InspectionTransNo->CurrentValue !== null) {
            $url .= $this->RouteCompositeKeySeparator . $this->encodeKeyValue($this->InspectionTransNo->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            $this->DrillDown ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
            for ($i = 0; $i < $cnt; $i++) {
                $arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
            }
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 1))) // Other API
                : []; // Non-API
            if (($keyValue = Param("FarmNo") ?? Route("FarmNo")) !== null) {
                $arKey[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKey[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
            if (($keyValue = Param("InspectionTransNo") ?? Route("InspectionTransNo")) !== null) {
                $arKey[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(1) ?? $keyValues[1] ?? null) !== null)) {
                $arKey[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
            $arKeys[] = $arKey;
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_array($key) || count($key) != 2) {
                    continue; // Just skip so other keys will still work
                }
                if (!is_numeric($key[0])) { // FarmNo
                    continue;
                }
                if (!is_numeric($key[1])) { // InspectionTransNo
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->FarmNo->CurrentValue = $key[0];
            } else {
                $this->FarmNo->OldValue = $key[0];
            }
            if ($setCurrent) {
                $this->InspectionTransNo->CurrentValue = $key[1];
            } else {
                $this->InspectionTransNo->OldValue = $key[1];
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
