<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class FarmInspectionSearch extends FarmInspection
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "FarmInspectionSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "FarmInspectionSearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ProvinceCode->setVisibility();
        $this->DistrictCode->setVisibility();
        $this->CampCode->setVisibility();
        $this->VillageCode->setVisibility();
        $this->NRC->setVisibility();
        $this->FarmerNo->setVisibility();
        $this->FarmNo->setVisibility();
        $this->InspectionTransNo->setVisibility();
        $this->PlantsDead->setVisibility();
        $this->PlantsVerifiedNo->setVisibility();
        $this->PlantsReplaced->setVisibility();
        $this->FungicidesReceived->setVisibility();
        $this->PescticidesReceived->setVisibility();
        $this->DiseasePresence->setVisibility();
        $this->AvailableLand->setVisibility();
        $this->LandForCashewCleared->setVisibility();
        $this->HolesDug->setVisibility();
        $this->VerifiedSeedlingArea->setVisibility();
        $this->OldTreesNo->setVisibility();
        $this->InspectionReport->setVisibility();
        $this->InspectionDate->setVisibility();
        $this->InspectedBy->setVisibility();
        $this->AuthorisedBy->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'farm_inspection';
        $this->TableName = 'farm_inspection';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (farm_inspection)
        if (!isset($GLOBALS["farm_inspection"]) || $GLOBALS["farm_inspection"]::class == PROJECT_NAMESPACE . "farm_inspection") {
            $GLOBALS["farm_inspection"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'farm_inspection');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "FarmInspectionView"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['InspectionTransNo'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->InspectionTransNo->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->ProvinceCode);
        $this->setupLookupOptions($this->DistrictCode);
        $this->setupLookupOptions($this->CampCode);
        $this->setupLookupOptions($this->VillageCode);
        $this->setupLookupOptions($this->NRC);
        $this->setupLookupOptions($this->DiseasePresence);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "FarmInspectionList" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->ProvinceCode); // ProvinceCode
        $this->buildSearchUrl($srchUrl, $this->DistrictCode); // DistrictCode
        $this->buildSearchUrl($srchUrl, $this->CampCode); // CampCode
        $this->buildSearchUrl($srchUrl, $this->VillageCode); // VillageCode
        $this->buildSearchUrl($srchUrl, $this->NRC); // NRC
        $this->buildSearchUrl($srchUrl, $this->FarmerNo); // FarmerNo
        $this->buildSearchUrl($srchUrl, $this->FarmNo); // FarmNo
        $this->buildSearchUrl($srchUrl, $this->InspectionTransNo); // InspectionTransNo
        $this->buildSearchUrl($srchUrl, $this->PlantsDead); // PlantsDead
        $this->buildSearchUrl($srchUrl, $this->PlantsVerifiedNo); // PlantsVerifiedNo
        $this->buildSearchUrl($srchUrl, $this->PlantsReplaced); // PlantsReplaced
        $this->buildSearchUrl($srchUrl, $this->FungicidesReceived); // FungicidesReceived
        $this->buildSearchUrl($srchUrl, $this->PescticidesReceived); // PescticidesReceived
        $this->buildSearchUrl($srchUrl, $this->DiseasePresence); // DiseasePresence
        $this->buildSearchUrl($srchUrl, $this->AvailableLand); // AvailableLand
        $this->buildSearchUrl($srchUrl, $this->LandForCashewCleared); // LandForCashewCleared
        $this->buildSearchUrl($srchUrl, $this->HolesDug); // HolesDug
        $this->buildSearchUrl($srchUrl, $this->VerifiedSeedlingArea); // VerifiedSeedlingArea
        $this->buildSearchUrl($srchUrl, $this->OldTreesNo); // OldTreesNo
        $this->buildSearchUrl($srchUrl, $this->InspectionReport); // InspectionReport
        $this->buildSearchUrl($srchUrl, $this->InspectionDate); // InspectionDate
        $this->buildSearchUrl($srchUrl, $this->InspectedBy); // InspectedBy
        $this->buildSearchUrl($srchUrl, $this->AuthorisedBy); // AuthorisedBy
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // ProvinceCode
        if ($this->ProvinceCode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // DistrictCode
        if ($this->DistrictCode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // CampCode
        if ($this->CampCode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // VillageCode
        if ($this->VillageCode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // NRC
        if ($this->NRC->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // FarmerNo
        if ($this->FarmerNo->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // FarmNo
        if ($this->FarmNo->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // InspectionTransNo
        if ($this->InspectionTransNo->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // PlantsDead
        if ($this->PlantsDead->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // PlantsVerifiedNo
        if ($this->PlantsVerifiedNo->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // PlantsReplaced
        if ($this->PlantsReplaced->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // FungicidesReceived
        if ($this->FungicidesReceived->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // PescticidesReceived
        if ($this->PescticidesReceived->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // DiseasePresence
        if ($this->DiseasePresence->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->DiseasePresence->AdvancedSearch->SearchValue)) {
            $this->DiseasePresence->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->DiseasePresence->AdvancedSearch->SearchValue);
        }
        if (is_array($this->DiseasePresence->AdvancedSearch->SearchValue2)) {
            $this->DiseasePresence->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->DiseasePresence->AdvancedSearch->SearchValue2);
        }

        // AvailableLand
        if ($this->AvailableLand->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // LandForCashewCleared
        if ($this->LandForCashewCleared->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // HolesDug
        if ($this->HolesDug->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // VerifiedSeedlingArea
        if ($this->VerifiedSeedlingArea->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // OldTreesNo
        if ($this->OldTreesNo->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // InspectionReport
        if ($this->InspectionReport->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // InspectionDate
        if ($this->InspectionDate->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // InspectedBy
        if ($this->InspectedBy->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // AuthorisedBy
        if ($this->AuthorisedBy->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProvinceCode
        $this->ProvinceCode->RowCssClass = "row";

        // DistrictCode
        $this->DistrictCode->RowCssClass = "row";

        // CampCode
        $this->CampCode->RowCssClass = "row";

        // VillageCode
        $this->VillageCode->RowCssClass = "row";

        // NRC
        $this->NRC->RowCssClass = "row";

        // FarmerNo
        $this->FarmerNo->RowCssClass = "row";

        // FarmNo
        $this->FarmNo->RowCssClass = "row";

        // InspectionTransNo
        $this->InspectionTransNo->RowCssClass = "row";

        // PlantsDead
        $this->PlantsDead->RowCssClass = "row";

        // PlantsVerifiedNo
        $this->PlantsVerifiedNo->RowCssClass = "row";

        // PlantsReplaced
        $this->PlantsReplaced->RowCssClass = "row";

        // FungicidesReceived
        $this->FungicidesReceived->RowCssClass = "row";

        // PescticidesReceived
        $this->PescticidesReceived->RowCssClass = "row";

        // DiseasePresence
        $this->DiseasePresence->RowCssClass = "row";

        // AvailableLand
        $this->AvailableLand->RowCssClass = "row";

        // LandForCashewCleared
        $this->LandForCashewCleared->RowCssClass = "row";

        // HolesDug
        $this->HolesDug->RowCssClass = "row";

        // VerifiedSeedlingArea
        $this->VerifiedSeedlingArea->RowCssClass = "row";

        // OldTreesNo
        $this->OldTreesNo->RowCssClass = "row";

        // InspectionReport
        $this->InspectionReport->RowCssClass = "row";

        // InspectionDate
        $this->InspectionDate->RowCssClass = "row";

        // InspectedBy
        $this->InspectedBy->RowCssClass = "row";

        // AuthorisedBy
        $this->AuthorisedBy->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProvinceCode
            $curVal = strval($this->ProvinceCode->CurrentValue);
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                    } else {
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                    }
                }
            } else {
                $this->ProvinceCode->ViewValue = null;
            }

            // DistrictCode
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }

            // CampCode
            $curVal = strval($this->CampCode->CurrentValue);
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                if ($this->CampCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                    }
                }
            } else {
                $this->CampCode->ViewValue = null;
            }

            // VillageCode
            $curVal = strval($this->VillageCode->CurrentValue);
            if ($curVal != "") {
                $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                if ($this->VillageCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                    }
                }
            } else {
                $this->VillageCode->ViewValue = null;
            }

            // NRC
            $curVal = strval($this->NRC->CurrentValue);
            if ($curVal != "") {
                $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->ViewValue = $this->NRC->CurrentValue;
                    }
                }
            } else {
                $this->NRC->ViewValue = null;
            }

            // FarmerNo
            $this->FarmerNo->ViewValue = $this->FarmerNo->CurrentValue;

            // FarmNo
            $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;

            // InspectionTransNo
            $this->InspectionTransNo->ViewValue = $this->InspectionTransNo->CurrentValue;

            // PlantsDead
            $this->PlantsDead->ViewValue = $this->PlantsDead->CurrentValue;
            $this->PlantsDead->ViewValue = FormatNumber($this->PlantsDead->ViewValue, $this->PlantsDead->formatPattern());

            // PlantsVerifiedNo
            $this->PlantsVerifiedNo->ViewValue = $this->PlantsVerifiedNo->CurrentValue;
            $this->PlantsVerifiedNo->ViewValue = FormatNumber($this->PlantsVerifiedNo->ViewValue, $this->PlantsVerifiedNo->formatPattern());

            // PlantsReplaced
            $this->PlantsReplaced->ViewValue = $this->PlantsReplaced->CurrentValue;
            $this->PlantsReplaced->ViewValue = FormatNumber($this->PlantsReplaced->ViewValue, $this->PlantsReplaced->formatPattern());

            // FungicidesReceived
            $this->FungicidesReceived->ViewValue = $this->FungicidesReceived->CurrentValue;
            $this->FungicidesReceived->ViewValue = FormatNumber($this->FungicidesReceived->ViewValue, $this->FungicidesReceived->formatPattern());

            // PescticidesReceived
            $this->PescticidesReceived->ViewValue = $this->PescticidesReceived->CurrentValue;
            $this->PescticidesReceived->ViewValue = FormatNumber($this->PescticidesReceived->ViewValue, $this->PescticidesReceived->formatPattern());

            // DiseasePresence
            $curVal = strval($this->DiseasePresence->CurrentValue);
            if ($curVal != "") {
                $this->DiseasePresence->ViewValue = $this->DiseasePresence->lookupCacheOption($curVal);
                if ($this->DiseasePresence->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->DiseasePresence->Lookup->getTable()->Fields["DiseasePresence"]->searchExpression(), "=", trim($wrk), $this->DiseasePresence->Lookup->getTable()->Fields["DiseasePresence"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->DiseasePresence->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->DiseasePresence->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->DiseasePresence->Lookup->renderViewRow($row);
                            $this->DiseasePresence->ViewValue->add($this->DiseasePresence->displayValue($arwrk));
                        }
                    } else {
                        $this->DiseasePresence->ViewValue = $this->DiseasePresence->CurrentValue;
                    }
                }
            } else {
                $this->DiseasePresence->ViewValue = null;
            }

            // AvailableLand
            $this->AvailableLand->ViewValue = $this->AvailableLand->CurrentValue;
            $this->AvailableLand->ViewValue = FormatNumber($this->AvailableLand->ViewValue, $this->AvailableLand->formatPattern());

            // LandForCashewCleared
            $this->LandForCashewCleared->ViewValue = $this->LandForCashewCleared->CurrentValue;
            $this->LandForCashewCleared->ViewValue = FormatNumber($this->LandForCashewCleared->ViewValue, $this->LandForCashewCleared->formatPattern());

            // HolesDug
            $this->HolesDug->ViewValue = $this->HolesDug->CurrentValue;

            // VerifiedSeedlingArea
            $this->VerifiedSeedlingArea->ViewValue = $this->VerifiedSeedlingArea->CurrentValue;
            $this->VerifiedSeedlingArea->ViewValue = FormatNumber($this->VerifiedSeedlingArea->ViewValue, $this->VerifiedSeedlingArea->formatPattern());

            // OldTreesNo
            $this->OldTreesNo->ViewValue = $this->OldTreesNo->CurrentValue;
            $this->OldTreesNo->ViewValue = FormatNumber($this->OldTreesNo->ViewValue, $this->OldTreesNo->formatPattern());

            // InspectionReport
            $this->InspectionReport->ViewValue = $this->InspectionReport->CurrentValue;

            // InspectionDate
            $this->InspectionDate->ViewValue = $this->InspectionDate->CurrentValue;
            $this->InspectionDate->ViewValue = FormatDateTime($this->InspectionDate->ViewValue, $this->InspectionDate->formatPattern());

            // InspectedBy
            $this->InspectedBy->ViewValue = $this->InspectedBy->CurrentValue;

            // AuthorisedBy
            $this->AuthorisedBy->ViewValue = $this->AuthorisedBy->CurrentValue;

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";
            $this->ProvinceCode->TooltipValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";
            $this->DistrictCode->TooltipValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";
            $this->CampCode->TooltipValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";
            $this->VillageCode->TooltipValue = "";

            // NRC
            $this->NRC->HrefValue = "";
            $this->NRC->TooltipValue = "";

            // FarmerNo
            $this->FarmerNo->HrefValue = "";
            $this->FarmerNo->TooltipValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";
            $this->FarmNo->TooltipValue = "";

            // InspectionTransNo
            $this->InspectionTransNo->HrefValue = "";
            $this->InspectionTransNo->TooltipValue = "";

            // PlantsDead
            $this->PlantsDead->HrefValue = "";
            $this->PlantsDead->TooltipValue = "";

            // PlantsVerifiedNo
            $this->PlantsVerifiedNo->HrefValue = "";
            $this->PlantsVerifiedNo->TooltipValue = "";

            // PlantsReplaced
            $this->PlantsReplaced->HrefValue = "";
            $this->PlantsReplaced->TooltipValue = "";

            // FungicidesReceived
            $this->FungicidesReceived->HrefValue = "";
            $this->FungicidesReceived->TooltipValue = "";

            // PescticidesReceived
            $this->PescticidesReceived->HrefValue = "";
            $this->PescticidesReceived->TooltipValue = "";

            // DiseasePresence
            $this->DiseasePresence->HrefValue = "";
            $this->DiseasePresence->TooltipValue = "";

            // AvailableLand
            $this->AvailableLand->HrefValue = "";
            $this->AvailableLand->TooltipValue = "";

            // LandForCashewCleared
            $this->LandForCashewCleared->HrefValue = "";
            $this->LandForCashewCleared->TooltipValue = "";

            // HolesDug
            $this->HolesDug->HrefValue = "";
            $this->HolesDug->TooltipValue = "";

            // VerifiedSeedlingArea
            $this->VerifiedSeedlingArea->HrefValue = "";
            $this->VerifiedSeedlingArea->TooltipValue = "";

            // OldTreesNo
            $this->OldTreesNo->HrefValue = "";
            $this->OldTreesNo->TooltipValue = "";

            // InspectionReport
            $this->InspectionReport->HrefValue = "";
            $this->InspectionReport->TooltipValue = "";

            // InspectionDate
            $this->InspectionDate->HrefValue = "";
            $this->InspectionDate->TooltipValue = "";

            // InspectedBy
            $this->InspectedBy->HrefValue = "";
            $this->InspectedBy->TooltipValue = "";

            // AuthorisedBy
            $this->AuthorisedBy->HrefValue = "";
            $this->AuthorisedBy->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // ProvinceCode
            $this->ProvinceCode->setupEditAttributes();
            $curVal = trim(strval($this->ProvinceCode->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->ProvinceCode->AdvancedSearch->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
            } else {
                $this->ProvinceCode->AdvancedSearch->ViewValue = $this->ProvinceCode->Lookup !== null && is_array($this->ProvinceCode->lookupOptions()) && count($this->ProvinceCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ProvinceCode->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->ProvinceCode->EditValue = array_values($this->ProvinceCode->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $this->ProvinceCode->AdvancedSearch->SearchValue, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->ProvinceCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ProvinceCode->EditValue = $arwrk;
            }
            $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());

            // DistrictCode
            $this->DistrictCode->setupEditAttributes();
            $curVal = trim(strval($this->DistrictCode->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->DistrictCode->AdvancedSearch->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
            } else {
                $this->DistrictCode->AdvancedSearch->ViewValue = $this->DistrictCode->Lookup !== null && is_array($this->DistrictCode->lookupOptions()) && count($this->DistrictCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->DistrictCode->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->DistrictCode->EditValue = array_values($this->DistrictCode->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->DistrictCode->AdvancedSearch->SearchValue, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->DistrictCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->DistrictCode->EditValue = $arwrk;
            }
            $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());

            // CampCode
            $this->CampCode->setupEditAttributes();
            $curVal = trim(strval($this->CampCode->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->CampCode->AdvancedSearch->ViewValue = $this->CampCode->lookupCacheOption($curVal);
            } else {
                $this->CampCode->AdvancedSearch->ViewValue = $this->CampCode->Lookup !== null && is_array($this->CampCode->lookupOptions()) && count($this->CampCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->CampCode->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->CampCode->EditValue = array_values($this->CampCode->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $this->CampCode->AdvancedSearch->SearchValue, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->CampCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->CampCode->EditValue = $arwrk;
            }
            $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());

            // VillageCode
            $this->VillageCode->setupEditAttributes();
            $curVal = trim(strval($this->VillageCode->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->VillageCode->AdvancedSearch->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
            } else {
                $this->VillageCode->AdvancedSearch->ViewValue = $this->VillageCode->Lookup !== null && is_array($this->VillageCode->lookupOptions()) && count($this->VillageCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->VillageCode->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->VillageCode->EditValue = array_values($this->VillageCode->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $this->VillageCode->AdvancedSearch->SearchValue, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->VillageCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->VillageCode->EditValue = $arwrk;
            }
            $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());

            // NRC
            $this->NRC->setupEditAttributes();
            $curVal = trim(strval($this->NRC->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->NRC->AdvancedSearch->ViewValue = $this->NRC->lookupCacheOption($curVal);
            } else {
                $this->NRC->AdvancedSearch->ViewValue = $this->NRC->Lookup !== null && is_array($this->NRC->lookupOptions()) && count($this->NRC->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->NRC->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->NRC->EditValue = array_values($this->NRC->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $this->NRC->AdvancedSearch->SearchValue, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                }
                $sqlWrk = $this->NRC->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->NRC->EditValue = $arwrk;
            }
            $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

            // FarmerNo
            $this->FarmerNo->setupEditAttributes();
            $this->FarmerNo->EditValue = $this->FarmerNo->AdvancedSearch->SearchValue;
            $this->FarmerNo->PlaceHolder = RemoveHtml($this->FarmerNo->caption());

            // FarmNo
            $this->FarmNo->setupEditAttributes();
            $this->FarmNo->EditValue = $this->FarmNo->AdvancedSearch->SearchValue;
            $this->FarmNo->PlaceHolder = RemoveHtml($this->FarmNo->caption());

            // InspectionTransNo
            $this->InspectionTransNo->setupEditAttributes();
            $this->InspectionTransNo->EditValue = $this->InspectionTransNo->AdvancedSearch->SearchValue;
            $this->InspectionTransNo->PlaceHolder = RemoveHtml($this->InspectionTransNo->caption());

            // PlantsDead
            $this->PlantsDead->setupEditAttributes();
            $this->PlantsDead->EditValue = $this->PlantsDead->AdvancedSearch->SearchValue;
            $this->PlantsDead->PlaceHolder = RemoveHtml($this->PlantsDead->caption());

            // PlantsVerifiedNo
            $this->PlantsVerifiedNo->setupEditAttributes();
            $this->PlantsVerifiedNo->EditValue = $this->PlantsVerifiedNo->AdvancedSearch->SearchValue;
            $this->PlantsVerifiedNo->PlaceHolder = RemoveHtml($this->PlantsVerifiedNo->caption());

            // PlantsReplaced
            $this->PlantsReplaced->setupEditAttributes();
            $this->PlantsReplaced->EditValue = $this->PlantsReplaced->AdvancedSearch->SearchValue;
            $this->PlantsReplaced->PlaceHolder = RemoveHtml($this->PlantsReplaced->caption());

            // FungicidesReceived
            $this->FungicidesReceived->setupEditAttributes();
            $this->FungicidesReceived->EditValue = $this->FungicidesReceived->AdvancedSearch->SearchValue;
            $this->FungicidesReceived->PlaceHolder = RemoveHtml($this->FungicidesReceived->caption());

            // PescticidesReceived
            $this->PescticidesReceived->setupEditAttributes();
            $this->PescticidesReceived->EditValue = $this->PescticidesReceived->AdvancedSearch->SearchValue;
            $this->PescticidesReceived->PlaceHolder = RemoveHtml($this->PescticidesReceived->caption());

            // DiseasePresence
            $curVal = trim(strval($this->DiseasePresence->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->DiseasePresence->AdvancedSearch->ViewValue = $this->DiseasePresence->lookupCacheOption($curVal);
            } else {
                $this->DiseasePresence->AdvancedSearch->ViewValue = $this->DiseasePresence->Lookup !== null && is_array($this->DiseasePresence->lookupOptions()) && count($this->DiseasePresence->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->DiseasePresence->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->DiseasePresence->EditValue = array_values($this->DiseasePresence->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->DiseasePresence->Lookup->getTable()->Fields["DiseasePresence"]->searchExpression(), "=", trim($wrk), $this->DiseasePresence->Lookup->getTable()->Fields["DiseasePresence"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->DiseasePresence->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->DiseasePresence->EditValue = $arwrk;
            }
            $this->DiseasePresence->PlaceHolder = RemoveHtml($this->DiseasePresence->caption());

            // AvailableLand
            $this->AvailableLand->setupEditAttributes();
            $this->AvailableLand->EditValue = $this->AvailableLand->AdvancedSearch->SearchValue;
            $this->AvailableLand->PlaceHolder = RemoveHtml($this->AvailableLand->caption());

            // LandForCashewCleared
            $this->LandForCashewCleared->setupEditAttributes();
            $this->LandForCashewCleared->EditValue = $this->LandForCashewCleared->AdvancedSearch->SearchValue;
            $this->LandForCashewCleared->PlaceHolder = RemoveHtml($this->LandForCashewCleared->caption());

            // HolesDug
            $this->HolesDug->setupEditAttributes();
            $this->HolesDug->EditValue = $this->HolesDug->AdvancedSearch->SearchValue;
            $this->HolesDug->PlaceHolder = RemoveHtml($this->HolesDug->caption());

            // VerifiedSeedlingArea
            $this->VerifiedSeedlingArea->setupEditAttributes();
            $this->VerifiedSeedlingArea->EditValue = $this->VerifiedSeedlingArea->AdvancedSearch->SearchValue;
            $this->VerifiedSeedlingArea->PlaceHolder = RemoveHtml($this->VerifiedSeedlingArea->caption());

            // OldTreesNo
            $this->OldTreesNo->setupEditAttributes();
            $this->OldTreesNo->EditValue = $this->OldTreesNo->AdvancedSearch->SearchValue;
            $this->OldTreesNo->PlaceHolder = RemoveHtml($this->OldTreesNo->caption());

            // InspectionReport
            $this->InspectionReport->setupEditAttributes();
            $this->InspectionReport->EditValue = HtmlEncode($this->InspectionReport->AdvancedSearch->SearchValue);
            $this->InspectionReport->PlaceHolder = RemoveHtml($this->InspectionReport->caption());

            // InspectionDate
            $this->InspectionDate->setupEditAttributes();
            $this->InspectionDate->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->InspectionDate->AdvancedSearch->SearchValue, $this->InspectionDate->formatPattern()), $this->InspectionDate->formatPattern()));
            $this->InspectionDate->PlaceHolder = RemoveHtml($this->InspectionDate->caption());

            // InspectedBy
            $this->InspectedBy->setupEditAttributes();
            if (!$this->InspectedBy->Raw) {
                $this->InspectedBy->AdvancedSearch->SearchValue = HtmlDecode($this->InspectedBy->AdvancedSearch->SearchValue);
            }
            $this->InspectedBy->EditValue = HtmlEncode($this->InspectedBy->AdvancedSearch->SearchValue);
            $this->InspectedBy->PlaceHolder = RemoveHtml($this->InspectedBy->caption());

            // AuthorisedBy
            $this->AuthorisedBy->setupEditAttributes();
            if (!$this->AuthorisedBy->Raw) {
                $this->AuthorisedBy->AdvancedSearch->SearchValue = HtmlDecode($this->AuthorisedBy->AdvancedSearch->SearchValue);
            }
            $this->AuthorisedBy->EditValue = HtmlEncode($this->AuthorisedBy->AdvancedSearch->SearchValue);
            $this->AuthorisedBy->PlaceHolder = RemoveHtml($this->AuthorisedBy->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->FarmerNo->AdvancedSearch->SearchValue)) {
            $this->FarmerNo->addErrorMessage($this->FarmerNo->getErrorMessage(false));
        }
        if (!CheckInteger($this->FarmNo->AdvancedSearch->SearchValue)) {
            $this->FarmNo->addErrorMessage($this->FarmNo->getErrorMessage(false));
        }
        if (!CheckInteger($this->InspectionTransNo->AdvancedSearch->SearchValue)) {
            $this->InspectionTransNo->addErrorMessage($this->InspectionTransNo->getErrorMessage(false));
        }
        if (!CheckInteger($this->PlantsDead->AdvancedSearch->SearchValue)) {
            $this->PlantsDead->addErrorMessage($this->PlantsDead->getErrorMessage(false));
        }
        if (!CheckInteger($this->PlantsVerifiedNo->AdvancedSearch->SearchValue)) {
            $this->PlantsVerifiedNo->addErrorMessage($this->PlantsVerifiedNo->getErrorMessage(false));
        }
        if (!CheckInteger($this->PlantsReplaced->AdvancedSearch->SearchValue)) {
            $this->PlantsReplaced->addErrorMessage($this->PlantsReplaced->getErrorMessage(false));
        }
        if (!CheckNumber($this->FungicidesReceived->AdvancedSearch->SearchValue)) {
            $this->FungicidesReceived->addErrorMessage($this->FungicidesReceived->getErrorMessage(false));
        }
        if (!CheckNumber($this->PescticidesReceived->AdvancedSearch->SearchValue)) {
            $this->PescticidesReceived->addErrorMessage($this->PescticidesReceived->getErrorMessage(false));
        }
        if (!CheckNumber($this->AvailableLand->AdvancedSearch->SearchValue)) {
            $this->AvailableLand->addErrorMessage($this->AvailableLand->getErrorMessage(false));
        }
        if (!CheckNumber($this->LandForCashewCleared->AdvancedSearch->SearchValue)) {
            $this->LandForCashewCleared->addErrorMessage($this->LandForCashewCleared->getErrorMessage(false));
        }
        if (!CheckInteger($this->HolesDug->AdvancedSearch->SearchValue)) {
            $this->HolesDug->addErrorMessage($this->HolesDug->getErrorMessage(false));
        }
        if (!CheckNumber($this->VerifiedSeedlingArea->AdvancedSearch->SearchValue)) {
            $this->VerifiedSeedlingArea->addErrorMessage($this->VerifiedSeedlingArea->getErrorMessage(false));
        }
        if (!CheckInteger($this->OldTreesNo->AdvancedSearch->SearchValue)) {
            $this->OldTreesNo->addErrorMessage($this->OldTreesNo->getErrorMessage(false));
        }
        if (!CheckDate($this->InspectionDate->AdvancedSearch->SearchValue, $this->InspectionDate->formatPattern())) {
            $this->InspectionDate->addErrorMessage($this->InspectionDate->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->ProvinceCode->AdvancedSearch->load();
        $this->DistrictCode->AdvancedSearch->load();
        $this->CampCode->AdvancedSearch->load();
        $this->VillageCode->AdvancedSearch->load();
        $this->NRC->AdvancedSearch->load();
        $this->FarmerNo->AdvancedSearch->load();
        $this->FarmNo->AdvancedSearch->load();
        $this->InspectionTransNo->AdvancedSearch->load();
        $this->PlantsDead->AdvancedSearch->load();
        $this->PlantsVerifiedNo->AdvancedSearch->load();
        $this->PlantsReplaced->AdvancedSearch->load();
        $this->FungicidesReceived->AdvancedSearch->load();
        $this->PescticidesReceived->AdvancedSearch->load();
        $this->DiseasePresence->AdvancedSearch->load();
        $this->AvailableLand->AdvancedSearch->load();
        $this->LandForCashewCleared->AdvancedSearch->load();
        $this->HolesDug->AdvancedSearch->load();
        $this->VerifiedSeedlingArea->AdvancedSearch->load();
        $this->OldTreesNo->AdvancedSearch->load();
        $this->InspectionReport->AdvancedSearch->load();
        $this->InspectionDate->AdvancedSearch->load();
        $this->InspectedBy->AdvancedSearch->load();
        $this->AuthorisedBy->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("FarmInspectionList"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ProvinceCode":
                    break;
                case "x_DistrictCode":
                    break;
                case "x_CampCode":
                    break;
                case "x_VillageCode":
                    break;
                case "x_NRC":
                    break;
                case "x_DiseasePresence":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
