<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class FarmInspectionAdd extends FarmInspection
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "FarmInspectionAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "FarmInspectionAdd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ProvinceCode->setVisibility();
        $this->DistrictCode->setVisibility();
        $this->CampCode->setVisibility();
        $this->VillageCode->setVisibility();
        $this->NRC->setVisibility();
        $this->FarmerNo->setVisibility();
        $this->FarmNo->setVisibility();
        $this->InspectionTransNo->Visible = false;
        $this->PlantsDead->setVisibility();
        $this->PlantsVerifiedNo->setVisibility();
        $this->PlantsReplaced->setVisibility();
        $this->FungicidesReceived->setVisibility();
        $this->PescticidesReceived->setVisibility();
        $this->DiseasePresence->setVisibility();
        $this->AvailableLand->setVisibility();
        $this->LandForCashewCleared->setVisibility();
        $this->HolesDug->setVisibility();
        $this->VerifiedSeedlingArea->setVisibility();
        $this->OldTreesNo->setVisibility();
        $this->InspectionReport->setVisibility();
        $this->InspectionDate->setVisibility();
        $this->InspectedBy->setVisibility();
        $this->AuthorisedBy->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'farm_inspection';
        $this->TableName = 'farm_inspection';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (farm_inspection)
        if (!isset($GLOBALS["farm_inspection"]) || $GLOBALS["farm_inspection"]::class == PROJECT_NAMESPACE . "farm_inspection") {
            $GLOBALS["farm_inspection"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'farm_inspection');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "FarmInspectionView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['InspectionTransNo'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->InspectionTransNo->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->ProvinceCode);
        $this->setupLookupOptions($this->DistrictCode);
        $this->setupLookupOptions($this->CampCode);
        $this->setupLookupOptions($this->VillageCode);
        $this->setupLookupOptions($this->NRC);
        $this->setupLookupOptions($this->DiseasePresence);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("InspectionTransNo") ?? Route("InspectionTransNo")) !== null) {
                $this->InspectionTransNo->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Set up master/detail parameters
        // NOTE: Must be after loadOldRecord to prevent master key values being overwritten
        $this->setupMasterParms();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("FarmInspectionList"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "FarmInspectionList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "FarmInspectionView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "FarmInspectionList") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "FarmInspectionList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->ProvinceCode->DefaultValue = $this->ProvinceCode->getDefault(); // PHP
        $this->ProvinceCode->OldValue = $this->ProvinceCode->DefaultValue;
        $this->DistrictCode->DefaultValue = $this->DistrictCode->getDefault(); // PHP
        $this->DistrictCode->OldValue = $this->DistrictCode->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'ProvinceCode' first before field var 'x_ProvinceCode'
        $val = $CurrentForm->hasValue("ProvinceCode") ? $CurrentForm->getValue("ProvinceCode") : $CurrentForm->getValue("x_ProvinceCode");
        if (!$this->ProvinceCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ProvinceCode->Visible = false; // Disable update for API request
            } else {
                $this->ProvinceCode->setFormValue($val);
            }
        }

        // Check field name 'DistrictCode' first before field var 'x_DistrictCode'
        $val = $CurrentForm->hasValue("DistrictCode") ? $CurrentForm->getValue("DistrictCode") : $CurrentForm->getValue("x_DistrictCode");
        if (!$this->DistrictCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DistrictCode->Visible = false; // Disable update for API request
            } else {
                $this->DistrictCode->setFormValue($val);
            }
        }

        // Check field name 'CampCode' first before field var 'x_CampCode'
        $val = $CurrentForm->hasValue("CampCode") ? $CurrentForm->getValue("CampCode") : $CurrentForm->getValue("x_CampCode");
        if (!$this->CampCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->CampCode->Visible = false; // Disable update for API request
            } else {
                $this->CampCode->setFormValue($val);
            }
        }

        // Check field name 'VillageCode' first before field var 'x_VillageCode'
        $val = $CurrentForm->hasValue("VillageCode") ? $CurrentForm->getValue("VillageCode") : $CurrentForm->getValue("x_VillageCode");
        if (!$this->VillageCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->VillageCode->Visible = false; // Disable update for API request
            } else {
                $this->VillageCode->setFormValue($val);
            }
        }

        // Check field name 'NRC' first before field var 'x_NRC'
        $val = $CurrentForm->hasValue("NRC") ? $CurrentForm->getValue("NRC") : $CurrentForm->getValue("x_NRC");
        if (!$this->NRC->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NRC->Visible = false; // Disable update for API request
            } else {
                $this->NRC->setFormValue($val);
            }
        }

        // Check field name 'FarmerNo' first before field var 'x_FarmerNo'
        $val = $CurrentForm->hasValue("FarmerNo") ? $CurrentForm->getValue("FarmerNo") : $CurrentForm->getValue("x_FarmerNo");
        if (!$this->FarmerNo->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmerNo->Visible = false; // Disable update for API request
            } else {
                $this->FarmerNo->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'FarmNo' first before field var 'x_FarmNo'
        $val = $CurrentForm->hasValue("FarmNo") ? $CurrentForm->getValue("FarmNo") : $CurrentForm->getValue("x_FarmNo");
        if (!$this->FarmNo->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmNo->Visible = false; // Disable update for API request
            } else {
                $this->FarmNo->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'PlantsDead' first before field var 'x_PlantsDead'
        $val = $CurrentForm->hasValue("PlantsDead") ? $CurrentForm->getValue("PlantsDead") : $CurrentForm->getValue("x_PlantsDead");
        if (!$this->PlantsDead->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->PlantsDead->Visible = false; // Disable update for API request
            } else {
                $this->PlantsDead->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'PlantsVerifiedNo' first before field var 'x_PlantsVerifiedNo'
        $val = $CurrentForm->hasValue("PlantsVerifiedNo") ? $CurrentForm->getValue("PlantsVerifiedNo") : $CurrentForm->getValue("x_PlantsVerifiedNo");
        if (!$this->PlantsVerifiedNo->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->PlantsVerifiedNo->Visible = false; // Disable update for API request
            } else {
                $this->PlantsVerifiedNo->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'PlantsReplaced' first before field var 'x_PlantsReplaced'
        $val = $CurrentForm->hasValue("PlantsReplaced") ? $CurrentForm->getValue("PlantsReplaced") : $CurrentForm->getValue("x_PlantsReplaced");
        if (!$this->PlantsReplaced->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->PlantsReplaced->Visible = false; // Disable update for API request
            } else {
                $this->PlantsReplaced->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'FungicidesReceived' first before field var 'x_FungicidesReceived'
        $val = $CurrentForm->hasValue("FungicidesReceived") ? $CurrentForm->getValue("FungicidesReceived") : $CurrentForm->getValue("x_FungicidesReceived");
        if (!$this->FungicidesReceived->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FungicidesReceived->Visible = false; // Disable update for API request
            } else {
                $this->FungicidesReceived->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'PescticidesReceived' first before field var 'x_PescticidesReceived'
        $val = $CurrentForm->hasValue("PescticidesReceived") ? $CurrentForm->getValue("PescticidesReceived") : $CurrentForm->getValue("x_PescticidesReceived");
        if (!$this->PescticidesReceived->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->PescticidesReceived->Visible = false; // Disable update for API request
            } else {
                $this->PescticidesReceived->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'DiseasePresence' first before field var 'x_DiseasePresence'
        $val = $CurrentForm->hasValue("DiseasePresence") ? $CurrentForm->getValue("DiseasePresence") : $CurrentForm->getValue("x_DiseasePresence");
        if (!$this->DiseasePresence->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DiseasePresence->Visible = false; // Disable update for API request
            } else {
                $this->DiseasePresence->setFormValue($val);
            }
        }

        // Check field name 'AvailableLand' first before field var 'x_AvailableLand'
        $val = $CurrentForm->hasValue("AvailableLand") ? $CurrentForm->getValue("AvailableLand") : $CurrentForm->getValue("x_AvailableLand");
        if (!$this->AvailableLand->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->AvailableLand->Visible = false; // Disable update for API request
            } else {
                $this->AvailableLand->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'LandForCashewCleared' first before field var 'x_LandForCashewCleared'
        $val = $CurrentForm->hasValue("LandForCashewCleared") ? $CurrentForm->getValue("LandForCashewCleared") : $CurrentForm->getValue("x_LandForCashewCleared");
        if (!$this->LandForCashewCleared->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->LandForCashewCleared->Visible = false; // Disable update for API request
            } else {
                $this->LandForCashewCleared->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'HolesDug' first before field var 'x_HolesDug'
        $val = $CurrentForm->hasValue("HolesDug") ? $CurrentForm->getValue("HolesDug") : $CurrentForm->getValue("x_HolesDug");
        if (!$this->HolesDug->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->HolesDug->Visible = false; // Disable update for API request
            } else {
                $this->HolesDug->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'VerifiedSeedlingArea' first before field var 'x_VerifiedSeedlingArea'
        $val = $CurrentForm->hasValue("VerifiedSeedlingArea") ? $CurrentForm->getValue("VerifiedSeedlingArea") : $CurrentForm->getValue("x_VerifiedSeedlingArea");
        if (!$this->VerifiedSeedlingArea->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->VerifiedSeedlingArea->Visible = false; // Disable update for API request
            } else {
                $this->VerifiedSeedlingArea->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'OldTreesNo' first before field var 'x_OldTreesNo'
        $val = $CurrentForm->hasValue("OldTreesNo") ? $CurrentForm->getValue("OldTreesNo") : $CurrentForm->getValue("x_OldTreesNo");
        if (!$this->OldTreesNo->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->OldTreesNo->Visible = false; // Disable update for API request
            } else {
                $this->OldTreesNo->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'InspectionReport' first before field var 'x_InspectionReport'
        $val = $CurrentForm->hasValue("InspectionReport") ? $CurrentForm->getValue("InspectionReport") : $CurrentForm->getValue("x_InspectionReport");
        if (!$this->InspectionReport->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->InspectionReport->Visible = false; // Disable update for API request
            } else {
                $this->InspectionReport->setFormValue($val);
            }
        }

        // Check field name 'InspectionDate' first before field var 'x_InspectionDate'
        $val = $CurrentForm->hasValue("InspectionDate") ? $CurrentForm->getValue("InspectionDate") : $CurrentForm->getValue("x_InspectionDate");
        if (!$this->InspectionDate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->InspectionDate->Visible = false; // Disable update for API request
            } else {
                $this->InspectionDate->setFormValue($val, true, $validate);
            }
            $this->InspectionDate->CurrentValue = UnFormatDateTime($this->InspectionDate->CurrentValue, $this->InspectionDate->formatPattern());
        }

        // Check field name 'InspectedBy' first before field var 'x_InspectedBy'
        $val = $CurrentForm->hasValue("InspectedBy") ? $CurrentForm->getValue("InspectedBy") : $CurrentForm->getValue("x_InspectedBy");
        if (!$this->InspectedBy->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->InspectedBy->Visible = false; // Disable update for API request
            } else {
                $this->InspectedBy->setFormValue($val);
            }
        }

        // Check field name 'AuthorisedBy' first before field var 'x_AuthorisedBy'
        $val = $CurrentForm->hasValue("AuthorisedBy") ? $CurrentForm->getValue("AuthorisedBy") : $CurrentForm->getValue("x_AuthorisedBy");
        if (!$this->AuthorisedBy->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->AuthorisedBy->Visible = false; // Disable update for API request
            } else {
                $this->AuthorisedBy->setFormValue($val);
            }
        }

        // Check field name 'InspectionTransNo' first before field var 'x_InspectionTransNo'
        $val = $CurrentForm->hasValue("InspectionTransNo") ? $CurrentForm->getValue("InspectionTransNo") : $CurrentForm->getValue("x_InspectionTransNo");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->ProvinceCode->CurrentValue = $this->ProvinceCode->FormValue;
        $this->DistrictCode->CurrentValue = $this->DistrictCode->FormValue;
        $this->CampCode->CurrentValue = $this->CampCode->FormValue;
        $this->VillageCode->CurrentValue = $this->VillageCode->FormValue;
        $this->NRC->CurrentValue = $this->NRC->FormValue;
        $this->FarmerNo->CurrentValue = $this->FarmerNo->FormValue;
        $this->FarmNo->CurrentValue = $this->FarmNo->FormValue;
        $this->PlantsDead->CurrentValue = $this->PlantsDead->FormValue;
        $this->PlantsVerifiedNo->CurrentValue = $this->PlantsVerifiedNo->FormValue;
        $this->PlantsReplaced->CurrentValue = $this->PlantsReplaced->FormValue;
        $this->FungicidesReceived->CurrentValue = $this->FungicidesReceived->FormValue;
        $this->PescticidesReceived->CurrentValue = $this->PescticidesReceived->FormValue;
        $this->DiseasePresence->CurrentValue = $this->DiseasePresence->FormValue;
        $this->AvailableLand->CurrentValue = $this->AvailableLand->FormValue;
        $this->LandForCashewCleared->CurrentValue = $this->LandForCashewCleared->FormValue;
        $this->HolesDug->CurrentValue = $this->HolesDug->FormValue;
        $this->VerifiedSeedlingArea->CurrentValue = $this->VerifiedSeedlingArea->FormValue;
        $this->OldTreesNo->CurrentValue = $this->OldTreesNo->FormValue;
        $this->InspectionReport->CurrentValue = $this->InspectionReport->FormValue;
        $this->InspectionDate->CurrentValue = $this->InspectionDate->FormValue;
        $this->InspectionDate->CurrentValue = UnFormatDateTime($this->InspectionDate->CurrentValue, $this->InspectionDate->formatPattern());
        $this->InspectedBy->CurrentValue = $this->InspectedBy->FormValue;
        $this->AuthorisedBy->CurrentValue = $this->AuthorisedBy->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->VillageCode->setDbValue($row['VillageCode']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmerNo->setDbValue($row['FarmerNo']);
        $this->FarmNo->setDbValue($row['FarmNo']);
        $this->InspectionTransNo->setDbValue($row['InspectionTransNo']);
        $this->PlantsDead->setDbValue($row['PlantsDead']);
        $this->PlantsVerifiedNo->setDbValue($row['PlantsVerifiedNo']);
        $this->PlantsReplaced->setDbValue($row['PlantsReplaced']);
        $this->FungicidesReceived->setDbValue($row['FungicidesReceived']);
        $this->PescticidesReceived->setDbValue($row['PescticidesReceived']);
        $this->DiseasePresence->setDbValue($row['DiseasePresence']);
        $this->AvailableLand->setDbValue($row['AvailableLand']);
        $this->LandForCashewCleared->setDbValue($row['LandForCashewCleared']);
        $this->HolesDug->setDbValue($row['HolesDug']);
        $this->VerifiedSeedlingArea->setDbValue($row['VerifiedSeedlingArea']);
        $this->OldTreesNo->setDbValue($row['OldTreesNo']);
        $this->InspectionReport->setDbValue($row['InspectionReport']);
        $this->InspectionDate->setDbValue($row['InspectionDate']);
        $this->InspectedBy->setDbValue($row['InspectedBy']);
        $this->AuthorisedBy->setDbValue($row['AuthorisedBy']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ProvinceCode'] = $this->ProvinceCode->DefaultValue;
        $row['DistrictCode'] = $this->DistrictCode->DefaultValue;
        $row['CampCode'] = $this->CampCode->DefaultValue;
        $row['VillageCode'] = $this->VillageCode->DefaultValue;
        $row['NRC'] = $this->NRC->DefaultValue;
        $row['FarmerNo'] = $this->FarmerNo->DefaultValue;
        $row['FarmNo'] = $this->FarmNo->DefaultValue;
        $row['InspectionTransNo'] = $this->InspectionTransNo->DefaultValue;
        $row['PlantsDead'] = $this->PlantsDead->DefaultValue;
        $row['PlantsVerifiedNo'] = $this->PlantsVerifiedNo->DefaultValue;
        $row['PlantsReplaced'] = $this->PlantsReplaced->DefaultValue;
        $row['FungicidesReceived'] = $this->FungicidesReceived->DefaultValue;
        $row['PescticidesReceived'] = $this->PescticidesReceived->DefaultValue;
        $row['DiseasePresence'] = $this->DiseasePresence->DefaultValue;
        $row['AvailableLand'] = $this->AvailableLand->DefaultValue;
        $row['LandForCashewCleared'] = $this->LandForCashewCleared->DefaultValue;
        $row['HolesDug'] = $this->HolesDug->DefaultValue;
        $row['VerifiedSeedlingArea'] = $this->VerifiedSeedlingArea->DefaultValue;
        $row['OldTreesNo'] = $this->OldTreesNo->DefaultValue;
        $row['InspectionReport'] = $this->InspectionReport->DefaultValue;
        $row['InspectionDate'] = $this->InspectionDate->DefaultValue;
        $row['InspectedBy'] = $this->InspectedBy->DefaultValue;
        $row['AuthorisedBy'] = $this->AuthorisedBy->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProvinceCode
        $this->ProvinceCode->RowCssClass = "row";

        // DistrictCode
        $this->DistrictCode->RowCssClass = "row";

        // CampCode
        $this->CampCode->RowCssClass = "row";

        // VillageCode
        $this->VillageCode->RowCssClass = "row";

        // NRC
        $this->NRC->RowCssClass = "row";

        // FarmerNo
        $this->FarmerNo->RowCssClass = "row";

        // FarmNo
        $this->FarmNo->RowCssClass = "row";

        // InspectionTransNo
        $this->InspectionTransNo->RowCssClass = "row";

        // PlantsDead
        $this->PlantsDead->RowCssClass = "row";

        // PlantsVerifiedNo
        $this->PlantsVerifiedNo->RowCssClass = "row";

        // PlantsReplaced
        $this->PlantsReplaced->RowCssClass = "row";

        // FungicidesReceived
        $this->FungicidesReceived->RowCssClass = "row";

        // PescticidesReceived
        $this->PescticidesReceived->RowCssClass = "row";

        // DiseasePresence
        $this->DiseasePresence->RowCssClass = "row";

        // AvailableLand
        $this->AvailableLand->RowCssClass = "row";

        // LandForCashewCleared
        $this->LandForCashewCleared->RowCssClass = "row";

        // HolesDug
        $this->HolesDug->RowCssClass = "row";

        // VerifiedSeedlingArea
        $this->VerifiedSeedlingArea->RowCssClass = "row";

        // OldTreesNo
        $this->OldTreesNo->RowCssClass = "row";

        // InspectionReport
        $this->InspectionReport->RowCssClass = "row";

        // InspectionDate
        $this->InspectionDate->RowCssClass = "row";

        // InspectedBy
        $this->InspectedBy->RowCssClass = "row";

        // AuthorisedBy
        $this->AuthorisedBy->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProvinceCode
            $curVal = strval($this->ProvinceCode->CurrentValue);
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                    } else {
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                    }
                }
            } else {
                $this->ProvinceCode->ViewValue = null;
            }

            // DistrictCode
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }

            // CampCode
            $curVal = strval($this->CampCode->CurrentValue);
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                if ($this->CampCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                    }
                }
            } else {
                $this->CampCode->ViewValue = null;
            }

            // VillageCode
            $curVal = strval($this->VillageCode->CurrentValue);
            if ($curVal != "") {
                $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                if ($this->VillageCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                    }
                }
            } else {
                $this->VillageCode->ViewValue = null;
            }

            // NRC
            $curVal = strval($this->NRC->CurrentValue);
            if ($curVal != "") {
                $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->ViewValue = $this->NRC->CurrentValue;
                    }
                }
            } else {
                $this->NRC->ViewValue = null;
            }

            // FarmerNo
            $this->FarmerNo->ViewValue = $this->FarmerNo->CurrentValue;

            // FarmNo
            $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;

            // InspectionTransNo
            $this->InspectionTransNo->ViewValue = $this->InspectionTransNo->CurrentValue;

            // PlantsDead
            $this->PlantsDead->ViewValue = $this->PlantsDead->CurrentValue;
            $this->PlantsDead->ViewValue = FormatNumber($this->PlantsDead->ViewValue, $this->PlantsDead->formatPattern());

            // PlantsVerifiedNo
            $this->PlantsVerifiedNo->ViewValue = $this->PlantsVerifiedNo->CurrentValue;
            $this->PlantsVerifiedNo->ViewValue = FormatNumber($this->PlantsVerifiedNo->ViewValue, $this->PlantsVerifiedNo->formatPattern());

            // PlantsReplaced
            $this->PlantsReplaced->ViewValue = $this->PlantsReplaced->CurrentValue;
            $this->PlantsReplaced->ViewValue = FormatNumber($this->PlantsReplaced->ViewValue, $this->PlantsReplaced->formatPattern());

            // FungicidesReceived
            $this->FungicidesReceived->ViewValue = $this->FungicidesReceived->CurrentValue;
            $this->FungicidesReceived->ViewValue = FormatNumber($this->FungicidesReceived->ViewValue, $this->FungicidesReceived->formatPattern());

            // PescticidesReceived
            $this->PescticidesReceived->ViewValue = $this->PescticidesReceived->CurrentValue;
            $this->PescticidesReceived->ViewValue = FormatNumber($this->PescticidesReceived->ViewValue, $this->PescticidesReceived->formatPattern());

            // DiseasePresence
            $curVal = strval($this->DiseasePresence->CurrentValue);
            if ($curVal != "") {
                $this->DiseasePresence->ViewValue = $this->DiseasePresence->lookupCacheOption($curVal);
                if ($this->DiseasePresence->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->DiseasePresence->Lookup->getTable()->Fields["DiseasePresence"]->searchExpression(), "=", trim($wrk), $this->DiseasePresence->Lookup->getTable()->Fields["DiseasePresence"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->DiseasePresence->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->DiseasePresence->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->DiseasePresence->Lookup->renderViewRow($row);
                            $this->DiseasePresence->ViewValue->add($this->DiseasePresence->displayValue($arwrk));
                        }
                    } else {
                        $this->DiseasePresence->ViewValue = $this->DiseasePresence->CurrentValue;
                    }
                }
            } else {
                $this->DiseasePresence->ViewValue = null;
            }

            // AvailableLand
            $this->AvailableLand->ViewValue = $this->AvailableLand->CurrentValue;
            $this->AvailableLand->ViewValue = FormatNumber($this->AvailableLand->ViewValue, $this->AvailableLand->formatPattern());

            // LandForCashewCleared
            $this->LandForCashewCleared->ViewValue = $this->LandForCashewCleared->CurrentValue;
            $this->LandForCashewCleared->ViewValue = FormatNumber($this->LandForCashewCleared->ViewValue, $this->LandForCashewCleared->formatPattern());

            // HolesDug
            $this->HolesDug->ViewValue = $this->HolesDug->CurrentValue;

            // VerifiedSeedlingArea
            $this->VerifiedSeedlingArea->ViewValue = $this->VerifiedSeedlingArea->CurrentValue;
            $this->VerifiedSeedlingArea->ViewValue = FormatNumber($this->VerifiedSeedlingArea->ViewValue, $this->VerifiedSeedlingArea->formatPattern());

            // OldTreesNo
            $this->OldTreesNo->ViewValue = $this->OldTreesNo->CurrentValue;
            $this->OldTreesNo->ViewValue = FormatNumber($this->OldTreesNo->ViewValue, $this->OldTreesNo->formatPattern());

            // InspectionReport
            $this->InspectionReport->ViewValue = $this->InspectionReport->CurrentValue;

            // InspectionDate
            $this->InspectionDate->ViewValue = $this->InspectionDate->CurrentValue;
            $this->InspectionDate->ViewValue = FormatDateTime($this->InspectionDate->ViewValue, $this->InspectionDate->formatPattern());

            // InspectedBy
            $this->InspectedBy->ViewValue = $this->InspectedBy->CurrentValue;

            // AuthorisedBy
            $this->AuthorisedBy->ViewValue = $this->AuthorisedBy->CurrentValue;

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FarmerNo
            $this->FarmerNo->HrefValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";

            // PlantsDead
            $this->PlantsDead->HrefValue = "";

            // PlantsVerifiedNo
            $this->PlantsVerifiedNo->HrefValue = "";

            // PlantsReplaced
            $this->PlantsReplaced->HrefValue = "";

            // FungicidesReceived
            $this->FungicidesReceived->HrefValue = "";

            // PescticidesReceived
            $this->PescticidesReceived->HrefValue = "";

            // DiseasePresence
            $this->DiseasePresence->HrefValue = "";

            // AvailableLand
            $this->AvailableLand->HrefValue = "";

            // LandForCashewCleared
            $this->LandForCashewCleared->HrefValue = "";

            // HolesDug
            $this->HolesDug->HrefValue = "";

            // VerifiedSeedlingArea
            $this->VerifiedSeedlingArea->HrefValue = "";

            // OldTreesNo
            $this->OldTreesNo->HrefValue = "";

            // InspectionReport
            $this->InspectionReport->HrefValue = "";

            // InspectionDate
            $this->InspectionDate->HrefValue = "";

            // InspectedBy
            $this->InspectedBy->HrefValue = "";

            // AuthorisedBy
            $this->AuthorisedBy->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // ProvinceCode
            $this->ProvinceCode->setupEditAttributes();
            if ($this->ProvinceCode->getSessionValue() != "") {
                $this->ProvinceCode->CurrentValue = GetForeignKeyValue($this->ProvinceCode->getSessionValue());
                $curVal = strval($this->ProvinceCode->CurrentValue);
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                    if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                        $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                        } else {
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                        }
                    }
                } else {
                    $this->ProvinceCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->ProvinceCode->CurrentValue));
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                } else {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->Lookup !== null && is_array($this->ProvinceCode->lookupOptions()) && count($this->ProvinceCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->ProvinceCode->ViewValue !== null) { // Load from cache
                    $this->ProvinceCode->EditValue = array_values($this->ProvinceCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $this->ProvinceCode->CurrentValue, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->ProvinceCode->EditValue = $arwrk;
                }
                $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
            }

            // DistrictCode
            $this->DistrictCode->setupEditAttributes();
            if ($this->DistrictCode->getSessionValue() != "") {
                $this->DistrictCode->CurrentValue = GetForeignKeyValue($this->DistrictCode->getSessionValue());
                $curVal = strval($this->DistrictCode->CurrentValue);
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                    if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                        $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                            $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                        } else {
                            $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                        }
                    }
                } else {
                    $this->DistrictCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->DistrictCode->CurrentValue));
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                } else {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->Lookup !== null && is_array($this->DistrictCode->lookupOptions()) && count($this->DistrictCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->DistrictCode->ViewValue !== null) { // Load from cache
                    $this->DistrictCode->EditValue = array_values($this->DistrictCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->DistrictCode->CurrentValue, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->DistrictCode->EditValue = $arwrk;
                }
                $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
            }

            // CampCode
            $this->CampCode->setupEditAttributes();
            if ($this->CampCode->getSessionValue() != "") {
                $this->CampCode->CurrentValue = GetForeignKeyValue($this->CampCode->getSessionValue());
                $curVal = strval($this->CampCode->CurrentValue);
                if ($curVal != "") {
                    $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                    if ($this->CampCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                        $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                            $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                        } else {
                            $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                        }
                    }
                } else {
                    $this->CampCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->CampCode->CurrentValue));
                if ($curVal != "") {
                    $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                } else {
                    $this->CampCode->ViewValue = $this->CampCode->Lookup !== null && is_array($this->CampCode->lookupOptions()) && count($this->CampCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->CampCode->ViewValue !== null) { // Load from cache
                    $this->CampCode->EditValue = array_values($this->CampCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $this->CampCode->CurrentValue, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->CampCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->CampCode->EditValue = $arwrk;
                }
                $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());
            }

            // VillageCode
            $this->VillageCode->setupEditAttributes();
            if ($this->VillageCode->getSessionValue() != "") {
                $this->VillageCode->CurrentValue = GetForeignKeyValue($this->VillageCode->getSessionValue());
                $curVal = strval($this->VillageCode->CurrentValue);
                if ($curVal != "") {
                    $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                    if ($this->VillageCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                        $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                            $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                        } else {
                            $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                        }
                    }
                } else {
                    $this->VillageCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->VillageCode->CurrentValue));
                if ($curVal != "") {
                    $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                } else {
                    $this->VillageCode->ViewValue = $this->VillageCode->Lookup !== null && is_array($this->VillageCode->lookupOptions()) && count($this->VillageCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->VillageCode->ViewValue !== null) { // Load from cache
                    $this->VillageCode->EditValue = array_values($this->VillageCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $this->VillageCode->CurrentValue, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->VillageCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->VillageCode->EditValue = $arwrk;
                }
                $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());
            }

            // NRC
            $this->NRC->setupEditAttributes();
            if ($this->NRC->getSessionValue() != "") {
                $this->NRC->CurrentValue = GetForeignKeyValue($this->NRC->getSessionValue());
                $curVal = strval($this->NRC->CurrentValue);
                if ($curVal != "") {
                    $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                    if ($this->NRC->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                        $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                            $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                        } else {
                            $this->NRC->ViewValue = $this->NRC->CurrentValue;
                        }
                    }
                } else {
                    $this->NRC->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->NRC->CurrentValue));
                if ($curVal != "") {
                    $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                } else {
                    $this->NRC->ViewValue = $this->NRC->Lookup !== null && is_array($this->NRC->lookupOptions()) && count($this->NRC->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->NRC->ViewValue !== null) { // Load from cache
                    $this->NRC->EditValue = array_values($this->NRC->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $this->NRC->CurrentValue, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->NRC->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->NRC->EditValue = $arwrk;
                }
                $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());
            }

            // FarmerNo
            $this->FarmerNo->setupEditAttributes();
            $this->FarmerNo->EditValue = $this->FarmerNo->CurrentValue;
            $this->FarmerNo->PlaceHolder = RemoveHtml($this->FarmerNo->caption());
            if (strval($this->FarmerNo->EditValue) != "" && is_numeric($this->FarmerNo->EditValue)) {
                $this->FarmerNo->EditValue = $this->FarmerNo->EditValue;
            }

            // FarmNo
            $this->FarmNo->setupEditAttributes();
            if ($this->FarmNo->getSessionValue() != "") {
                $this->FarmNo->CurrentValue = GetForeignKeyValue($this->FarmNo->getSessionValue());
                $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;
            } else {
                $this->FarmNo->EditValue = $this->FarmNo->CurrentValue;
                $this->FarmNo->PlaceHolder = RemoveHtml($this->FarmNo->caption());
                if (strval($this->FarmNo->EditValue) != "" && is_numeric($this->FarmNo->EditValue)) {
                    $this->FarmNo->EditValue = $this->FarmNo->EditValue;
                }
            }

            // PlantsDead
            $this->PlantsDead->setupEditAttributes();
            $this->PlantsDead->EditValue = $this->PlantsDead->CurrentValue;
            $this->PlantsDead->PlaceHolder = RemoveHtml($this->PlantsDead->caption());
            if (strval($this->PlantsDead->EditValue) != "" && is_numeric($this->PlantsDead->EditValue)) {
                $this->PlantsDead->EditValue = FormatNumber($this->PlantsDead->EditValue, null);
            }

            // PlantsVerifiedNo
            $this->PlantsVerifiedNo->setupEditAttributes();
            $this->PlantsVerifiedNo->EditValue = $this->PlantsVerifiedNo->CurrentValue;
            $this->PlantsVerifiedNo->PlaceHolder = RemoveHtml($this->PlantsVerifiedNo->caption());
            if (strval($this->PlantsVerifiedNo->EditValue) != "" && is_numeric($this->PlantsVerifiedNo->EditValue)) {
                $this->PlantsVerifiedNo->EditValue = FormatNumber($this->PlantsVerifiedNo->EditValue, null);
            }

            // PlantsReplaced
            $this->PlantsReplaced->setupEditAttributes();
            $this->PlantsReplaced->EditValue = $this->PlantsReplaced->CurrentValue;
            $this->PlantsReplaced->PlaceHolder = RemoveHtml($this->PlantsReplaced->caption());
            if (strval($this->PlantsReplaced->EditValue) != "" && is_numeric($this->PlantsReplaced->EditValue)) {
                $this->PlantsReplaced->EditValue = FormatNumber($this->PlantsReplaced->EditValue, null);
            }

            // FungicidesReceived
            $this->FungicidesReceived->setupEditAttributes();
            $this->FungicidesReceived->EditValue = $this->FungicidesReceived->CurrentValue;
            $this->FungicidesReceived->PlaceHolder = RemoveHtml($this->FungicidesReceived->caption());
            if (strval($this->FungicidesReceived->EditValue) != "" && is_numeric($this->FungicidesReceived->EditValue)) {
                $this->FungicidesReceived->EditValue = FormatNumber($this->FungicidesReceived->EditValue, null);
            }

            // PescticidesReceived
            $this->PescticidesReceived->setupEditAttributes();
            $this->PescticidesReceived->EditValue = $this->PescticidesReceived->CurrentValue;
            $this->PescticidesReceived->PlaceHolder = RemoveHtml($this->PescticidesReceived->caption());
            if (strval($this->PescticidesReceived->EditValue) != "" && is_numeric($this->PescticidesReceived->EditValue)) {
                $this->PescticidesReceived->EditValue = FormatNumber($this->PescticidesReceived->EditValue, null);
            }

            // DiseasePresence
            $curVal = trim(strval($this->DiseasePresence->CurrentValue));
            if ($curVal != "") {
                $this->DiseasePresence->ViewValue = $this->DiseasePresence->lookupCacheOption($curVal);
            } else {
                $this->DiseasePresence->ViewValue = $this->DiseasePresence->Lookup !== null && is_array($this->DiseasePresence->lookupOptions()) && count($this->DiseasePresence->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->DiseasePresence->ViewValue !== null) { // Load from cache
                $this->DiseasePresence->EditValue = array_values($this->DiseasePresence->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->DiseasePresence->Lookup->getTable()->Fields["DiseasePresence"]->searchExpression(), "=", trim($wrk), $this->DiseasePresence->Lookup->getTable()->Fields["DiseasePresence"]->searchDataType(), ""), "OR");
                    }
                }
                $sqlWrk = $this->DiseasePresence->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->DiseasePresence->EditValue = $arwrk;
            }
            $this->DiseasePresence->PlaceHolder = RemoveHtml($this->DiseasePresence->caption());

            // AvailableLand
            $this->AvailableLand->setupEditAttributes();
            $this->AvailableLand->EditValue = $this->AvailableLand->CurrentValue;
            $this->AvailableLand->PlaceHolder = RemoveHtml($this->AvailableLand->caption());
            if (strval($this->AvailableLand->EditValue) != "" && is_numeric($this->AvailableLand->EditValue)) {
                $this->AvailableLand->EditValue = FormatNumber($this->AvailableLand->EditValue, null);
            }

            // LandForCashewCleared
            $this->LandForCashewCleared->setupEditAttributes();
            $this->LandForCashewCleared->EditValue = $this->LandForCashewCleared->CurrentValue;
            $this->LandForCashewCleared->PlaceHolder = RemoveHtml($this->LandForCashewCleared->caption());
            if (strval($this->LandForCashewCleared->EditValue) != "" && is_numeric($this->LandForCashewCleared->EditValue)) {
                $this->LandForCashewCleared->EditValue = FormatNumber($this->LandForCashewCleared->EditValue, null);
            }

            // HolesDug
            $this->HolesDug->setupEditAttributes();
            $this->HolesDug->EditValue = $this->HolesDug->CurrentValue;
            $this->HolesDug->PlaceHolder = RemoveHtml($this->HolesDug->caption());
            if (strval($this->HolesDug->EditValue) != "" && is_numeric($this->HolesDug->EditValue)) {
                $this->HolesDug->EditValue = $this->HolesDug->EditValue;
            }

            // VerifiedSeedlingArea
            $this->VerifiedSeedlingArea->setupEditAttributes();
            $this->VerifiedSeedlingArea->EditValue = $this->VerifiedSeedlingArea->CurrentValue;
            $this->VerifiedSeedlingArea->PlaceHolder = RemoveHtml($this->VerifiedSeedlingArea->caption());
            if (strval($this->VerifiedSeedlingArea->EditValue) != "" && is_numeric($this->VerifiedSeedlingArea->EditValue)) {
                $this->VerifiedSeedlingArea->EditValue = FormatNumber($this->VerifiedSeedlingArea->EditValue, null);
            }

            // OldTreesNo
            $this->OldTreesNo->setupEditAttributes();
            $this->OldTreesNo->EditValue = $this->OldTreesNo->CurrentValue;
            $this->OldTreesNo->PlaceHolder = RemoveHtml($this->OldTreesNo->caption());
            if (strval($this->OldTreesNo->EditValue) != "" && is_numeric($this->OldTreesNo->EditValue)) {
                $this->OldTreesNo->EditValue = FormatNumber($this->OldTreesNo->EditValue, null);
            }

            // InspectionReport
            $this->InspectionReport->setupEditAttributes();
            $this->InspectionReport->EditValue = HtmlEncode($this->InspectionReport->CurrentValue);
            $this->InspectionReport->PlaceHolder = RemoveHtml($this->InspectionReport->caption());

            // InspectionDate
            $this->InspectionDate->setupEditAttributes();
            $this->InspectionDate->EditValue = HtmlEncode(FormatDateTime($this->InspectionDate->CurrentValue, $this->InspectionDate->formatPattern()));
            $this->InspectionDate->PlaceHolder = RemoveHtml($this->InspectionDate->caption());

            // InspectedBy
            $this->InspectedBy->setupEditAttributes();
            if (!$this->InspectedBy->Raw) {
                $this->InspectedBy->CurrentValue = HtmlDecode($this->InspectedBy->CurrentValue);
            }
            $this->InspectedBy->EditValue = HtmlEncode($this->InspectedBy->CurrentValue);
            $this->InspectedBy->PlaceHolder = RemoveHtml($this->InspectedBy->caption());

            // AuthorisedBy
            $this->AuthorisedBy->setupEditAttributes();
            if (!$this->AuthorisedBy->Raw) {
                $this->AuthorisedBy->CurrentValue = HtmlDecode($this->AuthorisedBy->CurrentValue);
            }
            $this->AuthorisedBy->EditValue = HtmlEncode($this->AuthorisedBy->CurrentValue);
            $this->AuthorisedBy->PlaceHolder = RemoveHtml($this->AuthorisedBy->caption());

            // Add refer script

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FarmerNo
            $this->FarmerNo->HrefValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";

            // PlantsDead
            $this->PlantsDead->HrefValue = "";

            // PlantsVerifiedNo
            $this->PlantsVerifiedNo->HrefValue = "";

            // PlantsReplaced
            $this->PlantsReplaced->HrefValue = "";

            // FungicidesReceived
            $this->FungicidesReceived->HrefValue = "";

            // PescticidesReceived
            $this->PescticidesReceived->HrefValue = "";

            // DiseasePresence
            $this->DiseasePresence->HrefValue = "";

            // AvailableLand
            $this->AvailableLand->HrefValue = "";

            // LandForCashewCleared
            $this->LandForCashewCleared->HrefValue = "";

            // HolesDug
            $this->HolesDug->HrefValue = "";

            // VerifiedSeedlingArea
            $this->VerifiedSeedlingArea->HrefValue = "";

            // OldTreesNo
            $this->OldTreesNo->HrefValue = "";

            // InspectionReport
            $this->InspectionReport->HrefValue = "";

            // InspectionDate
            $this->InspectionDate->HrefValue = "";

            // InspectedBy
            $this->InspectedBy->HrefValue = "";

            // AuthorisedBy
            $this->AuthorisedBy->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->ProvinceCode->Visible && $this->ProvinceCode->Required) {
                if (!$this->ProvinceCode->IsDetailKey && EmptyValue($this->ProvinceCode->FormValue)) {
                    $this->ProvinceCode->addErrorMessage(str_replace("%s", $this->ProvinceCode->caption(), $this->ProvinceCode->RequiredErrorMessage));
                }
            }
            if ($this->DistrictCode->Visible && $this->DistrictCode->Required) {
                if (!$this->DistrictCode->IsDetailKey && EmptyValue($this->DistrictCode->FormValue)) {
                    $this->DistrictCode->addErrorMessage(str_replace("%s", $this->DistrictCode->caption(), $this->DistrictCode->RequiredErrorMessage));
                }
            }
            if ($this->CampCode->Visible && $this->CampCode->Required) {
                if (!$this->CampCode->IsDetailKey && EmptyValue($this->CampCode->FormValue)) {
                    $this->CampCode->addErrorMessage(str_replace("%s", $this->CampCode->caption(), $this->CampCode->RequiredErrorMessage));
                }
            }
            if ($this->VillageCode->Visible && $this->VillageCode->Required) {
                if (!$this->VillageCode->IsDetailKey && EmptyValue($this->VillageCode->FormValue)) {
                    $this->VillageCode->addErrorMessage(str_replace("%s", $this->VillageCode->caption(), $this->VillageCode->RequiredErrorMessage));
                }
            }
            if ($this->NRC->Visible && $this->NRC->Required) {
                if (!$this->NRC->IsDetailKey && EmptyValue($this->NRC->FormValue)) {
                    $this->NRC->addErrorMessage(str_replace("%s", $this->NRC->caption(), $this->NRC->RequiredErrorMessage));
                }
            }
            if ($this->FarmerNo->Visible && $this->FarmerNo->Required) {
                if (!$this->FarmerNo->IsDetailKey && EmptyValue($this->FarmerNo->FormValue)) {
                    $this->FarmerNo->addErrorMessage(str_replace("%s", $this->FarmerNo->caption(), $this->FarmerNo->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->FarmerNo->FormValue)) {
                $this->FarmerNo->addErrorMessage($this->FarmerNo->getErrorMessage(false));
            }
            if ($this->FarmNo->Visible && $this->FarmNo->Required) {
                if (!$this->FarmNo->IsDetailKey && EmptyValue($this->FarmNo->FormValue)) {
                    $this->FarmNo->addErrorMessage(str_replace("%s", $this->FarmNo->caption(), $this->FarmNo->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->FarmNo->FormValue)) {
                $this->FarmNo->addErrorMessage($this->FarmNo->getErrorMessage(false));
            }
            if ($this->PlantsDead->Visible && $this->PlantsDead->Required) {
                if (!$this->PlantsDead->IsDetailKey && EmptyValue($this->PlantsDead->FormValue)) {
                    $this->PlantsDead->addErrorMessage(str_replace("%s", $this->PlantsDead->caption(), $this->PlantsDead->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->PlantsDead->FormValue)) {
                $this->PlantsDead->addErrorMessage($this->PlantsDead->getErrorMessage(false));
            }
            if ($this->PlantsVerifiedNo->Visible && $this->PlantsVerifiedNo->Required) {
                if (!$this->PlantsVerifiedNo->IsDetailKey && EmptyValue($this->PlantsVerifiedNo->FormValue)) {
                    $this->PlantsVerifiedNo->addErrorMessage(str_replace("%s", $this->PlantsVerifiedNo->caption(), $this->PlantsVerifiedNo->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->PlantsVerifiedNo->FormValue)) {
                $this->PlantsVerifiedNo->addErrorMessage($this->PlantsVerifiedNo->getErrorMessage(false));
            }
            if ($this->PlantsReplaced->Visible && $this->PlantsReplaced->Required) {
                if (!$this->PlantsReplaced->IsDetailKey && EmptyValue($this->PlantsReplaced->FormValue)) {
                    $this->PlantsReplaced->addErrorMessage(str_replace("%s", $this->PlantsReplaced->caption(), $this->PlantsReplaced->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->PlantsReplaced->FormValue)) {
                $this->PlantsReplaced->addErrorMessage($this->PlantsReplaced->getErrorMessage(false));
            }
            if ($this->FungicidesReceived->Visible && $this->FungicidesReceived->Required) {
                if (!$this->FungicidesReceived->IsDetailKey && EmptyValue($this->FungicidesReceived->FormValue)) {
                    $this->FungicidesReceived->addErrorMessage(str_replace("%s", $this->FungicidesReceived->caption(), $this->FungicidesReceived->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->FungicidesReceived->FormValue)) {
                $this->FungicidesReceived->addErrorMessage($this->FungicidesReceived->getErrorMessage(false));
            }
            if ($this->PescticidesReceived->Visible && $this->PescticidesReceived->Required) {
                if (!$this->PescticidesReceived->IsDetailKey && EmptyValue($this->PescticidesReceived->FormValue)) {
                    $this->PescticidesReceived->addErrorMessage(str_replace("%s", $this->PescticidesReceived->caption(), $this->PescticidesReceived->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->PescticidesReceived->FormValue)) {
                $this->PescticidesReceived->addErrorMessage($this->PescticidesReceived->getErrorMessage(false));
            }
            if ($this->DiseasePresence->Visible && $this->DiseasePresence->Required) {
                if ($this->DiseasePresence->FormValue == "") {
                    $this->DiseasePresence->addErrorMessage(str_replace("%s", $this->DiseasePresence->caption(), $this->DiseasePresence->RequiredErrorMessage));
                }
            }
            if ($this->AvailableLand->Visible && $this->AvailableLand->Required) {
                if (!$this->AvailableLand->IsDetailKey && EmptyValue($this->AvailableLand->FormValue)) {
                    $this->AvailableLand->addErrorMessage(str_replace("%s", $this->AvailableLand->caption(), $this->AvailableLand->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->AvailableLand->FormValue)) {
                $this->AvailableLand->addErrorMessage($this->AvailableLand->getErrorMessage(false));
            }
            if ($this->LandForCashewCleared->Visible && $this->LandForCashewCleared->Required) {
                if (!$this->LandForCashewCleared->IsDetailKey && EmptyValue($this->LandForCashewCleared->FormValue)) {
                    $this->LandForCashewCleared->addErrorMessage(str_replace("%s", $this->LandForCashewCleared->caption(), $this->LandForCashewCleared->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->LandForCashewCleared->FormValue)) {
                $this->LandForCashewCleared->addErrorMessage($this->LandForCashewCleared->getErrorMessage(false));
            }
            if ($this->HolesDug->Visible && $this->HolesDug->Required) {
                if (!$this->HolesDug->IsDetailKey && EmptyValue($this->HolesDug->FormValue)) {
                    $this->HolesDug->addErrorMessage(str_replace("%s", $this->HolesDug->caption(), $this->HolesDug->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->HolesDug->FormValue)) {
                $this->HolesDug->addErrorMessage($this->HolesDug->getErrorMessage(false));
            }
            if ($this->VerifiedSeedlingArea->Visible && $this->VerifiedSeedlingArea->Required) {
                if (!$this->VerifiedSeedlingArea->IsDetailKey && EmptyValue($this->VerifiedSeedlingArea->FormValue)) {
                    $this->VerifiedSeedlingArea->addErrorMessage(str_replace("%s", $this->VerifiedSeedlingArea->caption(), $this->VerifiedSeedlingArea->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->VerifiedSeedlingArea->FormValue)) {
                $this->VerifiedSeedlingArea->addErrorMessage($this->VerifiedSeedlingArea->getErrorMessage(false));
            }
            if ($this->OldTreesNo->Visible && $this->OldTreesNo->Required) {
                if (!$this->OldTreesNo->IsDetailKey && EmptyValue($this->OldTreesNo->FormValue)) {
                    $this->OldTreesNo->addErrorMessage(str_replace("%s", $this->OldTreesNo->caption(), $this->OldTreesNo->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->OldTreesNo->FormValue)) {
                $this->OldTreesNo->addErrorMessage($this->OldTreesNo->getErrorMessage(false));
            }
            if ($this->InspectionReport->Visible && $this->InspectionReport->Required) {
                if (!$this->InspectionReport->IsDetailKey && EmptyValue($this->InspectionReport->FormValue)) {
                    $this->InspectionReport->addErrorMessage(str_replace("%s", $this->InspectionReport->caption(), $this->InspectionReport->RequiredErrorMessage));
                }
            }
            if ($this->InspectionDate->Visible && $this->InspectionDate->Required) {
                if (!$this->InspectionDate->IsDetailKey && EmptyValue($this->InspectionDate->FormValue)) {
                    $this->InspectionDate->addErrorMessage(str_replace("%s", $this->InspectionDate->caption(), $this->InspectionDate->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->InspectionDate->FormValue, $this->InspectionDate->formatPattern())) {
                $this->InspectionDate->addErrorMessage($this->InspectionDate->getErrorMessage(false));
            }
            if ($this->InspectedBy->Visible && $this->InspectedBy->Required) {
                if (!$this->InspectedBy->IsDetailKey && EmptyValue($this->InspectedBy->FormValue)) {
                    $this->InspectedBy->addErrorMessage(str_replace("%s", $this->InspectedBy->caption(), $this->InspectedBy->RequiredErrorMessage));
                }
            }
            if ($this->AuthorisedBy->Visible && $this->AuthorisedBy->Required) {
                if (!$this->AuthorisedBy->IsDetailKey && EmptyValue($this->AuthorisedBy->FormValue)) {
                    $this->AuthorisedBy->addErrorMessage(str_replace("%s", $this->AuthorisedBy->caption(), $this->AuthorisedBy->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // ProvinceCode
        $this->ProvinceCode->setDbValueDef($rsnew, $this->ProvinceCode->CurrentValue, strval($this->ProvinceCode->CurrentValue) == "");

        // DistrictCode
        $this->DistrictCode->setDbValueDef($rsnew, $this->DistrictCode->CurrentValue, strval($this->DistrictCode->CurrentValue) == "");

        // CampCode
        $this->CampCode->setDbValueDef($rsnew, $this->CampCode->CurrentValue, false);

        // VillageCode
        $this->VillageCode->setDbValueDef($rsnew, $this->VillageCode->CurrentValue, false);

        // NRC
        $this->NRC->setDbValueDef($rsnew, $this->NRC->CurrentValue, false);

        // FarmerNo
        $this->FarmerNo->setDbValueDef($rsnew, $this->FarmerNo->CurrentValue, false);

        // FarmNo
        $this->FarmNo->setDbValueDef($rsnew, $this->FarmNo->CurrentValue, false);

        // PlantsDead
        $this->PlantsDead->setDbValueDef($rsnew, $this->PlantsDead->CurrentValue, false);

        // PlantsVerifiedNo
        $this->PlantsVerifiedNo->setDbValueDef($rsnew, $this->PlantsVerifiedNo->CurrentValue, false);

        // PlantsReplaced
        $this->PlantsReplaced->setDbValueDef($rsnew, $this->PlantsReplaced->CurrentValue, false);

        // FungicidesReceived
        $this->FungicidesReceived->setDbValueDef($rsnew, $this->FungicidesReceived->CurrentValue, false);

        // PescticidesReceived
        $this->PescticidesReceived->setDbValueDef($rsnew, $this->PescticidesReceived->CurrentValue, false);

        // DiseasePresence
        $this->DiseasePresence->setDbValueDef($rsnew, $this->DiseasePresence->CurrentValue, false);

        // AvailableLand
        $this->AvailableLand->setDbValueDef($rsnew, $this->AvailableLand->CurrentValue, false);

        // LandForCashewCleared
        $this->LandForCashewCleared->setDbValueDef($rsnew, $this->LandForCashewCleared->CurrentValue, false);

        // HolesDug
        $this->HolesDug->setDbValueDef($rsnew, $this->HolesDug->CurrentValue, false);

        // VerifiedSeedlingArea
        $this->VerifiedSeedlingArea->setDbValueDef($rsnew, $this->VerifiedSeedlingArea->CurrentValue, false);

        // OldTreesNo
        $this->OldTreesNo->setDbValueDef($rsnew, $this->OldTreesNo->CurrentValue, false);

        // InspectionReport
        $this->InspectionReport->setDbValueDef($rsnew, $this->InspectionReport->CurrentValue, false);

        // InspectionDate
        $this->InspectionDate->setDbValueDef($rsnew, UnFormatDateTime($this->InspectionDate->CurrentValue, $this->InspectionDate->formatPattern()), false);

        // InspectedBy
        $this->InspectedBy->setDbValueDef($rsnew, $this->InspectedBy->CurrentValue, false);

        // AuthorisedBy
        $this->AuthorisedBy->setDbValueDef($rsnew, $this->AuthorisedBy->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['ProvinceCode'])) { // ProvinceCode
            $this->ProvinceCode->setFormValue($row['ProvinceCode']);
        }
        if (isset($row['DistrictCode'])) { // DistrictCode
            $this->DistrictCode->setFormValue($row['DistrictCode']);
        }
        if (isset($row['CampCode'])) { // CampCode
            $this->CampCode->setFormValue($row['CampCode']);
        }
        if (isset($row['VillageCode'])) { // VillageCode
            $this->VillageCode->setFormValue($row['VillageCode']);
        }
        if (isset($row['NRC'])) { // NRC
            $this->NRC->setFormValue($row['NRC']);
        }
        if (isset($row['FarmerNo'])) { // FarmerNo
            $this->FarmerNo->setFormValue($row['FarmerNo']);
        }
        if (isset($row['FarmNo'])) { // FarmNo
            $this->FarmNo->setFormValue($row['FarmNo']);
        }
        if (isset($row['PlantsDead'])) { // PlantsDead
            $this->PlantsDead->setFormValue($row['PlantsDead']);
        }
        if (isset($row['PlantsVerifiedNo'])) { // PlantsVerifiedNo
            $this->PlantsVerifiedNo->setFormValue($row['PlantsVerifiedNo']);
        }
        if (isset($row['PlantsReplaced'])) { // PlantsReplaced
            $this->PlantsReplaced->setFormValue($row['PlantsReplaced']);
        }
        if (isset($row['FungicidesReceived'])) { // FungicidesReceived
            $this->FungicidesReceived->setFormValue($row['FungicidesReceived']);
        }
        if (isset($row['PescticidesReceived'])) { // PescticidesReceived
            $this->PescticidesReceived->setFormValue($row['PescticidesReceived']);
        }
        if (isset($row['DiseasePresence'])) { // DiseasePresence
            $this->DiseasePresence->setFormValue($row['DiseasePresence']);
        }
        if (isset($row['AvailableLand'])) { // AvailableLand
            $this->AvailableLand->setFormValue($row['AvailableLand']);
        }
        if (isset($row['LandForCashewCleared'])) { // LandForCashewCleared
            $this->LandForCashewCleared->setFormValue($row['LandForCashewCleared']);
        }
        if (isset($row['HolesDug'])) { // HolesDug
            $this->HolesDug->setFormValue($row['HolesDug']);
        }
        if (isset($row['VerifiedSeedlingArea'])) { // VerifiedSeedlingArea
            $this->VerifiedSeedlingArea->setFormValue($row['VerifiedSeedlingArea']);
        }
        if (isset($row['OldTreesNo'])) { // OldTreesNo
            $this->OldTreesNo->setFormValue($row['OldTreesNo']);
        }
        if (isset($row['InspectionReport'])) { // InspectionReport
            $this->InspectionReport->setFormValue($row['InspectionReport']);
        }
        if (isset($row['InspectionDate'])) { // InspectionDate
            $this->InspectionDate->setFormValue($row['InspectionDate']);
        }
        if (isset($row['InspectedBy'])) { // InspectedBy
            $this->InspectedBy->setFormValue($row['InspectedBy']);
        }
        if (isset($row['AuthorisedBy'])) { // AuthorisedBy
            $this->AuthorisedBy->setFormValue($row['AuthorisedBy']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "farm") {
                $validMaster = true;
                $masterTbl = Container("farm");
                if (($parm = Get("fk_ProvinceCode", Get("ProvinceCode"))) !== null) {
                    $masterTbl->ProvinceCode->setQueryStringValue($parm);
                    $this->ProvinceCode->QueryStringValue = $masterTbl->ProvinceCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->ProvinceCode->setSessionValue($this->ProvinceCode->QueryStringValue);
                    $foreignKeys["ProvinceCode"] = $this->ProvinceCode->QueryStringValue;
                    if (!is_numeric($masterTbl->ProvinceCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_DistrictCode", Get("DistrictCode"))) !== null) {
                    $masterTbl->DistrictCode->setQueryStringValue($parm);
                    $this->DistrictCode->QueryStringValue = $masterTbl->DistrictCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->DistrictCode->setSessionValue($this->DistrictCode->QueryStringValue);
                    $foreignKeys["DistrictCode"] = $this->DistrictCode->QueryStringValue;
                    if (!is_numeric($masterTbl->DistrictCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_CampCode", Get("CampCode"))) !== null) {
                    $masterTbl->CampCode->setQueryStringValue($parm);
                    $this->CampCode->QueryStringValue = $masterTbl->CampCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->CampCode->setSessionValue($this->CampCode->QueryStringValue);
                    $foreignKeys["CampCode"] = $this->CampCode->QueryStringValue;
                    if (!is_numeric($masterTbl->CampCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_VillageCode", Get("VillageCode"))) !== null) {
                    $masterTbl->VillageCode->setQueryStringValue($parm);
                    $this->VillageCode->QueryStringValue = $masterTbl->VillageCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->VillageCode->setSessionValue($this->VillageCode->QueryStringValue);
                    $foreignKeys["VillageCode"] = $this->VillageCode->QueryStringValue;
                    if (!is_numeric($masterTbl->VillageCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_NRC", Get("NRC"))) !== null) {
                    $masterTbl->NRC->setQueryStringValue($parm);
                    $this->NRC->QueryStringValue = $masterTbl->NRC->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->NRC->setSessionValue($this->NRC->QueryStringValue);
                    $foreignKeys["NRC"] = $this->NRC->QueryStringValue;
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_FarmNo", Get("FarmNo"))) !== null) {
                    $masterTbl->FarmNo->setQueryStringValue($parm);
                    $this->FarmNo->QueryStringValue = $masterTbl->FarmNo->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->FarmNo->setSessionValue($this->FarmNo->QueryStringValue);
                    $foreignKeys["FarmNo"] = $this->FarmNo->QueryStringValue;
                    if (!is_numeric($masterTbl->FarmNo->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "farm") {
                $validMaster = true;
                $masterTbl = Container("farm");
                if (($parm = Post("fk_ProvinceCode", Post("ProvinceCode"))) !== null) {
                    $masterTbl->ProvinceCode->setFormValue($parm);
                    $this->ProvinceCode->FormValue = $masterTbl->ProvinceCode->FormValue;
                    $this->ProvinceCode->setSessionValue($this->ProvinceCode->FormValue);
                    $foreignKeys["ProvinceCode"] = $this->ProvinceCode->FormValue;
                    if (!is_numeric($masterTbl->ProvinceCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_DistrictCode", Post("DistrictCode"))) !== null) {
                    $masterTbl->DistrictCode->setFormValue($parm);
                    $this->DistrictCode->FormValue = $masterTbl->DistrictCode->FormValue;
                    $this->DistrictCode->setSessionValue($this->DistrictCode->FormValue);
                    $foreignKeys["DistrictCode"] = $this->DistrictCode->FormValue;
                    if (!is_numeric($masterTbl->DistrictCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_CampCode", Post("CampCode"))) !== null) {
                    $masterTbl->CampCode->setFormValue($parm);
                    $this->CampCode->FormValue = $masterTbl->CampCode->FormValue;
                    $this->CampCode->setSessionValue($this->CampCode->FormValue);
                    $foreignKeys["CampCode"] = $this->CampCode->FormValue;
                    if (!is_numeric($masterTbl->CampCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_VillageCode", Post("VillageCode"))) !== null) {
                    $masterTbl->VillageCode->setFormValue($parm);
                    $this->VillageCode->FormValue = $masterTbl->VillageCode->FormValue;
                    $this->VillageCode->setSessionValue($this->VillageCode->FormValue);
                    $foreignKeys["VillageCode"] = $this->VillageCode->FormValue;
                    if (!is_numeric($masterTbl->VillageCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_NRC", Post("NRC"))) !== null) {
                    $masterTbl->NRC->setFormValue($parm);
                    $this->NRC->FormValue = $masterTbl->NRC->FormValue;
                    $this->NRC->setSessionValue($this->NRC->FormValue);
                    $foreignKeys["NRC"] = $this->NRC->FormValue;
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_FarmNo", Post("FarmNo"))) !== null) {
                    $masterTbl->FarmNo->setFormValue($parm);
                    $this->FarmNo->FormValue = $masterTbl->FarmNo->FormValue;
                    $this->FarmNo->setSessionValue($this->FarmNo->FormValue);
                    $foreignKeys["FarmNo"] = $this->FarmNo->FormValue;
                    if (!is_numeric($masterTbl->FarmNo->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "farm") {
                if (!array_key_exists("ProvinceCode", $foreignKeys)) { // Not current foreign key
                    $this->ProvinceCode->setSessionValue("");
                }
                if (!array_key_exists("DistrictCode", $foreignKeys)) { // Not current foreign key
                    $this->DistrictCode->setSessionValue("");
                }
                if (!array_key_exists("CampCode", $foreignKeys)) { // Not current foreign key
                    $this->CampCode->setSessionValue("");
                }
                if (!array_key_exists("VillageCode", $foreignKeys)) { // Not current foreign key
                    $this->VillageCode->setSessionValue("");
                }
                if (!array_key_exists("NRC", $foreignKeys)) { // Not current foreign key
                    $this->NRC->setSessionValue("");
                }
                if (!array_key_exists("FarmNo", $foreignKeys)) { // Not current foreign key
                    $this->FarmNo->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("FarmInspectionList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ProvinceCode":
                    break;
                case "x_DistrictCode":
                    break;
                case "x_CampCode":
                    break;
                case "x_VillageCode":
                    break;
                case "x_NRC":
                    break;
                case "x_DiseasePresence":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
