<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for farm_inspection
 */
class FarmInspection extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $ProvinceCode;
    public $DistrictCode;
    public $CampCode;
    public $VillageCode;
    public $NRC;
    public $FarmerNo;
    public $FarmNo;
    public $InspectionTransNo;
    public $PlantsDead;
    public $PlantsVerifiedNo;
    public $PlantsReplaced;
    public $FungicidesReceived;
    public $PescticidesReceived;
    public $DiseasePresence;
    public $AvailableLand;
    public $LandForCashewCleared;
    public $HolesDug;
    public $VerifiedSeedlingArea;
    public $OldTreesNo;
    public $InspectionReport;
    public $InspectionDate;
    public $InspectedBy;
    public $AuthorisedBy;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "farm_inspection";
        $this->TableName = 'farm_inspection';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "farm_inspection";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // ProvinceCode
        $this->ProvinceCode = new DbField(
            $this, // Table
            'x_ProvinceCode', // Variable name
            'ProvinceCode', // Name
            '`ProvinceCode`', // Expression
            '`ProvinceCode`', // Basic search expression
            3, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProvinceCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ProvinceCode->addMethod("getDefault", fn() => 0);
        $this->ProvinceCode->InputTextType = "text";
        $this->ProvinceCode->Raw = true;
        $this->ProvinceCode->IsForeignKey = true; // Foreign key field
        $this->ProvinceCode->Nullable = false; // NOT NULL field
        $this->ProvinceCode->setSelectMultiple(false); // Select one
        $this->ProvinceCode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ProvinceCode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ProvinceCode->Lookup = new Lookup($this->ProvinceCode, 'province', false, 'ProvinceCode', ["ProvinceName","","",""], '', '', [], ["x_DistrictCode"], [], [], [], [], false, '', '', "`ProvinceName`");
        $this->ProvinceCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ProvinceCode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ProvinceCode'] = &$this->ProvinceCode;

        // DistrictCode
        $this->DistrictCode = new DbField(
            $this, // Table
            'x_DistrictCode', // Variable name
            'DistrictCode', // Name
            '`DistrictCode`', // Expression
            '`DistrictCode`', // Basic search expression
            3, // Type
            2, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`DistrictCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->DistrictCode->addMethod("getDefault", fn() => 0);
        $this->DistrictCode->InputTextType = "text";
        $this->DistrictCode->Raw = true;
        $this->DistrictCode->IsForeignKey = true; // Foreign key field
        $this->DistrictCode->Nullable = false; // NOT NULL field
        $this->DistrictCode->setSelectMultiple(false); // Select one
        $this->DistrictCode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->DistrictCode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->DistrictCode->Lookup = new Lookup($this->DistrictCode, 'district', false, 'DistrictCode', ["DistrictName","","",""], '', '', ["x_ProvinceCode"], ["x_CampCode"], ["ProvinceCode"], ["x_ProvinceCode"], [], [], false, '', '', "`DistrictName`");
        $this->DistrictCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->DistrictCode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['DistrictCode'] = &$this->DistrictCode;

        // CampCode
        $this->CampCode = new DbField(
            $this, // Table
            'x_CampCode', // Variable name
            'CampCode', // Name
            '`CampCode`', // Expression
            '`CampCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`CampCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->CampCode->InputTextType = "text";
        $this->CampCode->Raw = true;
        $this->CampCode->IsForeignKey = true; // Foreign key field
        $this->CampCode->setSelectMultiple(false); // Select one
        $this->CampCode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->CampCode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->CampCode->Lookup = new Lookup($this->CampCode, 'camp', false, 'CampCode', ["CampName","","",""], '', '', ["x_DistrictCode"], ["x_VillageCode"], ["DistrictCode"], ["x_DistrictCode"], [], [], false, '', '', "`CampName`");
        $this->CampCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->CampCode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['CampCode'] = &$this->CampCode;

        // VillageCode
        $this->VillageCode = new DbField(
            $this, // Table
            'x_VillageCode', // Variable name
            'VillageCode', // Name
            '`VillageCode`', // Expression
            '`VillageCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`VillageCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->VillageCode->InputTextType = "text";
        $this->VillageCode->Raw = true;
        $this->VillageCode->IsForeignKey = true; // Foreign key field
        $this->VillageCode->setSelectMultiple(false); // Select one
        $this->VillageCode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->VillageCode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->VillageCode->Lookup = new Lookup($this->VillageCode, 'village', false, 'VillageCode', ["Village","","",""], '', '', ["x_CampCode"], ["x_NRC"], ["CampCode"], ["x_CampCode"], [], [], false, '', '', "`Village`");
        $this->VillageCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->VillageCode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['VillageCode'] = &$this->VillageCode;

        // NRC
        $this->NRC = new DbField(
            $this, // Table
            'x_NRC', // Variable name
            'NRC', // Name
            '`NRC`', // Expression
            '`NRC`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NRC`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->NRC->InputTextType = "text";
        $this->NRC->IsForeignKey = true; // Foreign key field
        $this->NRC->setSelectMultiple(false); // Select one
        $this->NRC->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->NRC->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->NRC->Lookup = new Lookup($this->NRC, 'famer_farm_view', false, 'NRC', ["FarmerName","NRC","Gender",""], '', '', ["x_VillageCode"], [], ["VillageCode"], ["x_VillageCode"], ["FarmerNo","FarmNo"], ["x_FarmerNo","x_FarmNo"], false, '', '', "CONCAT(COALESCE(`FarmerName`, ''),'" . ValueSeparator(1, $this->NRC) . "',COALESCE(`NRC`,''),'" . ValueSeparator(2, $this->NRC) . "',COALESCE(`Gender`,''))");
        $this->NRC->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['NRC'] = &$this->NRC;

        // FarmerNo
        $this->FarmerNo = new DbField(
            $this, // Table
            'x_FarmerNo', // Variable name
            'FarmerNo', // Name
            '`FarmerNo`', // Expression
            '`FarmerNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerNo->InputTextType = "text";
        $this->FarmerNo->Raw = true;
        $this->FarmerNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmerNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmerNo'] = &$this->FarmerNo;

        // FarmNo
        $this->FarmNo = new DbField(
            $this, // Table
            'x_FarmNo', // Variable name
            'FarmNo', // Name
            '`FarmNo`', // Expression
            '`FarmNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmNo->InputTextType = "text";
        $this->FarmNo->Raw = true;
        $this->FarmNo->IsForeignKey = true; // Foreign key field
        $this->FarmNo->Nullable = false; // NOT NULL field
        $this->FarmNo->Required = true; // Required field
        $this->FarmNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['FarmNo'] = &$this->FarmNo;

        // InspectionTransNo
        $this->InspectionTransNo = new DbField(
            $this, // Table
            'x_InspectionTransNo', // Variable name
            'InspectionTransNo', // Name
            '`InspectionTransNo`', // Expression
            '`InspectionTransNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`InspectionTransNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->InspectionTransNo->InputTextType = "text";
        $this->InspectionTransNo->Raw = true;
        $this->InspectionTransNo->IsAutoIncrement = true; // Autoincrement field
        $this->InspectionTransNo->IsPrimaryKey = true; // Primary key field
        $this->InspectionTransNo->Nullable = false; // NOT NULL field
        $this->InspectionTransNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->InspectionTransNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['InspectionTransNo'] = &$this->InspectionTransNo;

        // PlantsDead
        $this->PlantsDead = new DbField(
            $this, // Table
            'x_PlantsDead', // Variable name
            'PlantsDead', // Name
            '`PlantsDead`', // Expression
            '`PlantsDead`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PlantsDead`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PlantsDead->InputTextType = "text";
        $this->PlantsDead->Raw = true;
        $this->PlantsDead->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->PlantsDead->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['PlantsDead'] = &$this->PlantsDead;

        // PlantsVerifiedNo
        $this->PlantsVerifiedNo = new DbField(
            $this, // Table
            'x_PlantsVerifiedNo', // Variable name
            'PlantsVerifiedNo', // Name
            '`PlantsVerifiedNo`', // Expression
            '`PlantsVerifiedNo`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PlantsVerifiedNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PlantsVerifiedNo->InputTextType = "text";
        $this->PlantsVerifiedNo->Raw = true;
        $this->PlantsVerifiedNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->PlantsVerifiedNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['PlantsVerifiedNo'] = &$this->PlantsVerifiedNo;

        // PlantsReplaced
        $this->PlantsReplaced = new DbField(
            $this, // Table
            'x_PlantsReplaced', // Variable name
            'PlantsReplaced', // Name
            '`PlantsReplaced`', // Expression
            '`PlantsReplaced`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PlantsReplaced`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PlantsReplaced->InputTextType = "text";
        $this->PlantsReplaced->Raw = true;
        $this->PlantsReplaced->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->PlantsReplaced->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['PlantsReplaced'] = &$this->PlantsReplaced;

        // FungicidesReceived
        $this->FungicidesReceived = new DbField(
            $this, // Table
            'x_FungicidesReceived', // Variable name
            'FungicidesReceived', // Name
            '`FungicidesReceived`', // Expression
            '`FungicidesReceived`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FungicidesReceived`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FungicidesReceived->InputTextType = "text";
        $this->FungicidesReceived->Raw = true;
        $this->FungicidesReceived->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->FungicidesReceived->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FungicidesReceived'] = &$this->FungicidesReceived;

        // PescticidesReceived
        $this->PescticidesReceived = new DbField(
            $this, // Table
            'x_PescticidesReceived', // Variable name
            'PescticidesReceived', // Name
            '`PescticidesReceived`', // Expression
            '`PescticidesReceived`', // Basic search expression
            5, // Type
            22, // Size
            0, // Date/Time format
            false, // Is upload field
            '`PescticidesReceived`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PescticidesReceived->InputTextType = "text";
        $this->PescticidesReceived->Raw = true;
        $this->PescticidesReceived->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->PescticidesReceived->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['PescticidesReceived'] = &$this->PescticidesReceived;

        // DiseasePresence
        $this->DiseasePresence = new DbField(
            $this, // Table
            'x_DiseasePresence', // Variable name
            'DiseasePresence', // Name
            '`DiseasePresence`', // Expression
            '`DiseasePresence`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`DiseasePresence`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->DiseasePresence->InputTextType = "text";
        $this->DiseasePresence->Lookup = new Lookup($this->DiseasePresence, 'disease', false, 'DiseasePresence', ["DiseasePresence","","",""], '', '', [], [], [], [], [], [], false, '', '', "`DiseasePresence`");
        $this->DiseasePresence->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['DiseasePresence'] = &$this->DiseasePresence;

        // AvailableLand
        $this->AvailableLand = new DbField(
            $this, // Table
            'x_AvailableLand', // Variable name
            'AvailableLand', // Name
            '`AvailableLand`', // Expression
            '`AvailableLand`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`AvailableLand`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->AvailableLand->InputTextType = "text";
        $this->AvailableLand->Raw = true;
        $this->AvailableLand->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->AvailableLand->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['AvailableLand'] = &$this->AvailableLand;

        // LandForCashewCleared
        $this->LandForCashewCleared = new DbField(
            $this, // Table
            'x_LandForCashewCleared', // Variable name
            'LandForCashewCleared', // Name
            '`LandForCashewCleared`', // Expression
            '`LandForCashewCleared`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`LandForCashewCleared`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->LandForCashewCleared->InputTextType = "text";
        $this->LandForCashewCleared->Raw = true;
        $this->LandForCashewCleared->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->LandForCashewCleared->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['LandForCashewCleared'] = &$this->LandForCashewCleared;

        // HolesDug
        $this->HolesDug = new DbField(
            $this, // Table
            'x_HolesDug', // Variable name
            'HolesDug', // Name
            '`HolesDug`', // Expression
            '`HolesDug`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`HolesDug`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->HolesDug->InputTextType = "text";
        $this->HolesDug->Raw = true;
        $this->HolesDug->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->HolesDug->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['HolesDug'] = &$this->HolesDug;

        // VerifiedSeedlingArea
        $this->VerifiedSeedlingArea = new DbField(
            $this, // Table
            'x_VerifiedSeedlingArea', // Variable name
            'VerifiedSeedlingArea', // Name
            '`VerifiedSeedlingArea`', // Expression
            '`VerifiedSeedlingArea`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`VerifiedSeedlingArea`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->VerifiedSeedlingArea->InputTextType = "text";
        $this->VerifiedSeedlingArea->Raw = true;
        $this->VerifiedSeedlingArea->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->VerifiedSeedlingArea->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['VerifiedSeedlingArea'] = &$this->VerifiedSeedlingArea;

        // OldTreesNo
        $this->OldTreesNo = new DbField(
            $this, // Table
            'x_OldTreesNo', // Variable name
            'OldTreesNo', // Name
            '`OldTreesNo`', // Expression
            '`OldTreesNo`', // Basic search expression
            3, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`OldTreesNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->OldTreesNo->InputTextType = "text";
        $this->OldTreesNo->Raw = true;
        $this->OldTreesNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->OldTreesNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['OldTreesNo'] = &$this->OldTreesNo;

        // InspectionReport
        $this->InspectionReport = new DbField(
            $this, // Table
            'x_InspectionReport', // Variable name
            'InspectionReport', // Name
            '`InspectionReport`', // Expression
            '`InspectionReport`', // Basic search expression
            201, // Type
            2147483647, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`InspectionReport`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->InspectionReport->InputTextType = "text";
        $this->InspectionReport->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['InspectionReport'] = &$this->InspectionReport;

        // InspectionDate
        $this->InspectionDate = new DbField(
            $this, // Table
            'x_InspectionDate', // Variable name
            'InspectionDate', // Name
            '`InspectionDate`', // Expression
            CastDateFieldForLike("`InspectionDate`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`InspectionDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->InspectionDate->InputTextType = "text";
        $this->InspectionDate->Raw = true;
        $this->InspectionDate->Nullable = false; // NOT NULL field
        $this->InspectionDate->Required = true; // Required field
        $this->InspectionDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->InspectionDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['InspectionDate'] = &$this->InspectionDate;

        // InspectedBy
        $this->InspectedBy = new DbField(
            $this, // Table
            'x_InspectedBy', // Variable name
            'InspectedBy', // Name
            '`InspectedBy`', // Expression
            '`InspectedBy`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`InspectedBy`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->InspectedBy->InputTextType = "text";
        $this->InspectedBy->Nullable = false; // NOT NULL field
        $this->InspectedBy->Required = true; // Required field
        $this->InspectedBy->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['InspectedBy'] = &$this->InspectedBy;

        // AuthorisedBy
        $this->AuthorisedBy = new DbField(
            $this, // Table
            'x_AuthorisedBy', // Variable name
            'AuthorisedBy', // Name
            '`AuthorisedBy`', // Expression
            '`AuthorisedBy`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`AuthorisedBy`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->AuthorisedBy->InputTextType = "text";
        $this->AuthorisedBy->Nullable = false; // NOT NULL field
        $this->AuthorisedBy->Required = true; // Required field
        $this->AuthorisedBy->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['AuthorisedBy'] = &$this->AuthorisedBy;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current master table name
    public function getCurrentMasterTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE"));
    }

    public function setCurrentMasterTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
    }

    // Get master WHERE clause from session values
    public function getMasterFilterFromSession()
    {
        // Master filter
        $masterFilter = "";
        if ($this->getCurrentMasterTable() == "farm") {
            $masterTable = Container("farm");
            if ($this->ProvinceCode->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->ProvinceCode, $this->ProvinceCode->getSessionValue(), $masterTable->ProvinceCode->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
            if ($this->DistrictCode->getSessionValue() != "") {
                $masterFilter .= " AND " . GetKeyFilter($masterTable->DistrictCode, $this->DistrictCode->getSessionValue(), $masterTable->DistrictCode->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
            if ($this->CampCode->getSessionValue() != "") {
                $masterFilter .= " AND " . GetKeyFilter($masterTable->CampCode, $this->CampCode->getSessionValue(), $masterTable->CampCode->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
            if ($this->VillageCode->getSessionValue() != "") {
                $masterFilter .= " AND " . GetKeyFilter($masterTable->VillageCode, $this->VillageCode->getSessionValue(), $masterTable->VillageCode->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
            if ($this->NRC->getSessionValue() != "") {
                $masterFilter .= " AND " . GetKeyFilter($masterTable->NRC, $this->NRC->getSessionValue(), $masterTable->NRC->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
            if ($this->FarmNo->getSessionValue() != "") {
                $masterFilter .= " AND " . GetKeyFilter($masterTable->FarmNo, $this->FarmNo->getSessionValue(), $masterTable->FarmNo->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        return $masterFilter;
    }

    // Get detail WHERE clause from session values
    public function getDetailFilterFromSession()
    {
        // Detail filter
        $detailFilter = "";
        if ($this->getCurrentMasterTable() == "farm") {
            $masterTable = Container("farm");
            if ($this->ProvinceCode->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->ProvinceCode, $this->ProvinceCode->getSessionValue(), $masterTable->ProvinceCode->DataType, $this->Dbid);
            } else {
                return "";
            }
            if ($this->DistrictCode->getSessionValue() != "") {
                $detailFilter .= " AND " . GetKeyFilter($this->DistrictCode, $this->DistrictCode->getSessionValue(), $masterTable->DistrictCode->DataType, $this->Dbid);
            } else {
                return "";
            }
            if ($this->CampCode->getSessionValue() != "") {
                $detailFilter .= " AND " . GetKeyFilter($this->CampCode, $this->CampCode->getSessionValue(), $masterTable->CampCode->DataType, $this->Dbid);
            } else {
                return "";
            }
            if ($this->VillageCode->getSessionValue() != "") {
                $detailFilter .= " AND " . GetKeyFilter($this->VillageCode, $this->VillageCode->getSessionValue(), $masterTable->VillageCode->DataType, $this->Dbid);
            } else {
                return "";
            }
            if ($this->NRC->getSessionValue() != "") {
                $detailFilter .= " AND " . GetKeyFilter($this->NRC, $this->NRC->getSessionValue(), $masterTable->NRC->DataType, $this->Dbid);
            } else {
                return "";
            }
            if ($this->FarmNo->getSessionValue() != "") {
                $detailFilter .= " AND " . GetKeyFilter($this->FarmNo, $this->FarmNo->getSessionValue(), $masterTable->FarmNo->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        return $detailFilter;
    }

    /**
     * Get master filter
     *
     * @param object $masterTable Master Table
     * @param array $keys Detail Keys
     * @return mixed NULL is returned if all keys are empty, Empty string is returned if some keys are empty and is required
     */
    public function getMasterFilter($masterTable, $keys)
    {
        $validKeys = true;
        switch ($masterTable->TableVar) {
            case "farm":
                $key = $keys["ProvinceCode"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->ProvinceCode->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                $key = $keys["DistrictCode"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->DistrictCode->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                $key = $keys["CampCode"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->CampCode->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                $key = $keys["VillageCode"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->VillageCode->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                $key = $keys["NRC"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->NRC->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                $key = $keys["FarmNo"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->FarmNo->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->ProvinceCode, $keys["ProvinceCode"], $this->ProvinceCode->DataType, $this->Dbid) . " AND " . GetKeyFilter($masterTable->DistrictCode, $keys["DistrictCode"], $this->DistrictCode->DataType, $this->Dbid) . " AND " . GetKeyFilter($masterTable->CampCode, $keys["CampCode"], $this->CampCode->DataType, $this->Dbid) . " AND " . GetKeyFilter($masterTable->VillageCode, $keys["VillageCode"], $this->VillageCode->DataType, $this->Dbid) . " AND " . GetKeyFilter($masterTable->NRC, $keys["NRC"], $this->NRC->DataType, $this->Dbid) . " AND " . GetKeyFilter($masterTable->FarmNo, $keys["FarmNo"], $this->FarmNo->DataType, $this->Dbid);
                }
                break;
        }
        return null; // All null values and no required fields
    }

    // Get detail filter
    public function getDetailFilter($masterTable)
    {
        switch ($masterTable->TableVar) {
            case "farm":
                return GetKeyFilter($this->ProvinceCode, $masterTable->ProvinceCode->DbValue, $masterTable->ProvinceCode->DataType, $masterTable->Dbid) . " AND " . GetKeyFilter($this->DistrictCode, $masterTable->DistrictCode->DbValue, $masterTable->DistrictCode->DataType, $masterTable->Dbid) . " AND " . GetKeyFilter($this->CampCode, $masterTable->CampCode->DbValue, $masterTable->CampCode->DataType, $masterTable->Dbid) . " AND " . GetKeyFilter($this->VillageCode, $masterTable->VillageCode->DbValue, $masterTable->VillageCode->DataType, $masterTable->Dbid) . " AND " . GetKeyFilter($this->NRC, $masterTable->NRC->DbValue, $masterTable->NRC->DataType, $masterTable->Dbid) . " AND " . GetKeyFilter($this->FarmNo, $masterTable->FarmNo->DbValue, $masterTable->FarmNo->DataType, $masterTable->Dbid);
        }
        return "";
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "farm_inspection";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD) == Allow::ADD;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT) == Allow::EDIT;
            case "delete":
                return ($allow & Allow::DELETE) == Allow::DELETE;
            case "view":
                return ($allow & Allow::VIEW) == Allow::VIEW;
            case "search":
                return ($allow & Allow::SEARCH) == Allow::SEARCH;
            case "lookup":
                return ($allow & Allow::LOOKUP) == Allow::LOOKUP;
            default:
                return ($allow & Allow::LIST) == Allow::LIST;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->InspectionTransNo->setDbValue($conn->lastInsertId());
            $rs['InspectionTransNo'] = $this->InspectionTransNo->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['InspectionTransNo']) && !EmptyValue($this->InspectionTransNo->CurrentValue)) {
                $rs['InspectionTransNo'] = $this->InspectionTransNo->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('InspectionTransNo', $rs)) {
                AddFilter($where, QuotedName('InspectionTransNo', $this->Dbid) . '=' . QuotedValue($rs['InspectionTransNo'], $this->InspectionTransNo->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->ProvinceCode->DbValue = $row['ProvinceCode'];
        $this->DistrictCode->DbValue = $row['DistrictCode'];
        $this->CampCode->DbValue = $row['CampCode'];
        $this->VillageCode->DbValue = $row['VillageCode'];
        $this->NRC->DbValue = $row['NRC'];
        $this->FarmerNo->DbValue = $row['FarmerNo'];
        $this->FarmNo->DbValue = $row['FarmNo'];
        $this->InspectionTransNo->DbValue = $row['InspectionTransNo'];
        $this->PlantsDead->DbValue = $row['PlantsDead'];
        $this->PlantsVerifiedNo->DbValue = $row['PlantsVerifiedNo'];
        $this->PlantsReplaced->DbValue = $row['PlantsReplaced'];
        $this->FungicidesReceived->DbValue = $row['FungicidesReceived'];
        $this->PescticidesReceived->DbValue = $row['PescticidesReceived'];
        $this->DiseasePresence->DbValue = $row['DiseasePresence'];
        $this->AvailableLand->DbValue = $row['AvailableLand'];
        $this->LandForCashewCleared->DbValue = $row['LandForCashewCleared'];
        $this->HolesDug->DbValue = $row['HolesDug'];
        $this->VerifiedSeedlingArea->DbValue = $row['VerifiedSeedlingArea'];
        $this->OldTreesNo->DbValue = $row['OldTreesNo'];
        $this->InspectionReport->DbValue = $row['InspectionReport'];
        $this->InspectionDate->DbValue = $row['InspectionDate'];
        $this->InspectedBy->DbValue = $row['InspectedBy'];
        $this->AuthorisedBy->DbValue = $row['AuthorisedBy'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`InspectionTransNo` = @InspectionTransNo@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->InspectionTransNo->CurrentValue : $this->InspectionTransNo->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->InspectionTransNo->CurrentValue = $keys[0];
            } else {
                $this->InspectionTransNo->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('InspectionTransNo', $row) ? $row['InspectionTransNo'] : null;
        } else {
            $val = !EmptyValue($this->InspectionTransNo->OldValue) && !$current ? $this->InspectionTransNo->OldValue : $this->InspectionTransNo->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@InspectionTransNo@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("FarmInspectionList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "FarmInspectionView" => $Language->phrase("View"),
            "FarmInspectionEdit" => $Language->phrase("Edit"),
            "FarmInspectionAdd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "FarmInspectionList";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "FarmInspectionView",
            Config("API_ADD_ACTION") => "FarmInspectionAdd",
            Config("API_EDIT_ACTION") => "FarmInspectionEdit",
            Config("API_DELETE_ACTION") => "FarmInspectionDelete",
            Config("API_LIST_ACTION") => "FarmInspectionList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "FarmInspectionList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("FarmInspectionView", $parm);
        } else {
            $url = $this->keyUrl("FarmInspectionView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "FarmInspectionAdd?" . $parm;
        } else {
            $url = "FarmInspectionAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("FarmInspectionEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("FarmInspectionList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("FarmInspectionAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("FarmInspectionList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("FarmInspectionDelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        if ($this->getCurrentMasterTable() == "farm" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_ProvinceCode", $this->ProvinceCode->getSessionValue()); // Use Session Value
            $url .= "&" . GetForeignKeyUrl("fk_DistrictCode", $this->DistrictCode->getSessionValue()); // Use Session Value
            $url .= "&" . GetForeignKeyUrl("fk_CampCode", $this->CampCode->getSessionValue()); // Use Session Value
            $url .= "&" . GetForeignKeyUrl("fk_VillageCode", $this->VillageCode->getSessionValue()); // Use Session Value
            $url .= "&" . GetForeignKeyUrl("fk_NRC", $this->NRC->getSessionValue()); // Use Session Value
            $url .= "&" . GetForeignKeyUrl("fk_FarmNo", $this->FarmNo->getSessionValue()); // Use Session Value
        }
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"InspectionTransNo\":" . VarToJson($this->InspectionTransNo->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->InspectionTransNo->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->InspectionTransNo->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("InspectionTransNo") ?? Route("InspectionTransNo")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->InspectionTransNo->CurrentValue = $key;
            } else {
                $this->InspectionTransNo->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->VillageCode->setDbValue($row['VillageCode']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmerNo->setDbValue($row['FarmerNo']);
        $this->FarmNo->setDbValue($row['FarmNo']);
        $this->InspectionTransNo->setDbValue($row['InspectionTransNo']);
        $this->PlantsDead->setDbValue($row['PlantsDead']);
        $this->PlantsVerifiedNo->setDbValue($row['PlantsVerifiedNo']);
        $this->PlantsReplaced->setDbValue($row['PlantsReplaced']);
        $this->FungicidesReceived->setDbValue($row['FungicidesReceived']);
        $this->PescticidesReceived->setDbValue($row['PescticidesReceived']);
        $this->DiseasePresence->setDbValue($row['DiseasePresence']);
        $this->AvailableLand->setDbValue($row['AvailableLand']);
        $this->LandForCashewCleared->setDbValue($row['LandForCashewCleared']);
        $this->HolesDug->setDbValue($row['HolesDug']);
        $this->VerifiedSeedlingArea->setDbValue($row['VerifiedSeedlingArea']);
        $this->OldTreesNo->setDbValue($row['OldTreesNo']);
        $this->InspectionReport->setDbValue($row['InspectionReport']);
        $this->InspectionDate->setDbValue($row['InspectionDate']);
        $this->InspectedBy->setDbValue($row['InspectedBy']);
        $this->AuthorisedBy->setDbValue($row['AuthorisedBy']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "FarmInspectionList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // ProvinceCode

        // DistrictCode

        // CampCode

        // VillageCode

        // NRC

        // FarmerNo

        // FarmNo

        // InspectionTransNo

        // PlantsDead

        // PlantsVerifiedNo

        // PlantsReplaced

        // FungicidesReceived

        // PescticidesReceived

        // DiseasePresence

        // AvailableLand

        // LandForCashewCleared

        // HolesDug

        // VerifiedSeedlingArea

        // OldTreesNo

        // InspectionReport

        // InspectionDate

        // InspectedBy

        // AuthorisedBy

        // ProvinceCode
        $curVal = strval($this->ProvinceCode->CurrentValue);
        if ($curVal != "") {
            $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
            if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                } else {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                }
            }
        } else {
            $this->ProvinceCode->ViewValue = null;
        }

        // DistrictCode
        $curVal = strval($this->DistrictCode->CurrentValue);
        if ($curVal != "") {
            $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
            if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                    $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                } else {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                }
            }
        } else {
            $this->DistrictCode->ViewValue = null;
        }

        // CampCode
        $curVal = strval($this->CampCode->CurrentValue);
        if ($curVal != "") {
            $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
            if ($this->CampCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                    $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                } else {
                    $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                }
            }
        } else {
            $this->CampCode->ViewValue = null;
        }

        // VillageCode
        $curVal = strval($this->VillageCode->CurrentValue);
        if ($curVal != "") {
            $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
            if ($this->VillageCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                    $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                } else {
                    $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                }
            }
        } else {
            $this->VillageCode->ViewValue = null;
        }

        // NRC
        $curVal = strval($this->NRC->CurrentValue);
        if ($curVal != "") {
            $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
            if ($this->NRC->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                    $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                } else {
                    $this->NRC->ViewValue = $this->NRC->CurrentValue;
                }
            }
        } else {
            $this->NRC->ViewValue = null;
        }

        // FarmerNo
        $this->FarmerNo->ViewValue = $this->FarmerNo->CurrentValue;

        // FarmNo
        $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;

        // InspectionTransNo
        $this->InspectionTransNo->ViewValue = $this->InspectionTransNo->CurrentValue;

        // PlantsDead
        $this->PlantsDead->ViewValue = $this->PlantsDead->CurrentValue;
        $this->PlantsDead->ViewValue = FormatNumber($this->PlantsDead->ViewValue, $this->PlantsDead->formatPattern());

        // PlantsVerifiedNo
        $this->PlantsVerifiedNo->ViewValue = $this->PlantsVerifiedNo->CurrentValue;
        $this->PlantsVerifiedNo->ViewValue = FormatNumber($this->PlantsVerifiedNo->ViewValue, $this->PlantsVerifiedNo->formatPattern());

        // PlantsReplaced
        $this->PlantsReplaced->ViewValue = $this->PlantsReplaced->CurrentValue;
        $this->PlantsReplaced->ViewValue = FormatNumber($this->PlantsReplaced->ViewValue, $this->PlantsReplaced->formatPattern());

        // FungicidesReceived
        $this->FungicidesReceived->ViewValue = $this->FungicidesReceived->CurrentValue;
        $this->FungicidesReceived->ViewValue = FormatNumber($this->FungicidesReceived->ViewValue, $this->FungicidesReceived->formatPattern());

        // PescticidesReceived
        $this->PescticidesReceived->ViewValue = $this->PescticidesReceived->CurrentValue;
        $this->PescticidesReceived->ViewValue = FormatNumber($this->PescticidesReceived->ViewValue, $this->PescticidesReceived->formatPattern());

        // DiseasePresence
        $curVal = strval($this->DiseasePresence->CurrentValue);
        if ($curVal != "") {
            $this->DiseasePresence->ViewValue = $this->DiseasePresence->lookupCacheOption($curVal);
            if ($this->DiseasePresence->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->DiseasePresence->Lookup->getTable()->Fields["DiseasePresence"]->searchExpression(), "=", trim($wrk), $this->DiseasePresence->Lookup->getTable()->Fields["DiseasePresence"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->DiseasePresence->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->DiseasePresence->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->DiseasePresence->Lookup->renderViewRow($row);
                        $this->DiseasePresence->ViewValue->add($this->DiseasePresence->displayValue($arwrk));
                    }
                } else {
                    $this->DiseasePresence->ViewValue = $this->DiseasePresence->CurrentValue;
                }
            }
        } else {
            $this->DiseasePresence->ViewValue = null;
        }

        // AvailableLand
        $this->AvailableLand->ViewValue = $this->AvailableLand->CurrentValue;
        $this->AvailableLand->ViewValue = FormatNumber($this->AvailableLand->ViewValue, $this->AvailableLand->formatPattern());

        // LandForCashewCleared
        $this->LandForCashewCleared->ViewValue = $this->LandForCashewCleared->CurrentValue;
        $this->LandForCashewCleared->ViewValue = FormatNumber($this->LandForCashewCleared->ViewValue, $this->LandForCashewCleared->formatPattern());

        // HolesDug
        $this->HolesDug->ViewValue = $this->HolesDug->CurrentValue;

        // VerifiedSeedlingArea
        $this->VerifiedSeedlingArea->ViewValue = $this->VerifiedSeedlingArea->CurrentValue;
        $this->VerifiedSeedlingArea->ViewValue = FormatNumber($this->VerifiedSeedlingArea->ViewValue, $this->VerifiedSeedlingArea->formatPattern());

        // OldTreesNo
        $this->OldTreesNo->ViewValue = $this->OldTreesNo->CurrentValue;
        $this->OldTreesNo->ViewValue = FormatNumber($this->OldTreesNo->ViewValue, $this->OldTreesNo->formatPattern());

        // InspectionReport
        $this->InspectionReport->ViewValue = $this->InspectionReport->CurrentValue;

        // InspectionDate
        $this->InspectionDate->ViewValue = $this->InspectionDate->CurrentValue;
        $this->InspectionDate->ViewValue = FormatDateTime($this->InspectionDate->ViewValue, $this->InspectionDate->formatPattern());

        // InspectedBy
        $this->InspectedBy->ViewValue = $this->InspectedBy->CurrentValue;

        // AuthorisedBy
        $this->AuthorisedBy->ViewValue = $this->AuthorisedBy->CurrentValue;

        // ProvinceCode
        $this->ProvinceCode->HrefValue = "";
        $this->ProvinceCode->TooltipValue = "";

        // DistrictCode
        $this->DistrictCode->HrefValue = "";
        $this->DistrictCode->TooltipValue = "";

        // CampCode
        $this->CampCode->HrefValue = "";
        $this->CampCode->TooltipValue = "";

        // VillageCode
        $this->VillageCode->HrefValue = "";
        $this->VillageCode->TooltipValue = "";

        // NRC
        $this->NRC->HrefValue = "";
        $this->NRC->TooltipValue = "";

        // FarmerNo
        $this->FarmerNo->HrefValue = "";
        $this->FarmerNo->TooltipValue = "";

        // FarmNo
        $this->FarmNo->HrefValue = "";
        $this->FarmNo->TooltipValue = "";

        // InspectionTransNo
        $this->InspectionTransNo->HrefValue = "";
        $this->InspectionTransNo->TooltipValue = "";

        // PlantsDead
        $this->PlantsDead->HrefValue = "";
        $this->PlantsDead->TooltipValue = "";

        // PlantsVerifiedNo
        $this->PlantsVerifiedNo->HrefValue = "";
        $this->PlantsVerifiedNo->TooltipValue = "";

        // PlantsReplaced
        $this->PlantsReplaced->HrefValue = "";
        $this->PlantsReplaced->TooltipValue = "";

        // FungicidesReceived
        $this->FungicidesReceived->HrefValue = "";
        $this->FungicidesReceived->TooltipValue = "";

        // PescticidesReceived
        $this->PescticidesReceived->HrefValue = "";
        $this->PescticidesReceived->TooltipValue = "";

        // DiseasePresence
        $this->DiseasePresence->HrefValue = "";
        $this->DiseasePresence->TooltipValue = "";

        // AvailableLand
        $this->AvailableLand->HrefValue = "";
        $this->AvailableLand->TooltipValue = "";

        // LandForCashewCleared
        $this->LandForCashewCleared->HrefValue = "";
        $this->LandForCashewCleared->TooltipValue = "";

        // HolesDug
        $this->HolesDug->HrefValue = "";
        $this->HolesDug->TooltipValue = "";

        // VerifiedSeedlingArea
        $this->VerifiedSeedlingArea->HrefValue = "";
        $this->VerifiedSeedlingArea->TooltipValue = "";

        // OldTreesNo
        $this->OldTreesNo->HrefValue = "";
        $this->OldTreesNo->TooltipValue = "";

        // InspectionReport
        $this->InspectionReport->HrefValue = "";
        $this->InspectionReport->TooltipValue = "";

        // InspectionDate
        $this->InspectionDate->HrefValue = "";
        $this->InspectionDate->TooltipValue = "";

        // InspectedBy
        $this->InspectedBy->HrefValue = "";
        $this->InspectedBy->TooltipValue = "";

        // AuthorisedBy
        $this->AuthorisedBy->HrefValue = "";
        $this->AuthorisedBy->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // ProvinceCode
        $this->ProvinceCode->setupEditAttributes();
        if ($this->ProvinceCode->getSessionValue() != "") {
            $this->ProvinceCode->CurrentValue = GetForeignKeyValue($this->ProvinceCode->getSessionValue());
            $curVal = strval($this->ProvinceCode->CurrentValue);
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                    } else {
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                    }
                }
            } else {
                $this->ProvinceCode->ViewValue = null;
            }
        } else {
            $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
        }

        // DistrictCode
        $this->DistrictCode->setupEditAttributes();
        if ($this->DistrictCode->getSessionValue() != "") {
            $this->DistrictCode->CurrentValue = GetForeignKeyValue($this->DistrictCode->getSessionValue());
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }
        } else {
            $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
        }

        // CampCode
        $this->CampCode->setupEditAttributes();
        if ($this->CampCode->getSessionValue() != "") {
            $this->CampCode->CurrentValue = GetForeignKeyValue($this->CampCode->getSessionValue());
            $curVal = strval($this->CampCode->CurrentValue);
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                if ($this->CampCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                    }
                }
            } else {
                $this->CampCode->ViewValue = null;
            }
        } else {
            $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());
        }

        // VillageCode
        $this->VillageCode->setupEditAttributes();
        if ($this->VillageCode->getSessionValue() != "") {
            $this->VillageCode->CurrentValue = GetForeignKeyValue($this->VillageCode->getSessionValue());
            $curVal = strval($this->VillageCode->CurrentValue);
            if ($curVal != "") {
                $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                if ($this->VillageCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                    }
                }
            } else {
                $this->VillageCode->ViewValue = null;
            }
        } else {
            $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());
        }

        // NRC
        $this->NRC->setupEditAttributes();
        if ($this->NRC->getSessionValue() != "") {
            $this->NRC->CurrentValue = GetForeignKeyValue($this->NRC->getSessionValue());
            $curVal = strval($this->NRC->CurrentValue);
            if ($curVal != "") {
                $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->ViewValue = $this->NRC->CurrentValue;
                    }
                }
            } else {
                $this->NRC->ViewValue = null;
            }
        } else {
            $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());
        }

        // FarmerNo
        $this->FarmerNo->setupEditAttributes();
        $this->FarmerNo->EditValue = $this->FarmerNo->CurrentValue;
        $this->FarmerNo->PlaceHolder = RemoveHtml($this->FarmerNo->caption());
        if (strval($this->FarmerNo->EditValue) != "" && is_numeric($this->FarmerNo->EditValue)) {
            $this->FarmerNo->EditValue = $this->FarmerNo->EditValue;
        }

        // FarmNo
        $this->FarmNo->setupEditAttributes();
        if ($this->FarmNo->getSessionValue() != "") {
            $this->FarmNo->CurrentValue = GetForeignKeyValue($this->FarmNo->getSessionValue());
            $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;
        } else {
            $this->FarmNo->EditValue = $this->FarmNo->CurrentValue;
            $this->FarmNo->PlaceHolder = RemoveHtml($this->FarmNo->caption());
            if (strval($this->FarmNo->EditValue) != "" && is_numeric($this->FarmNo->EditValue)) {
                $this->FarmNo->EditValue = $this->FarmNo->EditValue;
            }
        }

        // InspectionTransNo
        $this->InspectionTransNo->setupEditAttributes();
        $this->InspectionTransNo->EditValue = $this->InspectionTransNo->CurrentValue;

        // PlantsDead
        $this->PlantsDead->setupEditAttributes();
        $this->PlantsDead->EditValue = $this->PlantsDead->CurrentValue;
        $this->PlantsDead->PlaceHolder = RemoveHtml($this->PlantsDead->caption());
        if (strval($this->PlantsDead->EditValue) != "" && is_numeric($this->PlantsDead->EditValue)) {
            $this->PlantsDead->EditValue = FormatNumber($this->PlantsDead->EditValue, null);
        }

        // PlantsVerifiedNo
        $this->PlantsVerifiedNo->setupEditAttributes();
        $this->PlantsVerifiedNo->EditValue = $this->PlantsVerifiedNo->CurrentValue;
        $this->PlantsVerifiedNo->PlaceHolder = RemoveHtml($this->PlantsVerifiedNo->caption());
        if (strval($this->PlantsVerifiedNo->EditValue) != "" && is_numeric($this->PlantsVerifiedNo->EditValue)) {
            $this->PlantsVerifiedNo->EditValue = FormatNumber($this->PlantsVerifiedNo->EditValue, null);
        }

        // PlantsReplaced
        $this->PlantsReplaced->setupEditAttributes();
        $this->PlantsReplaced->EditValue = $this->PlantsReplaced->CurrentValue;
        $this->PlantsReplaced->PlaceHolder = RemoveHtml($this->PlantsReplaced->caption());
        if (strval($this->PlantsReplaced->EditValue) != "" && is_numeric($this->PlantsReplaced->EditValue)) {
            $this->PlantsReplaced->EditValue = FormatNumber($this->PlantsReplaced->EditValue, null);
        }

        // FungicidesReceived
        $this->FungicidesReceived->setupEditAttributes();
        $this->FungicidesReceived->EditValue = $this->FungicidesReceived->CurrentValue;
        $this->FungicidesReceived->PlaceHolder = RemoveHtml($this->FungicidesReceived->caption());
        if (strval($this->FungicidesReceived->EditValue) != "" && is_numeric($this->FungicidesReceived->EditValue)) {
            $this->FungicidesReceived->EditValue = FormatNumber($this->FungicidesReceived->EditValue, null);
        }

        // PescticidesReceived
        $this->PescticidesReceived->setupEditAttributes();
        $this->PescticidesReceived->EditValue = $this->PescticidesReceived->CurrentValue;
        $this->PescticidesReceived->PlaceHolder = RemoveHtml($this->PescticidesReceived->caption());
        if (strval($this->PescticidesReceived->EditValue) != "" && is_numeric($this->PescticidesReceived->EditValue)) {
            $this->PescticidesReceived->EditValue = FormatNumber($this->PescticidesReceived->EditValue, null);
        }

        // DiseasePresence
        $this->DiseasePresence->PlaceHolder = RemoveHtml($this->DiseasePresence->caption());

        // AvailableLand
        $this->AvailableLand->setupEditAttributes();
        $this->AvailableLand->EditValue = $this->AvailableLand->CurrentValue;
        $this->AvailableLand->PlaceHolder = RemoveHtml($this->AvailableLand->caption());
        if (strval($this->AvailableLand->EditValue) != "" && is_numeric($this->AvailableLand->EditValue)) {
            $this->AvailableLand->EditValue = FormatNumber($this->AvailableLand->EditValue, null);
        }

        // LandForCashewCleared
        $this->LandForCashewCleared->setupEditAttributes();
        $this->LandForCashewCleared->EditValue = $this->LandForCashewCleared->CurrentValue;
        $this->LandForCashewCleared->PlaceHolder = RemoveHtml($this->LandForCashewCleared->caption());
        if (strval($this->LandForCashewCleared->EditValue) != "" && is_numeric($this->LandForCashewCleared->EditValue)) {
            $this->LandForCashewCleared->EditValue = FormatNumber($this->LandForCashewCleared->EditValue, null);
        }

        // HolesDug
        $this->HolesDug->setupEditAttributes();
        $this->HolesDug->EditValue = $this->HolesDug->CurrentValue;
        $this->HolesDug->PlaceHolder = RemoveHtml($this->HolesDug->caption());
        if (strval($this->HolesDug->EditValue) != "" && is_numeric($this->HolesDug->EditValue)) {
            $this->HolesDug->EditValue = $this->HolesDug->EditValue;
        }

        // VerifiedSeedlingArea
        $this->VerifiedSeedlingArea->setupEditAttributes();
        $this->VerifiedSeedlingArea->EditValue = $this->VerifiedSeedlingArea->CurrentValue;
        $this->VerifiedSeedlingArea->PlaceHolder = RemoveHtml($this->VerifiedSeedlingArea->caption());
        if (strval($this->VerifiedSeedlingArea->EditValue) != "" && is_numeric($this->VerifiedSeedlingArea->EditValue)) {
            $this->VerifiedSeedlingArea->EditValue = FormatNumber($this->VerifiedSeedlingArea->EditValue, null);
        }

        // OldTreesNo
        $this->OldTreesNo->setupEditAttributes();
        $this->OldTreesNo->EditValue = $this->OldTreesNo->CurrentValue;
        $this->OldTreesNo->PlaceHolder = RemoveHtml($this->OldTreesNo->caption());
        if (strval($this->OldTreesNo->EditValue) != "" && is_numeric($this->OldTreesNo->EditValue)) {
            $this->OldTreesNo->EditValue = FormatNumber($this->OldTreesNo->EditValue, null);
        }

        // InspectionReport
        $this->InspectionReport->setupEditAttributes();
        $this->InspectionReport->EditValue = $this->InspectionReport->CurrentValue;
        $this->InspectionReport->PlaceHolder = RemoveHtml($this->InspectionReport->caption());

        // InspectionDate
        $this->InspectionDate->setupEditAttributes();
        $this->InspectionDate->EditValue = FormatDateTime($this->InspectionDate->CurrentValue, $this->InspectionDate->formatPattern());
        $this->InspectionDate->PlaceHolder = RemoveHtml($this->InspectionDate->caption());

        // InspectedBy
        $this->InspectedBy->setupEditAttributes();
        if (!$this->InspectedBy->Raw) {
            $this->InspectedBy->CurrentValue = HtmlDecode($this->InspectedBy->CurrentValue);
        }
        $this->InspectedBy->EditValue = $this->InspectedBy->CurrentValue;
        $this->InspectedBy->PlaceHolder = RemoveHtml($this->InspectedBy->caption());

        // AuthorisedBy
        $this->AuthorisedBy->setupEditAttributes();
        if (!$this->AuthorisedBy->Raw) {
            $this->AuthorisedBy->CurrentValue = HtmlDecode($this->AuthorisedBy->CurrentValue);
        }
        $this->AuthorisedBy->EditValue = $this->AuthorisedBy->CurrentValue;
        $this->AuthorisedBy->PlaceHolder = RemoveHtml($this->AuthorisedBy->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->CampCode);
                    $doc->exportCaption($this->VillageCode);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->FarmerNo);
                    $doc->exportCaption($this->FarmNo);
                    $doc->exportCaption($this->InspectionTransNo);
                    $doc->exportCaption($this->PlantsDead);
                    $doc->exportCaption($this->PlantsVerifiedNo);
                    $doc->exportCaption($this->PlantsReplaced);
                    $doc->exportCaption($this->FungicidesReceived);
                    $doc->exportCaption($this->PescticidesReceived);
                    $doc->exportCaption($this->DiseasePresence);
                    $doc->exportCaption($this->AvailableLand);
                    $doc->exportCaption($this->LandForCashewCleared);
                    $doc->exportCaption($this->HolesDug);
                    $doc->exportCaption($this->VerifiedSeedlingArea);
                    $doc->exportCaption($this->OldTreesNo);
                    $doc->exportCaption($this->InspectionReport);
                    $doc->exportCaption($this->InspectionDate);
                    $doc->exportCaption($this->InspectedBy);
                    $doc->exportCaption($this->AuthorisedBy);
                } else {
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->CampCode);
                    $doc->exportCaption($this->VillageCode);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->FarmerNo);
                    $doc->exportCaption($this->FarmNo);
                    $doc->exportCaption($this->InspectionTransNo);
                    $doc->exportCaption($this->PlantsDead);
                    $doc->exportCaption($this->PlantsVerifiedNo);
                    $doc->exportCaption($this->PlantsReplaced);
                    $doc->exportCaption($this->FungicidesReceived);
                    $doc->exportCaption($this->PescticidesReceived);
                    $doc->exportCaption($this->DiseasePresence);
                    $doc->exportCaption($this->AvailableLand);
                    $doc->exportCaption($this->LandForCashewCleared);
                    $doc->exportCaption($this->HolesDug);
                    $doc->exportCaption($this->VerifiedSeedlingArea);
                    $doc->exportCaption($this->OldTreesNo);
                    $doc->exportCaption($this->InspectionDate);
                    $doc->exportCaption($this->InspectedBy);
                    $doc->exportCaption($this->AuthorisedBy);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->CampCode);
                        $doc->exportField($this->VillageCode);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->FarmerNo);
                        $doc->exportField($this->FarmNo);
                        $doc->exportField($this->InspectionTransNo);
                        $doc->exportField($this->PlantsDead);
                        $doc->exportField($this->PlantsVerifiedNo);
                        $doc->exportField($this->PlantsReplaced);
                        $doc->exportField($this->FungicidesReceived);
                        $doc->exportField($this->PescticidesReceived);
                        $doc->exportField($this->DiseasePresence);
                        $doc->exportField($this->AvailableLand);
                        $doc->exportField($this->LandForCashewCleared);
                        $doc->exportField($this->HolesDug);
                        $doc->exportField($this->VerifiedSeedlingArea);
                        $doc->exportField($this->OldTreesNo);
                        $doc->exportField($this->InspectionReport);
                        $doc->exportField($this->InspectionDate);
                        $doc->exportField($this->InspectedBy);
                        $doc->exportField($this->AuthorisedBy);
                    } else {
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->CampCode);
                        $doc->exportField($this->VillageCode);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->FarmerNo);
                        $doc->exportField($this->FarmNo);
                        $doc->exportField($this->InspectionTransNo);
                        $doc->exportField($this->PlantsDead);
                        $doc->exportField($this->PlantsVerifiedNo);
                        $doc->exportField($this->PlantsReplaced);
                        $doc->exportField($this->FungicidesReceived);
                        $doc->exportField($this->PescticidesReceived);
                        $doc->exportField($this->DiseasePresence);
                        $doc->exportField($this->AvailableLand);
                        $doc->exportField($this->LandForCashewCleared);
                        $doc->exportField($this->HolesDug);
                        $doc->exportField($this->VerifiedSeedlingArea);
                        $doc->exportField($this->OldTreesNo);
                        $doc->exportField($this->InspectionDate);
                        $doc->exportField($this->InspectedBy);
                        $doc->exportField($this->AuthorisedBy);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter) {
    	// Enter your code here
    	$username = CurrentUserName(); 
    	$levelid = CurrentUserLevel();
    	$row = executeRow("select role from musers where username = '" . $username . "'");

    	/*set filter for province
    	$prov = executeRow("select count(security_matrix.ProvinceCode)as kountprov 
    	from security_matrix, musers
    	where security_matrix.usercode = musers.usercode and security_matrix.ProvinceCode is not null  
    	and musers.username = '" . $username .     "'  ");
    	if(($levelid <> -1) && ($prov["kountprov"] > 0)) {				//levelid -1 is for admin
    	AddFilter($filter,"`ProvinceCode`  in   (select DISTINCT security_matrix.ProvinceCode
    	from security_matrix, musers                            
    	where security_matrix.usercode = musers.usercode 
    	and musers.username = '" . $username .  	"')  ");
    	} */

    	//set filter for district
    	$dis = executeRow("select count(security_matrix.DistrictCode)as kountdistrict 
    	from security_matrix, musers
    	where security_matrix.usercode = musers.usercode and security_matrix.DistrictCode is not null  
    	and musers.username = '" . $username .     "'  ");
    	if(($levelid <> -1) && ($dis["kountdistrict"] > 0)) {				//levelid -1 is for admin
    	AddFilter($filter,"`DistrictCode`  in   (select DISTINCT security_matrix.DistrictCode
    	from security_matrix, musers                            
    	where security_matrix.usercode = musers.usercode 
    	and musers.username = '" . $username .  	"')  ");
    	}
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew) {
    	// Enter your code here
    	// To cancel, set return value to FALSE
    	if($rsnew[TotalWorkers] <> ($rsnew[MaleAdultWorkers] + $rsnew[FemaleAdultWorkers] + $rsnew[FemaleYouthWorkers] +
    	$rsnew[MaleYouthWorkers])) {
    	// Return error if numbers do not add up
    		$this->CancelMessage =  "Toal workers do not match sum of adults and youths " ;
    		 return FALSE;
    	}
    	return TRUE;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew) {
    	//echo "Row Inserted"
    	$dead = $rsnew["PlantsDead"];
    	$verify = $rsnew["PlantsVerifiedNo"];
    	$replace = $rsnew["PlantsReplaced"];
    	$holes = $rsnew["HolesDug"];
    	$clr = $rsnew["LandForCasheCleared"];
    	$oldtree = $rsnew["OldTreeNo"];
    	$farmno = $rsnew["FarmNo"];
    	execute("update farm set OldTrees = '" . $oldtree . "', ClearedLand = '"
    	 . $clr . "' , TreesPlantedVerified = '" . $verify . "' where FarmNo = '" . $farmno . "'");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
