<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class FarmEdit extends Farm
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "FarmEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "FarmEdit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ProvinceCode->setVisibility();
        $this->DistrictCode->setVisibility();
        $this->CampCode->setVisibility();
        $this->VillageCode->setVisibility();
        $this->NRC->setVisibility();
        $this->FarmNo->setVisibility();
        $this->FarmerNo->Visible = false;
        $this->FieldType->setVisibility();
        $this->Ownership->setVisibility();
        $this->SeedlingsAllocated->Visible = false;
        $this->TreesPlantedEstimated->Visible = false;
        $this->FarmSizeEstimated->Visible = false;
        $this->FarmSizeVerified->setVisibility();
        $this->TreesPlantedVerified->setVisibility();
        $this->SourcesOfSeedlings->Visible = false;
        $this->InspecationReport->setVisibility();
        $this->ClearedLand->setVisibility();
        $this->OldTrees->setVisibility();
        $this->FarmSize->setVisibility();
        $this->Latitude->setVisibility();
        $this->Longitude->setVisibility();
        $this->Coordinates->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'farm';
        $this->TableName = 'farm';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (farm)
        if (!isset($GLOBALS["farm"]) || $GLOBALS["farm"]::class == PROJECT_NAMESPACE . "farm") {
            $GLOBALS["farm"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'farm');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "FarmView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['FarmNo'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->FarmNo->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;
    public $DetailPages; // Detail pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up detail page object
        $this->setupDetailPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->ProvinceCode);
        $this->setupLookupOptions($this->DistrictCode);
        $this->setupLookupOptions($this->CampCode);
        $this->setupLookupOptions($this->VillageCode);
        $this->setupLookupOptions($this->NRC);
        $this->setupLookupOptions($this->FieldType);
        $this->setupLookupOptions($this->Ownership);
        $this->setupLookupOptions($this->SourcesOfSeedlings);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Load record by position
        $loadByPosition = false;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("FarmNo") ?? Key(0) ?? Route(2)) !== null) {
                $this->FarmNo->setQueryStringValue($keyValue);
                $this->FarmNo->setOldValue($this->FarmNo->QueryStringValue);
            } elseif (Post("FarmNo") !== null) {
                $this->FarmNo->setFormValue(Post("FarmNo"));
                $this->FarmNo->setOldValue($this->FarmNo->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("FarmNo") ?? Route("FarmNo")) !== null) {
                    $this->FarmNo->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->FarmNo->CurrentValue = null;
                }
                if (!$loadByQuery || Get(Config("TABLE_START_REC")) !== null || Get(Config("TABLE_PAGE_NUMBER")) !== null) {
                    $loadByPosition = true;
                }
            }

            // Set up master detail parameters
            $this->setupMasterParms();

            // Load result set
            if ($this->isShow()) {
                if (!$this->IsModal) { // Normal edit page
                    $this->StartRecord = 1; // Initialize start position
                    $this->Recordset = $this->loadRecordset(); // Load records
                    if ($this->TotalRecords <= 0) { // No record found
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("FarmList"); // Return to list page
                        return;
                    } elseif ($loadByPosition) { // Load record by position
                        $this->setupStartRecord(); // Set up start record position
                        // Point to current record
                        if ($this->StartRecord <= $this->TotalRecords) {
                            $this->fetch($this->StartRecord);
                            // Redirect to correct record
                            $this->loadRowValues($this->CurrentRow);
                            $url = $this->getCurrentUrl(Config("TABLE_SHOW_DETAIL") . "=" . $this->getCurrentDetailTable());
                            $this->terminate($url);
                            return;
                        }
                    } else { // Match key values
                        if ($this->FarmNo->CurrentValue != null) {
                            while ($this->fetch()) {
                                if (SameString($this->FarmNo->CurrentValue, $this->CurrentRow['FarmNo'])) {
                                    $this->setStartRecordNumber($this->StartRecord); // Save record position
                                    $loaded = true;
                                    break;
                                } else {
                                    $this->StartRecord++;
                                }
                            }
                        }
                    }

                    // Load current row values
                    if ($loaded) {
                        $this->loadRowValues($this->CurrentRow);
                    }
                } else {
                    // Load current record
                    $loaded = $this->loadRow();
                } // End modal checking
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values

            // Set up detail parameters
            $this->setupDetailParms();
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                if (!$this->IsModal) { // Normal edit page
                    if (!$loaded) {
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("FarmList"); // Return to list page
                        return;
                    } else {
                    }
                } else { // Modal edit page
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("FarmList"); // No matching record, return to list
                        return;
                    }
                } // End modal checking

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "update": // Update
                if ($this->getCurrentDetailTable() != "") { // Master/detail edit
                    $returnUrl = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $this->getCurrentDetailTable()); // Master/Detail view page
                } else {
                    $returnUrl = $this->getReturnUrl();
                }
                if (GetPageName($returnUrl) == "FarmList") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "FarmList") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "FarmList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();
        if (!$this->IsModal) { // Normal view page
            $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, "", $this->RecordRange, $this->AutoHidePager, false, false);
            $this->Pager->PageNumberName = Config("TABLE_PAGE_NUMBER");
            $this->Pager->PagePhraseId = "Record"; // Show as record
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'ProvinceCode' first before field var 'x_ProvinceCode'
        $val = $CurrentForm->hasValue("ProvinceCode") ? $CurrentForm->getValue("ProvinceCode") : $CurrentForm->getValue("x_ProvinceCode");
        if (!$this->ProvinceCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ProvinceCode->Visible = false; // Disable update for API request
            } else {
                $this->ProvinceCode->setFormValue($val);
            }
        }

        // Check field name 'DistrictCode' first before field var 'x_DistrictCode'
        $val = $CurrentForm->hasValue("DistrictCode") ? $CurrentForm->getValue("DistrictCode") : $CurrentForm->getValue("x_DistrictCode");
        if (!$this->DistrictCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DistrictCode->Visible = false; // Disable update for API request
            } else {
                $this->DistrictCode->setFormValue($val);
            }
        }

        // Check field name 'CampCode' first before field var 'x_CampCode'
        $val = $CurrentForm->hasValue("CampCode") ? $CurrentForm->getValue("CampCode") : $CurrentForm->getValue("x_CampCode");
        if (!$this->CampCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->CampCode->Visible = false; // Disable update for API request
            } else {
                $this->CampCode->setFormValue($val);
            }
        }

        // Check field name 'VillageCode' first before field var 'x_VillageCode'
        $val = $CurrentForm->hasValue("VillageCode") ? $CurrentForm->getValue("VillageCode") : $CurrentForm->getValue("x_VillageCode");
        if (!$this->VillageCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->VillageCode->Visible = false; // Disable update for API request
            } else {
                $this->VillageCode->setFormValue($val);
            }
        }

        // Check field name 'NRC' first before field var 'x_NRC'
        $val = $CurrentForm->hasValue("NRC") ? $CurrentForm->getValue("NRC") : $CurrentForm->getValue("x_NRC");
        if (!$this->NRC->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NRC->Visible = false; // Disable update for API request
            } else {
                $this->NRC->setFormValue($val);
            }
        }

        // Check field name 'FarmNo' first before field var 'x_FarmNo'
        $val = $CurrentForm->hasValue("FarmNo") ? $CurrentForm->getValue("FarmNo") : $CurrentForm->getValue("x_FarmNo");
        if (!$this->FarmNo->IsDetailKey) {
            $this->FarmNo->setFormValue($val);
        }

        // Check field name 'FieldType' first before field var 'x_FieldType'
        $val = $CurrentForm->hasValue("FieldType") ? $CurrentForm->getValue("FieldType") : $CurrentForm->getValue("x_FieldType");
        if (!$this->FieldType->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FieldType->Visible = false; // Disable update for API request
            } else {
                $this->FieldType->setFormValue($val);
            }
        }

        // Check field name 'Ownership' first before field var 'x_Ownership'
        $val = $CurrentForm->hasValue("Ownership") ? $CurrentForm->getValue("Ownership") : $CurrentForm->getValue("x_Ownership");
        if (!$this->Ownership->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Ownership->Visible = false; // Disable update for API request
            } else {
                $this->Ownership->setFormValue($val);
            }
        }

        // Check field name 'FarmSizeVerified' first before field var 'x_FarmSizeVerified'
        $val = $CurrentForm->hasValue("FarmSizeVerified") ? $CurrentForm->getValue("FarmSizeVerified") : $CurrentForm->getValue("x_FarmSizeVerified");
        if (!$this->FarmSizeVerified->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmSizeVerified->Visible = false; // Disable update for API request
            } else {
                $this->FarmSizeVerified->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'TreesPlantedVerified' first before field var 'x_TreesPlantedVerified'
        $val = $CurrentForm->hasValue("TreesPlantedVerified") ? $CurrentForm->getValue("TreesPlantedVerified") : $CurrentForm->getValue("x_TreesPlantedVerified");
        if (!$this->TreesPlantedVerified->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->TreesPlantedVerified->Visible = false; // Disable update for API request
            } else {
                $this->TreesPlantedVerified->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'InspecationReport' first before field var 'x_InspecationReport'
        $val = $CurrentForm->hasValue("InspecationReport") ? $CurrentForm->getValue("InspecationReport") : $CurrentForm->getValue("x_InspecationReport");
        if (!$this->InspecationReport->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->InspecationReport->Visible = false; // Disable update for API request
            } else {
                $this->InspecationReport->setFormValue($val);
            }
        }

        // Check field name 'ClearedLand' first before field var 'x_ClearedLand'
        $val = $CurrentForm->hasValue("ClearedLand") ? $CurrentForm->getValue("ClearedLand") : $CurrentForm->getValue("x_ClearedLand");
        if (!$this->ClearedLand->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ClearedLand->Visible = false; // Disable update for API request
            } else {
                $this->ClearedLand->setFormValue($val);
            }
        }

        // Check field name 'OldTrees' first before field var 'x_OldTrees'
        $val = $CurrentForm->hasValue("OldTrees") ? $CurrentForm->getValue("OldTrees") : $CurrentForm->getValue("x_OldTrees");
        if (!$this->OldTrees->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->OldTrees->Visible = false; // Disable update for API request
            } else {
                $this->OldTrees->setFormValue($val);
            }
        }

        // Check field name 'FarmSize' first before field var 'x_FarmSize'
        $val = $CurrentForm->hasValue("FarmSize") ? $CurrentForm->getValue("FarmSize") : $CurrentForm->getValue("x_FarmSize");
        if (!$this->FarmSize->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmSize->Visible = false; // Disable update for API request
            } else {
                $this->FarmSize->setFormValue($val);
            }
        }

        // Check field name 'Latitude' first before field var 'x_Latitude'
        $val = $CurrentForm->hasValue("Latitude") ? $CurrentForm->getValue("Latitude") : $CurrentForm->getValue("x_Latitude");
        if (!$this->Latitude->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Latitude->Visible = false; // Disable update for API request
            } else {
                $this->Latitude->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Longitude' first before field var 'x_Longitude'
        $val = $CurrentForm->hasValue("Longitude") ? $CurrentForm->getValue("Longitude") : $CurrentForm->getValue("x_Longitude");
        if (!$this->Longitude->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Longitude->Visible = false; // Disable update for API request
            } else {
                $this->Longitude->setFormValue($val, true, $validate);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->ProvinceCode->CurrentValue = $this->ProvinceCode->FormValue;
        $this->DistrictCode->CurrentValue = $this->DistrictCode->FormValue;
        $this->CampCode->CurrentValue = $this->CampCode->FormValue;
        $this->VillageCode->CurrentValue = $this->VillageCode->FormValue;
        $this->NRC->CurrentValue = $this->NRC->FormValue;
        $this->FarmNo->CurrentValue = $this->FarmNo->FormValue;
        $this->FieldType->CurrentValue = $this->FieldType->FormValue;
        $this->Ownership->CurrentValue = $this->Ownership->FormValue;
        $this->FarmSizeVerified->CurrentValue = $this->FarmSizeVerified->FormValue;
        $this->TreesPlantedVerified->CurrentValue = $this->TreesPlantedVerified->FormValue;
        $this->InspecationReport->CurrentValue = $this->InspecationReport->FormValue;
        $this->ClearedLand->CurrentValue = $this->ClearedLand->FormValue;
        $this->OldTrees->CurrentValue = $this->OldTrees->FormValue;
        $this->FarmSize->CurrentValue = $this->FarmSize->FormValue;
        $this->Latitude->CurrentValue = $this->Latitude->FormValue;
        $this->Longitude->CurrentValue = $this->Longitude->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->VillageCode->setDbValue($row['VillageCode']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmNo->setDbValue($row['FarmNo']);
        $this->FarmerNo->setDbValue($row['FarmerNo']);
        $this->FieldType->setDbValue($row['FieldType']);
        $this->Ownership->setDbValue($row['Ownership']);
        $this->SeedlingsAllocated->setDbValue($row['SeedlingsAllocated']);
        $this->TreesPlantedEstimated->setDbValue($row['TreesPlantedEstimated']);
        $this->FarmSizeEstimated->setDbValue($row['FarmSizeEstimated']);
        $this->FarmSizeVerified->setDbValue($row['FarmSizeVerified']);
        $this->TreesPlantedVerified->setDbValue($row['TreesPlantedVerified']);
        $this->SourcesOfSeedlings->setDbValue($row['SourcesOfSeedlings']);
        $this->InspecationReport->setDbValue($row['InspecationReport']);
        $this->ClearedLand->setDbValue($row['ClearedLand']);
        $this->OldTrees->setDbValue($row['OldTrees']);
        $this->FarmSize->setDbValue($row['FarmSize']);
        $this->Latitude->setDbValue($row['Latitude']);
        $this->Longitude->setDbValue($row['Longitude']);
        $this->Coordinates->setDbValue($row['Coordinates']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ProvinceCode'] = $this->ProvinceCode->DefaultValue;
        $row['DistrictCode'] = $this->DistrictCode->DefaultValue;
        $row['CampCode'] = $this->CampCode->DefaultValue;
        $row['VillageCode'] = $this->VillageCode->DefaultValue;
        $row['NRC'] = $this->NRC->DefaultValue;
        $row['FarmNo'] = $this->FarmNo->DefaultValue;
        $row['FarmerNo'] = $this->FarmerNo->DefaultValue;
        $row['FieldType'] = $this->FieldType->DefaultValue;
        $row['Ownership'] = $this->Ownership->DefaultValue;
        $row['SeedlingsAllocated'] = $this->SeedlingsAllocated->DefaultValue;
        $row['TreesPlantedEstimated'] = $this->TreesPlantedEstimated->DefaultValue;
        $row['FarmSizeEstimated'] = $this->FarmSizeEstimated->DefaultValue;
        $row['FarmSizeVerified'] = $this->FarmSizeVerified->DefaultValue;
        $row['TreesPlantedVerified'] = $this->TreesPlantedVerified->DefaultValue;
        $row['SourcesOfSeedlings'] = $this->SourcesOfSeedlings->DefaultValue;
        $row['InspecationReport'] = $this->InspecationReport->DefaultValue;
        $row['ClearedLand'] = $this->ClearedLand->DefaultValue;
        $row['OldTrees'] = $this->OldTrees->DefaultValue;
        $row['FarmSize'] = $this->FarmSize->DefaultValue;
        $row['Latitude'] = $this->Latitude->DefaultValue;
        $row['Longitude'] = $this->Longitude->DefaultValue;
        $row['Coordinates'] = $this->Coordinates->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProvinceCode
        $this->ProvinceCode->RowCssClass = "row";

        // DistrictCode
        $this->DistrictCode->RowCssClass = "row";

        // CampCode
        $this->CampCode->RowCssClass = "row";

        // VillageCode
        $this->VillageCode->RowCssClass = "row";

        // NRC
        $this->NRC->RowCssClass = "row";

        // FarmNo
        $this->FarmNo->RowCssClass = "row";

        // FarmerNo
        $this->FarmerNo->RowCssClass = "row";

        // FieldType
        $this->FieldType->RowCssClass = "row";

        // Ownership
        $this->Ownership->RowCssClass = "row";

        // SeedlingsAllocated
        $this->SeedlingsAllocated->RowCssClass = "row";

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->RowCssClass = "row";

        // FarmSizeEstimated
        $this->FarmSizeEstimated->RowCssClass = "row";

        // FarmSizeVerified
        $this->FarmSizeVerified->RowCssClass = "row";

        // TreesPlantedVerified
        $this->TreesPlantedVerified->RowCssClass = "row";

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->RowCssClass = "row";

        // InspecationReport
        $this->InspecationReport->RowCssClass = "row";

        // ClearedLand
        $this->ClearedLand->RowCssClass = "row";

        // OldTrees
        $this->OldTrees->RowCssClass = "row";

        // FarmSize
        $this->FarmSize->RowCssClass = "row";

        // Latitude
        $this->Latitude->RowCssClass = "row";

        // Longitude
        $this->Longitude->RowCssClass = "row";

        // Coordinates
        $this->Coordinates->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProvinceCode
            $curVal = strval($this->ProvinceCode->CurrentValue);
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                    } else {
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                    }
                }
            } else {
                $this->ProvinceCode->ViewValue = null;
            }

            // DistrictCode
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }

            // CampCode
            $curVal = strval($this->CampCode->CurrentValue);
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                if ($this->CampCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                    }
                }
            } else {
                $this->CampCode->ViewValue = null;
            }

            // VillageCode
            $curVal = strval($this->VillageCode->CurrentValue);
            if ($curVal != "") {
                $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                if ($this->VillageCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                    }
                }
            } else {
                $this->VillageCode->ViewValue = null;
            }

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;
            $curVal = strval($this->NRC->CurrentValue);
            if ($curVal != "") {
                $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->ViewValue = $this->NRC->CurrentValue;
                    }
                }
            } else {
                $this->NRC->ViewValue = null;
            }

            // FarmNo
            $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;

            // FieldType
            $curVal = strval($this->FieldType->CurrentValue);
            if ($curVal != "") {
                $this->FieldType->ViewValue = $this->FieldType->lookupCacheOption($curVal);
                if ($this->FieldType->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchExpression(), "=", $curVal, $this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchDataType(), "");
                    $sqlWrk = $this->FieldType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->FieldType->Lookup->renderViewRow($rswrk[0]);
                        $this->FieldType->ViewValue = $this->FieldType->displayValue($arwrk);
                    } else {
                        $this->FieldType->ViewValue = $this->FieldType->CurrentValue;
                    }
                }
            } else {
                $this->FieldType->ViewValue = null;
            }

            // Ownership
            $curVal = strval($this->Ownership->CurrentValue);
            if ($curVal != "") {
                $this->Ownership->ViewValue = $this->Ownership->lookupCacheOption($curVal);
                if ($this->Ownership->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchExpression(), "=", $curVal, $this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchDataType(), "");
                    $sqlWrk = $this->Ownership->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Ownership->Lookup->renderViewRow($rswrk[0]);
                        $this->Ownership->ViewValue = $this->Ownership->displayValue($arwrk);
                    } else {
                        $this->Ownership->ViewValue = $this->Ownership->CurrentValue;
                    }
                }
            } else {
                $this->Ownership->ViewValue = null;
            }

            // SeedlingsAllocated
            $this->SeedlingsAllocated->ViewValue = $this->SeedlingsAllocated->CurrentValue;
            $this->SeedlingsAllocated->ViewValue = FormatNumber($this->SeedlingsAllocated->ViewValue, $this->SeedlingsAllocated->formatPattern());

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->ViewValue = $this->TreesPlantedEstimated->CurrentValue;
            $this->TreesPlantedEstimated->ViewValue = FormatNumber($this->TreesPlantedEstimated->ViewValue, $this->TreesPlantedEstimated->formatPattern());

            // FarmSizeEstimated
            $this->FarmSizeEstimated->ViewValue = $this->FarmSizeEstimated->CurrentValue;
            $this->FarmSizeEstimated->ViewValue = FormatNumber($this->FarmSizeEstimated->ViewValue, $this->FarmSizeEstimated->formatPattern());

            // FarmSizeVerified
            $this->FarmSizeVerified->ViewValue = $this->FarmSizeVerified->CurrentValue;
            $this->FarmSizeVerified->ViewValue = FormatNumber($this->FarmSizeVerified->ViewValue, $this->FarmSizeVerified->formatPattern());

            // TreesPlantedVerified
            $this->TreesPlantedVerified->ViewValue = $this->TreesPlantedVerified->CurrentValue;
            $this->TreesPlantedVerified->ViewValue = FormatNumber($this->TreesPlantedVerified->ViewValue, $this->TreesPlantedVerified->formatPattern());

            // SourcesOfSeedlings
            $curVal = strval($this->SourcesOfSeedlings->CurrentValue);
            if ($curVal != "") {
                $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->lookupCacheOption($curVal);
                if ($this->SourcesOfSeedlings->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                    $sqlWrk = $this->SourcesOfSeedlings->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SourcesOfSeedlings->Lookup->renderViewRow($rswrk[0]);
                        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->displayValue($arwrk);
                    } else {
                        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->CurrentValue;
                    }
                }
            } else {
                $this->SourcesOfSeedlings->ViewValue = null;
            }

            // InspecationReport
            $this->InspecationReport->ViewValue = $this->InspecationReport->CurrentValue;

            // ClearedLand
            $this->ClearedLand->ViewValue = $this->ClearedLand->CurrentValue;

            // OldTrees
            $this->OldTrees->ViewValue = $this->OldTrees->CurrentValue;

            // FarmSize
            $this->FarmSize->ViewValue = $this->FarmSize->CurrentValue;

            // Latitude
            $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
            $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());

            // Longitude
            $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
            $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";

            // FieldType
            $this->FieldType->HrefValue = "";

            // Ownership
            $this->Ownership->HrefValue = "";

            // FarmSizeVerified
            $this->FarmSizeVerified->HrefValue = "";

            // TreesPlantedVerified
            $this->TreesPlantedVerified->HrefValue = "";

            // InspecationReport
            $this->InspecationReport->HrefValue = "";

            // ClearedLand
            $this->ClearedLand->HrefValue = "";

            // OldTrees
            $this->OldTrees->HrefValue = "";

            // FarmSize
            $this->FarmSize->HrefValue = "";

            // Latitude
            $this->Latitude->HrefValue = "";

            // Longitude
            $this->Longitude->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // ProvinceCode
            $this->ProvinceCode->setupEditAttributes();
            if ($this->ProvinceCode->getSessionValue() != "") {
                $this->ProvinceCode->CurrentValue = GetForeignKeyValue($this->ProvinceCode->getSessionValue());
                $curVal = strval($this->ProvinceCode->CurrentValue);
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                    if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                        $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                        $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                        } else {
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                        }
                    }
                } else {
                    $this->ProvinceCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->ProvinceCode->CurrentValue));
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                } else {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->Lookup !== null && is_array($this->ProvinceCode->lookupOptions()) && count($this->ProvinceCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->ProvinceCode->ViewValue !== null) { // Load from cache
                    $this->ProvinceCode->EditValue = array_values($this->ProvinceCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $this->ProvinceCode->CurrentValue, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->ProvinceCode->EditValue = $arwrk;
                }
                $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
            }

            // DistrictCode
            if ($this->DistrictCode->getSessionValue() != "") {
                $this->DistrictCode->CurrentValue = GetForeignKeyValue($this->DistrictCode->getSessionValue());
                $curVal = strval($this->DistrictCode->CurrentValue);
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                    if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                        $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                            $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                        } else {
                            $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                        }
                    }
                } else {
                    $this->DistrictCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->DistrictCode->CurrentValue));
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                } else {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->Lookup !== null && is_array($this->DistrictCode->lookupOptions()) && count($this->DistrictCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->DistrictCode->ViewValue !== null) { // Load from cache
                    $this->DistrictCode->EditValue = array_values($this->DistrictCode->lookupOptions());
                    if ($this->DistrictCode->ViewValue == "") {
                        $this->DistrictCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->DistrictCode->CurrentValue, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->DistrictCode->EditValue = $arwrk;
                }
                $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
            }

            // CampCode
            if ($this->CampCode->getSessionValue() != "") {
                $this->CampCode->CurrentValue = GetForeignKeyValue($this->CampCode->getSessionValue());
                $curVal = strval($this->CampCode->CurrentValue);
                if ($curVal != "") {
                    $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                    if ($this->CampCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                        $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                            $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                        } else {
                            $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                        }
                    }
                } else {
                    $this->CampCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->CampCode->CurrentValue));
                if ($curVal != "") {
                    $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                } else {
                    $this->CampCode->ViewValue = $this->CampCode->Lookup !== null && is_array($this->CampCode->lookupOptions()) && count($this->CampCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->CampCode->ViewValue !== null) { // Load from cache
                    $this->CampCode->EditValue = array_values($this->CampCode->lookupOptions());
                    if ($this->CampCode->ViewValue == "") {
                        $this->CampCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $this->CampCode->CurrentValue, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->CampCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->CampCode->EditValue = $arwrk;
                }
                $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());
            }

            // VillageCode
            if ($this->VillageCode->getSessionValue() != "") {
                $this->VillageCode->CurrentValue = GetForeignKeyValue($this->VillageCode->getSessionValue());
                $curVal = strval($this->VillageCode->CurrentValue);
                if ($curVal != "") {
                    $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                    if ($this->VillageCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                        $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                            $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                        } else {
                            $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                        }
                    }
                } else {
                    $this->VillageCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->VillageCode->CurrentValue));
                if ($curVal != "") {
                    $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                } else {
                    $this->VillageCode->ViewValue = $this->VillageCode->Lookup !== null && is_array($this->VillageCode->lookupOptions()) && count($this->VillageCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->VillageCode->ViewValue !== null) { // Load from cache
                    $this->VillageCode->EditValue = array_values($this->VillageCode->lookupOptions());
                    if ($this->VillageCode->ViewValue == "") {
                        $this->VillageCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $this->VillageCode->CurrentValue, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->VillageCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->VillageCode->EditValue = $arwrk;
                }
                $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());
            }

            // NRC
            $this->NRC->setupEditAttributes();
            if ($this->NRC->getSessionValue() != "") {
                $this->NRC->CurrentValue = GetForeignKeyValue($this->NRC->getSessionValue());
                $this->NRC->ViewValue = $this->NRC->CurrentValue;
                $curVal = strval($this->NRC->CurrentValue);
                if ($curVal != "") {
                    $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                    if ($this->NRC->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                        $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                            $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                        } else {
                            $this->NRC->ViewValue = $this->NRC->CurrentValue;
                        }
                    }
                } else {
                    $this->NRC->ViewValue = null;
                }
            } else {
                if (!$this->NRC->Raw) {
                    $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
                }
                $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
                $curVal = strval($this->NRC->CurrentValue);
                if ($curVal != "") {
                    $this->NRC->EditValue = $this->NRC->lookupCacheOption($curVal);
                    if ($this->NRC->EditValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                        $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                            $this->NRC->EditValue = $this->NRC->displayValue($arwrk);
                        } else {
                            $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
                        }
                    }
                } else {
                    $this->NRC->EditValue = null;
                }
                $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());
            }

            // FarmNo
            $this->FarmNo->setupEditAttributes();
            $this->FarmNo->EditValue = $this->FarmNo->CurrentValue;

            // FieldType
            $this->FieldType->setupEditAttributes();
            $curVal = trim(strval($this->FieldType->CurrentValue));
            if ($curVal != "") {
                $this->FieldType->ViewValue = $this->FieldType->lookupCacheOption($curVal);
            } else {
                $this->FieldType->ViewValue = $this->FieldType->Lookup !== null && is_array($this->FieldType->lookupOptions()) && count($this->FieldType->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->FieldType->ViewValue !== null) { // Load from cache
                $this->FieldType->EditValue = array_values($this->FieldType->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchExpression(), "=", $this->FieldType->CurrentValue, $this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchDataType(), "");
                }
                $sqlWrk = $this->FieldType->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->FieldType->EditValue = $arwrk;
            }
            $this->FieldType->PlaceHolder = RemoveHtml($this->FieldType->caption());

            // Ownership
            $this->Ownership->setupEditAttributes();
            $curVal = trim(strval($this->Ownership->CurrentValue));
            if ($curVal != "") {
                $this->Ownership->ViewValue = $this->Ownership->lookupCacheOption($curVal);
            } else {
                $this->Ownership->ViewValue = $this->Ownership->Lookup !== null && is_array($this->Ownership->lookupOptions()) && count($this->Ownership->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Ownership->ViewValue !== null) { // Load from cache
                $this->Ownership->EditValue = array_values($this->Ownership->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchExpression(), "=", $this->Ownership->CurrentValue, $this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchDataType(), "");
                }
                $sqlWrk = $this->Ownership->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Ownership->EditValue = $arwrk;
            }
            $this->Ownership->PlaceHolder = RemoveHtml($this->Ownership->caption());

            // FarmSizeVerified
            $this->FarmSizeVerified->setupEditAttributes();
            $this->FarmSizeVerified->EditValue = $this->FarmSizeVerified->CurrentValue;
            $this->FarmSizeVerified->PlaceHolder = RemoveHtml($this->FarmSizeVerified->caption());
            if (strval($this->FarmSizeVerified->EditValue) != "" && is_numeric($this->FarmSizeVerified->EditValue)) {
                $this->FarmSizeVerified->EditValue = FormatNumber($this->FarmSizeVerified->EditValue, null);
            }

            // TreesPlantedVerified
            $this->TreesPlantedVerified->setupEditAttributes();
            $this->TreesPlantedVerified->EditValue = $this->TreesPlantedVerified->CurrentValue;
            $this->TreesPlantedVerified->PlaceHolder = RemoveHtml($this->TreesPlantedVerified->caption());
            if (strval($this->TreesPlantedVerified->EditValue) != "" && is_numeric($this->TreesPlantedVerified->EditValue)) {
                $this->TreesPlantedVerified->EditValue = FormatNumber($this->TreesPlantedVerified->EditValue, null);
            }

            // InspecationReport
            $this->InspecationReport->setupEditAttributes();
            $this->InspecationReport->EditValue = HtmlEncode($this->InspecationReport->CurrentValue);
            $this->InspecationReport->PlaceHolder = RemoveHtml($this->InspecationReport->caption());

            // ClearedLand
            $this->ClearedLand->setupEditAttributes();
            if (!$this->ClearedLand->Raw) {
                $this->ClearedLand->CurrentValue = HtmlDecode($this->ClearedLand->CurrentValue);
            }
            $this->ClearedLand->EditValue = HtmlEncode($this->ClearedLand->CurrentValue);
            $this->ClearedLand->PlaceHolder = RemoveHtml($this->ClearedLand->caption());

            // OldTrees
            $this->OldTrees->setupEditAttributes();
            if (!$this->OldTrees->Raw) {
                $this->OldTrees->CurrentValue = HtmlDecode($this->OldTrees->CurrentValue);
            }
            $this->OldTrees->EditValue = HtmlEncode($this->OldTrees->CurrentValue);
            $this->OldTrees->PlaceHolder = RemoveHtml($this->OldTrees->caption());

            // FarmSize
            $this->FarmSize->setupEditAttributes();
            if (!$this->FarmSize->Raw) {
                $this->FarmSize->CurrentValue = HtmlDecode($this->FarmSize->CurrentValue);
            }
            $this->FarmSize->EditValue = HtmlEncode($this->FarmSize->CurrentValue);
            $this->FarmSize->PlaceHolder = RemoveHtml($this->FarmSize->caption());

            // Latitude
            $this->Latitude->setupEditAttributes();
            $this->Latitude->EditValue = $this->Latitude->CurrentValue;
            $this->Latitude->PlaceHolder = RemoveHtml($this->Latitude->caption());
            if (strval($this->Latitude->EditValue) != "" && is_numeric($this->Latitude->EditValue)) {
                $this->Latitude->EditValue = FormatNumber($this->Latitude->EditValue, null);
            }

            // Longitude
            $this->Longitude->setupEditAttributes();
            $this->Longitude->EditValue = $this->Longitude->CurrentValue;
            $this->Longitude->PlaceHolder = RemoveHtml($this->Longitude->caption());
            if (strval($this->Longitude->EditValue) != "" && is_numeric($this->Longitude->EditValue)) {
                $this->Longitude->EditValue = FormatNumber($this->Longitude->EditValue, null);
            }

            // Edit refer script

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";

            // FieldType
            $this->FieldType->HrefValue = "";

            // Ownership
            $this->Ownership->HrefValue = "";

            // FarmSizeVerified
            $this->FarmSizeVerified->HrefValue = "";

            // TreesPlantedVerified
            $this->TreesPlantedVerified->HrefValue = "";

            // InspecationReport
            $this->InspecationReport->HrefValue = "";

            // ClearedLand
            $this->ClearedLand->HrefValue = "";

            // OldTrees
            $this->OldTrees->HrefValue = "";

            // FarmSize
            $this->FarmSize->HrefValue = "";

            // Latitude
            $this->Latitude->HrefValue = "";

            // Longitude
            $this->Longitude->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->ProvinceCode->Visible && $this->ProvinceCode->Required) {
                if (!$this->ProvinceCode->IsDetailKey && EmptyValue($this->ProvinceCode->FormValue)) {
                    $this->ProvinceCode->addErrorMessage(str_replace("%s", $this->ProvinceCode->caption(), $this->ProvinceCode->RequiredErrorMessage));
                }
            }
            if ($this->DistrictCode->Visible && $this->DistrictCode->Required) {
                if (!$this->DistrictCode->IsDetailKey && EmptyValue($this->DistrictCode->FormValue)) {
                    $this->DistrictCode->addErrorMessage(str_replace("%s", $this->DistrictCode->caption(), $this->DistrictCode->RequiredErrorMessage));
                }
            }
            if ($this->CampCode->Visible && $this->CampCode->Required) {
                if (!$this->CampCode->IsDetailKey && EmptyValue($this->CampCode->FormValue)) {
                    $this->CampCode->addErrorMessage(str_replace("%s", $this->CampCode->caption(), $this->CampCode->RequiredErrorMessage));
                }
            }
            if ($this->VillageCode->Visible && $this->VillageCode->Required) {
                if (!$this->VillageCode->IsDetailKey && EmptyValue($this->VillageCode->FormValue)) {
                    $this->VillageCode->addErrorMessage(str_replace("%s", $this->VillageCode->caption(), $this->VillageCode->RequiredErrorMessage));
                }
            }
            if ($this->NRC->Visible && $this->NRC->Required) {
                if (!$this->NRC->IsDetailKey && EmptyValue($this->NRC->FormValue)) {
                    $this->NRC->addErrorMessage(str_replace("%s", $this->NRC->caption(), $this->NRC->RequiredErrorMessage));
                }
            }
            if ($this->FarmNo->Visible && $this->FarmNo->Required) {
                if (!$this->FarmNo->IsDetailKey && EmptyValue($this->FarmNo->FormValue)) {
                    $this->FarmNo->addErrorMessage(str_replace("%s", $this->FarmNo->caption(), $this->FarmNo->RequiredErrorMessage));
                }
            }
            if ($this->FieldType->Visible && $this->FieldType->Required) {
                if (!$this->FieldType->IsDetailKey && EmptyValue($this->FieldType->FormValue)) {
                    $this->FieldType->addErrorMessage(str_replace("%s", $this->FieldType->caption(), $this->FieldType->RequiredErrorMessage));
                }
            }
            if ($this->Ownership->Visible && $this->Ownership->Required) {
                if (!$this->Ownership->IsDetailKey && EmptyValue($this->Ownership->FormValue)) {
                    $this->Ownership->addErrorMessage(str_replace("%s", $this->Ownership->caption(), $this->Ownership->RequiredErrorMessage));
                }
            }
            if ($this->FarmSizeVerified->Visible && $this->FarmSizeVerified->Required) {
                if (!$this->FarmSizeVerified->IsDetailKey && EmptyValue($this->FarmSizeVerified->FormValue)) {
                    $this->FarmSizeVerified->addErrorMessage(str_replace("%s", $this->FarmSizeVerified->caption(), $this->FarmSizeVerified->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->FarmSizeVerified->FormValue)) {
                $this->FarmSizeVerified->addErrorMessage($this->FarmSizeVerified->getErrorMessage(false));
            }
            if ($this->TreesPlantedVerified->Visible && $this->TreesPlantedVerified->Required) {
                if (!$this->TreesPlantedVerified->IsDetailKey && EmptyValue($this->TreesPlantedVerified->FormValue)) {
                    $this->TreesPlantedVerified->addErrorMessage(str_replace("%s", $this->TreesPlantedVerified->caption(), $this->TreesPlantedVerified->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->TreesPlantedVerified->FormValue)) {
                $this->TreesPlantedVerified->addErrorMessage($this->TreesPlantedVerified->getErrorMessage(false));
            }
            if ($this->InspecationReport->Visible && $this->InspecationReport->Required) {
                if (!$this->InspecationReport->IsDetailKey && EmptyValue($this->InspecationReport->FormValue)) {
                    $this->InspecationReport->addErrorMessage(str_replace("%s", $this->InspecationReport->caption(), $this->InspecationReport->RequiredErrorMessage));
                }
            }
            if ($this->ClearedLand->Visible && $this->ClearedLand->Required) {
                if (!$this->ClearedLand->IsDetailKey && EmptyValue($this->ClearedLand->FormValue)) {
                    $this->ClearedLand->addErrorMessage(str_replace("%s", $this->ClearedLand->caption(), $this->ClearedLand->RequiredErrorMessage));
                }
            }
            if ($this->OldTrees->Visible && $this->OldTrees->Required) {
                if (!$this->OldTrees->IsDetailKey && EmptyValue($this->OldTrees->FormValue)) {
                    $this->OldTrees->addErrorMessage(str_replace("%s", $this->OldTrees->caption(), $this->OldTrees->RequiredErrorMessage));
                }
            }
            if ($this->FarmSize->Visible && $this->FarmSize->Required) {
                if (!$this->FarmSize->IsDetailKey && EmptyValue($this->FarmSize->FormValue)) {
                    $this->FarmSize->addErrorMessage(str_replace("%s", $this->FarmSize->caption(), $this->FarmSize->RequiredErrorMessage));
                }
            }
            if ($this->Latitude->Visible && $this->Latitude->Required) {
                if (!$this->Latitude->IsDetailKey && EmptyValue($this->Latitude->FormValue)) {
                    $this->Latitude->addErrorMessage(str_replace("%s", $this->Latitude->caption(), $this->Latitude->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->Latitude->FormValue)) {
                $this->Latitude->addErrorMessage($this->Latitude->getErrorMessage(false));
            }
            if ($this->Longitude->Visible && $this->Longitude->Required) {
                if (!$this->Longitude->IsDetailKey && EmptyValue($this->Longitude->FormValue)) {
                    $this->Longitude->addErrorMessage(str_replace("%s", $this->Longitude->caption(), $this->Longitude->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->Longitude->FormValue)) {
                $this->Longitude->addErrorMessage($this->Longitude->getErrorMessage(false));
            }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("FarmSeedAllocateGrid");
        if (in_array("farm_seed_allocate", $detailTblVar) && $detailPage->DetailEdit) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }
        $detailPage = Container("FarmInspectionGrid");
        if (in_array("farm_inspection", $detailTblVar) && $detailPage->DetailEdit) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }
        $detailPage = Container("ProductionSalesGrid");
        if (in_array("production_sales", $detailTblVar) && $detailPage->DetailEdit) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Begin transaction
        if ($this->getCurrentDetailTable() != "" && $this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }

            // Update detail records
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("FarmSeedAllocateGrid");
            if (in_array("farm_seed_allocate", $detailTblVar) && $detailPage->DetailEdit && $editRow) {
                $Security->loadCurrentUserLevel($this->ProjectID . "farm_seed_allocate"); // Load user level of detail table
                $editRow = $detailPage->gridUpdate();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
            }
            $detailPage = Container("FarmInspectionGrid");
            if (in_array("farm_inspection", $detailTblVar) && $detailPage->DetailEdit && $editRow) {
                $Security->loadCurrentUserLevel($this->ProjectID . "farm_inspection"); // Load user level of detail table
                $editRow = $detailPage->gridUpdate();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
            }
            $detailPage = Container("ProductionSalesGrid");
            if (in_array("production_sales", $detailTblVar) && $detailPage->DetailEdit && $editRow) {
                $Security->loadCurrentUserLevel($this->ProjectID . "production_sales"); // Load user level of detail table
                $editRow = $detailPage->gridUpdate();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
            }

            // Commit/Rollback transaction
            if ($this->getCurrentDetailTable() != "") {
                if ($editRow) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // ProvinceCode
        if ($this->ProvinceCode->getSessionValue() != "") {
            $this->ProvinceCode->ReadOnly = true;
        }
        $this->ProvinceCode->setDbValueDef($rsnew, $this->ProvinceCode->CurrentValue, $this->ProvinceCode->ReadOnly);

        // DistrictCode
        if ($this->DistrictCode->getSessionValue() != "") {
            $this->DistrictCode->ReadOnly = true;
        }
        $this->DistrictCode->setDbValueDef($rsnew, $this->DistrictCode->CurrentValue, $this->DistrictCode->ReadOnly);

        // CampCode
        if ($this->CampCode->getSessionValue() != "") {
            $this->CampCode->ReadOnly = true;
        }
        $this->CampCode->setDbValueDef($rsnew, $this->CampCode->CurrentValue, $this->CampCode->ReadOnly);

        // VillageCode
        if ($this->VillageCode->getSessionValue() != "") {
            $this->VillageCode->ReadOnly = true;
        }
        $this->VillageCode->setDbValueDef($rsnew, $this->VillageCode->CurrentValue, $this->VillageCode->ReadOnly);

        // NRC
        if ($this->NRC->getSessionValue() != "") {
            $this->NRC->ReadOnly = true;
        }
        $this->NRC->setDbValueDef($rsnew, $this->NRC->CurrentValue, $this->NRC->ReadOnly);

        // FieldType
        $this->FieldType->setDbValueDef($rsnew, $this->FieldType->CurrentValue, $this->FieldType->ReadOnly);

        // Ownership
        $this->Ownership->setDbValueDef($rsnew, $this->Ownership->CurrentValue, $this->Ownership->ReadOnly);

        // FarmSizeVerified
        $this->FarmSizeVerified->setDbValueDef($rsnew, $this->FarmSizeVerified->CurrentValue, $this->FarmSizeVerified->ReadOnly);

        // TreesPlantedVerified
        $this->TreesPlantedVerified->setDbValueDef($rsnew, $this->TreesPlantedVerified->CurrentValue, $this->TreesPlantedVerified->ReadOnly);

        // InspecationReport
        $this->InspecationReport->setDbValueDef($rsnew, $this->InspecationReport->CurrentValue, $this->InspecationReport->ReadOnly);

        // ClearedLand
        $this->ClearedLand->setDbValueDef($rsnew, $this->ClearedLand->CurrentValue, $this->ClearedLand->ReadOnly);

        // OldTrees
        $this->OldTrees->setDbValueDef($rsnew, $this->OldTrees->CurrentValue, $this->OldTrees->ReadOnly);

        // FarmSize
        $this->FarmSize->setDbValueDef($rsnew, $this->FarmSize->CurrentValue, $this->FarmSize->ReadOnly);

        // Latitude
        $this->Latitude->setDbValueDef($rsnew, $this->Latitude->CurrentValue, $this->Latitude->ReadOnly);

        // Longitude
        $this->Longitude->setDbValueDef($rsnew, $this->Longitude->CurrentValue, $this->Longitude->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['ProvinceCode'])) { // ProvinceCode
            $this->ProvinceCode->CurrentValue = $row['ProvinceCode'];
        }
        if (isset($row['DistrictCode'])) { // DistrictCode
            $this->DistrictCode->CurrentValue = $row['DistrictCode'];
        }
        if (isset($row['CampCode'])) { // CampCode
            $this->CampCode->CurrentValue = $row['CampCode'];
        }
        if (isset($row['VillageCode'])) { // VillageCode
            $this->VillageCode->CurrentValue = $row['VillageCode'];
        }
        if (isset($row['NRC'])) { // NRC
            $this->NRC->CurrentValue = $row['NRC'];
        }
        if (isset($row['FieldType'])) { // FieldType
            $this->FieldType->CurrentValue = $row['FieldType'];
        }
        if (isset($row['Ownership'])) { // Ownership
            $this->Ownership->CurrentValue = $row['Ownership'];
        }
        if (isset($row['FarmSizeVerified'])) { // FarmSizeVerified
            $this->FarmSizeVerified->CurrentValue = $row['FarmSizeVerified'];
        }
        if (isset($row['TreesPlantedVerified'])) { // TreesPlantedVerified
            $this->TreesPlantedVerified->CurrentValue = $row['TreesPlantedVerified'];
        }
        if (isset($row['InspecationReport'])) { // InspecationReport
            $this->InspecationReport->CurrentValue = $row['InspecationReport'];
        }
        if (isset($row['ClearedLand'])) { // ClearedLand
            $this->ClearedLand->CurrentValue = $row['ClearedLand'];
        }
        if (isset($row['OldTrees'])) { // OldTrees
            $this->OldTrees->CurrentValue = $row['OldTrees'];
        }
        if (isset($row['FarmSize'])) { // FarmSize
            $this->FarmSize->CurrentValue = $row['FarmSize'];
        }
        if (isset($row['Latitude'])) { // Latitude
            $this->Latitude->CurrentValue = $row['Latitude'];
        }
        if (isset($row['Longitude'])) { // Longitude
            $this->Longitude->CurrentValue = $row['Longitude'];
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "farmer") {
                $validMaster = true;
                $masterTbl = Container("farmer");
                if (($parm = Get("fk_NRC", Get("NRC"))) !== null) {
                    $masterTbl->NRC->setQueryStringValue($parm);
                    $this->NRC->QueryStringValue = $masterTbl->NRC->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->NRC->setSessionValue($this->NRC->QueryStringValue);
                    $foreignKeys["NRC"] = $this->NRC->QueryStringValue;
                } else {
                    $validMaster = false;
                }
            }
            if ($masterTblVar == "village") {
                $validMaster = true;
                $masterTbl = Container("village");
                if (($parm = Get("fk_ProvinceCode", Get("ProvinceCode"))) !== null) {
                    $masterTbl->ProvinceCode->setQueryStringValue($parm);
                    $this->ProvinceCode->QueryStringValue = $masterTbl->ProvinceCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->ProvinceCode->setSessionValue($this->ProvinceCode->QueryStringValue);
                    $foreignKeys["ProvinceCode"] = $this->ProvinceCode->QueryStringValue;
                    if (!is_numeric($masterTbl->ProvinceCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_DistrictCode", Get("DistrictCode"))) !== null) {
                    $masterTbl->DistrictCode->setQueryStringValue($parm);
                    $this->DistrictCode->QueryStringValue = $masterTbl->DistrictCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->DistrictCode->setSessionValue($this->DistrictCode->QueryStringValue);
                    $foreignKeys["DistrictCode"] = $this->DistrictCode->QueryStringValue;
                    if (!is_numeric($masterTbl->DistrictCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_CampCode", Get("CampCode"))) !== null) {
                    $masterTbl->CampCode->setQueryStringValue($parm);
                    $this->CampCode->QueryStringValue = $masterTbl->CampCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->CampCode->setSessionValue($this->CampCode->QueryStringValue);
                    $foreignKeys["CampCode"] = $this->CampCode->QueryStringValue;
                    if (!is_numeric($masterTbl->CampCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_VillageCode", Get("VillageCode"))) !== null) {
                    $masterTbl->VillageCode->setQueryStringValue($parm);
                    $this->VillageCode->QueryStringValue = $masterTbl->VillageCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->VillageCode->setSessionValue($this->VillageCode->QueryStringValue);
                    $foreignKeys["VillageCode"] = $this->VillageCode->QueryStringValue;
                    if (!is_numeric($masterTbl->VillageCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "farmer") {
                $validMaster = true;
                $masterTbl = Container("farmer");
                if (($parm = Post("fk_NRC", Post("NRC"))) !== null) {
                    $masterTbl->NRC->setFormValue($parm);
                    $this->NRC->FormValue = $masterTbl->NRC->FormValue;
                    $this->NRC->setSessionValue($this->NRC->FormValue);
                    $foreignKeys["NRC"] = $this->NRC->FormValue;
                } else {
                    $validMaster = false;
                }
            }
            if ($masterTblVar == "village") {
                $validMaster = true;
                $masterTbl = Container("village");
                if (($parm = Post("fk_ProvinceCode", Post("ProvinceCode"))) !== null) {
                    $masterTbl->ProvinceCode->setFormValue($parm);
                    $this->ProvinceCode->FormValue = $masterTbl->ProvinceCode->FormValue;
                    $this->ProvinceCode->setSessionValue($this->ProvinceCode->FormValue);
                    $foreignKeys["ProvinceCode"] = $this->ProvinceCode->FormValue;
                    if (!is_numeric($masterTbl->ProvinceCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_DistrictCode", Post("DistrictCode"))) !== null) {
                    $masterTbl->DistrictCode->setFormValue($parm);
                    $this->DistrictCode->FormValue = $masterTbl->DistrictCode->FormValue;
                    $this->DistrictCode->setSessionValue($this->DistrictCode->FormValue);
                    $foreignKeys["DistrictCode"] = $this->DistrictCode->FormValue;
                    if (!is_numeric($masterTbl->DistrictCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_CampCode", Post("CampCode"))) !== null) {
                    $masterTbl->CampCode->setFormValue($parm);
                    $this->CampCode->FormValue = $masterTbl->CampCode->FormValue;
                    $this->CampCode->setSessionValue($this->CampCode->FormValue);
                    $foreignKeys["CampCode"] = $this->CampCode->FormValue;
                    if (!is_numeric($masterTbl->CampCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_VillageCode", Post("VillageCode"))) !== null) {
                    $masterTbl->VillageCode->setFormValue($parm);
                    $this->VillageCode->FormValue = $masterTbl->VillageCode->FormValue;
                    $this->VillageCode->setSessionValue($this->VillageCode->FormValue);
                    $foreignKeys["VillageCode"] = $this->VillageCode->FormValue;
                    if (!is_numeric($masterTbl->VillageCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);
            $this->setSessionWhere($this->getDetailFilterFromSession());

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "farmer") {
                if (!array_key_exists("NRC", $foreignKeys)) { // Not current foreign key
                    $this->NRC->setSessionValue("");
                }
            }
            if ($masterTblVar != "village") {
                if (!array_key_exists("ProvinceCode", $foreignKeys)) { // Not current foreign key
                    $this->ProvinceCode->setSessionValue("");
                }
                if (!array_key_exists("DistrictCode", $foreignKeys)) { // Not current foreign key
                    $this->DistrictCode->setSessionValue("");
                }
                if (!array_key_exists("CampCode", $foreignKeys)) { // Not current foreign key
                    $this->CampCode->setSessionValue("");
                }
                if (!array_key_exists("VillageCode", $foreignKeys)) { // Not current foreign key
                    $this->VillageCode->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("farm_seed_allocate", $detailTblVar)) {
                $detailPageObj = Container("FarmSeedAllocateGrid");
                if ($detailPageObj->DetailEdit) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    $detailPageObj->CurrentMode = "edit";
                    $detailPageObj->CurrentAction = "gridedit";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->ProvinceCode->IsDetailKey = true;
                    $detailPageObj->ProvinceCode->CurrentValue = $this->ProvinceCode->CurrentValue;
                    $detailPageObj->ProvinceCode->setSessionValue($detailPageObj->ProvinceCode->CurrentValue);
                    $detailPageObj->DistrictCode->IsDetailKey = true;
                    $detailPageObj->DistrictCode->CurrentValue = $this->DistrictCode->CurrentValue;
                    $detailPageObj->DistrictCode->setSessionValue($detailPageObj->DistrictCode->CurrentValue);
                    $detailPageObj->CampCode->IsDetailKey = true;
                    $detailPageObj->CampCode->CurrentValue = $this->CampCode->CurrentValue;
                    $detailPageObj->CampCode->setSessionValue($detailPageObj->CampCode->CurrentValue);
                    $detailPageObj->VillageCode->IsDetailKey = true;
                    $detailPageObj->VillageCode->CurrentValue = $this->VillageCode->CurrentValue;
                    $detailPageObj->VillageCode->setSessionValue($detailPageObj->VillageCode->CurrentValue);
                    $detailPageObj->FarmNo->IsDetailKey = true;
                    $detailPageObj->FarmNo->CurrentValue = $this->FarmNo->CurrentValue;
                    $detailPageObj->FarmNo->setSessionValue($detailPageObj->FarmNo->CurrentValue);
                }
            }
            if (in_array("farm_inspection", $detailTblVar)) {
                $detailPageObj = Container("FarmInspectionGrid");
                if ($detailPageObj->DetailEdit) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    $detailPageObj->CurrentMode = "edit";
                    $detailPageObj->CurrentAction = "gridedit";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->ProvinceCode->IsDetailKey = true;
                    $detailPageObj->ProvinceCode->CurrentValue = $this->ProvinceCode->CurrentValue;
                    $detailPageObj->ProvinceCode->setSessionValue($detailPageObj->ProvinceCode->CurrentValue);
                    $detailPageObj->DistrictCode->IsDetailKey = true;
                    $detailPageObj->DistrictCode->CurrentValue = $this->DistrictCode->CurrentValue;
                    $detailPageObj->DistrictCode->setSessionValue($detailPageObj->DistrictCode->CurrentValue);
                    $detailPageObj->CampCode->IsDetailKey = true;
                    $detailPageObj->CampCode->CurrentValue = $this->CampCode->CurrentValue;
                    $detailPageObj->CampCode->setSessionValue($detailPageObj->CampCode->CurrentValue);
                    $detailPageObj->VillageCode->IsDetailKey = true;
                    $detailPageObj->VillageCode->CurrentValue = $this->VillageCode->CurrentValue;
                    $detailPageObj->VillageCode->setSessionValue($detailPageObj->VillageCode->CurrentValue);
                    $detailPageObj->NRC->IsDetailKey = true;
                    $detailPageObj->NRC->CurrentValue = $this->NRC->CurrentValue;
                    $detailPageObj->NRC->setSessionValue($detailPageObj->NRC->CurrentValue);
                    $detailPageObj->FarmNo->IsDetailKey = true;
                    $detailPageObj->FarmNo->CurrentValue = $this->FarmNo->CurrentValue;
                    $detailPageObj->FarmNo->setSessionValue($detailPageObj->FarmNo->CurrentValue);
                }
            }
            if (in_array("production_sales", $detailTblVar)) {
                $detailPageObj = Container("ProductionSalesGrid");
                if ($detailPageObj->DetailEdit) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    $detailPageObj->CurrentMode = "edit";
                    $detailPageObj->CurrentAction = "gridedit";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->FarmNo->IsDetailKey = true;
                    $detailPageObj->FarmNo->CurrentValue = $this->FarmNo->CurrentValue;
                    $detailPageObj->FarmNo->setSessionValue($detailPageObj->FarmNo->CurrentValue);
                    $detailPageObj->NRC->IsDetailKey = true;
                    $detailPageObj->NRC->CurrentValue = $this->NRC->CurrentValue;
                    $detailPageObj->NRC->setSessionValue($detailPageObj->NRC->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("FarmList"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Set up detail pages
    protected function setupDetailPages()
    {
        $pages = new SubPages();
        $pages->Style = "tabs";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add('farm_seed_allocate');
        $pages->add('farm_inspection');
        $pages->add('production_sales');
        $this->DetailPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ProvinceCode":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_DistrictCode":
                    break;
                case "x_CampCode":
                    break;
                case "x_VillageCode":
                    break;
                case "x_NRC":
                    break;
                case "x_FieldType":
                    break;
                case "x_Ownership":
                    break;
                case "x_SourcesOfSeedlings":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
