<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for awp
 */
class Awp extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $Component;
    public $Subcomponent;
    public $InvestmentCost;
    public $Type;
    public $CategoryofExpenditure;
    public $Activity;
    public $Implementer;
    public $Indicator;
    public $ProjectTarget;
    public $_2017Target;
    public $ProjectBudget;
    public $StartMonth;
    public $EndMonth;
    public $LineNo;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "awp";
        $this->TableName = 'awp';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "awp";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // Component
        $this->Component = new DbField(
            $this, // Table
            'x_Component', // Variable name
            'Component', // Name
            '`Component`', // Expression
            '`Component`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Component`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->Component->InputTextType = "text";
        $this->Component->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Component'] = &$this->Component;

        // Sub component
        $this->Subcomponent = new DbField(
            $this, // Table
            'x_Subcomponent', // Variable name
            'Sub component', // Name
            '`Sub component`', // Expression
            '`Sub component`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Sub component`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->Subcomponent->InputTextType = "text";
        $this->Subcomponent->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Sub component'] = &$this->Subcomponent;

        // Investment Cost
        $this->InvestmentCost = new DbField(
            $this, // Table
            'x_InvestmentCost', // Variable name
            'Investment Cost', // Name
            '`Investment Cost`', // Expression
            '`Investment Cost`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Investment Cost`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->InvestmentCost->InputTextType = "text";
        $this->InvestmentCost->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Investment Cost'] = &$this->InvestmentCost;

        // Type
        $this->Type = new DbField(
            $this, // Table
            'x_Type', // Variable name
            'Type', // Name
            '`Type`', // Expression
            '`Type`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Type->InputTextType = "text";
        $this->Type->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Type'] = &$this->Type;

        // Category of Expenditure
        $this->CategoryofExpenditure = new DbField(
            $this, // Table
            'x_CategoryofExpenditure', // Variable name
            'Category of Expenditure', // Name
            '`Category of Expenditure`', // Expression
            '`Category of Expenditure`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Category of Expenditure`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->CategoryofExpenditure->InputTextType = "text";
        $this->CategoryofExpenditure->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Category of Expenditure'] = &$this->CategoryofExpenditure;

        // Activity
        $this->Activity = new DbField(
            $this, // Table
            'x_Activity', // Variable name
            'Activity', // Name
            '`Activity`', // Expression
            '`Activity`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Activity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->Activity->InputTextType = "text";
        $this->Activity->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Activity'] = &$this->Activity;

        // Implementer
        $this->Implementer = new DbField(
            $this, // Table
            'x_Implementer', // Variable name
            'Implementer', // Name
            '`Implementer`', // Expression
            '`Implementer`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Implementer`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Implementer->InputTextType = "text";
        $this->Implementer->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Implementer'] = &$this->Implementer;

        // Indicator
        $this->Indicator = new DbField(
            $this, // Table
            'x_Indicator', // Variable name
            'Indicator', // Name
            '`Indicator`', // Expression
            '`Indicator`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Indicator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Indicator->InputTextType = "text";
        $this->Indicator->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Indicator'] = &$this->Indicator;

        // Project Target
        $this->ProjectTarget = new DbField(
            $this, // Table
            'x_ProjectTarget', // Variable name
            'Project Target', // Name
            '`Project Target`', // Expression
            '`Project Target`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Project Target`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ProjectTarget->InputTextType = "text";
        $this->ProjectTarget->Raw = true;
        $this->ProjectTarget->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ProjectTarget->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Project Target'] = &$this->ProjectTarget;

        // 2017 Target
        $this->_2017Target = new DbField(
            $this, // Table
            'x__2017Target', // Variable name
            '2017 Target', // Name
            '`2017 Target`', // Expression
            '`2017 Target`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`2017 Target`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_2017Target->InputTextType = "text";
        $this->_2017Target->Raw = true;
        $this->_2017Target->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->_2017Target->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['2017 Target'] = &$this->_2017Target;

        // Project Budget
        $this->ProjectBudget = new DbField(
            $this, // Table
            'x_ProjectBudget', // Variable name
            'Project Budget', // Name
            '`Project Budget`', // Expression
            '`Project Budget`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Project Budget`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ProjectBudget->InputTextType = "text";
        $this->ProjectBudget->Raw = true;
        $this->ProjectBudget->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ProjectBudget->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Project Budget'] = &$this->ProjectBudget;

        // StartMonth
        $this->StartMonth = new DbField(
            $this, // Table
            'x_StartMonth', // Variable name
            'StartMonth', // Name
            '`StartMonth`', // Expression
            '`StartMonth`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`StartMonth`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->StartMonth->InputTextType = "text";
        $this->StartMonth->Raw = true;
        $this->StartMonth->setSelectMultiple(false); // Select one
        $this->StartMonth->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->StartMonth->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->StartMonth->Lookup = new Lookup($this->StartMonth, 'month_ref', false, 'MonthCode', ["MonthShort","","",""], '', '', [], [], [], [], [], [], false, '', '', "`MonthShort`");
        $this->StartMonth->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->StartMonth->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['StartMonth'] = &$this->StartMonth;

        // EndMonth
        $this->EndMonth = new DbField(
            $this, // Table
            'x_EndMonth', // Variable name
            'EndMonth', // Name
            '`EndMonth`', // Expression
            '`EndMonth`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`EndMonth`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->EndMonth->InputTextType = "text";
        $this->EndMonth->Raw = true;
        $this->EndMonth->setSelectMultiple(false); // Select one
        $this->EndMonth->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->EndMonth->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->EndMonth->Lookup = new Lookup($this->EndMonth, 'month_ref', false, 'MonthCode', ["MonthShort","","",""], '', '', [], [], [], [], [], [], false, '', '', "`MonthShort`");
        $this->EndMonth->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->EndMonth->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['EndMonth'] = &$this->EndMonth;

        // LineNo
        $this->LineNo = new DbField(
            $this, // Table
            'x_LineNo', // Variable name
            'LineNo', // Name
            '`LineNo`', // Expression
            '`LineNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`LineNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->LineNo->InputTextType = "text";
        $this->LineNo->Raw = true;
        $this->LineNo->IsAutoIncrement = true; // Autoincrement field
        $this->LineNo->IsPrimaryKey = true; // Primary key field
        $this->LineNo->Nullable = false; // NOT NULL field
        $this->LineNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->LineNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['LineNo'] = &$this->LineNo;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "awp";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD) == Allow::ADD;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT) == Allow::EDIT;
            case "delete":
                return ($allow & Allow::DELETE) == Allow::DELETE;
            case "view":
                return ($allow & Allow::VIEW) == Allow::VIEW;
            case "search":
                return ($allow & Allow::SEARCH) == Allow::SEARCH;
            case "lookup":
                return ($allow & Allow::LOOKUP) == Allow::LOOKUP;
            default:
                return ($allow & Allow::LIST) == Allow::LIST;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->LineNo->setDbValue($conn->lastInsertId());
            $rs['LineNo'] = $this->LineNo->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['LineNo']) && !EmptyValue($this->LineNo->CurrentValue)) {
                $rs['LineNo'] = $this->LineNo->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'LineNo';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('LineNo', $rs)) {
                AddFilter($where, QuotedName('LineNo', $this->Dbid) . '=' . QuotedValue($rs['LineNo'], $this->LineNo->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->Component->DbValue = $row['Component'];
        $this->Subcomponent->DbValue = $row['Sub component'];
        $this->InvestmentCost->DbValue = $row['Investment Cost'];
        $this->Type->DbValue = $row['Type'];
        $this->CategoryofExpenditure->DbValue = $row['Category of Expenditure'];
        $this->Activity->DbValue = $row['Activity'];
        $this->Implementer->DbValue = $row['Implementer'];
        $this->Indicator->DbValue = $row['Indicator'];
        $this->ProjectTarget->DbValue = $row['Project Target'];
        $this->_2017Target->DbValue = $row['2017 Target'];
        $this->ProjectBudget->DbValue = $row['Project Budget'];
        $this->StartMonth->DbValue = $row['StartMonth'];
        $this->EndMonth->DbValue = $row['EndMonth'];
        $this->LineNo->DbValue = $row['LineNo'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`LineNo` = @LineNo@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->LineNo->CurrentValue : $this->LineNo->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->LineNo->CurrentValue = $keys[0];
            } else {
                $this->LineNo->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('LineNo', $row) ? $row['LineNo'] : null;
        } else {
            $val = !EmptyValue($this->LineNo->OldValue) && !$current ? $this->LineNo->OldValue : $this->LineNo->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@LineNo@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("AwpList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "AwpView" => $Language->phrase("View"),
            "AwpEdit" => $Language->phrase("Edit"),
            "AwpAdd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "AwpList";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "AwpView",
            Config("API_ADD_ACTION") => "AwpAdd",
            Config("API_EDIT_ACTION") => "AwpEdit",
            Config("API_DELETE_ACTION") => "AwpDelete",
            Config("API_LIST_ACTION") => "AwpList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "AwpList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("AwpView", $parm);
        } else {
            $url = $this->keyUrl("AwpView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "AwpAdd?" . $parm;
        } else {
            $url = "AwpAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("AwpEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("AwpList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("AwpAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("AwpList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("AwpDelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"LineNo\":" . VarToJson($this->LineNo->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->LineNo->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->LineNo->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("LineNo") ?? Route("LineNo")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        $keyFilter = "";
        foreach ($rows as $row) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter($row) . ")";
        }
        return $keyFilter;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->LineNo->CurrentValue = $key;
            } else {
                $this->LineNo->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->Component->setDbValue($row['Component']);
        $this->Subcomponent->setDbValue($row['Sub component']);
        $this->InvestmentCost->setDbValue($row['Investment Cost']);
        $this->Type->setDbValue($row['Type']);
        $this->CategoryofExpenditure->setDbValue($row['Category of Expenditure']);
        $this->Activity->setDbValue($row['Activity']);
        $this->Implementer->setDbValue($row['Implementer']);
        $this->Indicator->setDbValue($row['Indicator']);
        $this->ProjectTarget->setDbValue($row['Project Target']);
        $this->_2017Target->setDbValue($row['2017 Target']);
        $this->ProjectBudget->setDbValue($row['Project Budget']);
        $this->StartMonth->setDbValue($row['StartMonth']);
        $this->EndMonth->setDbValue($row['EndMonth']);
        $this->LineNo->setDbValue($row['LineNo']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "AwpList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // Component

        // Sub component

        // Investment Cost

        // Type

        // Category of Expenditure

        // Activity

        // Implementer

        // Indicator

        // Project Target

        // 2017 Target

        // Project Budget

        // StartMonth

        // EndMonth

        // LineNo

        // Component
        $this->Component->ViewValue = $this->Component->CurrentValue;

        // Sub component
        $this->Subcomponent->ViewValue = $this->Subcomponent->CurrentValue;

        // Investment Cost
        $this->InvestmentCost->ViewValue = $this->InvestmentCost->CurrentValue;

        // Type
        $this->Type->ViewValue = $this->Type->CurrentValue;

        // Category of Expenditure
        $this->CategoryofExpenditure->ViewValue = $this->CategoryofExpenditure->CurrentValue;

        // Activity
        $this->Activity->ViewValue = $this->Activity->CurrentValue;

        // Implementer
        $this->Implementer->ViewValue = $this->Implementer->CurrentValue;

        // Indicator
        $this->Indicator->ViewValue = $this->Indicator->CurrentValue;

        // Project Target
        $this->ProjectTarget->ViewValue = $this->ProjectTarget->CurrentValue;
        $this->ProjectTarget->ViewValue = FormatNumber($this->ProjectTarget->ViewValue, $this->ProjectTarget->formatPattern());
        $this->ProjectTarget->CellCssStyle .= "text-align: right;";

        // 2017 Target
        $this->_2017Target->ViewValue = $this->_2017Target->CurrentValue;
        $this->_2017Target->ViewValue = FormatNumber($this->_2017Target->ViewValue, $this->_2017Target->formatPattern());
        $this->_2017Target->CellCssStyle .= "text-align: right;";

        // Project Budget
        $this->ProjectBudget->ViewValue = $this->ProjectBudget->CurrentValue;
        $this->ProjectBudget->ViewValue = FormatNumber($this->ProjectBudget->ViewValue, $this->ProjectBudget->formatPattern());
        $this->ProjectBudget->CellCssStyle .= "text-align: right;";

        // StartMonth
        $curVal = strval($this->StartMonth->CurrentValue);
        if ($curVal != "") {
            $this->StartMonth->ViewValue = $this->StartMonth->lookupCacheOption($curVal);
            if ($this->StartMonth->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->StartMonth->Lookup->getTable()->Fields["MonthCode"]->searchExpression(), "=", $curVal, $this->StartMonth->Lookup->getTable()->Fields["MonthCode"]->searchDataType(), "");
                $sqlWrk = $this->StartMonth->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->StartMonth->Lookup->renderViewRow($rswrk[0]);
                    $this->StartMonth->ViewValue = $this->StartMonth->displayValue($arwrk);
                } else {
                    $this->StartMonth->ViewValue = $this->StartMonth->CurrentValue;
                }
            }
        } else {
            $this->StartMonth->ViewValue = null;
        }

        // EndMonth
        $curVal = strval($this->EndMonth->CurrentValue);
        if ($curVal != "") {
            $this->EndMonth->ViewValue = $this->EndMonth->lookupCacheOption($curVal);
            if ($this->EndMonth->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->EndMonth->Lookup->getTable()->Fields["MonthCode"]->searchExpression(), "=", $curVal, $this->EndMonth->Lookup->getTable()->Fields["MonthCode"]->searchDataType(), "");
                $sqlWrk = $this->EndMonth->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->EndMonth->Lookup->renderViewRow($rswrk[0]);
                    $this->EndMonth->ViewValue = $this->EndMonth->displayValue($arwrk);
                } else {
                    $this->EndMonth->ViewValue = $this->EndMonth->CurrentValue;
                }
            }
        } else {
            $this->EndMonth->ViewValue = null;
        }

        // LineNo
        $this->LineNo->ViewValue = $this->LineNo->CurrentValue;

        // Component
        $this->Component->HrefValue = "";
        $this->Component->TooltipValue = "";

        // Sub component
        $this->Subcomponent->HrefValue = "";
        $this->Subcomponent->TooltipValue = "";

        // Investment Cost
        $this->InvestmentCost->HrefValue = "";
        $this->InvestmentCost->TooltipValue = "";

        // Type
        $this->Type->HrefValue = "";
        $this->Type->TooltipValue = "";

        // Category of Expenditure
        $this->CategoryofExpenditure->HrefValue = "";
        $this->CategoryofExpenditure->TooltipValue = "";

        // Activity
        $this->Activity->HrefValue = "";
        $this->Activity->TooltipValue = "";

        // Implementer
        $this->Implementer->HrefValue = "";
        $this->Implementer->TooltipValue = "";

        // Indicator
        $this->Indicator->HrefValue = "";
        $this->Indicator->TooltipValue = "";

        // Project Target
        $this->ProjectTarget->HrefValue = "";
        $this->ProjectTarget->TooltipValue = "";

        // 2017 Target
        $this->_2017Target->HrefValue = "";
        $this->_2017Target->TooltipValue = "";

        // Project Budget
        $this->ProjectBudget->HrefValue = "";
        $this->ProjectBudget->TooltipValue = "";

        // StartMonth
        $this->StartMonth->HrefValue = "";
        $this->StartMonth->TooltipValue = "";

        // EndMonth
        $this->EndMonth->HrefValue = "";
        $this->EndMonth->TooltipValue = "";

        // LineNo
        $this->LineNo->HrefValue = "";
        $this->LineNo->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Component
        $this->Component->setupEditAttributes();
        $this->Component->EditValue = $this->Component->CurrentValue;
        $this->Component->PlaceHolder = RemoveHtml($this->Component->caption());

        // Sub component
        $this->Subcomponent->setupEditAttributes();
        $this->Subcomponent->EditValue = $this->Subcomponent->CurrentValue;
        $this->Subcomponent->PlaceHolder = RemoveHtml($this->Subcomponent->caption());

        // Investment Cost
        $this->InvestmentCost->setupEditAttributes();
        if (!$this->InvestmentCost->Raw) {
            $this->InvestmentCost->CurrentValue = HtmlDecode($this->InvestmentCost->CurrentValue);
        }
        $this->InvestmentCost->EditValue = $this->InvestmentCost->CurrentValue;
        $this->InvestmentCost->PlaceHolder = RemoveHtml($this->InvestmentCost->caption());

        // Type
        $this->Type->setupEditAttributes();
        if (!$this->Type->Raw) {
            $this->Type->CurrentValue = HtmlDecode($this->Type->CurrentValue);
        }
        $this->Type->EditValue = $this->Type->CurrentValue;
        $this->Type->PlaceHolder = RemoveHtml($this->Type->caption());

        // Category of Expenditure
        $this->CategoryofExpenditure->setupEditAttributes();
        $this->CategoryofExpenditure->EditValue = $this->CategoryofExpenditure->CurrentValue;
        $this->CategoryofExpenditure->PlaceHolder = RemoveHtml($this->CategoryofExpenditure->caption());

        // Activity
        $this->Activity->setupEditAttributes();
        $this->Activity->EditValue = $this->Activity->CurrentValue;
        $this->Activity->PlaceHolder = RemoveHtml($this->Activity->caption());

        // Implementer
        $this->Implementer->setupEditAttributes();
        if (!$this->Implementer->Raw) {
            $this->Implementer->CurrentValue = HtmlDecode($this->Implementer->CurrentValue);
        }
        $this->Implementer->EditValue = $this->Implementer->CurrentValue;
        $this->Implementer->PlaceHolder = RemoveHtml($this->Implementer->caption());

        // Indicator
        $this->Indicator->setupEditAttributes();
        if (!$this->Indicator->Raw) {
            $this->Indicator->CurrentValue = HtmlDecode($this->Indicator->CurrentValue);
        }
        $this->Indicator->EditValue = $this->Indicator->CurrentValue;
        $this->Indicator->PlaceHolder = RemoveHtml($this->Indicator->caption());

        // Project Target
        $this->ProjectTarget->setupEditAttributes();
        $this->ProjectTarget->EditValue = $this->ProjectTarget->CurrentValue;
        $this->ProjectTarget->PlaceHolder = RemoveHtml($this->ProjectTarget->caption());
        if (strval($this->ProjectTarget->EditValue) != "" && is_numeric($this->ProjectTarget->EditValue)) {
            $this->ProjectTarget->EditValue = FormatNumber($this->ProjectTarget->EditValue, null);
        }

        // 2017 Target
        $this->_2017Target->setupEditAttributes();
        $this->_2017Target->EditValue = $this->_2017Target->CurrentValue;
        $this->_2017Target->PlaceHolder = RemoveHtml($this->_2017Target->caption());
        if (strval($this->_2017Target->EditValue) != "" && is_numeric($this->_2017Target->EditValue)) {
            $this->_2017Target->EditValue = FormatNumber($this->_2017Target->EditValue, null);
        }

        // Project Budget
        $this->ProjectBudget->setupEditAttributes();
        $this->ProjectBudget->EditValue = $this->ProjectBudget->CurrentValue;
        $this->ProjectBudget->PlaceHolder = RemoveHtml($this->ProjectBudget->caption());
        if (strval($this->ProjectBudget->EditValue) != "" && is_numeric($this->ProjectBudget->EditValue)) {
            $this->ProjectBudget->EditValue = FormatNumber($this->ProjectBudget->EditValue, null);
        }

        // StartMonth
        $this->StartMonth->setupEditAttributes();
        $this->StartMonth->PlaceHolder = RemoveHtml($this->StartMonth->caption());

        // EndMonth
        $this->EndMonth->setupEditAttributes();
        $this->EndMonth->PlaceHolder = RemoveHtml($this->EndMonth->caption());

        // LineNo
        $this->LineNo->setupEditAttributes();
        $this->LineNo->EditValue = $this->LineNo->CurrentValue;

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->Component);
                    $doc->exportCaption($this->Subcomponent);
                    $doc->exportCaption($this->InvestmentCost);
                    $doc->exportCaption($this->Type);
                    $doc->exportCaption($this->CategoryofExpenditure);
                    $doc->exportCaption($this->Activity);
                    $doc->exportCaption($this->Implementer);
                    $doc->exportCaption($this->Indicator);
                    $doc->exportCaption($this->ProjectTarget);
                    $doc->exportCaption($this->_2017Target);
                    $doc->exportCaption($this->ProjectBudget);
                    $doc->exportCaption($this->StartMonth);
                    $doc->exportCaption($this->EndMonth);
                    $doc->exportCaption($this->LineNo);
                } else {
                    $doc->exportCaption($this->Component);
                    $doc->exportCaption($this->Subcomponent);
                    $doc->exportCaption($this->InvestmentCost);
                    $doc->exportCaption($this->Type);
                    $doc->exportCaption($this->CategoryofExpenditure);
                    $doc->exportCaption($this->Activity);
                    $doc->exportCaption($this->Implementer);
                    $doc->exportCaption($this->Indicator);
                    $doc->exportCaption($this->ProjectTarget);
                    $doc->exportCaption($this->_2017Target);
                    $doc->exportCaption($this->ProjectBudget);
                    $doc->exportCaption($this->StartMonth);
                    $doc->exportCaption($this->EndMonth);
                    $doc->exportCaption($this->LineNo);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->Component);
                        $doc->exportField($this->Subcomponent);
                        $doc->exportField($this->InvestmentCost);
                        $doc->exportField($this->Type);
                        $doc->exportField($this->CategoryofExpenditure);
                        $doc->exportField($this->Activity);
                        $doc->exportField($this->Implementer);
                        $doc->exportField($this->Indicator);
                        $doc->exportField($this->ProjectTarget);
                        $doc->exportField($this->_2017Target);
                        $doc->exportField($this->ProjectBudget);
                        $doc->exportField($this->StartMonth);
                        $doc->exportField($this->EndMonth);
                        $doc->exportField($this->LineNo);
                    } else {
                        $doc->exportField($this->Component);
                        $doc->exportField($this->Subcomponent);
                        $doc->exportField($this->InvestmentCost);
                        $doc->exportField($this->Type);
                        $doc->exportField($this->CategoryofExpenditure);
                        $doc->exportField($this->Activity);
                        $doc->exportField($this->Implementer);
                        $doc->exportField($this->Indicator);
                        $doc->exportField($this->ProjectTarget);
                        $doc->exportField($this->_2017Target);
                        $doc->exportField($this->ProjectBudget);
                        $doc->exportField($this->StartMonth);
                        $doc->exportField($this->EndMonth);
                        $doc->exportField($this->LineNo);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'awp');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['LineNo'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'awp', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['LineNo'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'awp', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['LineNo'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'awp', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
