<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class UnitOfMeasureController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/UnitOfMeasureList[/{Unit_of_measure:.*}]", [PermissionMiddleware::class], "list.unit_of_measure")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UnitOfMeasureList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/UnitOfMeasureAdd[/{Unit_of_measure:.*}]", [PermissionMiddleware::class], "add.unit_of_measure")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UnitOfMeasureAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/UnitOfMeasureView[/{Unit_of_measure:.*}]", [PermissionMiddleware::class], "view.unit_of_measure")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UnitOfMeasureView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/UnitOfMeasureEdit[/{Unit_of_measure:.*}]", [PermissionMiddleware::class], "edit.unit_of_measure")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UnitOfMeasureEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/UnitOfMeasureDelete[/{Unit_of_measure:.*}]", [PermissionMiddleware::class], "delete.unit_of_measure")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UnitOfMeasureDelete");
    }
}
