<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class TrainingCourseController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/TrainingCourseList[/{TrainingRef}]", [PermissionMiddleware::class], "list.training_course")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TrainingCourseList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/TrainingCourseAdd[/{TrainingRef}]", [PermissionMiddleware::class], "add.training_course")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TrainingCourseAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/TrainingCourseView[/{TrainingRef}]", [PermissionMiddleware::class], "view.training_course")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TrainingCourseView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/TrainingCourseEdit[/{TrainingRef}]", [PermissionMiddleware::class], "edit.training_course")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TrainingCourseEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/TrainingCourseDelete[/{TrainingRef}]", [PermissionMiddleware::class], "delete.training_course")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TrainingCourseDelete");
    }
}
