<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class TraineeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/TraineeList[/{TraineeNo}]", [PermissionMiddleware::class], "list.trainee")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TraineeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/TraineeAdd[/{TraineeNo}]", [PermissionMiddleware::class], "add.trainee")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TraineeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/TraineeView[/{TraineeNo}]", [PermissionMiddleware::class], "view.trainee")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TraineeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/TraineeEdit[/{TraineeNo}]", [PermissionMiddleware::class], "edit.trainee")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TraineeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/TraineeDelete[/{TraineeNo}]", [PermissionMiddleware::class], "delete.trainee")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TraineeDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/TraineeSearch", [PermissionMiddleware::class], "search.trainee")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TraineeSearch");
    }
}
