<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class SexController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/SexList[/{Gender:.*}]", [PermissionMiddleware::class], "list.sex")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SexList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/SexAdd[/{Gender:.*}]", [PermissionMiddleware::class], "add.sex")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SexAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/SexView[/{Gender:.*}]", [PermissionMiddleware::class], "view.sex")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SexView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/SexEdit[/{Gender:.*}]", [PermissionMiddleware::class], "edit.sex")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SexEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/SexDelete[/{Gender:.*}]", [PermissionMiddleware::class], "delete.sex")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SexDelete");
    }
}
