<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class SeedVarietyController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/SeedVarietyList[/{SeedVariety:.*}]", [PermissionMiddleware::class], "list.seed_variety")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SeedVarietyList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/SeedVarietyAdd[/{SeedVariety:.*}]", [PermissionMiddleware::class], "add.seed_variety")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SeedVarietyAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/SeedVarietyView[/{SeedVariety:.*}]", [PermissionMiddleware::class], "view.seed_variety")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SeedVarietyView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/SeedVarietyEdit[/{SeedVariety:.*}]", [PermissionMiddleware::class], "edit.seed_variety")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SeedVarietyEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/SeedVarietyDelete[/{SeedVariety:.*}]", [PermissionMiddleware::class], "delete.seed_variety")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SeedVarietyDelete");
    }
}
