<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class SecurityMatrixController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/SecurityMatrixList[/{Security_number}]", [PermissionMiddleware::class], "list.security_matrix")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SecurityMatrixList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/SecurityMatrixAdd[/{Security_number}]", [PermissionMiddleware::class], "add.security_matrix")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SecurityMatrixAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/SecurityMatrixView[/{Security_number}]", [PermissionMiddleware::class], "view.security_matrix")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SecurityMatrixView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/SecurityMatrixEdit[/{Security_number}]", [PermissionMiddleware::class], "edit.security_matrix")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SecurityMatrixEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/SecurityMatrixDelete[/{Security_number}]", [PermissionMiddleware::class], "delete.security_matrix")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SecurityMatrixDelete");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/SecurityMatrixPreview", [PermissionMiddleware::class], "preview.security_matrix")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SecurityMatrixPreview", null, false);
    }
}
