<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class Season1920Controller extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/Season1920List", [PermissionMiddleware::class], "list.season19_20")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Season1920List");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/Season1920Search", [PermissionMiddleware::class], "search.season19_20")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Season1920Search");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/Season1920Query", [PermissionMiddleware::class], "query.season19_20")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "Season1920Search", "Season1920Query");
    }
}
