<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class MonthRefController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/MonthRefList[/{MonthCode}]", [PermissionMiddleware::class], "list.month_ref")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MonthRefList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/MonthRefAdd[/{MonthCode}]", [PermissionMiddleware::class], "add.month_ref")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MonthRefAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/MonthRefView[/{MonthCode}]", [PermissionMiddleware::class], "view.month_ref")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MonthRefView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/MonthRefEdit[/{MonthCode}]", [PermissionMiddleware::class], "edit.month_ref")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MonthRefEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/MonthRefDelete[/{MonthCode}]", [PermissionMiddleware::class], "delete.month_ref")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MonthRefDelete");
    }
}
