<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class GrantBeneficiaryController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/GrantBeneficiaryList", [PermissionMiddleware::class], "list.grant_beneficiary")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GrantBeneficiaryList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/GrantBeneficiaryAdd", [PermissionMiddleware::class], "add.grant_beneficiary")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GrantBeneficiaryAdd");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/GrantBeneficiarySearch", [PermissionMiddleware::class], "search.grant_beneficiary")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GrantBeneficiarySearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/GrantBeneficiaryPreview", [PermissionMiddleware::class], "preview.grant_beneficiary")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "GrantBeneficiaryPreview", null, false);
    }
}
