<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class GoodsReceivedNoteController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/GoodsReceivedNoteList[/{keys:.*}]", [PermissionMiddleware::class], "list.goods_received_note")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "GoodsReceivedNoteList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/GoodsReceivedNoteAdd[/{keys:.*}]", [PermissionMiddleware::class], "add.goods_received_note")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "GoodsReceivedNoteAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/GoodsReceivedNoteView[/{keys:.*}]", [PermissionMiddleware::class], "view.goods_received_note")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "GoodsReceivedNoteView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/GoodsReceivedNoteEdit[/{keys:.*}]", [PermissionMiddleware::class], "edit.goods_received_note")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "GoodsReceivedNoteEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/GoodsReceivedNoteDelete[/{keys:.*}]", [PermissionMiddleware::class], "delete.goods_received_note")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "GoodsReceivedNoteDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/GoodsReceivedNoteSearch", [PermissionMiddleware::class], "search.goods_received_note")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "GoodsReceivedNoteSearch");
    }

    // Get keys as associative array
    protected function getKeyParams($args)
    {
        global $RouteValues;
        if (array_key_exists("keys", $args)) {
            $sep = Container("goods_received_note")->RouteCompositeKeySeparator;
            $keys = explode($sep, $args["keys"]);
            if (count($keys) == 2) {
                $keyArgs = array_combine(["SupplierCode","GRN"], $keys);
                $RouteValues = array_merge(Route(), $keyArgs);
                $args = array_merge($args, $keyArgs);
            }
        }
        return $args;
    }
}
