<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class FieldTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/FieldTypeList[/{FieldType}]", [PermissionMiddleware::class], "list.field_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FieldTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/FieldTypeAdd[/{FieldType}]", [PermissionMiddleware::class], "add.field_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FieldTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/FieldTypeView[/{FieldType}]", [PermissionMiddleware::class], "view.field_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FieldTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/FieldTypeEdit[/{FieldType}]", [PermissionMiddleware::class], "edit.field_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FieldTypeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/FieldTypeDelete[/{FieldType}]", [PermissionMiddleware::class], "delete.field_type")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FieldTypeDelete");
    }
}
