<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class FarmerTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/FarmerTypeList[/{FarmerType}]", [PermissionMiddleware::class], "list.farmer_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/FarmerTypeAdd[/{FarmerType}]", [PermissionMiddleware::class], "add.farmer_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/FarmerTypeView[/{FarmerType}]", [PermissionMiddleware::class], "view.farmer_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/FarmerTypeEdit[/{FarmerType}]", [PermissionMiddleware::class], "edit.farmer_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerTypeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/FarmerTypeDelete[/{FarmerType}]", [PermissionMiddleware::class], "delete.farmer_type")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerTypeDelete");
    }
}
