<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class FarmOpenBalController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/FarmOpenBalList[/{TransNo}]", [PermissionMiddleware::class], "list.farm_open_bal")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmOpenBalList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/FarmOpenBalAdd[/{TransNo}]", [PermissionMiddleware::class], "add.farm_open_bal")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmOpenBalAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/FarmOpenBalView[/{TransNo}]", [PermissionMiddleware::class], "view.farm_open_bal")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmOpenBalView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/FarmOpenBalEdit[/{TransNo}]", [PermissionMiddleware::class], "edit.farm_open_bal")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmOpenBalEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/FarmOpenBalDelete[/{TransNo}]", [PermissionMiddleware::class], "delete.farm_open_bal")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmOpenBalDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/FarmOpenBalSearch", [PermissionMiddleware::class], "search.farm_open_bal")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmOpenBalSearch");
    }
}
