<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class CurrencyController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/CurrencyList[/{currency_code:.*}]", [PermissionMiddleware::class], "list.currency")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrencyList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/CurrencyAdd[/{currency_code:.*}]", [PermissionMiddleware::class], "add.currency")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrencyAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/CurrencyView[/{currency_code:.*}]", [PermissionMiddleware::class], "view.currency")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrencyView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/CurrencyEdit[/{currency_code:.*}]", [PermissionMiddleware::class], "edit.currency")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrencyEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/CurrencyDelete[/{currency_code:.*}]", [PermissionMiddleware::class], "delete.currency")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CurrencyDelete");
    }
}
