<?php

namespace PHPMaker2024\cidp24;

// Page object
$VillagePreview = &$Page;
?>
<script>
ew.deepAssign(ew.vars, { tables: { village: <?= JsonEncode($Page->toClientVar()) ?> } });
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php if ($Page->TotalRecords > 0) { ?>
<div class="card ew-grid <?= $Page->TableGridClass ?>"><!-- .card -->
<div class="card-header ew-grid-upper-panel ew-preview-upper-panel"><!-- .card-header -->
<?= $Page->Pager->render() ?>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card-header -->
<div class="card-body ew-preview-middle-panel ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>"><!-- .card-body -->
<table class="<?= $Page->TableClass ?>"><!-- .table -->
    <thead><!-- Table header -->
        <tr class="ew-table-header">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <?php if (!$Page->ProvinceCode->Sortable || !$Page->sortUrl($Page->ProvinceCode)) { ?>
        <th class="<?= $Page->ProvinceCode->headerCellClass() ?>"><?= $Page->ProvinceCode->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->ProvinceCode->headerCellClass() ?>"><div role="button" data-table="village" data-sort="<?= HtmlEncode($Page->ProvinceCode->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->ProvinceCode->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->ProvinceCode->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->ProvinceCode->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <?php if (!$Page->DistrictCode->Sortable || !$Page->sortUrl($Page->DistrictCode)) { ?>
        <th class="<?= $Page->DistrictCode->headerCellClass() ?>"><?= $Page->DistrictCode->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->DistrictCode->headerCellClass() ?>"><div role="button" data-table="village" data-sort="<?= HtmlEncode($Page->DistrictCode->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->DistrictCode->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->DistrictCode->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->DistrictCode->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <?php if (!$Page->CampCode->Sortable || !$Page->sortUrl($Page->CampCode)) { ?>
        <th class="<?= $Page->CampCode->headerCellClass() ?>"><?= $Page->CampCode->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->CampCode->headerCellClass() ?>"><div role="button" data-table="village" data-sort="<?= HtmlEncode($Page->CampCode->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->CampCode->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->CampCode->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->CampCode->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->Camp->Visible) { // Camp ?>
    <?php if (!$Page->Camp->Sortable || !$Page->sortUrl($Page->Camp)) { ?>
        <th class="<?= $Page->Camp->headerCellClass() ?>"><?= $Page->Camp->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->Camp->headerCellClass() ?>"><div role="button" data-table="village" data-sort="<?= HtmlEncode($Page->Camp->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->Camp->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->Camp->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->Camp->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <?php if (!$Page->VillageCode->Sortable || !$Page->sortUrl($Page->VillageCode)) { ?>
        <th class="<?= $Page->VillageCode->headerCellClass() ?>"><?= $Page->VillageCode->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->VillageCode->headerCellClass() ?>"><div role="button" data-table="village" data-sort="<?= HtmlEncode($Page->VillageCode->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->VillageCode->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->VillageCode->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->VillageCode->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php if ($Page->Village->Visible) { // Village ?>
    <?php if (!$Page->Village->Sortable || !$Page->sortUrl($Page->Village)) { ?>
        <th class="<?= $Page->Village->headerCellClass() ?>"><?= $Page->Village->caption() ?></th>
    <?php } else { ?>
        <th class="<?= $Page->Village->headerCellClass() ?>"><div role="button" data-table="village" data-sort="<?= HtmlEncode($Page->Village->Name) ?>" data-sort-type="1" data-sort-order="<?= $Page->Village->getNextSort() ?>">
            <div class="ew-table-header-btn">
                <span class="ew-table-header-caption"><?= $Page->Village->caption() ?></span>
                <span class="ew-table-header-sort"><?= $Page->Village->getSortIcon() ?></span>
            </div>
        </th>
    <?php } ?>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
        </tr>
    </thead>
    <tbody><!-- Table body -->
<?php
$Page->RecordCount = 0;
$Page->RowCount = 0;
while ($Page->fetch()) {
    // Init row class and style
    $Page->RecordCount++;
    $Page->RowCount++;
    $Page->CssStyle = "";
    $Page->loadListRowValues($Page->CurrentRow);

    // Render row
    $Page->RowType = RowType::PREVIEW; // Preview record
    $Page->resetAttributes();
    $Page->renderListRow();

    // Set up row attributes
    $Page->RowAttrs->merge([
        "data-rowindex" => $Page->RowCount,
        "class" => ($Page->RowCount % 2 != 1) ? "ew-table-alt-row" : "",

        // Add row attributes for expandable row
        "data-widget" => "expandable-table",
        "aria-expanded" => "false",
    ]);

    // Render list options
    $Page->renderListOptions();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <!-- ProvinceCode -->
        <td<?= $Page->ProvinceCode->cellAttributes() ?>>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <!-- DistrictCode -->
        <td<?= $Page->DistrictCode->cellAttributes() ?>>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
        <!-- CampCode -->
        <td<?= $Page->CampCode->cellAttributes() ?>>
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Camp->Visible) { // Camp ?>
        <!-- Camp -->
        <td<?= $Page->Camp->cellAttributes() ?>>
<span<?= $Page->Camp->viewAttributes() ?>>
<?= $Page->Camp->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <!-- VillageCode -->
        <td<?= $Page->VillageCode->cellAttributes() ?>>
<span<?= $Page->VillageCode->viewAttributes() ?>>
<?= $Page->VillageCode->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->Village->Visible) { // Village ?>
        <!-- Village -->
        <td<?= $Page->Village->cellAttributes() ?>>
<span<?= $Page->Village->viewAttributes() ?>>
<?= $Page->Village->getViewValue() ?></span>
</td>
<?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
} // while
?>
    </tbody>
</table><!-- /.table -->
</div><!-- /.card-body -->
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?= $Page->Pager->render() ?>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php } else { // No record ?>
<div class="card border-0"><!-- .card -->
<div class="ew-detail-count"><?= $Language->phrase("NoRecord") ?></div>
<?php if ($Page->OtherOptions->visible()) { ?>
<div class="ew-preview-other-options">
<?php
    foreach ($Page->OtherOptions as $option) {
        $option->render("body");
    }
?>
</div>
<?php } ?>
</div><!-- /.card -->
<?php } ?>
<?php
foreach ($Page->DetailCounts as $detailTblVar => $detailCount) {
?>
<div class="ew-detail-count d-none" data-table="<?= $detailTblVar ?>" data-count="<?= $detailCount ?>"><?= FormatInteger($detailCount) ?></div>
<?php
}
?>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php
$Page->Recordset?->free();
?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
