<?php

namespace PHPMaker2024\cidp24;

// Page object
$VillageFarmActivityReportSummary = &$Page;
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { Village_Farm_Activity_report: currentTable } });
var currentPageID = ew.PAGE_ID = "summary";
var currentForm;
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<a id="top"></a>
<!-- Content Container -->
<div id="ew-report" class="ew-report container-fluid">
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<div class="btn-toolbar ew-toolbar">
<?php
if (!$Page->DrillDownInPanel) {
    $Page->ExportOptions->render("body");
    $Page->SearchOptions->render("body");
    $Page->FilterOptions->render("body");
}
?>
</div>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<form name="fVillage_Farm_Activity_reportsrch" id="fVillage_Farm_Activity_reportsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fVillage_Farm_Activity_reportsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { Village_Farm_Activity_report: currentTable } });
var currentPageID = ew.PAGE_ID = "summary";
var currentForm;
var fVillage_Farm_Activity_reportsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fVillage_Farm_Activity_reportsrch")
        .setPageId("summary")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "DistrictName": <?= $Page->DistrictName->toClientList($Page) ?>,
            "CampName": <?= $Page->CampName->toClientList($Page) ?>,
            "Village": <?= $Page->Village->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
<?php
if (!$Page->DistrictName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_DistrictName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->DistrictName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_DistrictName"
            name="x_DistrictName[]"
            class="form-control ew-select<?= $Page->DistrictName->isInvalidClass() ?>"
            data-select2-id="fVillage_Farm_Activity_reportsrch_x_DistrictName"
            data-table="Village_Farm_Activity_report"
            data-field="x_DistrictName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->DistrictName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->DistrictName->editAttributes() ?>>
            <?= $Page->DistrictName->selectOptionListHtml("x_DistrictName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fVillage_Farm_Activity_reportsrch", function() {
            var options = {
                name: "x_DistrictName",
                selectId: "fVillage_Farm_Activity_reportsrch_x_DistrictName",
                ajax: { id: "x_DistrictName", form: "fVillage_Farm_Activity_reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Village_Farm_Activity_report.fields.DistrictName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->CampName->Visible) { // CampName ?>
<?php
if (!$Page->CampName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_CampName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->CampName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_CampName"
            name="x_CampName[]"
            class="form-control ew-select<?= $Page->CampName->isInvalidClass() ?>"
            data-select2-id="fVillage_Farm_Activity_reportsrch_x_CampName"
            data-table="Village_Farm_Activity_report"
            data-field="x_CampName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->CampName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->CampName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->CampName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->CampName->editAttributes() ?>>
            <?= $Page->CampName->selectOptionListHtml("x_CampName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->CampName->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fVillage_Farm_Activity_reportsrch", function() {
            var options = {
                name: "x_CampName",
                selectId: "fVillage_Farm_Activity_reportsrch_x_CampName",
                ajax: { id: "x_CampName", form: "fVillage_Farm_Activity_reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Village_Farm_Activity_report.fields.CampName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Village->Visible) { // Village ?>
<?php
if (!$Page->Village->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Village" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Village->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Village"
            name="x_Village[]"
            class="form-control ew-select<?= $Page->Village->isInvalidClass() ?>"
            data-select2-id="fVillage_Farm_Activity_reportsrch_x_Village"
            data-table="Village_Farm_Activity_report"
            data-field="x_Village"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Village->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Village->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Village->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Village->editAttributes() ?>>
            <?= $Page->Village->selectOptionListHtml("x_Village", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Village->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fVillage_Farm_Activity_reportsrch", function() {
            var options = {
                name: "x_Village",
                selectId: "fVillage_Farm_Activity_reportsrch_x_Village",
                ajax: { id: "x_Village", form: "fVillage_Farm_Activity_reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Village_Farm_Activity_report.fields.Village.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<?php if ($Page->ShowReport) { ?>
<!-- Summary report (begin) -->
<main class="report-summary<?= ($Page->TotalGroups == 0) ? " ew-no-record" : "" ?>">
<?php
while ($Page->GroupCount <= count($Page->GroupRecords) && $Page->GroupCount <= $Page->DisplayGroups) {
?>
<?php
    // Show header
    if ($Page->ShowHeader) {
?>
<?php if ($Page->GroupCount > 1) { ?>
</tbody>
</table>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php if ($Page->TotalGroups > 0) { ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<?php } ?>
</div>
<!-- /.ew-grid -->
<?= $Page->PageBreakHtml ?>
<?php } ?>
<div class="<?= $Page->ReportContainerClass ?>">
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Top pager -->
<div class="card-header ew-grid-upper-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<!-- Report grid (begin) -->
<div id="gmp_Village_Farm_Activity_report" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>">
<table class="<?= $Page->TableClass ?>">
<thead>
	<!-- Table header -->
    <tr class="ew-table-header">
<?php if ($Page->DistrictName->Visible) { ?>
    <?php if ($Page->DistrictName->ShowGroupHeaderAsRow) { ?>
    <th data-name="DistrictName"<?= $Page->DistrictName->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->DistrictName->groupToggleIcon() ?></th>
    <?php } else { ?>
    <th data-name="DistrictName" class="<?= $Page->DistrictName->headerCellClass() ?>"><div class="Village_Farm_Activity_report_DistrictName"><?= $Page->renderFieldHeader($Page->DistrictName) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
    <?php if ($Page->CampName->ShowGroupHeaderAsRow) { ?>
    <th data-name="CampName">&nbsp;</th>
    <?php } else { ?>
    <th data-name="CampName" class="<?= $Page->CampName->headerCellClass() ?>"><div class="Village_Farm_Activity_report_CampName"><?= $Page->renderFieldHeader($Page->CampName) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->Village->Visible) { ?>
    <?php if ($Page->Village->ShowGroupHeaderAsRow) { ?>
    <th data-name="Village">&nbsp;</th>
    <?php } else { ?>
    <th data-name="Village" class="<?= $Page->Village->headerCellClass() ?>"><div class="Village_Farm_Activity_report_Village"><?= $Page->renderFieldHeader($Page->Village) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
    <th data-name="FarmSizeEstimated" class="<?= $Page->FarmSizeEstimated->headerCellClass() ?>"><div class="Village_Farm_Activity_report_FarmSizeEstimated"><?= $Page->renderFieldHeader($Page->FarmSizeEstimated) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
    <th data-name="TreesPlantedEstimated" class="<?= $Page->TreesPlantedEstimated->headerCellClass() ?>"><div class="Village_Farm_Activity_report_TreesPlantedEstimated"><?= $Page->renderFieldHeader($Page->TreesPlantedEstimated) ?></div></th>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
    <th data-name="FarmSizeVerified" class="<?= $Page->FarmSizeVerified->headerCellClass() ?>"><div class="Village_Farm_Activity_report_FarmSizeVerified"><?= $Page->renderFieldHeader($Page->FarmSizeVerified) ?></div></th>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
    <th data-name="TreesPlantedVerified" class="<?= $Page->TreesPlantedVerified->headerCellClass() ?>"><div class="Village_Farm_Activity_report_TreesPlantedVerified"><?= $Page->renderFieldHeader($Page->TreesPlantedVerified) ?></div></th>
<?php } ?>
    </tr>
</thead>
<tbody>
<?php
        if ($Page->TotalGroups == 0) {
            break; // Show header only
        }
        $Page->ShowHeader = false;
    } // End show header
?>
<?php

    // Build detail SQL
    $where = DetailFilterSql($Page->DistrictName, $Page->getSqlFirstGroupField(), $Page->DistrictName->groupValue(), $Page->Dbid);
    AddFilter($Page->PageFirstGroupFilter, $where, "OR");
    AddFilter($where, $Page->Filter);
    $sql = $Page->buildReportSql($Page->getSqlSelect(), $Page->getSqlFrom(), $Page->getSqlWhere(), $Page->getSqlGroupBy(), $Page->getSqlHaving(), $Page->getSqlOrderBy(), $where, $Page->Sort);
    $rs = $sql->executeQuery();
    $Page->DetailRecords = $rs?->fetchAll() ?? [];
    $Page->DetailRecordCount = count($Page->DetailRecords);

    // Load detail records
    $Page->DistrictName->Records = &$Page->DetailRecords;
    $Page->DistrictName->LevelBreak = true; // Set field level break
        $Page->GroupCounter[1] = $Page->GroupCount;
        $Page->DistrictName->getCnt($Page->DistrictName->Records); // Get record count
?>
<?php if ($Page->DistrictName->Visible && $Page->DistrictName->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 1;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->DistrictName->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="DistrictName" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 1) ?>"<?= $Page->DistrictName->cellAttributes() ?>>
            <span class="ew-summary-caption Village_Farm_Activity_report_DistrictName"><?= $Page->renderFieldHeader($Page->DistrictName) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->DistrictName->viewAttributes() ?>><?= $Page->DistrictName->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->DistrictName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
    $Page->CampName->getDistinctValues($Page->DistrictName->Records, $Page->CampName->getSort());
    $Page->setGroupCount(count($Page->CampName->DistinctValues), $Page->GroupCounter[1]);
    $Page->GroupCounter[2] = 0; // Init group count index
    foreach ($Page->CampName->DistinctValues as $CampName) { // Load records for this distinct value
        $Page->CampName->setGroupValue($CampName); // Set group value
        $Page->CampName->getDistinctRecords($Page->DistrictName->Records, $Page->CampName->groupValue());
        $Page->CampName->LevelBreak = true; // Set field level break
        $Page->GroupCounter[2]++;
        $Page->CampName->getCnt($Page->CampName->Records); // Get record count
?>
<?php if ($Page->CampName->Visible && $Page->CampName->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->CampName->setDbValue($CampName); // Set current value for CampName
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 2;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->CampName->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="CampName" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 2) ?>"<?= $Page->CampName->cellAttributes() ?>>
            <span class="ew-summary-caption Village_Farm_Activity_report_CampName"><?= $Page->renderFieldHeader($Page->CampName) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->CampName->viewAttributes() ?>><?= $Page->CampName->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->CampName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
    $Page->Village->getDistinctValues($Page->CampName->Records, $Page->Village->getSort());
    $Page->setGroupCount(count($Page->Village->DistinctValues), $Page->GroupCounter[1], $Page->GroupCounter[2]);
    $Page->GroupCounter[3] = 0; // Init group count index
    foreach ($Page->Village->DistinctValues as $Village) { // Load records for this distinct value
        $Page->Village->setGroupValue($Village); // Set group value
        $Page->Village->getDistinctRecords($Page->CampName->Records, $Page->Village->groupValue());
        $Page->Village->LevelBreak = true; // Set field level break
        $Page->GroupCounter[3]++;
        $Page->Village->getCnt($Page->Village->Records); // Get record count
        $Page->setGroupCount($Page->Village->Count, $Page->GroupCounter[1], $Page->GroupCounter[2], $Page->GroupCounter[3]);
?>
<?php if ($Page->Village->Visible && $Page->Village->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->Village->setDbValue($Village); // Set current value for Village
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 3;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Village->Visible) { ?>
        <td data-field="Village"<?= $Page->Village->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->Village->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="Village" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 3) ?>"<?= $Page->Village->cellAttributes() ?>>
            <span class="ew-summary-caption Village_Farm_Activity_report_Village"><?= $Page->renderFieldHeader($Page->Village) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->Village->viewAttributes() ?>><?= $Page->Village->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->Village->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
        $Page->RecordCount = 0; // Reset record count
        foreach ($Page->Village->Records as $record) {
            $Page->RecordCount++;
            $Page->RecordIndex++;
            $Page->loadRowValues($record);
?>
<?php
        // Render detail row
        $Page->resetAttributes();
        $Page->RowType = RowType::DETAIL;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
    <?php if ($Page->DistrictName->ShowGroupHeaderAsRow) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>><span<?= $Page->DistrictName->viewAttributes() ?>><?= $Page->DistrictName->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
    <?php if ($Page->CampName->ShowGroupHeaderAsRow) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>><span<?= $Page->CampName->viewAttributes() ?>><?= $Page->CampName->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->Village->Visible) { ?>
    <?php if ($Page->Village->ShowGroupHeaderAsRow) { ?>
        <td data-field="Village"<?= $Page->Village->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="Village"<?= $Page->Village->cellAttributes() ?>><span<?= $Page->Village->viewAttributes() ?>><?= $Page->Village->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span<?= $Page->FarmSizeEstimated->viewAttributes() ?>>
<?= $Page->FarmSizeEstimated->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span<?= $Page->FarmSizeVerified->viewAttributes() ?>>
<?= $Page->FarmSizeVerified->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->getViewValue() ?></span>
</td>
<?php } ?>
    </tr>
<?php
    }
?>
<?php if ($Page->TotalGroups > 0) { ?>
<?php
    $Page->FarmSizeEstimated->getSum($Page->Village->Records, false); // Get Sum
    $Page->TreesPlantedEstimated->getSum($Page->Village->Records, false); // Get Sum
    $Page->FarmSizeVerified->getSum($Page->Village->Records, false); // Get Sum
    $Page->TreesPlantedVerified->getSum($Page->Village->Records, false); // Get Sum
    $Page->resetAttributes();
    $Page->RowType = RowType::TOTAL;
    $Page->RowTotalType = RowSummary::GROUP;
    $Page->RowTotalSubType = RowTotal::FOOTER;
    $Page->RowGroupLevel = 3;
    $Page->renderRow();
?>
<?php if ($Page->Village->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
    <?php if ($Page->DistrictName->ShowGroupHeaderAsRow) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 1) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->DistrictName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
    <?php if ($Page->CampName->ShowGroupHeaderAsRow) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 2) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->CampName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->Village->Visible) { ?>
    <?php if ($Page->Village->ShowGroupHeaderAsRow) { ?>
        <td data-field="Village"<?= $Page->Village->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 3) { ?>
        <td data-field="Village"<?= $Page->Village->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="Village"<?= $Page->Village->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->Village->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->Village->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FarmSizeEstimated->viewAttributes() ?>><?= $Page->FarmSizeEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->Village->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>><?= $Page->TreesPlantedEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->Village->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FarmSizeVerified->viewAttributes() ?>><?= $Page->FarmSizeVerified->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->Village->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedVerified->viewAttributes() ?>><?= $Page->TreesPlantedVerified->SumViewValue ?></span></span></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->SubGroupColumnCount + $Page->DetailColumnCount - 1 > 0) { ?>
        <td colspan="<?= ($Page->SubGroupColumnCount + $Page->DetailColumnCount - 1) ?>"<?= $Page->Village->cellAttributes() ?>><?= str_replace(["%v", "%c"], [$Page->Village->GroupViewValue, $Page->Village->caption()], $Language->phrase("RptSumHead")) ?> <span class="ew-dir-ltr">(<?= FormatNumber($Page->Village->Count, Config("DEFAULT_NUMBER_FORMAT")) ?><?= $Language->phrase("RptDtlRec") ?>)</span></td>
<?php } ?>
    </tr>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= ($Page->GroupColumnCount - 2) ?>"<?= $Page->Village->cellAttributes() ?>><?= $Language->phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span<?= $Page->FarmSizeEstimated->viewAttributes() ?>>
<?= $Page->FarmSizeEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span<?= $Page->FarmSizeVerified->viewAttributes() ?>>
<?= $Page->FarmSizeVerified->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->SumViewValue ?></span>
</td>
<?php } ?>
    </tr>
<?php } ?>
<?php } ?>
<?php
    } // End group level 2
?>
<?php if ($Page->TotalGroups > 0) { ?>
<?php
    $Page->FarmSizeEstimated->getSum($Page->CampName->Records, false); // Get Sum
    $Page->TreesPlantedEstimated->getSum($Page->CampName->Records, false); // Get Sum
    $Page->FarmSizeVerified->getSum($Page->CampName->Records, false); // Get Sum
    $Page->TreesPlantedVerified->getSum($Page->CampName->Records, false); // Get Sum
    $Page->resetAttributes();
    $Page->RowType = RowType::TOTAL;
    $Page->RowTotalType = RowSummary::GROUP;
    $Page->RowTotalSubType = RowTotal::FOOTER;
    $Page->RowGroupLevel = 2;
    $Page->renderRow();
?>
<?php if ($Page->CampName->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
    <?php if ($Page->DistrictName->ShowGroupHeaderAsRow) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 1) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->DistrictName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
    <?php if ($Page->CampName->ShowGroupHeaderAsRow) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 2) { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="CampName"<?= $Page->CampName->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->CampName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->Village->Visible) { ?>
    <?php if ($Page->Village->ShowGroupHeaderAsRow) { ?>
        <td data-field="Village"<?= $Page->CampName->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 3) { ?>
        <td data-field="Village"<?= $Page->CampName->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="Village"<?= $Page->CampName->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->Village->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->CampName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FarmSizeEstimated->viewAttributes() ?>><?= $Page->FarmSizeEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->CampName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>><?= $Page->TreesPlantedEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->CampName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FarmSizeVerified->viewAttributes() ?>><?= $Page->FarmSizeVerified->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->CampName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedVerified->viewAttributes() ?>><?= $Page->TreesPlantedVerified->SumViewValue ?></span></span></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->SubGroupColumnCount + $Page->DetailColumnCount > 0) { ?>
        <td colspan="<?= ($Page->SubGroupColumnCount + $Page->DetailColumnCount) ?>"<?= $Page->CampName->cellAttributes() ?>><?= str_replace(["%v", "%c"], [$Page->CampName->GroupViewValue, $Page->CampName->caption()], $Language->phrase("RptSumHead")) ?> <span class="ew-dir-ltr">(<?= FormatNumber($Page->CampName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?><?= $Language->phrase("RptDtlRec") ?>)</span></td>
<?php } ?>
    </tr>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= ($Page->GroupColumnCount - 1) ?>"<?= $Page->CampName->cellAttributes() ?>><?= $Language->phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span<?= $Page->FarmSizeEstimated->viewAttributes() ?>>
<?= $Page->FarmSizeEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span<?= $Page->FarmSizeVerified->viewAttributes() ?>>
<?= $Page->FarmSizeVerified->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->SumViewValue ?></span>
</td>
<?php } ?>
    </tr>
<?php } ?>
<?php } ?>
<?php
    } // End group level 1
?>
<?php if ($Page->TotalGroups > 0) { ?>
<?php
    $Page->FarmSizeEstimated->getSum($Page->DistrictName->Records, false); // Get Sum
    $Page->TreesPlantedEstimated->getSum($Page->DistrictName->Records, false); // Get Sum
    $Page->FarmSizeVerified->getSum($Page->DistrictName->Records, false); // Get Sum
    $Page->TreesPlantedVerified->getSum($Page->DistrictName->Records, false); // Get Sum
    $Page->resetAttributes();
    $Page->RowType = RowType::TOTAL;
    $Page->RowTotalType = RowSummary::GROUP;
    $Page->RowTotalSubType = RowTotal::FOOTER;
    $Page->RowGroupLevel = 1;
    $Page->renderRow();
?>
<?php if ($Page->DistrictName->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->DistrictName->Visible) { ?>
    <?php if ($Page->DistrictName->ShowGroupHeaderAsRow) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 1) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->DistrictName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->CampName->Visible) { ?>
    <?php if ($Page->CampName->ShowGroupHeaderAsRow) { ?>
        <td data-field="CampName"<?= $Page->DistrictName->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 2) { ?>
        <td data-field="CampName"<?= $Page->DistrictName->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="CampName"<?= $Page->DistrictName->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->CampName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->Village->Visible) { ?>
    <?php if ($Page->Village->ShowGroupHeaderAsRow) { ?>
        <td data-field="Village"<?= $Page->DistrictName->cellAttributes() ?>></td>
    <?php } elseif ($Page->RowGroupLevel != 3) { ?>
        <td data-field="Village"<?= $Page->DistrictName->cellAttributes() ?>>
        </td>
    <?php } else { ?>
        <td data-field="Village"<?= $Page->DistrictName->cellAttributes() ?>>
            <span class="ew-summary-count"><span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->Village->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span></span>
        </td>
    <?php } ?>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->DistrictName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FarmSizeEstimated->viewAttributes() ?>><?= $Page->FarmSizeEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->DistrictName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>><?= $Page->TreesPlantedEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->DistrictName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FarmSizeVerified->viewAttributes() ?>><?= $Page->FarmSizeVerified->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->DistrictName->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedVerified->viewAttributes() ?>><?= $Page->TreesPlantedVerified->SumViewValue ?></span></span></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->GroupColumnCount + $Page->DetailColumnCount > 0) { ?>
        <td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"<?= $Page->DistrictName->cellAttributes() ?>><?= str_replace(["%v", "%c"], [$Page->DistrictName->GroupViewValue, $Page->DistrictName->caption()], $Language->phrase("RptSumHead")) ?> <span class="ew-dir-ltr">(<?= FormatNumber($Page->DistrictName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?><?= $Language->phrase("RptDtlRec") ?>)</span></td>
<?php } ?>
    </tr>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= ($Page->GroupColumnCount - 0) ?>"<?= $Page->DistrictName->cellAttributes() ?>><?= $Language->phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span<?= $Page->FarmSizeEstimated->viewAttributes() ?>>
<?= $Page->FarmSizeEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span<?= $Page->FarmSizeVerified->viewAttributes() ?>>
<?= $Page->FarmSizeVerified->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->SumViewValue ?></span>
</td>
<?php } ?>
    </tr>
<?php } ?>
<?php } ?>
<?php
?>
<?php

    // Next group
    $Page->loadGroupRowValues();

    // Show header if page break
    if ($Page->isExport()) {
        $Page->ShowHeader = ($Page->ExportPageBreakCount == 0) ? false : ($Page->GroupCount % $Page->ExportPageBreakCount == 0);
    }

    // Page_Breaking server event
    if ($Page->ShowHeader) {
        $Page->pageBreaking($Page->ShowHeader, $Page->PageBreakHtml);
    }
    $Page->GroupCount++;
} // End while
?>
<?php if ($Page->TotalGroups > 0) { ?>
</tbody>
<tfoot>
<?php
    $Page->resetAttributes();
    $Page->RowType = RowType::TOTAL;
    $Page->RowTotalType = RowSummary::GRAND;
    $Page->RowTotalSubType = RowTotal::FOOTER;
    $Page->RowAttrs["class"] = "ew-rpt-grand-summary";
    $Page->renderRow();
?>
<?php if ($Page->DistrictName->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->TotalCount, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate"></td>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FarmSizeEstimated->viewAttributes() ?>><?= $Page->FarmSizeEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>><?= $Page->TreesPlantedEstimated->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->FarmSizeVerified->viewAttributes() ?>><?= $Page->FarmSizeVerified->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->TreesPlantedVerified->viewAttributes() ?>><?= $Page->TreesPlantedVerified->SumViewValue ?></span></span></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<?= FormatNumber($Page->TotalCount, Config("DEFAULT_NUMBER_FORMAT")) ?><?= $Language->phrase("RptDtlRec") ?>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate"><?= $Language->phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->FarmSizeEstimated->Visible) { ?>
        <td data-field="FarmSizeEstimated"<?= $Page->FarmSizeEstimated->cellAttributes() ?>>
<span<?= $Page->FarmSizeEstimated->viewAttributes() ?>>
<?= $Page->FarmSizeEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedEstimated->Visible) { ?>
        <td data-field="TreesPlantedEstimated"<?= $Page->TreesPlantedEstimated->cellAttributes() ?>>
<span<?= $Page->TreesPlantedEstimated->viewAttributes() ?>>
<?= $Page->TreesPlantedEstimated->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->FarmSizeVerified->Visible) { ?>
        <td data-field="FarmSizeVerified"<?= $Page->FarmSizeVerified->cellAttributes() ?>>
<span<?= $Page->FarmSizeVerified->viewAttributes() ?>>
<?= $Page->FarmSizeVerified->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesPlantedVerified->Visible) { ?>
        <td data-field="TreesPlantedVerified"<?= $Page->TreesPlantedVerified->cellAttributes() ?>>
<span<?= $Page->TreesPlantedVerified->viewAttributes() ?>>
<?= $Page->TreesPlantedVerified->SumViewValue ?></span>
</td>
<?php } ?>
    </tr>
<?php } ?>
</tfoot>
</table>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php if ($Page->TotalGroups > 0) { ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<?php } ?>
</div>
<!-- /.ew-grid -->
<?php } ?>
</main>
<!-- /.report-summary -->
<!-- Summary report (end) -->
<?php } ?>
</div>
<!-- /.ew-report -->
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
