<?php

namespace PHPMaker2024\cidp24;

// Page object
$VillageEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fvillageedit" id="fvillageedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { village: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fvillageedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fvillageedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["Camp", [fields.Camp.visible && fields.Camp.required ? ew.Validators.required(fields.Camp.caption) : null], fields.Camp.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null, ew.Validators.integer], fields.VillageCode.isInvalid],
            ["Village", [fields.Village.visible && fields.Village.required ? ew.Validators.required(fields.Village.caption) : null], fields.Village.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="village">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "camp") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="camp">
<input type="hidden" name="fk_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->getSessionValue()) ?>">
<input type="hidden" name="fk_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->getSessionValue()) ?>">
<input type="hidden" name="fk_CampCode" value="<?= HtmlEncode($Page->CampCode->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label id="elh_village_ProvinceCode" for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProvinceCode->caption() ?><?= $Page->ProvinceCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProvinceCode->cellAttributes() ?>>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x_ProvinceCode" name="x_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_village_ProvinceCode">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="fvillageedit_x_ProvinceCode"
        <?php } ?>
        data-table="village"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <?= $Page->ProvinceCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fvillageedit", function() {
    var options = { name: "x_ProvinceCode", selectId: "fvillageedit_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvillageedit.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "fvillageedit" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "fvillageedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.village.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label id="elh_village_DistrictCode" for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DistrictCode->caption() ?><?= $Page->DistrictCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x_DistrictCode" name="x_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_village_DistrictCode">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        data-select2-id="fvillageedit_x_DistrictCode"
        data-table="village"
        data-field="x_DistrictCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <?= $Page->DistrictCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<script>
loadjs.ready("fvillageedit", function() {
    var options = { name: "x_DistrictCode", selectId: "fvillageedit_x_DistrictCode" };
    if (fvillageedit.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "fvillageedit" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "fvillageedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.village.fields.DistrictCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode"<?= $Page->CampCode->rowAttributes() ?>>
        <label id="elh_village_CampCode" for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->CampCode->caption() ?><?= $Page->CampCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->CampCode->cellAttributes() ?>>
<?php if ($Page->CampCode->getSessionValue() != "") { ?>
<span<?= $Page->CampCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->CampCode->getDisplayValue($Page->CampCode->ViewValue) ?></span></span>
<input type="hidden" id="x_CampCode" name="x_CampCode" value="<?= HtmlEncode($Page->CampCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_village_CampCode">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-select ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        <?php if (!$Page->CampCode->IsNativeSelect) { ?>
        data-select2-id="fvillageedit_x_CampCode"
        <?php } ?>
        data-table="village"
        data-field="x_CampCode"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <?= $Page->CampCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<?php if (!$Page->CampCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fvillageedit", function() {
    var options = { name: "x_CampCode", selectId: "fvillageedit_x_CampCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fvillageedit.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "fvillageedit" };
    } else {
        options.ajax = { id: "x_CampCode", form: "fvillageedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.village.fields.CampCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Camp->Visible) { // Camp ?>
    <div id="r_Camp"<?= $Page->Camp->rowAttributes() ?>>
        <label id="elh_village_Camp" for="x_Camp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Camp->caption() ?><?= $Page->Camp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Camp->cellAttributes() ?>>
<span id="el_village_Camp">
<input type="<?= $Page->Camp->getInputTextType() ?>" name="x_Camp" id="x_Camp" data-table="village" data-field="x_Camp" value="<?= $Page->Camp->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Camp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Camp->formatPattern()) ?>"<?= $Page->Camp->editAttributes() ?> aria-describedby="x_Camp_help">
<?= $Page->Camp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Camp->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode"<?= $Page->VillageCode->rowAttributes() ?>>
        <label id="elh_village_VillageCode" for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->VillageCode->caption() ?><?= $Page->VillageCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->VillageCode->cellAttributes() ?>>
<span id="el_village_VillageCode">
<span<?= $Page->VillageCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->VillageCode->getDisplayValue($Page->VillageCode->EditValue))) ?>"></span>
<input type="hidden" data-table="village" data-field="x_VillageCode" data-hidden="1" name="x_VillageCode" id="x_VillageCode" value="<?= HtmlEncode($Page->VillageCode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Village->Visible) { // Village ?>
    <div id="r_Village"<?= $Page->Village->rowAttributes() ?>>
        <label id="elh_village_Village" for="x_Village" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Village->caption() ?><?= $Page->Village->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Village->cellAttributes() ?>>
<span id="el_village_Village">
<input type="<?= $Page->Village->getInputTextType() ?>" name="x_Village" id="x_Village" data-table="village" data-field="x_Village" value="<?= $Page->Village->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Village->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Village->formatPattern()) ?>"<?= $Page->Village->editAttributes() ?> aria-describedby="x_Village_help">
<?= $Page->Village->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Village->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?php
    if (in_array("farmer", explode(",", $Page->getCurrentDetailTable())) && $farmer->DetailEdit) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("farmer", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "FarmerGrid.php" ?>
<?php } ?>
<?php
    if (in_array("farm", explode(",", $Page->getCurrentDetailTable())) && $farm->DetailEdit) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("farm", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "FarmGrid.php" ?>
<?php } ?>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fvillageedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fvillageedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("village");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
