<?php

namespace PHPMaker2024\cidp24;

// Page object
$TraineeAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { trainee: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var ftraineeadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ftraineeadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["CampCode", [fields.CampCode.visible && fields.CampCode.required ? ew.Validators.required(fields.CampCode.caption) : null], fields.CampCode.isInvalid],
            ["VillageCode", [fields.VillageCode.visible && fields.VillageCode.required ? ew.Validators.required(fields.VillageCode.caption) : null], fields.VillageCode.isInvalid],
            ["NRC", [fields.NRC.visible && fields.NRC.required ? ew.Validators.required(fields.NRC.caption) : null], fields.NRC.isInvalid],
            ["TraineeName", [fields.TraineeName.visible && fields.TraineeName.required ? ew.Validators.required(fields.TraineeName.caption) : null], fields.TraineeName.isInvalid],
            ["DOB", [fields.DOB.visible && fields.DOB.required ? ew.Validators.required(fields.DOB.caption) : null, ew.Validators.datetime(fields.DOB.clientFormatPattern)], fields.DOB.isInvalid],
            ["Gender", [fields.Gender.visible && fields.Gender.required ? ew.Validators.required(fields.Gender.caption) : null], fields.Gender.isInvalid],
            ["MaritalStatus", [fields.MaritalStatus.visible && fields.MaritalStatus.required ? ew.Validators.required(fields.MaritalStatus.caption) : null], fields.MaritalStatus.isInvalid],
            ["PhoneNo", [fields.PhoneNo.visible && fields.PhoneNo.required ? ew.Validators.required(fields.PhoneNo.caption) : null], fields.PhoneNo.isInvalid],
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null, ew.Validators.email], fields._Email.isInvalid],
            ["Comments", [fields.Comments.visible && fields.Comments.required ? ew.Validators.required(fields.Comments.caption) : null], fields.Comments.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "CampCode": <?= $Page->CampCode->toClientList($Page) ?>,
            "VillageCode": <?= $Page->VillageCode->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
            "MaritalStatus": <?= $Page->MaritalStatus->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="ftraineeadd" id="ftraineeadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="trainee">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label id="elh_trainee_ProvinceCode" for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProvinceCode->caption() ?><?= $Page->ProvinceCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProvinceCode->cellAttributes() ?>>
<span id="el_trainee_ProvinceCode">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="ftraineeadd_x_ProvinceCode"
        <?php } ?>
        data-table="trainee"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <?= $Page->ProvinceCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraineeadd", function() {
    var options = { name: "x_ProvinceCode", selectId: "ftraineeadd_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraineeadd.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "ftraineeadd" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "ftraineeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.trainee.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label id="elh_trainee_DistrictCode" for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DistrictCode->caption() ?><?= $Page->DistrictCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DistrictCode->cellAttributes() ?>>
<span id="el_trainee_DistrictCode">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="ftraineeadd_x_DistrictCode"
        <?php } ?>
        data-table="trainee"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <?= $Page->DistrictCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraineeadd", function() {
    var options = { name: "x_DistrictCode", selectId: "ftraineeadd_x_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraineeadd.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "ftraineeadd" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "ftraineeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.trainee.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
    <div id="r_CampCode"<?= $Page->CampCode->rowAttributes() ?>>
        <label id="elh_trainee_CampCode" for="x_CampCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->CampCode->caption() ?><?= $Page->CampCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->CampCode->cellAttributes() ?>>
<span id="el_trainee_CampCode">
    <select
        id="x_CampCode"
        name="x_CampCode"
        class="form-control ew-select<?= $Page->CampCode->isInvalidClass() ?>"
        data-select2-id="ftraineeadd_x_CampCode"
        data-table="trainee"
        data-field="x_CampCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->CampCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->CampCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->CampCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->CampCode->editAttributes() ?>>
        <?= $Page->CampCode->selectOptionListHtml("x_CampCode") ?>
    </select>
    <?= $Page->CampCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->CampCode->getErrorMessage() ?></div>
<?= $Page->CampCode->Lookup->getParamTag($Page, "p_x_CampCode") ?>
<script>
loadjs.ready("ftraineeadd", function() {
    var options = { name: "x_CampCode", selectId: "ftraineeadd_x_CampCode" };
    if (ftraineeadd.lists.CampCode?.lookupOptions.length) {
        options.data = { id: "x_CampCode", form: "ftraineeadd" };
    } else {
        options.ajax = { id: "x_CampCode", form: "ftraineeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.trainee.fields.CampCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
    <div id="r_VillageCode"<?= $Page->VillageCode->rowAttributes() ?>>
        <label id="elh_trainee_VillageCode" for="x_VillageCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->VillageCode->caption() ?><?= $Page->VillageCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->VillageCode->cellAttributes() ?>>
<span id="el_trainee_VillageCode">
    <select
        id="x_VillageCode"
        name="x_VillageCode"
        class="form-control ew-select<?= $Page->VillageCode->isInvalidClass() ?>"
        data-select2-id="ftraineeadd_x_VillageCode"
        data-table="trainee"
        data-field="x_VillageCode"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->VillageCode->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->VillageCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->VillageCode->getPlaceHolder()) ?>"
        <?= $Page->VillageCode->editAttributes() ?>>
        <?= $Page->VillageCode->selectOptionListHtml("x_VillageCode") ?>
    </select>
    <?= $Page->VillageCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->VillageCode->getErrorMessage() ?></div>
<?= $Page->VillageCode->Lookup->getParamTag($Page, "p_x_VillageCode") ?>
<script>
loadjs.ready("ftraineeadd", function() {
    var options = { name: "x_VillageCode", selectId: "ftraineeadd_x_VillageCode" };
    if (ftraineeadd.lists.VillageCode?.lookupOptions.length) {
        options.data = { id: "x_VillageCode", form: "ftraineeadd" };
    } else {
        options.ajax = { id: "x_VillageCode", form: "ftraineeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.trainee.fields.VillageCode.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NRC->Visible) { // NRC ?>
    <div id="r_NRC"<?= $Page->NRC->rowAttributes() ?>>
        <label id="elh_trainee_NRC" for="x_NRC" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NRC->caption() ?><?= $Page->NRC->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NRC->cellAttributes() ?>>
<span id="el_trainee_NRC">
<input type="<?= $Page->NRC->getInputTextType() ?>" name="x_NRC" id="x_NRC" data-table="trainee" data-field="x_NRC" value="<?= $Page->NRC->EditValue ?>" size="30" maxlength="13" placeholder="<?= HtmlEncode($Page->NRC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NRC->formatPattern()) ?>"<?= $Page->NRC->editAttributes() ?> aria-describedby="x_NRC_help">
<?= $Page->NRC->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->NRC->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->TraineeName->Visible) { // TraineeName ?>
    <div id="r_TraineeName"<?= $Page->TraineeName->rowAttributes() ?>>
        <label id="elh_trainee_TraineeName" for="x_TraineeName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->TraineeName->caption() ?><?= $Page->TraineeName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->TraineeName->cellAttributes() ?>>
<span id="el_trainee_TraineeName">
<input type="<?= $Page->TraineeName->getInputTextType() ?>" name="x_TraineeName" id="x_TraineeName" data-table="trainee" data-field="x_TraineeName" value="<?= $Page->TraineeName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->TraineeName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->TraineeName->formatPattern()) ?>"<?= $Page->TraineeName->editAttributes() ?> aria-describedby="x_TraineeName_help">
<?= $Page->TraineeName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->TraineeName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DOB->Visible) { // DOB ?>
    <div id="r_DOB"<?= $Page->DOB->rowAttributes() ?>>
        <label id="elh_trainee_DOB" for="x_DOB" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DOB->caption() ?><?= $Page->DOB->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DOB->cellAttributes() ?>>
<span id="el_trainee_DOB">
<input type="<?= $Page->DOB->getInputTextType() ?>" name="x_DOB" id="x_DOB" data-table="trainee" data-field="x_DOB" value="<?= $Page->DOB->EditValue ?>" placeholder="<?= HtmlEncode($Page->DOB->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->DOB->formatPattern()) ?>"<?= $Page->DOB->editAttributes() ?> aria-describedby="x_DOB_help">
<?= $Page->DOB->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->DOB->getErrorMessage() ?></div>
<?php if (!$Page->DOB->ReadOnly && !$Page->DOB->Disabled && !isset($Page->DOB->EditAttrs["readonly"]) && !isset($Page->DOB->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["ftraineeadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("ftraineeadd", "x_DOB", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
    <div id="r_Gender"<?= $Page->Gender->rowAttributes() ?>>
        <label id="elh_trainee_Gender" for="x_Gender" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Gender->caption() ?><?= $Page->Gender->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Gender->cellAttributes() ?>>
<span id="el_trainee_Gender">
    <select
        id="x_Gender"
        name="x_Gender"
        class="form-select ew-select<?= $Page->Gender->isInvalidClass() ?>"
        <?php if (!$Page->Gender->IsNativeSelect) { ?>
        data-select2-id="ftraineeadd_x_Gender"
        <?php } ?>
        data-table="trainee"
        data-field="x_Gender"
        data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
        <?= $Page->Gender->editAttributes() ?>>
        <?= $Page->Gender->selectOptionListHtml("x_Gender") ?>
    </select>
    <?= $Page->Gender->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage() ?></div>
<?= $Page->Gender->Lookup->getParamTag($Page, "p_x_Gender") ?>
<?php if (!$Page->Gender->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraineeadd", function() {
    var options = { name: "x_Gender", selectId: "ftraineeadd_x_Gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraineeadd.lists.Gender?.lookupOptions.length) {
        options.data = { id: "x_Gender", form: "ftraineeadd" };
    } else {
        options.ajax = { id: "x_Gender", form: "ftraineeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.trainee.fields.Gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->MaritalStatus->Visible) { // MaritalStatus ?>
    <div id="r_MaritalStatus"<?= $Page->MaritalStatus->rowAttributes() ?>>
        <label id="elh_trainee_MaritalStatus" for="x_MaritalStatus" class="<?= $Page->LeftColumnClass ?>"><?= $Page->MaritalStatus->caption() ?><?= $Page->MaritalStatus->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->MaritalStatus->cellAttributes() ?>>
<span id="el_trainee_MaritalStatus">
    <select
        id="x_MaritalStatus"
        name="x_MaritalStatus"
        class="form-select ew-select<?= $Page->MaritalStatus->isInvalidClass() ?>"
        <?php if (!$Page->MaritalStatus->IsNativeSelect) { ?>
        data-select2-id="ftraineeadd_x_MaritalStatus"
        <?php } ?>
        data-table="trainee"
        data-field="x_MaritalStatus"
        data-value-separator="<?= $Page->MaritalStatus->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->MaritalStatus->getPlaceHolder()) ?>"
        <?= $Page->MaritalStatus->editAttributes() ?>>
        <?= $Page->MaritalStatus->selectOptionListHtml("x_MaritalStatus") ?>
    </select>
    <?= $Page->MaritalStatus->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->MaritalStatus->getErrorMessage() ?></div>
<?= $Page->MaritalStatus->Lookup->getParamTag($Page, "p_x_MaritalStatus") ?>
<?php if (!$Page->MaritalStatus->IsNativeSelect) { ?>
<script>
loadjs.ready("ftraineeadd", function() {
    var options = { name: "x_MaritalStatus", selectId: "ftraineeadd_x_MaritalStatus" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftraineeadd.lists.MaritalStatus?.lookupOptions.length) {
        options.data = { id: "x_MaritalStatus", form: "ftraineeadd" };
    } else {
        options.ajax = { id: "x_MaritalStatus", form: "ftraineeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.trainee.fields.MaritalStatus.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PhoneNo->Visible) { // PhoneNo ?>
    <div id="r_PhoneNo"<?= $Page->PhoneNo->rowAttributes() ?>>
        <label id="elh_trainee_PhoneNo" for="x_PhoneNo" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PhoneNo->caption() ?><?= $Page->PhoneNo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PhoneNo->cellAttributes() ?>>
<span id="el_trainee_PhoneNo">
<input type="<?= $Page->PhoneNo->getInputTextType() ?>" name="x_PhoneNo" id="x_PhoneNo" data-table="trainee" data-field="x_PhoneNo" value="<?= $Page->PhoneNo->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->PhoneNo->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PhoneNo->formatPattern()) ?>"<?= $Page->PhoneNo->editAttributes() ?> aria-describedby="x_PhoneNo_help">
<?= $Page->PhoneNo->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PhoneNo->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
    <div id="r__Email"<?= $Page->_Email->rowAttributes() ?>>
        <label id="elh_trainee__Email" for="x__Email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_Email->caption() ?><?= $Page->_Email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Email->cellAttributes() ?>>
<span id="el_trainee__Email">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="trainee" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?> aria-describedby="x__Email_help">
<?= $Page->_Email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Comments->Visible) { // Comments ?>
    <div id="r_Comments"<?= $Page->Comments->rowAttributes() ?>>
        <label id="elh_trainee_Comments" for="x_Comments" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Comments->caption() ?><?= $Page->Comments->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Comments->cellAttributes() ?>>
<span id="el_trainee_Comments">
<textarea data-table="trainee" data-field="x_Comments" name="x_Comments" id="x_Comments" cols="35" rows="2" placeholder="<?= HtmlEncode($Page->Comments->getPlaceHolder()) ?>"<?= $Page->Comments->editAttributes() ?> aria-describedby="x_Comments_help"><?= $Page->Comments->EditValue ?></textarea>
<?= $Page->Comments->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Comments->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="ftraineeadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ftraineeadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("trainee");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
