<?php

namespace PHPMaker2024\cidp24;

// Page object
$SeedAllocationSummaryReportSummary = &$Page;
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { Seed_Allocation_Summary_Report: currentTable } });
var currentPageID = ew.PAGE_ID = "summary";
var currentForm;
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<a id="top"></a>
<!-- Content Container -->
<div id="ew-report" class="ew-report container-fluid">
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<div class="btn-toolbar ew-toolbar">
<?php
if (!$Page->DrillDownInPanel) {
    $Page->ExportOptions->render("body");
    $Page->SearchOptions->render("body");
    $Page->FilterOptions->render("body");
}
?>
</div>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<form name="fSeed_Allocation_Summary_Reportsrch" id="fSeed_Allocation_Summary_Reportsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" autocomplete="off">
<div id="fSeed_Allocation_Summary_Reportsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { Seed_Allocation_Summary_Report: currentTable } });
var currentPageID = ew.PAGE_ID = "summary";
var currentForm;
var fSeed_Allocation_Summary_Reportsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fSeed_Allocation_Summary_Reportsrch")
        .setPageId("summary")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "DistrictName": <?= $Page->DistrictName->toClientList($Page) ?>,
            "AgeGroup": <?= $Page->AgeGroup->toClientList($Page) ?>,
            "Gender": <?= $Page->Gender->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
<?php
if (!$Page->DistrictCode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_DistrictCode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->DistrictCode->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_DistrictCode"
            name="x_DistrictCode[]"
            class="form-control ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
            data-select2-id="fSeed_Allocation_Summary_Reportsrch_x_DistrictCode"
            data-table="Seed_Allocation_Summary_Report"
            data-field="x_DistrictCode"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictCode->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->DistrictCode->editAttributes() ?>>
            <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fSeed_Allocation_Summary_Reportsrch", function() {
            var options = {
                name: "x_DistrictCode",
                selectId: "fSeed_Allocation_Summary_Reportsrch_x_DistrictCode",
                ajax: { id: "x_DistrictCode", form: "fSeed_Allocation_Summary_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Seed_Allocation_Summary_Report.fields.DistrictCode.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->DistrictName->Visible) { // DistrictName ?>
<?php
if (!$Page->DistrictName->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_DistrictName" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->DistrictName->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_DistrictName"
            name="x_DistrictName[]"
            class="form-control ew-select<?= $Page->DistrictName->isInvalidClass() ?>"
            data-select2-id="fSeed_Allocation_Summary_Reportsrch_x_DistrictName"
            data-table="Seed_Allocation_Summary_Report"
            data-field="x_DistrictName"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->DistrictName->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->DistrictName->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->DistrictName->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->DistrictName->editAttributes() ?>>
            <?= $Page->DistrictName->selectOptionListHtml("x_DistrictName", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->DistrictName->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fSeed_Allocation_Summary_Reportsrch", function() {
            var options = {
                name: "x_DistrictName",
                selectId: "fSeed_Allocation_Summary_Reportsrch_x_DistrictName",
                ajax: { id: "x_DistrictName", form: "fSeed_Allocation_Summary_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Seed_Allocation_Summary_Report.fields.DistrictName.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->AgeGroup->Visible) { // AgeGroup ?>
<?php
if (!$Page->AgeGroup->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_AgeGroup" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->AgeGroup->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_AgeGroup"
            name="x_AgeGroup[]"
            class="form-control ew-select<?= $Page->AgeGroup->isInvalidClass() ?>"
            data-select2-id="fSeed_Allocation_Summary_Reportsrch_x_AgeGroup"
            data-table="Seed_Allocation_Summary_Report"
            data-field="x_AgeGroup"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->AgeGroup->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->AgeGroup->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->AgeGroup->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->AgeGroup->editAttributes() ?>>
            <?= $Page->AgeGroup->selectOptionListHtml("x_AgeGroup", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->AgeGroup->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fSeed_Allocation_Summary_Reportsrch", function() {
            var options = {
                name: "x_AgeGroup",
                selectId: "fSeed_Allocation_Summary_Reportsrch_x_AgeGroup",
                ajax: { id: "x_AgeGroup", form: "fSeed_Allocation_Summary_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Seed_Allocation_Summary_Report.fields.AgeGroup.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Gender->Visible) { // Gender ?>
<?php
if (!$Page->Gender->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Gender" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Gender->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_Gender"
            name="x_Gender[]"
            class="form-control ew-select<?= $Page->Gender->isInvalidClass() ?>"
            data-select2-id="fSeed_Allocation_Summary_Reportsrch_x_Gender"
            data-table="Seed_Allocation_Summary_Report"
            data-field="x_Gender"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->Gender->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->Gender->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->Gender->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->Gender->editAttributes() ?>>
            <?= $Page->Gender->selectOptionListHtml("x_Gender", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->Gender->getErrorMessage() ?></div>
        <script>
        loadjs.ready("fSeed_Allocation_Summary_Reportsrch", function() {
            var options = {
                name: "x_Gender",
                selectId: "fSeed_Allocation_Summary_Reportsrch_x_Gender",
                ajax: { id: "x_Gender", form: "fSeed_Allocation_Summary_Reportsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.Seed_Allocation_Summary_Report.fields.Gender.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
<!-- Middle Container -->
<div id="ew-middle" class="<?= $Page->MiddleContentClass ?>">
<?php } ?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
<!-- Content Container -->
<div id="ew-content" class="<?= $Page->ContainerClass ?>">
<?php } ?>
<?php if ($Page->ShowReport) { ?>
<!-- Summary report (begin) -->
<main class="report-summary<?= ($Page->TotalGroups == 0) ? " ew-no-record" : "" ?>">
<?php
while ($Page->GroupCount <= count($Page->GroupRecords) && $Page->GroupCount <= $Page->DisplayGroups) {
?>
<?php
    // Show header
    if ($Page->ShowHeader) {
?>
<?php if ($Page->GroupCount > 1) { ?>
</tbody>
</table>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php if ($Page->TotalGroups > 0) { ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<?php } ?>
</div>
<!-- /.ew-grid -->
<?= $Page->PageBreakHtml ?>
<?php } ?>
<div class="<?= $Page->ReportContainerClass ?>">
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Top pager -->
<div class="card-header ew-grid-upper-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<!-- Report grid (begin) -->
<div id="gmp_Seed_Allocation_Summary_Report" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>">
<table class="<?= $Page->TableClass ?>">
<thead>
	<!-- Table header -->
    <tr class="ew-table-header">
<?php if ($Page->FarmingSeason->Visible) { ?>
    <?php if ($Page->FarmingSeason->ShowGroupHeaderAsRow) { ?>
    <th data-name="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->FarmingSeason->groupToggleIcon() ?></th>
    <?php } else { ?>
    <th data-name="FarmingSeason" class="<?= $Page->FarmingSeason->headerCellClass() ?>"><div class="Seed_Allocation_Summary_Report_FarmingSeason"><?= $Page->renderFieldHeader($Page->FarmingSeason) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { ?>
    <?php if ($Page->DistrictName->ShowGroupHeaderAsRow) { ?>
    <th data-name="DistrictName">&nbsp;</th>
    <?php } else { ?>
    <th data-name="DistrictName" class="<?= $Page->DistrictName->headerCellClass() ?>"><div class="Seed_Allocation_Summary_Report_DistrictName"><?= $Page->renderFieldHeader($Page->DistrictName) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->AgeGroup->Visible) { ?>
    <?php if ($Page->AgeGroup->ShowGroupHeaderAsRow) { ?>
    <th data-name="AgeGroup">&nbsp;</th>
    <?php } else { ?>
    <th data-name="AgeGroup" class="<?= $Page->AgeGroup->headerCellClass() ?>"><div class="Seed_Allocation_Summary_Report_AgeGroup"><?= $Page->renderFieldHeader($Page->AgeGroup) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->Gender->Visible) { ?>
    <?php if ($Page->Gender->ShowGroupHeaderAsRow) { ?>
    <th data-name="Gender">&nbsp;</th>
    <?php } else { ?>
    <th data-name="Gender" class="<?= $Page->Gender->headerCellClass() ?>"><div class="Seed_Allocation_Summary_Report_Gender"><?= $Page->renderFieldHeader($Page->Gender) ?></div></th>
    <?php } ?>
<?php } ?>
<?php if ($Page->NoOfBeneficiaries->Visible) { ?>
    <th data-name="NoOfBeneficiaries" class="<?= $Page->NoOfBeneficiaries->headerCellClass() ?>"><div class="Seed_Allocation_Summary_Report_NoOfBeneficiaries"><?= $Page->renderFieldHeader($Page->NoOfBeneficiaries) ?></div></th>
<?php } ?>
<?php if ($Page->TreesAllocated->Visible) { ?>
    <th data-name="TreesAllocated" class="<?= $Page->TreesAllocated->headerCellClass() ?>"><div class="Seed_Allocation_Summary_Report_TreesAllocated"><?= $Page->renderFieldHeader($Page->TreesAllocated) ?></div></th>
<?php } ?>
    </tr>
</thead>
<tbody>
<?php
        if ($Page->TotalGroups == 0) {
            break; // Show header only
        }
        $Page->ShowHeader = false;
    } // End show header
?>
<?php

    // Build detail SQL
    $where = DetailFilterSql($Page->FarmingSeason, $Page->getSqlFirstGroupField(), $Page->FarmingSeason->groupValue(), $Page->Dbid);
    AddFilter($Page->PageFirstGroupFilter, $where, "OR");
    AddFilter($where, $Page->Filter);
    $sql = $Page->buildReportSql($Page->getSqlSelect(), $Page->getSqlFrom(), $Page->getSqlWhere(), $Page->getSqlGroupBy(), $Page->getSqlHaving(), $Page->getSqlOrderBy(), $where, $Page->Sort);
    $rs = $sql->executeQuery();
    $Page->DetailRecords = $rs?->fetchAll() ?? [];
    $Page->DetailRecordCount = count($Page->DetailRecords);

    // Load detail records
    $Page->FarmingSeason->Records = &$Page->DetailRecords;
    $Page->FarmingSeason->LevelBreak = true; // Set field level break
        $Page->GroupCounter[1] = $Page->GroupCount;
        $Page->FarmingSeason->getCnt($Page->FarmingSeason->Records); // Get record count
?>
<?php if ($Page->FarmingSeason->Visible && $Page->FarmingSeason->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 1;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->FarmingSeason->Visible) { ?>
        <td data-field="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->FarmingSeason->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="FarmingSeason" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 1) ?>"<?= $Page->FarmingSeason->cellAttributes() ?>>
            <span class="ew-summary-caption Seed_Allocation_Summary_Report_FarmingSeason"><?= $Page->renderFieldHeader($Page->FarmingSeason) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->FarmingSeason->viewAttributes() ?>><?= $Page->FarmingSeason->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->FarmingSeason->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
    $Page->DistrictName->getDistinctValues($Page->FarmingSeason->Records, $Page->DistrictName->getSort());
    $Page->setGroupCount(count($Page->DistrictName->DistinctValues), $Page->GroupCounter[1]);
    $Page->GroupCounter[2] = 0; // Init group count index
    foreach ($Page->DistrictName->DistinctValues as $DistrictName) { // Load records for this distinct value
        $Page->DistrictName->setGroupValue($DistrictName); // Set group value
        $Page->DistrictName->getDistinctRecords($Page->FarmingSeason->Records, $Page->DistrictName->groupValue());
        $Page->DistrictName->LevelBreak = true; // Set field level break
        $Page->GroupCounter[2]++;
        $Page->DistrictName->getCnt($Page->DistrictName->Records); // Get record count
?>
<?php if ($Page->DistrictName->Visible && $Page->DistrictName->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->DistrictName->setDbValue($DistrictName); // Set current value for DistrictName
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 2;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->FarmingSeason->Visible) { ?>
        <td data-field="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->DistrictName->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="DistrictName" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 2) ?>"<?= $Page->DistrictName->cellAttributes() ?>>
            <span class="ew-summary-caption Seed_Allocation_Summary_Report_DistrictName"><?= $Page->renderFieldHeader($Page->DistrictName) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->DistrictName->viewAttributes() ?>><?= $Page->DistrictName->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->DistrictName->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
    $Page->AgeGroup->getDistinctValues($Page->DistrictName->Records, $Page->AgeGroup->getSort());
    $Page->setGroupCount(count($Page->AgeGroup->DistinctValues), $Page->GroupCounter[1], $Page->GroupCounter[2]);
    $Page->GroupCounter[3] = 0; // Init group count index
    foreach ($Page->AgeGroup->DistinctValues as $AgeGroup) { // Load records for this distinct value
        $Page->AgeGroup->setGroupValue($AgeGroup); // Set group value
        $Page->AgeGroup->getDistinctRecords($Page->DistrictName->Records, $Page->AgeGroup->groupValue());
        $Page->AgeGroup->LevelBreak = true; // Set field level break
        $Page->GroupCounter[3]++;
        $Page->AgeGroup->getCnt($Page->AgeGroup->Records); // Get record count
?>
<?php if ($Page->AgeGroup->Visible && $Page->AgeGroup->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->AgeGroup->setDbValue($AgeGroup); // Set current value for AgeGroup
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 3;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->FarmingSeason->Visible) { ?>
        <td data-field="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->AgeGroup->Visible) { ?>
        <td data-field="AgeGroup"<?= $Page->AgeGroup->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->AgeGroup->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="AgeGroup" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 3) ?>"<?= $Page->AgeGroup->cellAttributes() ?>>
            <span class="ew-summary-caption Seed_Allocation_Summary_Report_AgeGroup"><?= $Page->renderFieldHeader($Page->AgeGroup) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->AgeGroup->viewAttributes() ?>><?= $Page->AgeGroup->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->AgeGroup->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
    $Page->Gender->getDistinctValues($Page->AgeGroup->Records, $Page->Gender->getSort());
    $Page->setGroupCount(count($Page->Gender->DistinctValues), $Page->GroupCounter[1], $Page->GroupCounter[2], $Page->GroupCounter[3]);
    $Page->GroupCounter[4] = 0; // Init group count index
    foreach ($Page->Gender->DistinctValues as $Gender) { // Load records for this distinct value
        $Page->Gender->setGroupValue($Gender); // Set group value
        $Page->Gender->getDistinctRecords($Page->AgeGroup->Records, $Page->Gender->groupValue());
        $Page->Gender->LevelBreak = true; // Set field level break
        $Page->GroupCounter[4]++;
        $Page->Gender->getCnt($Page->Gender->Records); // Get record count
        $Page->setGroupCount($Page->Gender->Count, $Page->GroupCounter[1], $Page->GroupCounter[2], $Page->GroupCounter[3], $Page->GroupCounter[4]);
?>
<?php if ($Page->Gender->Visible && $Page->Gender->ShowGroupHeaderAsRow) { ?>
<?php
        // Render header row
        $Page->Gender->setDbValue($Gender); // Set current value for Gender
        $Page->resetAttributes();
        $Page->RowType = RowType::TOTAL;
        $Page->RowTotalType = RowSummary::GROUP;
        $Page->RowTotalSubType = RowTotal::HEADER;
        $Page->RowGroupLevel = 4;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->FarmingSeason->Visible) { ?>
        <td data-field="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->AgeGroup->Visible) { ?>
        <td data-field="AgeGroup"<?= $Page->AgeGroup->cellAttributes() ?>></td>
<?php } ?>
<?php if ($Page->Gender->Visible) { ?>
        <td data-field="Gender"<?= $Page->Gender->cellAttributes("ew-rpt-grp-caret") ?>><?= $Page->Gender->groupToggleIcon() ?></td>
<?php } ?>
        <td data-field="Gender" colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount - 4) ?>"<?= $Page->Gender->cellAttributes() ?>>
            <span class="ew-summary-caption Seed_Allocation_Summary_Report_Gender"><?= $Page->renderFieldHeader($Page->Gender) ?></span><?= $Language->phrase("SummaryColon") ?><span<?= $Page->Gender->viewAttributes() ?>><?= $Page->Gender->GroupViewValue ?></span>
            <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->Gender->Count, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span>
        </td>
    </tr>
<?php } ?>
<?php
        $Page->RecordCount = 0; // Reset record count
        foreach ($Page->Gender->Records as $record) {
            $Page->RecordCount++;
            $Page->RecordIndex++;
            $Page->loadRowValues($record);
?>
<?php
        // Render detail row
        $Page->resetAttributes();
        $Page->RowType = RowType::DETAIL;
        $Page->renderRow();
?>
    <tr<?= $Page->rowAttributes(); ?>>
<?php if ($Page->FarmingSeason->Visible) { ?>
    <?php if ($Page->FarmingSeason->ShowGroupHeaderAsRow) { ?>
        <td data-field="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="FarmingSeason"<?= $Page->FarmingSeason->cellAttributes() ?>><span<?= $Page->FarmingSeason->viewAttributes() ?>><?= $Page->FarmingSeason->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->DistrictName->Visible) { ?>
    <?php if ($Page->DistrictName->ShowGroupHeaderAsRow) { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="DistrictName"<?= $Page->DistrictName->cellAttributes() ?>><span<?= $Page->DistrictName->viewAttributes() ?>><?= $Page->DistrictName->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->AgeGroup->Visible) { ?>
    <?php if ($Page->AgeGroup->ShowGroupHeaderAsRow) { ?>
        <td data-field="AgeGroup"<?= $Page->AgeGroup->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="AgeGroup"<?= $Page->AgeGroup->cellAttributes() ?>><span<?= $Page->AgeGroup->viewAttributes() ?>><?= $Page->AgeGroup->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->Gender->Visible) { ?>
    <?php if ($Page->Gender->ShowGroupHeaderAsRow) { ?>
        <td data-field="Gender"<?= $Page->Gender->cellAttributes() ?>></td>
    <?php } else { ?>
        <td data-field="Gender"<?= $Page->Gender->cellAttributes() ?>><span<?= $Page->Gender->viewAttributes() ?>><?= $Page->Gender->GroupViewValue ?></span></td>
    <?php } ?>
<?php } ?>
<?php if ($Page->NoOfBeneficiaries->Visible) { ?>
        <td data-field="NoOfBeneficiaries"<?= $Page->NoOfBeneficiaries->cellAttributes() ?>>
<span<?= $Page->NoOfBeneficiaries->viewAttributes() ?>>
<?= $Page->NoOfBeneficiaries->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesAllocated->Visible) { ?>
        <td data-field="TreesAllocated"<?= $Page->TreesAllocated->cellAttributes() ?>>
<span<?= $Page->TreesAllocated->viewAttributes() ?>>
<?= $Page->TreesAllocated->getViewValue() ?></span>
</td>
<?php } ?>
    </tr>
<?php
    }
    } // End group level 3
    } // End group level 2
    } // End group level 1
?>
<?php

    // Next group
    $Page->loadGroupRowValues();

    // Show header if page break
    if ($Page->isExport()) {
        $Page->ShowHeader = ($Page->ExportPageBreakCount == 0) ? false : ($Page->GroupCount % $Page->ExportPageBreakCount == 0);
    }

    // Page_Breaking server event
    if ($Page->ShowHeader) {
        $Page->pageBreaking($Page->ShowHeader, $Page->PageBreakHtml);
    }
    $Page->GroupCount++;
} // End while
?>
<?php if ($Page->TotalGroups > 0) { ?>
</tbody>
<tfoot>
<?php
    $Page->resetAttributes();
    $Page->RowType = RowType::TOTAL;
    $Page->RowTotalType = RowSummary::GRAND;
    $Page->RowTotalSubType = RowTotal::FOOTER;
    $Page->RowAttrs["class"] = "ew-rpt-grand-summary";
    $Page->renderRow();
?>
<?php if ($Page->FarmingSeason->ShowCompactSummaryFooter) { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<span class="ew-aggregate-caption"><?= $Language->phrase("RptCnt") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><?= FormatNumber($Page->TotalCount, Config("DEFAULT_NUMBER_FORMAT")) ?></span>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate"></td>
<?php } ?>
<?php if ($Page->NoOfBeneficiaries->Visible) { ?>
        <td data-field="NoOfBeneficiaries"<?= $Page->NoOfBeneficiaries->cellAttributes() ?>><span class="ew-aggregate-caption"><?= $Language->phrase("RptSum") ?></span><span class="ew-aggregate-equal"><?= $Language->phrase("AggregateEqual") ?></span><span class="ew-aggregate-value"><span<?= $Page->NoOfBeneficiaries->viewAttributes() ?>><?= $Page->NoOfBeneficiaries->SumViewValue ?></span></span></td>
<?php } ?>
<?php if ($Page->TreesAllocated->Visible) { ?>
        <td data-field="TreesAllocated"<?= $Page->TreesAllocated->cellAttributes() ?>></td>
<?php } ?>
    </tr>
<?php } else { ?>
    <tr<?= $Page->rowAttributes() ?>><td colspan="<?= ($Page->GroupColumnCount + $Page->DetailColumnCount) ?>"><?= $Language->phrase("RptGrandSummary") ?> <span class="ew-summary-count">(<?= FormatNumber($Page->TotalCount, Config("DEFAULT_NUMBER_FORMAT")) ?><?= $Language->phrase("RptDtlRec") ?>)</span></td></tr>
    <tr<?= $Page->rowAttributes() ?>>
<?php if ($Page->GroupColumnCount > 0) { ?>
        <td colspan="<?= $Page->GroupColumnCount ?>" class="ew-rpt-grp-aggregate"><?= $Language->phrase("RptSum") ?></td>
<?php } ?>
<?php if ($Page->NoOfBeneficiaries->Visible) { ?>
        <td data-field="NoOfBeneficiaries"<?= $Page->NoOfBeneficiaries->cellAttributes() ?>>
<span<?= $Page->NoOfBeneficiaries->viewAttributes() ?>>
<?= $Page->NoOfBeneficiaries->SumViewValue ?></span>
</td>
<?php } ?>
<?php if ($Page->TreesAllocated->Visible) { ?>
        <td data-field="TreesAllocated"<?= $Page->TreesAllocated->cellAttributes() ?>></td>
<?php } ?>
    </tr>
<?php } ?>
</tfoot>
</table>
</div>
<!-- /.ew-grid-middle-panel -->
<!-- Report grid (end) -->
<?php if ($Page->TotalGroups > 0) { ?>
<?php if (!$Page->isExport() && !($Page->DrillDown && $Page->TotalGroups > 0) && $Page->Pager->Visible) { ?>
<!-- Bottom pager -->
<div class="card-footer ew-grid-lower-panel">
<?= $Page->Pager->render() ?>
</div>
<?php } ?>
<?php } ?>
</div>
<!-- /.ew-grid -->
<?php } ?>
</main>
<!-- /.report-summary -->
<!-- Summary report (end) -->
<?php } ?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
</div>
<!-- /#ew-content -->
<?php } ?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
</div>
<!-- /#ew-middle -->
<?php } ?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
<!-- Bottom Container -->
<div id="ew-bottom" class="<?= $Page->BottomContentClass ?>">
<?php } ?>
<?php
if (!$DashboardReport) {
    // Set up chart drilldown
    $Page->SeedAllocationSummary->DrillDownInPanel = $Page->DrillDownInPanel;
    echo $Page->SeedAllocationSummary->render("ew-chart-bottom");
}
?>
<?php if ((!$Page->isExport() || $Page->isExport("print")) && !$DashboardReport) { ?>
</div>
<!-- /#ew-bottom -->
<?php } ?>
<?php if (!$DashboardReport && !$Page->isExport() && !$Page->DrillDown) { ?>
<div class="mb-3"><a class="ew-top-link" data-ew-action="scroll-top"><?= $Language->phrase("Top") ?></a></div>
<?php } ?>
</div>
<!-- /.ew-report -->
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport() && !$Page->DrillDown && !$DashboardReport) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
