<?php

namespace PHPMaker2024\cidp24;

// Page object
$SecurityMatrixDelete = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { security_matrix: currentTable } });
var currentPageID = ew.PAGE_ID = "delete";
var currentForm;
var fsecurity_matrixdelete;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fsecurity_matrixdelete")
        .setPageId("delete")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fsecurity_matrixdelete" id="fsecurity_matrixdelete" class="ew-form ew-delete-form" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="security_matrix">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid <?= $Page->TableGridClass ?>">
<div class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<table class="<?= $Page->TableClass ?>">
    <thead>
    <tr class="ew-table-header">
<?php if ($Page->UserCode->Visible) { // UserCode ?>
        <th class="<?= $Page->UserCode->headerCellClass() ?>"><span id="elh_security_matrix_UserCode" class="security_matrix_UserCode"><?= $Page->UserCode->caption() ?></span></th>
<?php } ?>
<?php if ($Page->Security_number->Visible) { // Security_number ?>
        <th class="<?= $Page->Security_number->headerCellClass() ?>"><span id="elh_security_matrix_Security_number" class="security_matrix_Security_number"><?= $Page->Security_number->caption() ?></span></th>
<?php } ?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <th class="<?= $Page->ProvinceCode->headerCellClass() ?>"><span id="elh_security_matrix_ProvinceCode" class="security_matrix_ProvinceCode"><?= $Page->ProvinceCode->caption() ?></span></th>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <th class="<?= $Page->DistrictCode->headerCellClass() ?>"><span id="elh_security_matrix_DistrictCode" class="security_matrix_DistrictCode"><?= $Page->DistrictCode->caption() ?></span></th>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
        <th class="<?= $Page->CampCode->headerCellClass() ?>"><span id="elh_security_matrix_CampCode" class="security_matrix_CampCode"><?= $Page->CampCode->caption() ?></span></th>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <th class="<?= $Page->VillageCode->headerCellClass() ?>"><span id="elh_security_matrix_VillageCode" class="security_matrix_VillageCode"><?= $Page->VillageCode->caption() ?></span></th>
<?php } ?>
    </tr>
    </thead>
    <tbody>
<?php
$Page->RecordCount = 0;
$i = 0;
while ($Page->fetch()) {
    $Page->RecordCount++;
    $Page->RowCount++;

    // Set row properties
    $Page->resetAttributes();
    $Page->RowType = RowType::VIEW; // View

    // Get the field contents
    $Page->loadRowValues($Page->CurrentRow);

    // Render row
    $Page->renderRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php if ($Page->UserCode->Visible) { // UserCode ?>
        <td<?= $Page->UserCode->cellAttributes() ?>>
<span id="">
<span<?= $Page->UserCode->viewAttributes() ?>>
<?= $Page->UserCode->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($Page->Security_number->Visible) { // Security_number ?>
        <td<?= $Page->Security_number->cellAttributes() ?>>
<span id="">
<span<?= $Page->Security_number->viewAttributes() ?>>
<?= $Page->Security_number->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
        <td<?= $Page->ProvinceCode->cellAttributes() ?>>
<span id="">
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<?= $Page->ProvinceCode->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
        <td<?= $Page->DistrictCode->cellAttributes() ?>>
<span id="">
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<?= $Page->DistrictCode->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($Page->CampCode->Visible) { // CampCode ?>
        <td<?= $Page->CampCode->cellAttributes() ?>>
<span id="">
<span<?= $Page->CampCode->viewAttributes() ?>>
<?= $Page->CampCode->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($Page->VillageCode->Visible) { // VillageCode ?>
        <td<?= $Page->VillageCode->cellAttributes() ?>>
<span id="">
<span<?= $Page->VillageCode->viewAttributes() ?>>
<?= $Page->VillageCode->getViewValue() ?></span>
</span>
</td>
<?php } ?>
    </tr>
<?php
}
$Page->Recordset?->free();
?>
</tbody>
</table>
</div>
</div>
<div class="ew-buttons ew-desktop-buttons">
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?= $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
