<?php

namespace PHPMaker2024\cidp24;

// Page object
$QuarterRefEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fquarter_refedit" id="fquarter_refedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { quarter_ref: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fquarter_refedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fquarter_refedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["QuarterCode", [fields.QuarterCode.visible && fields.QuarterCode.required ? ew.Validators.required(fields.QuarterCode.caption) : null, ew.Validators.integer], fields.QuarterCode.isInvalid],
            ["QuarterName", [fields.QuarterName.visible && fields.QuarterName.required ? ew.Validators.required(fields.QuarterName.caption) : null], fields.QuarterName.isInvalid],
            ["QuarterShort", [fields.QuarterShort.visible && fields.QuarterShort.required ? ew.Validators.required(fields.QuarterShort.caption) : null], fields.QuarterShort.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="quarter_ref">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->QuarterCode->Visible) { // QuarterCode ?>
    <div id="r_QuarterCode"<?= $Page->QuarterCode->rowAttributes() ?>>
        <label id="elh_quarter_ref_QuarterCode" for="x_QuarterCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->QuarterCode->caption() ?><?= $Page->QuarterCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->QuarterCode->cellAttributes() ?>>
<span id="el_quarter_ref_QuarterCode">
<input type="<?= $Page->QuarterCode->getInputTextType() ?>" name="x_QuarterCode" id="x_QuarterCode" data-table="quarter_ref" data-field="x_QuarterCode" value="<?= $Page->QuarterCode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->QuarterCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->QuarterCode->formatPattern()) ?>"<?= $Page->QuarterCode->editAttributes() ?> aria-describedby="x_QuarterCode_help">
<?= $Page->QuarterCode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->QuarterCode->getErrorMessage() ?></div>
<input type="hidden" data-table="quarter_ref" data-field="x_QuarterCode" data-hidden="1" data-old name="o_QuarterCode" id="o_QuarterCode" value="<?= HtmlEncode($Page->QuarterCode->OldValue ?? $Page->QuarterCode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->QuarterName->Visible) { // QuarterName ?>
    <div id="r_QuarterName"<?= $Page->QuarterName->rowAttributes() ?>>
        <label id="elh_quarter_ref_QuarterName" for="x_QuarterName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->QuarterName->caption() ?><?= $Page->QuarterName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->QuarterName->cellAttributes() ?>>
<span id="el_quarter_ref_QuarterName">
<input type="<?= $Page->QuarterName->getInputTextType() ?>" name="x_QuarterName" id="x_QuarterName" data-table="quarter_ref" data-field="x_QuarterName" value="<?= $Page->QuarterName->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->QuarterName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->QuarterName->formatPattern()) ?>"<?= $Page->QuarterName->editAttributes() ?> aria-describedby="x_QuarterName_help">
<?= $Page->QuarterName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->QuarterName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->QuarterShort->Visible) { // QuarterShort ?>
    <div id="r_QuarterShort"<?= $Page->QuarterShort->rowAttributes() ?>>
        <label id="elh_quarter_ref_QuarterShort" for="x_QuarterShort" class="<?= $Page->LeftColumnClass ?>"><?= $Page->QuarterShort->caption() ?><?= $Page->QuarterShort->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->QuarterShort->cellAttributes() ?>>
<span id="el_quarter_ref_QuarterShort">
<input type="<?= $Page->QuarterShort->getInputTextType() ?>" name="x_QuarterShort" id="x_QuarterShort" data-table="quarter_ref" data-field="x_QuarterShort" value="<?= $Page->QuarterShort->EditValue ?>" size="30" maxlength="4" placeholder="<?= HtmlEncode($Page->QuarterShort->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->QuarterShort->formatPattern()) ?>"<?= $Page->QuarterShort->editAttributes() ?> aria-describedby="x_QuarterShort_help">
<?= $Page->QuarterShort->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->QuarterShort->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fquarter_refedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fquarter_refedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("quarter_ref");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
