<?php

namespace PHPMaker2024\cidp24;

// Page object
$NurseryTypeEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fnursery_typeedit" id="fnursery_typeedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { nursery_type: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fnursery_typeedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fnursery_typeedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["NurseryTpeCode", [fields.NurseryTpeCode.visible && fields.NurseryTpeCode.required ? ew.Validators.required(fields.NurseryTpeCode.caption) : null], fields.NurseryTpeCode.isInvalid],
            ["NurseryType", [fields.NurseryType.visible && fields.NurseryType.required ? ew.Validators.required(fields.NurseryType.caption) : null], fields.NurseryType.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="nursery_type">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->NurseryTpeCode->Visible) { // NurseryTpeCode ?>
    <div id="r_NurseryTpeCode"<?= $Page->NurseryTpeCode->rowAttributes() ?>>
        <label id="elh_nursery_type_NurseryTpeCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NurseryTpeCode->caption() ?><?= $Page->NurseryTpeCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NurseryTpeCode->cellAttributes() ?>>
<span id="el_nursery_type_NurseryTpeCode">
<span<?= $Page->NurseryTpeCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->NurseryTpeCode->getDisplayValue($Page->NurseryTpeCode->EditValue))) ?>"></span>
<input type="hidden" data-table="nursery_type" data-field="x_NurseryTpeCode" data-hidden="1" name="x_NurseryTpeCode" id="x_NurseryTpeCode" value="<?= HtmlEncode($Page->NurseryTpeCode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NurseryType->Visible) { // NurseryType ?>
    <div id="r_NurseryType"<?= $Page->NurseryType->rowAttributes() ?>>
        <label id="elh_nursery_type_NurseryType" for="x_NurseryType" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NurseryType->caption() ?><?= $Page->NurseryType->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NurseryType->cellAttributes() ?>>
<span id="el_nursery_type_NurseryType">
<input type="<?= $Page->NurseryType->getInputTextType() ?>" name="x_NurseryType" id="x_NurseryType" data-table="nursery_type" data-field="x_NurseryType" value="<?= $Page->NurseryType->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->NurseryType->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NurseryType->formatPattern()) ?>"<?= $Page->NurseryType->editAttributes() ?> aria-describedby="x_NurseryType_help">
<?= $Page->NurseryType->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->NurseryType->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fnursery_typeedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fnursery_typeedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("nursery_type");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
