<?php

namespace PHPMaker2024\cidp24;

// Set up and run Grid object
$Grid = Container("NurseryGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fnurserygrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { nursery: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fnurserygrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["NurseryCode", [fields.NurseryCode.visible && fields.NurseryCode.required ? ew.Validators.required(fields.NurseryCode.caption) : null], fields.NurseryCode.isInvalid],
            ["NurseryName", [fields.NurseryName.visible && fields.NurseryName.required ? ew.Validators.required(fields.NurseryName.caption) : null], fields.NurseryName.isInvalid],
            ["NurseryType", [fields.NurseryType.visible && fields.NurseryType.required ? ew.Validators.required(fields.NurseryType.caption) : null], fields.NurseryType.isInvalid],
            ["PhysicalAddress", [fields.PhysicalAddress.visible && fields.PhysicalAddress.required ? ew.Validators.required(fields.PhysicalAddress.caption) : null], fields.PhysicalAddress.isInvalid],
            ["PostalAddress", [fields.PostalAddress.visible && fields.PostalAddress.required ? ew.Validators.required(fields.PostalAddress.caption) : null], fields.PostalAddress.isInvalid],
            ["Phone", [fields.Phone.visible && fields.Phone.required ? ew.Validators.required(fields.Phone.caption) : null], fields.Phone.isInvalid],
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null, ew.Validators.email], fields._Email.isInvalid],
            ["NurseryOwnership", [fields.NurseryOwnership.visible && fields.NurseryOwnership.required ? ew.Validators.required(fields.NurseryOwnership.caption) : null], fields.NurseryOwnership.isInvalid],
            ["SeedVariety", [fields.SeedVariety.visible && fields.SeedVariety.required ? ew.Validators.required(fields.SeedVariety.caption) : null], fields.SeedVariety.isInvalid],
            ["NumberOfMembers", [fields.NumberOfMembers.visible && fields.NumberOfMembers.required ? ew.Validators.required(fields.NumberOfMembers.caption) : null, ew.Validators.integer], fields.NumberOfMembers.isInvalid],
            ["FemaleMembers", [fields.FemaleMembers.visible && fields.FemaleMembers.required ? ew.Validators.required(fields.FemaleMembers.caption) : null, ew.Validators.integer], fields.FemaleMembers.isInvalid],
            ["MaleMembers", [fields.MaleMembers.visible && fields.MaleMembers.required ? ew.Validators.required(fields.MaleMembers.caption) : null, ew.Validators.integer], fields.MaleMembers.isInvalid],
            ["YoungFemales", [fields.YoungFemales.visible && fields.YoungFemales.required ? ew.Validators.required(fields.YoungFemales.caption) : null, ew.Validators.integer], fields.YoungFemales.isInvalid],
            ["YoungMales", [fields.YoungMales.visible && fields.YoungMales.required ? ew.Validators.required(fields.YoungMales.caption) : null, ew.Validators.integer], fields.YoungMales.isInvalid],
            ["FemalesInManagement", [fields.FemalesInManagement.visible && fields.FemalesInManagement.required ? ew.Validators.required(fields.FemalesInManagement.caption) : null, ew.Validators.integer], fields.FemalesInManagement.isInvalid],
            ["MalesInManagement", [fields.MalesInManagement.visible && fields.MalesInManagement.required ? ew.Validators.required(fields.MalesInManagement.caption) : null, ew.Validators.integer], fields.MalesInManagement.isInvalid],
            ["Latitude", [fields.Latitude.visible && fields.Latitude.required ? ew.Validators.required(fields.Latitude.caption) : null, ew.Validators.float], fields.Latitude.isInvalid],
            ["Longitude", [fields.Longitude.visible && fields.Longitude.required ? ew.Validators.required(fields.Longitude.caption) : null, ew.Validators.float], fields.Longitude.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["ProvinceCode",false],["DistrictCode",false],["NurseryName",false],["NurseryType",false],["PhysicalAddress",false],["PostalAddress",false],["Phone",false],["_Email",false],["NurseryOwnership",false],["SeedVariety",false],["NumberOfMembers",false],["FemaleMembers",false],["MaleMembers",false],["YoungFemales",false],["YoungMales",false],["FemalesInManagement",false],["MalesInManagement",false],["Latitude",false],["Longitude",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Grid->ProvinceCode->toClientList($Grid) ?>,
            "DistrictCode": <?= $Grid->DistrictCode->toClientList($Grid) ?>,
            "NurseryType": <?= $Grid->NurseryType->toClientList($Grid) ?>,
            "NurseryOwnership": <?= $Grid->NurseryOwnership->toClientList($Grid) ?>,
            "SeedVariety": <?= $Grid->SeedVariety->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fnurserygrid" class="ew-form ew-list-form">
<div id="gmp_nursery" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_nurserygrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <th data-name="ProvinceCode" class="<?= $Grid->ProvinceCode->headerCellClass() ?>"><div id="elh_nursery_ProvinceCode" class="nursery_ProvinceCode"><?= $Grid->renderFieldHeader($Grid->ProvinceCode) ?></div></th>
<?php } ?>
<?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <th data-name="DistrictCode" class="<?= $Grid->DistrictCode->headerCellClass() ?>"><div id="elh_nursery_DistrictCode" class="nursery_DistrictCode"><?= $Grid->renderFieldHeader($Grid->DistrictCode) ?></div></th>
<?php } ?>
<?php if ($Grid->NurseryCode->Visible) { // NurseryCode ?>
        <th data-name="NurseryCode" class="<?= $Grid->NurseryCode->headerCellClass() ?>"><div id="elh_nursery_NurseryCode" class="nursery_NurseryCode"><?= $Grid->renderFieldHeader($Grid->NurseryCode) ?></div></th>
<?php } ?>
<?php if ($Grid->NurseryName->Visible) { // NurseryName ?>
        <th data-name="NurseryName" class="<?= $Grid->NurseryName->headerCellClass() ?>"><div id="elh_nursery_NurseryName" class="nursery_NurseryName"><?= $Grid->renderFieldHeader($Grid->NurseryName) ?></div></th>
<?php } ?>
<?php if ($Grid->NurseryType->Visible) { // NurseryType ?>
        <th data-name="NurseryType" class="<?= $Grid->NurseryType->headerCellClass() ?>"><div id="elh_nursery_NurseryType" class="nursery_NurseryType"><?= $Grid->renderFieldHeader($Grid->NurseryType) ?></div></th>
<?php } ?>
<?php if ($Grid->PhysicalAddress->Visible) { // PhysicalAddress ?>
        <th data-name="PhysicalAddress" class="<?= $Grid->PhysicalAddress->headerCellClass() ?>"><div id="elh_nursery_PhysicalAddress" class="nursery_PhysicalAddress"><?= $Grid->renderFieldHeader($Grid->PhysicalAddress) ?></div></th>
<?php } ?>
<?php if ($Grid->PostalAddress->Visible) { // PostalAddress ?>
        <th data-name="PostalAddress" class="<?= $Grid->PostalAddress->headerCellClass() ?>"><div id="elh_nursery_PostalAddress" class="nursery_PostalAddress"><?= $Grid->renderFieldHeader($Grid->PostalAddress) ?></div></th>
<?php } ?>
<?php if ($Grid->Phone->Visible) { // Phone ?>
        <th data-name="Phone" class="<?= $Grid->Phone->headerCellClass() ?>"><div id="elh_nursery_Phone" class="nursery_Phone"><?= $Grid->renderFieldHeader($Grid->Phone) ?></div></th>
<?php } ?>
<?php if ($Grid->_Email->Visible) { // Email ?>
        <th data-name="_Email" class="<?= $Grid->_Email->headerCellClass() ?>"><div id="elh_nursery__Email" class="nursery__Email"><?= $Grid->renderFieldHeader($Grid->_Email) ?></div></th>
<?php } ?>
<?php if ($Grid->NurseryOwnership->Visible) { // NurseryOwnership ?>
        <th data-name="NurseryOwnership" class="<?= $Grid->NurseryOwnership->headerCellClass() ?>"><div id="elh_nursery_NurseryOwnership" class="nursery_NurseryOwnership"><?= $Grid->renderFieldHeader($Grid->NurseryOwnership) ?></div></th>
<?php } ?>
<?php if ($Grid->SeedVariety->Visible) { // SeedVariety ?>
        <th data-name="SeedVariety" class="<?= $Grid->SeedVariety->headerCellClass() ?>"><div id="elh_nursery_SeedVariety" class="nursery_SeedVariety"><?= $Grid->renderFieldHeader($Grid->SeedVariety) ?></div></th>
<?php } ?>
<?php if ($Grid->NumberOfMembers->Visible) { // NumberOfMembers ?>
        <th data-name="NumberOfMembers" class="<?= $Grid->NumberOfMembers->headerCellClass() ?>"><div id="elh_nursery_NumberOfMembers" class="nursery_NumberOfMembers"><?= $Grid->renderFieldHeader($Grid->NumberOfMembers) ?></div></th>
<?php } ?>
<?php if ($Grid->FemaleMembers->Visible) { // FemaleMembers ?>
        <th data-name="FemaleMembers" class="<?= $Grid->FemaleMembers->headerCellClass() ?>"><div id="elh_nursery_FemaleMembers" class="nursery_FemaleMembers"><?= $Grid->renderFieldHeader($Grid->FemaleMembers) ?></div></th>
<?php } ?>
<?php if ($Grid->MaleMembers->Visible) { // MaleMembers ?>
        <th data-name="MaleMembers" class="<?= $Grid->MaleMembers->headerCellClass() ?>"><div id="elh_nursery_MaleMembers" class="nursery_MaleMembers"><?= $Grid->renderFieldHeader($Grid->MaleMembers) ?></div></th>
<?php } ?>
<?php if ($Grid->YoungFemales->Visible) { // YoungFemales ?>
        <th data-name="YoungFemales" class="<?= $Grid->YoungFemales->headerCellClass() ?>"><div id="elh_nursery_YoungFemales" class="nursery_YoungFemales"><?= $Grid->renderFieldHeader($Grid->YoungFemales) ?></div></th>
<?php } ?>
<?php if ($Grid->YoungMales->Visible) { // YoungMales ?>
        <th data-name="YoungMales" class="<?= $Grid->YoungMales->headerCellClass() ?>"><div id="elh_nursery_YoungMales" class="nursery_YoungMales"><?= $Grid->renderFieldHeader($Grid->YoungMales) ?></div></th>
<?php } ?>
<?php if ($Grid->FemalesInManagement->Visible) { // FemalesInManagement ?>
        <th data-name="FemalesInManagement" class="<?= $Grid->FemalesInManagement->headerCellClass() ?>"><div id="elh_nursery_FemalesInManagement" class="nursery_FemalesInManagement"><?= $Grid->renderFieldHeader($Grid->FemalesInManagement) ?></div></th>
<?php } ?>
<?php if ($Grid->MalesInManagement->Visible) { // MalesInManagement ?>
        <th data-name="MalesInManagement" class="<?= $Grid->MalesInManagement->headerCellClass() ?>"><div id="elh_nursery_MalesInManagement" class="nursery_MalesInManagement"><?= $Grid->renderFieldHeader($Grid->MalesInManagement) ?></div></th>
<?php } ?>
<?php if ($Grid->Latitude->Visible) { // Latitude ?>
        <th data-name="Latitude" class="<?= $Grid->Latitude->headerCellClass() ?>"><div id="elh_nursery_Latitude" class="nursery_Latitude"><?= $Grid->renderFieldHeader($Grid->Latitude) ?></div></th>
<?php } ?>
<?php if ($Grid->Longitude->Visible) { // Longitude ?>
        <th data-name="Longitude" class="<?= $Grid->Longitude->headerCellClass() ?>"><div id="elh_nursery_Longitude" class="nursery_Longitude"><?= $Grid->renderFieldHeader($Grid->Longitude) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->ProvinceCode->Visible) { // ProvinceCode ?>
        <td data-name="ProvinceCode"<?= $Grid->ProvinceCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_ProvinceCode" class="el_nursery_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="fnurserygrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="nursery"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurserygrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "fnurserygrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurserygrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "fnurserygrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "fnurserygrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="nursery" data-field="x_ProvinceCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_ProvinceCode" id="o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->ProvinceCode->getDisplayValue($Grid->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_ProvinceCode" name="x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_ProvinceCode" class="el_nursery_ProvinceCode">
    <select
        id="x<?= $Grid->RowIndex ?>_ProvinceCode"
        name="x<?= $Grid->RowIndex ?>_ProvinceCode"
        class="form-select ew-select<?= $Grid->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="fnurserygrid_x<?= $Grid->RowIndex ?>_ProvinceCode"
        <?php } ?>
        data-table="nursery"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Grid->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->ProvinceCode->editAttributes() ?>>
        <?= $Grid->ProvinceCode->selectOptionListHtml("x{$Grid->RowIndex}_ProvinceCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->ProvinceCode->getErrorMessage() ?></div>
<?= $Grid->ProvinceCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_ProvinceCode") ?>
<?php if (!$Grid->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurserygrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_ProvinceCode", selectId: "fnurserygrid_x<?= $Grid->RowIndex ?>_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurserygrid.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "fnurserygrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_ProvinceCode", form: "fnurserygrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_ProvinceCode" class="el_nursery_ProvinceCode">
<span<?= $Grid->ProvinceCode->viewAttributes() ?>>
<?= $Grid->ProvinceCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_ProvinceCode" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_ProvinceCode" id="fnurserygrid$x<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_ProvinceCode" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_ProvinceCode" id="fnurserygrid$o<?= $Grid->RowIndex ?>_ProvinceCode" value="<?= HtmlEncode($Grid->ProvinceCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->DistrictCode->Visible) { // DistrictCode ?>
        <td data-name="DistrictCode"<?= $Grid->DistrictCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_DistrictCode" class="el_nursery_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="fnurserygrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="nursery"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurserygrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "fnurserygrid_x<?= $Grid->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurserygrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "fnurserygrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "fnurserygrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="nursery" data-field="x_DistrictCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_DistrictCode" id="o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->DistrictCode->getDisplayValue($Grid->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_DistrictCode" name="x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_DistrictCode" class="el_nursery_DistrictCode">
    <select
        id="x<?= $Grid->RowIndex ?>_DistrictCode"
        name="x<?= $Grid->RowIndex ?>_DistrictCode"
        class="form-select ew-select<?= $Grid->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="fnurserygrid_x<?= $Grid->RowIndex ?>_DistrictCode"
        <?php } ?>
        data-table="nursery"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Grid->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->DistrictCode->getPlaceHolder()) ?>"
        <?= $Grid->DistrictCode->editAttributes() ?>>
        <?= $Grid->DistrictCode->selectOptionListHtml("x{$Grid->RowIndex}_DistrictCode") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->DistrictCode->getErrorMessage() ?></div>
<?= $Grid->DistrictCode->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_DistrictCode") ?>
<?php if (!$Grid->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurserygrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_DistrictCode", selectId: "fnurserygrid_x<?= $Grid->RowIndex ?>_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurserygrid.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "fnurserygrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_DistrictCode", form: "fnurserygrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_DistrictCode" class="el_nursery_DistrictCode">
<span<?= $Grid->DistrictCode->viewAttributes() ?>>
<?= $Grid->DistrictCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_DistrictCode" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_DistrictCode" id="fnurserygrid$x<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_DistrictCode" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_DistrictCode" id="fnurserygrid$o<?= $Grid->RowIndex ?>_DistrictCode" value="<?= HtmlEncode($Grid->DistrictCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->NurseryCode->Visible) { // NurseryCode ?>
        <td data-name="NurseryCode"<?= $Grid->NurseryCode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NurseryCode" class="el_nursery_NurseryCode"></span>
<input type="hidden" data-table="nursery" data-field="x_NurseryCode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NurseryCode" id="o<?= $Grid->RowIndex ?>_NurseryCode" value="<?= HtmlEncode($Grid->NurseryCode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NurseryCode" class="el_nursery_NurseryCode">
<span<?= $Grid->NurseryCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->NurseryCode->getDisplayValue($Grid->NurseryCode->EditValue))) ?>"></span>
<input type="hidden" data-table="nursery" data-field="x_NurseryCode" data-hidden="1" name="x<?= $Grid->RowIndex ?>_NurseryCode" id="x<?= $Grid->RowIndex ?>_NurseryCode" value="<?= HtmlEncode($Grid->NurseryCode->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NurseryCode" class="el_nursery_NurseryCode">
<span<?= $Grid->NurseryCode->viewAttributes() ?>>
<?= $Grid->NurseryCode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_NurseryCode" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_NurseryCode" id="fnurserygrid$x<?= $Grid->RowIndex ?>_NurseryCode" value="<?= HtmlEncode($Grid->NurseryCode->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_NurseryCode" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_NurseryCode" id="fnurserygrid$o<?= $Grid->RowIndex ?>_NurseryCode" value="<?= HtmlEncode($Grid->NurseryCode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="nursery" data-field="x_NurseryCode" data-hidden="1" name="x<?= $Grid->RowIndex ?>_NurseryCode" id="x<?= $Grid->RowIndex ?>_NurseryCode" value="<?= HtmlEncode($Grid->NurseryCode->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->NurseryName->Visible) { // NurseryName ?>
        <td data-name="NurseryName"<?= $Grid->NurseryName->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NurseryName" class="el_nursery_NurseryName">
<input type="<?= $Grid->NurseryName->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_NurseryName" id="x<?= $Grid->RowIndex ?>_NurseryName" data-table="nursery" data-field="x_NurseryName" value="<?= $Grid->NurseryName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->NurseryName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NurseryName->formatPattern()) ?>"<?= $Grid->NurseryName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->NurseryName->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_NurseryName" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NurseryName" id="o<?= $Grid->RowIndex ?>_NurseryName" value="<?= HtmlEncode($Grid->NurseryName->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NurseryName" class="el_nursery_NurseryName">
<input type="<?= $Grid->NurseryName->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_NurseryName" id="x<?= $Grid->RowIndex ?>_NurseryName" data-table="nursery" data-field="x_NurseryName" value="<?= $Grid->NurseryName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Grid->NurseryName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NurseryName->formatPattern()) ?>"<?= $Grid->NurseryName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->NurseryName->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NurseryName" class="el_nursery_NurseryName">
<span<?= $Grid->NurseryName->viewAttributes() ?>>
<?= $Grid->NurseryName->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_NurseryName" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_NurseryName" id="fnurserygrid$x<?= $Grid->RowIndex ?>_NurseryName" value="<?= HtmlEncode($Grid->NurseryName->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_NurseryName" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_NurseryName" id="fnurserygrid$o<?= $Grid->RowIndex ?>_NurseryName" value="<?= HtmlEncode($Grid->NurseryName->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->NurseryType->Visible) { // NurseryType ?>
        <td data-name="NurseryType"<?= $Grid->NurseryType->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NurseryType" class="el_nursery_NurseryType">
    <select
        id="x<?= $Grid->RowIndex ?>_NurseryType"
        name="x<?= $Grid->RowIndex ?>_NurseryType"
        class="form-select ew-select<?= $Grid->NurseryType->isInvalidClass() ?>"
        <?php if (!$Grid->NurseryType->IsNativeSelect) { ?>
        data-select2-id="fnurserygrid_x<?= $Grid->RowIndex ?>_NurseryType"
        <?php } ?>
        data-table="nursery"
        data-field="x_NurseryType"
        data-value-separator="<?= $Grid->NurseryType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->NurseryType->getPlaceHolder()) ?>"
        <?= $Grid->NurseryType->editAttributes() ?>>
        <?= $Grid->NurseryType->selectOptionListHtml("x{$Grid->RowIndex}_NurseryType") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->NurseryType->getErrorMessage() ?></div>
<?= $Grid->NurseryType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NurseryType") ?>
<?php if (!$Grid->NurseryType->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurserygrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_NurseryType", selectId: "fnurserygrid_x<?= $Grid->RowIndex ?>_NurseryType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurserygrid.lists.NurseryType?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_NurseryType", form: "fnurserygrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_NurseryType", form: "fnurserygrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.NurseryType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="nursery" data-field="x_NurseryType" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NurseryType" id="o<?= $Grid->RowIndex ?>_NurseryType" value="<?= HtmlEncode($Grid->NurseryType->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NurseryType" class="el_nursery_NurseryType">
    <select
        id="x<?= $Grid->RowIndex ?>_NurseryType"
        name="x<?= $Grid->RowIndex ?>_NurseryType"
        class="form-select ew-select<?= $Grid->NurseryType->isInvalidClass() ?>"
        <?php if (!$Grid->NurseryType->IsNativeSelect) { ?>
        data-select2-id="fnurserygrid_x<?= $Grid->RowIndex ?>_NurseryType"
        <?php } ?>
        data-table="nursery"
        data-field="x_NurseryType"
        data-value-separator="<?= $Grid->NurseryType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->NurseryType->getPlaceHolder()) ?>"
        <?= $Grid->NurseryType->editAttributes() ?>>
        <?= $Grid->NurseryType->selectOptionListHtml("x{$Grid->RowIndex}_NurseryType") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->NurseryType->getErrorMessage() ?></div>
<?= $Grid->NurseryType->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NurseryType") ?>
<?php if (!$Grid->NurseryType->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurserygrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_NurseryType", selectId: "fnurserygrid_x<?= $Grid->RowIndex ?>_NurseryType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurserygrid.lists.NurseryType?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_NurseryType", form: "fnurserygrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_NurseryType", form: "fnurserygrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.NurseryType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NurseryType" class="el_nursery_NurseryType">
<span<?= $Grid->NurseryType->viewAttributes() ?>>
<?= $Grid->NurseryType->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_NurseryType" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_NurseryType" id="fnurserygrid$x<?= $Grid->RowIndex ?>_NurseryType" value="<?= HtmlEncode($Grid->NurseryType->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_NurseryType" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_NurseryType" id="fnurserygrid$o<?= $Grid->RowIndex ?>_NurseryType" value="<?= HtmlEncode($Grid->NurseryType->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->PhysicalAddress->Visible) { // PhysicalAddress ?>
        <td data-name="PhysicalAddress"<?= $Grid->PhysicalAddress->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_PhysicalAddress" class="el_nursery_PhysicalAddress">
<textarea data-table="nursery" data-field="x_PhysicalAddress" name="x<?= $Grid->RowIndex ?>_PhysicalAddress" id="x<?= $Grid->RowIndex ?>_PhysicalAddress" cols="35" rows="2" placeholder="<?= HtmlEncode($Grid->PhysicalAddress->getPlaceHolder()) ?>"<?= $Grid->PhysicalAddress->editAttributes() ?>><?= $Grid->PhysicalAddress->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->PhysicalAddress->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_PhysicalAddress" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PhysicalAddress" id="o<?= $Grid->RowIndex ?>_PhysicalAddress" value="<?= HtmlEncode($Grid->PhysicalAddress->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_PhysicalAddress" class="el_nursery_PhysicalAddress">
<textarea data-table="nursery" data-field="x_PhysicalAddress" name="x<?= $Grid->RowIndex ?>_PhysicalAddress" id="x<?= $Grid->RowIndex ?>_PhysicalAddress" cols="35" rows="2" placeholder="<?= HtmlEncode($Grid->PhysicalAddress->getPlaceHolder()) ?>"<?= $Grid->PhysicalAddress->editAttributes() ?>><?= $Grid->PhysicalAddress->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->PhysicalAddress->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_PhysicalAddress" class="el_nursery_PhysicalAddress">
<span<?= $Grid->PhysicalAddress->viewAttributes() ?>>
<?= $Grid->PhysicalAddress->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_PhysicalAddress" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_PhysicalAddress" id="fnurserygrid$x<?= $Grid->RowIndex ?>_PhysicalAddress" value="<?= HtmlEncode($Grid->PhysicalAddress->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_PhysicalAddress" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_PhysicalAddress" id="fnurserygrid$o<?= $Grid->RowIndex ?>_PhysicalAddress" value="<?= HtmlEncode($Grid->PhysicalAddress->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->PostalAddress->Visible) { // PostalAddress ?>
        <td data-name="PostalAddress"<?= $Grid->PostalAddress->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_PostalAddress" class="el_nursery_PostalAddress">
<textarea data-table="nursery" data-field="x_PostalAddress" name="x<?= $Grid->RowIndex ?>_PostalAddress" id="x<?= $Grid->RowIndex ?>_PostalAddress" cols="35" rows="2" placeholder="<?= HtmlEncode($Grid->PostalAddress->getPlaceHolder()) ?>"<?= $Grid->PostalAddress->editAttributes() ?>><?= $Grid->PostalAddress->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->PostalAddress->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_PostalAddress" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_PostalAddress" id="o<?= $Grid->RowIndex ?>_PostalAddress" value="<?= HtmlEncode($Grid->PostalAddress->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_PostalAddress" class="el_nursery_PostalAddress">
<textarea data-table="nursery" data-field="x_PostalAddress" name="x<?= $Grid->RowIndex ?>_PostalAddress" id="x<?= $Grid->RowIndex ?>_PostalAddress" cols="35" rows="2" placeholder="<?= HtmlEncode($Grid->PostalAddress->getPlaceHolder()) ?>"<?= $Grid->PostalAddress->editAttributes() ?>><?= $Grid->PostalAddress->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->PostalAddress->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_PostalAddress" class="el_nursery_PostalAddress">
<span<?= $Grid->PostalAddress->viewAttributes() ?>>
<?= $Grid->PostalAddress->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_PostalAddress" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_PostalAddress" id="fnurserygrid$x<?= $Grid->RowIndex ?>_PostalAddress" value="<?= HtmlEncode($Grid->PostalAddress->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_PostalAddress" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_PostalAddress" id="fnurserygrid$o<?= $Grid->RowIndex ?>_PostalAddress" value="<?= HtmlEncode($Grid->PostalAddress->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Phone->Visible) { // Phone ?>
        <td data-name="Phone"<?= $Grid->Phone->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_Phone" class="el_nursery_Phone">
<input type="<?= $Grid->Phone->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Phone" id="x<?= $Grid->RowIndex ?>_Phone" data-table="nursery" data-field="x_Phone" value="<?= $Grid->Phone->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->Phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Phone->formatPattern()) ?>"<?= $Grid->Phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Phone->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_Phone" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Phone" id="o<?= $Grid->RowIndex ?>_Phone" value="<?= HtmlEncode($Grid->Phone->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_Phone" class="el_nursery_Phone">
<input type="<?= $Grid->Phone->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Phone" id="x<?= $Grid->RowIndex ?>_Phone" data-table="nursery" data-field="x_Phone" value="<?= $Grid->Phone->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->Phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Phone->formatPattern()) ?>"<?= $Grid->Phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Phone->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_Phone" class="el_nursery_Phone">
<span<?= $Grid->Phone->viewAttributes() ?>>
<?= $Grid->Phone->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_Phone" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_Phone" id="fnurserygrid$x<?= $Grid->RowIndex ?>_Phone" value="<?= HtmlEncode($Grid->Phone->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_Phone" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_Phone" id="fnurserygrid$o<?= $Grid->RowIndex ?>_Phone" value="<?= HtmlEncode($Grid->Phone->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_Email->Visible) { // Email ?>
        <td data-name="_Email"<?= $Grid->_Email->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery__Email" class="el_nursery__Email">
<input type="<?= $Grid->_Email->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__Email" id="x<?= $Grid->RowIndex ?>__Email" data-table="nursery" data-field="x__Email" value="<?= $Grid->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_Email->formatPattern()) ?>"<?= $Grid->_Email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_Email->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x__Email" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__Email" id="o<?= $Grid->RowIndex ?>__Email" value="<?= HtmlEncode($Grid->_Email->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery__Email" class="el_nursery__Email">
<input type="<?= $Grid->_Email->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__Email" id="x<?= $Grid->RowIndex ?>__Email" data-table="nursery" data-field="x__Email" value="<?= $Grid->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Grid->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_Email->formatPattern()) ?>"<?= $Grid->_Email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_Email->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery__Email" class="el_nursery__Email">
<span<?= $Grid->_Email->viewAttributes() ?>>
<?= $Grid->_Email->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x__Email" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>__Email" id="fnurserygrid$x<?= $Grid->RowIndex ?>__Email" value="<?= HtmlEncode($Grid->_Email->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x__Email" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>__Email" id="fnurserygrid$o<?= $Grid->RowIndex ?>__Email" value="<?= HtmlEncode($Grid->_Email->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->NurseryOwnership->Visible) { // NurseryOwnership ?>
        <td data-name="NurseryOwnership"<?= $Grid->NurseryOwnership->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NurseryOwnership" class="el_nursery_NurseryOwnership">
    <select
        id="x<?= $Grid->RowIndex ?>_NurseryOwnership"
        name="x<?= $Grid->RowIndex ?>_NurseryOwnership"
        class="form-select ew-select<?= $Grid->NurseryOwnership->isInvalidClass() ?>"
        <?php if (!$Grid->NurseryOwnership->IsNativeSelect) { ?>
        data-select2-id="fnurserygrid_x<?= $Grid->RowIndex ?>_NurseryOwnership"
        <?php } ?>
        data-table="nursery"
        data-field="x_NurseryOwnership"
        data-value-separator="<?= $Grid->NurseryOwnership->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->NurseryOwnership->getPlaceHolder()) ?>"
        <?= $Grid->NurseryOwnership->editAttributes() ?>>
        <?= $Grid->NurseryOwnership->selectOptionListHtml("x{$Grid->RowIndex}_NurseryOwnership") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->NurseryOwnership->getErrorMessage() ?></div>
<?= $Grid->NurseryOwnership->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NurseryOwnership") ?>
<?php if (!$Grid->NurseryOwnership->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurserygrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_NurseryOwnership", selectId: "fnurserygrid_x<?= $Grid->RowIndex ?>_NurseryOwnership" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurserygrid.lists.NurseryOwnership?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_NurseryOwnership", form: "fnurserygrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_NurseryOwnership", form: "fnurserygrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.NurseryOwnership.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="nursery" data-field="x_NurseryOwnership" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NurseryOwnership" id="o<?= $Grid->RowIndex ?>_NurseryOwnership" value="<?= HtmlEncode($Grid->NurseryOwnership->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NurseryOwnership" class="el_nursery_NurseryOwnership">
    <select
        id="x<?= $Grid->RowIndex ?>_NurseryOwnership"
        name="x<?= $Grid->RowIndex ?>_NurseryOwnership"
        class="form-select ew-select<?= $Grid->NurseryOwnership->isInvalidClass() ?>"
        <?php if (!$Grid->NurseryOwnership->IsNativeSelect) { ?>
        data-select2-id="fnurserygrid_x<?= $Grid->RowIndex ?>_NurseryOwnership"
        <?php } ?>
        data-table="nursery"
        data-field="x_NurseryOwnership"
        data-value-separator="<?= $Grid->NurseryOwnership->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->NurseryOwnership->getPlaceHolder()) ?>"
        <?= $Grid->NurseryOwnership->editAttributes() ?>>
        <?= $Grid->NurseryOwnership->selectOptionListHtml("x{$Grid->RowIndex}_NurseryOwnership") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->NurseryOwnership->getErrorMessage() ?></div>
<?= $Grid->NurseryOwnership->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_NurseryOwnership") ?>
<?php if (!$Grid->NurseryOwnership->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurserygrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_NurseryOwnership", selectId: "fnurserygrid_x<?= $Grid->RowIndex ?>_NurseryOwnership" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurserygrid.lists.NurseryOwnership?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_NurseryOwnership", form: "fnurserygrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_NurseryOwnership", form: "fnurserygrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.NurseryOwnership.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NurseryOwnership" class="el_nursery_NurseryOwnership">
<span<?= $Grid->NurseryOwnership->viewAttributes() ?>>
<?= $Grid->NurseryOwnership->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_NurseryOwnership" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_NurseryOwnership" id="fnurserygrid$x<?= $Grid->RowIndex ?>_NurseryOwnership" value="<?= HtmlEncode($Grid->NurseryOwnership->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_NurseryOwnership" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_NurseryOwnership" id="fnurserygrid$o<?= $Grid->RowIndex ?>_NurseryOwnership" value="<?= HtmlEncode($Grid->NurseryOwnership->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->SeedVariety->Visible) { // SeedVariety ?>
        <td data-name="SeedVariety"<?= $Grid->SeedVariety->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_SeedVariety" class="el_nursery_SeedVariety">
    <select
        id="x<?= $Grid->RowIndex ?>_SeedVariety"
        name="x<?= $Grid->RowIndex ?>_SeedVariety"
        class="form-select ew-select<?= $Grid->SeedVariety->isInvalidClass() ?>"
        <?php if (!$Grid->SeedVariety->IsNativeSelect) { ?>
        data-select2-id="fnurserygrid_x<?= $Grid->RowIndex ?>_SeedVariety"
        <?php } ?>
        data-table="nursery"
        data-field="x_SeedVariety"
        data-value-separator="<?= $Grid->SeedVariety->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->SeedVariety->getPlaceHolder()) ?>"
        <?= $Grid->SeedVariety->editAttributes() ?>>
        <?= $Grid->SeedVariety->selectOptionListHtml("x{$Grid->RowIndex}_SeedVariety") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->SeedVariety->getErrorMessage() ?></div>
<?= $Grid->SeedVariety->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_SeedVariety") ?>
<?php if (!$Grid->SeedVariety->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurserygrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_SeedVariety", selectId: "fnurserygrid_x<?= $Grid->RowIndex ?>_SeedVariety" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurserygrid.lists.SeedVariety?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_SeedVariety", form: "fnurserygrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_SeedVariety", form: "fnurserygrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.SeedVariety.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="nursery" data-field="x_SeedVariety" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_SeedVariety" id="o<?= $Grid->RowIndex ?>_SeedVariety" value="<?= HtmlEncode($Grid->SeedVariety->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_SeedVariety" class="el_nursery_SeedVariety">
    <select
        id="x<?= $Grid->RowIndex ?>_SeedVariety"
        name="x<?= $Grid->RowIndex ?>_SeedVariety"
        class="form-select ew-select<?= $Grid->SeedVariety->isInvalidClass() ?>"
        <?php if (!$Grid->SeedVariety->IsNativeSelect) { ?>
        data-select2-id="fnurserygrid_x<?= $Grid->RowIndex ?>_SeedVariety"
        <?php } ?>
        data-table="nursery"
        data-field="x_SeedVariety"
        data-value-separator="<?= $Grid->SeedVariety->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->SeedVariety->getPlaceHolder()) ?>"
        <?= $Grid->SeedVariety->editAttributes() ?>>
        <?= $Grid->SeedVariety->selectOptionListHtml("x{$Grid->RowIndex}_SeedVariety") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->SeedVariety->getErrorMessage() ?></div>
<?= $Grid->SeedVariety->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_SeedVariety") ?>
<?php if (!$Grid->SeedVariety->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurserygrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_SeedVariety", selectId: "fnurserygrid_x<?= $Grid->RowIndex ?>_SeedVariety" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurserygrid.lists.SeedVariety?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_SeedVariety", form: "fnurserygrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_SeedVariety", form: "fnurserygrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.SeedVariety.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_SeedVariety" class="el_nursery_SeedVariety">
<span<?= $Grid->SeedVariety->viewAttributes() ?>>
<?= $Grid->SeedVariety->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_SeedVariety" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_SeedVariety" id="fnurserygrid$x<?= $Grid->RowIndex ?>_SeedVariety" value="<?= HtmlEncode($Grid->SeedVariety->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_SeedVariety" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_SeedVariety" id="fnurserygrid$o<?= $Grid->RowIndex ?>_SeedVariety" value="<?= HtmlEncode($Grid->SeedVariety->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->NumberOfMembers->Visible) { // NumberOfMembers ?>
        <td data-name="NumberOfMembers"<?= $Grid->NumberOfMembers->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NumberOfMembers" class="el_nursery_NumberOfMembers">
<input type="<?= $Grid->NumberOfMembers->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_NumberOfMembers" id="x<?= $Grid->RowIndex ?>_NumberOfMembers" data-table="nursery" data-field="x_NumberOfMembers" value="<?= $Grid->NumberOfMembers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->NumberOfMembers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NumberOfMembers->formatPattern()) ?>"<?= $Grid->NumberOfMembers->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->NumberOfMembers->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_NumberOfMembers" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_NumberOfMembers" id="o<?= $Grid->RowIndex ?>_NumberOfMembers" value="<?= HtmlEncode($Grid->NumberOfMembers->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NumberOfMembers" class="el_nursery_NumberOfMembers">
<input type="<?= $Grid->NumberOfMembers->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_NumberOfMembers" id="x<?= $Grid->RowIndex ?>_NumberOfMembers" data-table="nursery" data-field="x_NumberOfMembers" value="<?= $Grid->NumberOfMembers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->NumberOfMembers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->NumberOfMembers->formatPattern()) ?>"<?= $Grid->NumberOfMembers->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->NumberOfMembers->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_NumberOfMembers" class="el_nursery_NumberOfMembers">
<span<?= $Grid->NumberOfMembers->viewAttributes() ?>>
<?= $Grid->NumberOfMembers->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_NumberOfMembers" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_NumberOfMembers" id="fnurserygrid$x<?= $Grid->RowIndex ?>_NumberOfMembers" value="<?= HtmlEncode($Grid->NumberOfMembers->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_NumberOfMembers" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_NumberOfMembers" id="fnurserygrid$o<?= $Grid->RowIndex ?>_NumberOfMembers" value="<?= HtmlEncode($Grid->NumberOfMembers->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FemaleMembers->Visible) { // FemaleMembers ?>
        <td data-name="FemaleMembers"<?= $Grid->FemaleMembers->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_FemaleMembers" class="el_nursery_FemaleMembers">
<input type="<?= $Grid->FemaleMembers->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FemaleMembers" id="x<?= $Grid->RowIndex ?>_FemaleMembers" data-table="nursery" data-field="x_FemaleMembers" value="<?= $Grid->FemaleMembers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FemaleMembers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FemaleMembers->formatPattern()) ?>"<?= $Grid->FemaleMembers->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FemaleMembers->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_FemaleMembers" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FemaleMembers" id="o<?= $Grid->RowIndex ?>_FemaleMembers" value="<?= HtmlEncode($Grid->FemaleMembers->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_FemaleMembers" class="el_nursery_FemaleMembers">
<input type="<?= $Grid->FemaleMembers->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FemaleMembers" id="x<?= $Grid->RowIndex ?>_FemaleMembers" data-table="nursery" data-field="x_FemaleMembers" value="<?= $Grid->FemaleMembers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FemaleMembers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FemaleMembers->formatPattern()) ?>"<?= $Grid->FemaleMembers->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FemaleMembers->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_FemaleMembers" class="el_nursery_FemaleMembers">
<span<?= $Grid->FemaleMembers->viewAttributes() ?>>
<?= $Grid->FemaleMembers->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_FemaleMembers" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_FemaleMembers" id="fnurserygrid$x<?= $Grid->RowIndex ?>_FemaleMembers" value="<?= HtmlEncode($Grid->FemaleMembers->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_FemaleMembers" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_FemaleMembers" id="fnurserygrid$o<?= $Grid->RowIndex ?>_FemaleMembers" value="<?= HtmlEncode($Grid->FemaleMembers->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->MaleMembers->Visible) { // MaleMembers ?>
        <td data-name="MaleMembers"<?= $Grid->MaleMembers->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_MaleMembers" class="el_nursery_MaleMembers">
<input type="<?= $Grid->MaleMembers->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_MaleMembers" id="x<?= $Grid->RowIndex ?>_MaleMembers" data-table="nursery" data-field="x_MaleMembers" value="<?= $Grid->MaleMembers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->MaleMembers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->MaleMembers->formatPattern()) ?>"<?= $Grid->MaleMembers->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->MaleMembers->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_MaleMembers" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_MaleMembers" id="o<?= $Grid->RowIndex ?>_MaleMembers" value="<?= HtmlEncode($Grid->MaleMembers->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_MaleMembers" class="el_nursery_MaleMembers">
<input type="<?= $Grid->MaleMembers->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_MaleMembers" id="x<?= $Grid->RowIndex ?>_MaleMembers" data-table="nursery" data-field="x_MaleMembers" value="<?= $Grid->MaleMembers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->MaleMembers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->MaleMembers->formatPattern()) ?>"<?= $Grid->MaleMembers->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->MaleMembers->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_MaleMembers" class="el_nursery_MaleMembers">
<span<?= $Grid->MaleMembers->viewAttributes() ?>>
<?= $Grid->MaleMembers->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_MaleMembers" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_MaleMembers" id="fnurserygrid$x<?= $Grid->RowIndex ?>_MaleMembers" value="<?= HtmlEncode($Grid->MaleMembers->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_MaleMembers" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_MaleMembers" id="fnurserygrid$o<?= $Grid->RowIndex ?>_MaleMembers" value="<?= HtmlEncode($Grid->MaleMembers->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->YoungFemales->Visible) { // YoungFemales ?>
        <td data-name="YoungFemales"<?= $Grid->YoungFemales->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_YoungFemales" class="el_nursery_YoungFemales">
<input type="<?= $Grid->YoungFemales->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_YoungFemales" id="x<?= $Grid->RowIndex ?>_YoungFemales" data-table="nursery" data-field="x_YoungFemales" value="<?= $Grid->YoungFemales->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->YoungFemales->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->YoungFemales->formatPattern()) ?>"<?= $Grid->YoungFemales->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->YoungFemales->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_YoungFemales" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_YoungFemales" id="o<?= $Grid->RowIndex ?>_YoungFemales" value="<?= HtmlEncode($Grid->YoungFemales->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_YoungFemales" class="el_nursery_YoungFemales">
<input type="<?= $Grid->YoungFemales->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_YoungFemales" id="x<?= $Grid->RowIndex ?>_YoungFemales" data-table="nursery" data-field="x_YoungFemales" value="<?= $Grid->YoungFemales->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->YoungFemales->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->YoungFemales->formatPattern()) ?>"<?= $Grid->YoungFemales->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->YoungFemales->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_YoungFemales" class="el_nursery_YoungFemales">
<span<?= $Grid->YoungFemales->viewAttributes() ?>>
<?= $Grid->YoungFemales->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_YoungFemales" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_YoungFemales" id="fnurserygrid$x<?= $Grid->RowIndex ?>_YoungFemales" value="<?= HtmlEncode($Grid->YoungFemales->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_YoungFemales" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_YoungFemales" id="fnurserygrid$o<?= $Grid->RowIndex ?>_YoungFemales" value="<?= HtmlEncode($Grid->YoungFemales->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->YoungMales->Visible) { // YoungMales ?>
        <td data-name="YoungMales"<?= $Grid->YoungMales->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_YoungMales" class="el_nursery_YoungMales">
<input type="<?= $Grid->YoungMales->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_YoungMales" id="x<?= $Grid->RowIndex ?>_YoungMales" data-table="nursery" data-field="x_YoungMales" value="<?= $Grid->YoungMales->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->YoungMales->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->YoungMales->formatPattern()) ?>"<?= $Grid->YoungMales->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->YoungMales->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_YoungMales" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_YoungMales" id="o<?= $Grid->RowIndex ?>_YoungMales" value="<?= HtmlEncode($Grid->YoungMales->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_YoungMales" class="el_nursery_YoungMales">
<input type="<?= $Grid->YoungMales->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_YoungMales" id="x<?= $Grid->RowIndex ?>_YoungMales" data-table="nursery" data-field="x_YoungMales" value="<?= $Grid->YoungMales->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->YoungMales->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->YoungMales->formatPattern()) ?>"<?= $Grid->YoungMales->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->YoungMales->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_YoungMales" class="el_nursery_YoungMales">
<span<?= $Grid->YoungMales->viewAttributes() ?>>
<?= $Grid->YoungMales->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_YoungMales" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_YoungMales" id="fnurserygrid$x<?= $Grid->RowIndex ?>_YoungMales" value="<?= HtmlEncode($Grid->YoungMales->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_YoungMales" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_YoungMales" id="fnurserygrid$o<?= $Grid->RowIndex ?>_YoungMales" value="<?= HtmlEncode($Grid->YoungMales->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->FemalesInManagement->Visible) { // FemalesInManagement ?>
        <td data-name="FemalesInManagement"<?= $Grid->FemalesInManagement->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_FemalesInManagement" class="el_nursery_FemalesInManagement">
<input type="<?= $Grid->FemalesInManagement->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FemalesInManagement" id="x<?= $Grid->RowIndex ?>_FemalesInManagement" data-table="nursery" data-field="x_FemalesInManagement" value="<?= $Grid->FemalesInManagement->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FemalesInManagement->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FemalesInManagement->formatPattern()) ?>"<?= $Grid->FemalesInManagement->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FemalesInManagement->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_FemalesInManagement" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_FemalesInManagement" id="o<?= $Grid->RowIndex ?>_FemalesInManagement" value="<?= HtmlEncode($Grid->FemalesInManagement->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_FemalesInManagement" class="el_nursery_FemalesInManagement">
<input type="<?= $Grid->FemalesInManagement->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_FemalesInManagement" id="x<?= $Grid->RowIndex ?>_FemalesInManagement" data-table="nursery" data-field="x_FemalesInManagement" value="<?= $Grid->FemalesInManagement->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->FemalesInManagement->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->FemalesInManagement->formatPattern()) ?>"<?= $Grid->FemalesInManagement->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->FemalesInManagement->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_FemalesInManagement" class="el_nursery_FemalesInManagement">
<span<?= $Grid->FemalesInManagement->viewAttributes() ?>>
<?= $Grid->FemalesInManagement->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_FemalesInManagement" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_FemalesInManagement" id="fnurserygrid$x<?= $Grid->RowIndex ?>_FemalesInManagement" value="<?= HtmlEncode($Grid->FemalesInManagement->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_FemalesInManagement" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_FemalesInManagement" id="fnurserygrid$o<?= $Grid->RowIndex ?>_FemalesInManagement" value="<?= HtmlEncode($Grid->FemalesInManagement->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->MalesInManagement->Visible) { // MalesInManagement ?>
        <td data-name="MalesInManagement"<?= $Grid->MalesInManagement->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_MalesInManagement" class="el_nursery_MalesInManagement">
<input type="<?= $Grid->MalesInManagement->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_MalesInManagement" id="x<?= $Grid->RowIndex ?>_MalesInManagement" data-table="nursery" data-field="x_MalesInManagement" value="<?= $Grid->MalesInManagement->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->MalesInManagement->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->MalesInManagement->formatPattern()) ?>"<?= $Grid->MalesInManagement->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->MalesInManagement->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_MalesInManagement" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_MalesInManagement" id="o<?= $Grid->RowIndex ?>_MalesInManagement" value="<?= HtmlEncode($Grid->MalesInManagement->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_MalesInManagement" class="el_nursery_MalesInManagement">
<input type="<?= $Grid->MalesInManagement->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_MalesInManagement" id="x<?= $Grid->RowIndex ?>_MalesInManagement" data-table="nursery" data-field="x_MalesInManagement" value="<?= $Grid->MalesInManagement->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->MalesInManagement->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->MalesInManagement->formatPattern()) ?>"<?= $Grid->MalesInManagement->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->MalesInManagement->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_MalesInManagement" class="el_nursery_MalesInManagement">
<span<?= $Grid->MalesInManagement->viewAttributes() ?>>
<?= $Grid->MalesInManagement->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_MalesInManagement" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_MalesInManagement" id="fnurserygrid$x<?= $Grid->RowIndex ?>_MalesInManagement" value="<?= HtmlEncode($Grid->MalesInManagement->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_MalesInManagement" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_MalesInManagement" id="fnurserygrid$o<?= $Grid->RowIndex ?>_MalesInManagement" value="<?= HtmlEncode($Grid->MalesInManagement->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Latitude->Visible) { // Latitude ?>
        <td data-name="Latitude"<?= $Grid->Latitude->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_Latitude" class="el_nursery_Latitude">
<input type="<?= $Grid->Latitude->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Latitude" id="x<?= $Grid->RowIndex ?>_Latitude" data-table="nursery" data-field="x_Latitude" value="<?= $Grid->Latitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Latitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Latitude->formatPattern()) ?>"<?= $Grid->Latitude->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Latitude->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_Latitude" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Latitude" id="o<?= $Grid->RowIndex ?>_Latitude" value="<?= HtmlEncode($Grid->Latitude->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_Latitude" class="el_nursery_Latitude">
<input type="<?= $Grid->Latitude->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Latitude" id="x<?= $Grid->RowIndex ?>_Latitude" data-table="nursery" data-field="x_Latitude" value="<?= $Grid->Latitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Latitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Latitude->formatPattern()) ?>"<?= $Grid->Latitude->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Latitude->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_Latitude" class="el_nursery_Latitude">
<span<?= $Grid->Latitude->viewAttributes() ?>>
<?= $Grid->Latitude->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_Latitude" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_Latitude" id="fnurserygrid$x<?= $Grid->RowIndex ?>_Latitude" value="<?= HtmlEncode($Grid->Latitude->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_Latitude" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_Latitude" id="fnurserygrid$o<?= $Grid->RowIndex ?>_Latitude" value="<?= HtmlEncode($Grid->Latitude->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Longitude->Visible) { // Longitude ?>
        <td data-name="Longitude"<?= $Grid->Longitude->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_Longitude" class="el_nursery_Longitude">
<input type="<?= $Grid->Longitude->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Longitude" id="x<?= $Grid->RowIndex ?>_Longitude" data-table="nursery" data-field="x_Longitude" value="<?= $Grid->Longitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Longitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Longitude->formatPattern()) ?>"<?= $Grid->Longitude->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Longitude->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="nursery" data-field="x_Longitude" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Longitude" id="o<?= $Grid->RowIndex ?>_Longitude" value="<?= HtmlEncode($Grid->Longitude->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_Longitude" class="el_nursery_Longitude">
<input type="<?= $Grid->Longitude->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Longitude" id="x<?= $Grid->RowIndex ?>_Longitude" data-table="nursery" data-field="x_Longitude" value="<?= $Grid->Longitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Longitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Longitude->formatPattern()) ?>"<?= $Grid->Longitude->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Longitude->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_nursery_Longitude" class="el_nursery_Longitude">
<span<?= $Grid->Longitude->viewAttributes() ?>>
<?= $Grid->Longitude->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="nursery" data-field="x_Longitude" data-hidden="1" name="fnurserygrid$x<?= $Grid->RowIndex ?>_Longitude" id="fnurserygrid$x<?= $Grid->RowIndex ?>_Longitude" value="<?= HtmlEncode($Grid->Longitude->FormValue) ?>">
<input type="hidden" data-table="nursery" data-field="x_Longitude" data-hidden="1" data-old name="fnurserygrid$o<?= $Grid->RowIndex ?>_Longitude" id="fnurserygrid$o<?= $Grid->RowIndex ?>_Longitude" value="<?= HtmlEncode($Grid->Longitude->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fnurserygrid","load"], () => fnurserygrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fnurserygrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("nursery");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
