<?php

namespace PHPMaker2024\cidp24;

// Page object
$NurseryEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<form name="fnurseryedit" id="fnurseryedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { nursery: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fnurseryedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fnurseryedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["ProvinceCode", [fields.ProvinceCode.visible && fields.ProvinceCode.required ? ew.Validators.required(fields.ProvinceCode.caption) : null], fields.ProvinceCode.isInvalid],
            ["DistrictCode", [fields.DistrictCode.visible && fields.DistrictCode.required ? ew.Validators.required(fields.DistrictCode.caption) : null], fields.DistrictCode.isInvalid],
            ["NurseryCode", [fields.NurseryCode.visible && fields.NurseryCode.required ? ew.Validators.required(fields.NurseryCode.caption) : null], fields.NurseryCode.isInvalid],
            ["NurseryName", [fields.NurseryName.visible && fields.NurseryName.required ? ew.Validators.required(fields.NurseryName.caption) : null], fields.NurseryName.isInvalid],
            ["NurseryType", [fields.NurseryType.visible && fields.NurseryType.required ? ew.Validators.required(fields.NurseryType.caption) : null], fields.NurseryType.isInvalid],
            ["PhysicalAddress", [fields.PhysicalAddress.visible && fields.PhysicalAddress.required ? ew.Validators.required(fields.PhysicalAddress.caption) : null], fields.PhysicalAddress.isInvalid],
            ["PostalAddress", [fields.PostalAddress.visible && fields.PostalAddress.required ? ew.Validators.required(fields.PostalAddress.caption) : null], fields.PostalAddress.isInvalid],
            ["Phone", [fields.Phone.visible && fields.Phone.required ? ew.Validators.required(fields.Phone.caption) : null], fields.Phone.isInvalid],
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null, ew.Validators.email], fields._Email.isInvalid],
            ["NurseryOwnership", [fields.NurseryOwnership.visible && fields.NurseryOwnership.required ? ew.Validators.required(fields.NurseryOwnership.caption) : null], fields.NurseryOwnership.isInvalid],
            ["SeedVariety", [fields.SeedVariety.visible && fields.SeedVariety.required ? ew.Validators.required(fields.SeedVariety.caption) : null], fields.SeedVariety.isInvalid],
            ["NumberOfMembers", [fields.NumberOfMembers.visible && fields.NumberOfMembers.required ? ew.Validators.required(fields.NumberOfMembers.caption) : null, ew.Validators.integer], fields.NumberOfMembers.isInvalid],
            ["FemaleMembers", [fields.FemaleMembers.visible && fields.FemaleMembers.required ? ew.Validators.required(fields.FemaleMembers.caption) : null, ew.Validators.integer], fields.FemaleMembers.isInvalid],
            ["MaleMembers", [fields.MaleMembers.visible && fields.MaleMembers.required ? ew.Validators.required(fields.MaleMembers.caption) : null, ew.Validators.integer], fields.MaleMembers.isInvalid],
            ["YoungFemales", [fields.YoungFemales.visible && fields.YoungFemales.required ? ew.Validators.required(fields.YoungFemales.caption) : null, ew.Validators.integer], fields.YoungFemales.isInvalid],
            ["YoungMales", [fields.YoungMales.visible && fields.YoungMales.required ? ew.Validators.required(fields.YoungMales.caption) : null, ew.Validators.integer], fields.YoungMales.isInvalid],
            ["FemalesInManagement", [fields.FemalesInManagement.visible && fields.FemalesInManagement.required ? ew.Validators.required(fields.FemalesInManagement.caption) : null, ew.Validators.integer], fields.FemalesInManagement.isInvalid],
            ["MalesInManagement", [fields.MalesInManagement.visible && fields.MalesInManagement.required ? ew.Validators.required(fields.MalesInManagement.caption) : null, ew.Validators.integer], fields.MalesInManagement.isInvalid],
            ["Latitude", [fields.Latitude.visible && fields.Latitude.required ? ew.Validators.required(fields.Latitude.caption) : null, ew.Validators.float], fields.Latitude.isInvalid],
            ["Longitude", [fields.Longitude.visible && fields.Longitude.required ? ew.Validators.required(fields.Longitude.caption) : null, ew.Validators.float], fields.Longitude.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "ProvinceCode": <?= $Page->ProvinceCode->toClientList($Page) ?>,
            "DistrictCode": <?= $Page->DistrictCode->toClientList($Page) ?>,
            "NurseryType": <?= $Page->NurseryType->toClientList($Page) ?>,
            "NurseryOwnership": <?= $Page->NurseryOwnership->toClientList($Page) ?>,
            "SeedVariety": <?= $Page->SeedVariety->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="nursery">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "district") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="district">
<input type="hidden" name="fk_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->getSessionValue()) ?>">
<input type="hidden" name="fk_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->ProvinceCode->Visible) { // ProvinceCode ?>
    <div id="r_ProvinceCode"<?= $Page->ProvinceCode->rowAttributes() ?>>
        <label id="elh_nursery_ProvinceCode" for="x_ProvinceCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProvinceCode->caption() ?><?= $Page->ProvinceCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProvinceCode->cellAttributes() ?>>
<?php if ($Page->ProvinceCode->getSessionValue() != "") { ?>
<span<?= $Page->ProvinceCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->ProvinceCode->getDisplayValue($Page->ProvinceCode->ViewValue) ?></span></span>
<input type="hidden" id="x_ProvinceCode" name="x_ProvinceCode" value="<?= HtmlEncode($Page->ProvinceCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_nursery_ProvinceCode">
    <select
        id="x_ProvinceCode"
        name="x_ProvinceCode"
        class="form-select ew-select<?= $Page->ProvinceCode->isInvalidClass() ?>"
        <?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
        data-select2-id="fnurseryedit_x_ProvinceCode"
        <?php } ?>
        data-table="nursery"
        data-field="x_ProvinceCode"
        data-value-separator="<?= $Page->ProvinceCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ProvinceCode->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->ProvinceCode->editAttributes() ?>>
        <?= $Page->ProvinceCode->selectOptionListHtml("x_ProvinceCode") ?>
    </select>
    <?= $Page->ProvinceCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->ProvinceCode->getErrorMessage() ?></div>
<?= $Page->ProvinceCode->Lookup->getParamTag($Page, "p_x_ProvinceCode") ?>
<?php if (!$Page->ProvinceCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurseryedit", function() {
    var options = { name: "x_ProvinceCode", selectId: "fnurseryedit_x_ProvinceCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurseryedit.lists.ProvinceCode?.lookupOptions.length) {
        options.data = { id: "x_ProvinceCode", form: "fnurseryedit" };
    } else {
        options.ajax = { id: "x_ProvinceCode", form: "fnurseryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.ProvinceCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->DistrictCode->Visible) { // DistrictCode ?>
    <div id="r_DistrictCode"<?= $Page->DistrictCode->rowAttributes() ?>>
        <label id="elh_nursery_DistrictCode" for="x_DistrictCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->DistrictCode->caption() ?><?= $Page->DistrictCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->DistrictCode->cellAttributes() ?>>
<?php if ($Page->DistrictCode->getSessionValue() != "") { ?>
<span<?= $Page->DistrictCode->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->DistrictCode->getDisplayValue($Page->DistrictCode->ViewValue) ?></span></span>
<input type="hidden" id="x_DistrictCode" name="x_DistrictCode" value="<?= HtmlEncode($Page->DistrictCode->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el_nursery_DistrictCode">
    <select
        id="x_DistrictCode"
        name="x_DistrictCode"
        class="form-select ew-select<?= $Page->DistrictCode->isInvalidClass() ?>"
        <?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
        data-select2-id="fnurseryedit_x_DistrictCode"
        <?php } ?>
        data-table="nursery"
        data-field="x_DistrictCode"
        data-value-separator="<?= $Page->DistrictCode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->DistrictCode->getPlaceHolder()) ?>"
        <?= $Page->DistrictCode->editAttributes() ?>>
        <?= $Page->DistrictCode->selectOptionListHtml("x_DistrictCode") ?>
    </select>
    <?= $Page->DistrictCode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->DistrictCode->getErrorMessage() ?></div>
<?= $Page->DistrictCode->Lookup->getParamTag($Page, "p_x_DistrictCode") ?>
<?php if (!$Page->DistrictCode->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurseryedit", function() {
    var options = { name: "x_DistrictCode", selectId: "fnurseryedit_x_DistrictCode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurseryedit.lists.DistrictCode?.lookupOptions.length) {
        options.data = { id: "x_DistrictCode", form: "fnurseryedit" };
    } else {
        options.ajax = { id: "x_DistrictCode", form: "fnurseryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.DistrictCode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NurseryCode->Visible) { // NurseryCode ?>
    <div id="r_NurseryCode"<?= $Page->NurseryCode->rowAttributes() ?>>
        <label id="elh_nursery_NurseryCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NurseryCode->caption() ?><?= $Page->NurseryCode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NurseryCode->cellAttributes() ?>>
<span id="el_nursery_NurseryCode">
<span<?= $Page->NurseryCode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->NurseryCode->getDisplayValue($Page->NurseryCode->EditValue))) ?>"></span>
<input type="hidden" data-table="nursery" data-field="x_NurseryCode" data-hidden="1" name="x_NurseryCode" id="x_NurseryCode" value="<?= HtmlEncode($Page->NurseryCode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NurseryName->Visible) { // NurseryName ?>
    <div id="r_NurseryName"<?= $Page->NurseryName->rowAttributes() ?>>
        <label id="elh_nursery_NurseryName" for="x_NurseryName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NurseryName->caption() ?><?= $Page->NurseryName->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NurseryName->cellAttributes() ?>>
<span id="el_nursery_NurseryName">
<input type="<?= $Page->NurseryName->getInputTextType() ?>" name="x_NurseryName" id="x_NurseryName" data-table="nursery" data-field="x_NurseryName" value="<?= $Page->NurseryName->EditValue ?>" size="50" maxlength="255" placeholder="<?= HtmlEncode($Page->NurseryName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NurseryName->formatPattern()) ?>"<?= $Page->NurseryName->editAttributes() ?> aria-describedby="x_NurseryName_help">
<?= $Page->NurseryName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->NurseryName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NurseryType->Visible) { // NurseryType ?>
    <div id="r_NurseryType"<?= $Page->NurseryType->rowAttributes() ?>>
        <label id="elh_nursery_NurseryType" for="x_NurseryType" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NurseryType->caption() ?><?= $Page->NurseryType->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NurseryType->cellAttributes() ?>>
<span id="el_nursery_NurseryType">
    <select
        id="x_NurseryType"
        name="x_NurseryType"
        class="form-select ew-select<?= $Page->NurseryType->isInvalidClass() ?>"
        <?php if (!$Page->NurseryType->IsNativeSelect) { ?>
        data-select2-id="fnurseryedit_x_NurseryType"
        <?php } ?>
        data-table="nursery"
        data-field="x_NurseryType"
        data-value-separator="<?= $Page->NurseryType->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->NurseryType->getPlaceHolder()) ?>"
        <?= $Page->NurseryType->editAttributes() ?>>
        <?= $Page->NurseryType->selectOptionListHtml("x_NurseryType") ?>
    </select>
    <?= $Page->NurseryType->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->NurseryType->getErrorMessage() ?></div>
<?= $Page->NurseryType->Lookup->getParamTag($Page, "p_x_NurseryType") ?>
<?php if (!$Page->NurseryType->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurseryedit", function() {
    var options = { name: "x_NurseryType", selectId: "fnurseryedit_x_NurseryType" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurseryedit.lists.NurseryType?.lookupOptions.length) {
        options.data = { id: "x_NurseryType", form: "fnurseryedit" };
    } else {
        options.ajax = { id: "x_NurseryType", form: "fnurseryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.NurseryType.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PhysicalAddress->Visible) { // PhysicalAddress ?>
    <div id="r_PhysicalAddress"<?= $Page->PhysicalAddress->rowAttributes() ?>>
        <label id="elh_nursery_PhysicalAddress" for="x_PhysicalAddress" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PhysicalAddress->caption() ?><?= $Page->PhysicalAddress->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PhysicalAddress->cellAttributes() ?>>
<span id="el_nursery_PhysicalAddress">
<textarea data-table="nursery" data-field="x_PhysicalAddress" name="x_PhysicalAddress" id="x_PhysicalAddress" cols="35" rows="2" placeholder="<?= HtmlEncode($Page->PhysicalAddress->getPlaceHolder()) ?>"<?= $Page->PhysicalAddress->editAttributes() ?> aria-describedby="x_PhysicalAddress_help"><?= $Page->PhysicalAddress->EditValue ?></textarea>
<?= $Page->PhysicalAddress->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PhysicalAddress->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->PostalAddress->Visible) { // PostalAddress ?>
    <div id="r_PostalAddress"<?= $Page->PostalAddress->rowAttributes() ?>>
        <label id="elh_nursery_PostalAddress" for="x_PostalAddress" class="<?= $Page->LeftColumnClass ?>"><?= $Page->PostalAddress->caption() ?><?= $Page->PostalAddress->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->PostalAddress->cellAttributes() ?>>
<span id="el_nursery_PostalAddress">
<textarea data-table="nursery" data-field="x_PostalAddress" name="x_PostalAddress" id="x_PostalAddress" cols="35" rows="2" placeholder="<?= HtmlEncode($Page->PostalAddress->getPlaceHolder()) ?>"<?= $Page->PostalAddress->editAttributes() ?> aria-describedby="x_PostalAddress_help"><?= $Page->PostalAddress->EditValue ?></textarea>
<?= $Page->PostalAddress->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->PostalAddress->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Phone->Visible) { // Phone ?>
    <div id="r_Phone"<?= $Page->Phone->rowAttributes() ?>>
        <label id="elh_nursery_Phone" for="x_Phone" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Phone->caption() ?><?= $Page->Phone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Phone->cellAttributes() ?>>
<span id="el_nursery_Phone">
<input type="<?= $Page->Phone->getInputTextType() ?>" name="x_Phone" id="x_Phone" data-table="nursery" data-field="x_Phone" value="<?= $Page->Phone->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Phone->formatPattern()) ?>"<?= $Page->Phone->editAttributes() ?> aria-describedby="x_Phone_help">
<?= $Page->Phone->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Phone->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_Email->Visible) { // Email ?>
    <div id="r__Email"<?= $Page->_Email->rowAttributes() ?>>
        <label id="elh_nursery__Email" for="x__Email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_Email->caption() ?><?= $Page->_Email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Email->cellAttributes() ?>>
<span id="el_nursery__Email">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="nursery" data-field="x__Email" value="<?= $Page->_Email->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?> aria-describedby="x__Email_help">
<?= $Page->_Email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NurseryOwnership->Visible) { // NurseryOwnership ?>
    <div id="r_NurseryOwnership"<?= $Page->NurseryOwnership->rowAttributes() ?>>
        <label id="elh_nursery_NurseryOwnership" for="x_NurseryOwnership" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NurseryOwnership->caption() ?><?= $Page->NurseryOwnership->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NurseryOwnership->cellAttributes() ?>>
<span id="el_nursery_NurseryOwnership">
    <select
        id="x_NurseryOwnership"
        name="x_NurseryOwnership"
        class="form-select ew-select<?= $Page->NurseryOwnership->isInvalidClass() ?>"
        <?php if (!$Page->NurseryOwnership->IsNativeSelect) { ?>
        data-select2-id="fnurseryedit_x_NurseryOwnership"
        <?php } ?>
        data-table="nursery"
        data-field="x_NurseryOwnership"
        data-value-separator="<?= $Page->NurseryOwnership->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->NurseryOwnership->getPlaceHolder()) ?>"
        <?= $Page->NurseryOwnership->editAttributes() ?>>
        <?= $Page->NurseryOwnership->selectOptionListHtml("x_NurseryOwnership") ?>
    </select>
    <?= $Page->NurseryOwnership->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->NurseryOwnership->getErrorMessage() ?></div>
<?= $Page->NurseryOwnership->Lookup->getParamTag($Page, "p_x_NurseryOwnership") ?>
<?php if (!$Page->NurseryOwnership->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurseryedit", function() {
    var options = { name: "x_NurseryOwnership", selectId: "fnurseryedit_x_NurseryOwnership" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurseryedit.lists.NurseryOwnership?.lookupOptions.length) {
        options.data = { id: "x_NurseryOwnership", form: "fnurseryedit" };
    } else {
        options.ajax = { id: "x_NurseryOwnership", form: "fnurseryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.NurseryOwnership.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->SeedVariety->Visible) { // SeedVariety ?>
    <div id="r_SeedVariety"<?= $Page->SeedVariety->rowAttributes() ?>>
        <label id="elh_nursery_SeedVariety" for="x_SeedVariety" class="<?= $Page->LeftColumnClass ?>"><?= $Page->SeedVariety->caption() ?><?= $Page->SeedVariety->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->SeedVariety->cellAttributes() ?>>
<span id="el_nursery_SeedVariety">
    <select
        id="x_SeedVariety"
        name="x_SeedVariety"
        class="form-select ew-select<?= $Page->SeedVariety->isInvalidClass() ?>"
        <?php if (!$Page->SeedVariety->IsNativeSelect) { ?>
        data-select2-id="fnurseryedit_x_SeedVariety"
        <?php } ?>
        data-table="nursery"
        data-field="x_SeedVariety"
        data-value-separator="<?= $Page->SeedVariety->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->SeedVariety->getPlaceHolder()) ?>"
        <?= $Page->SeedVariety->editAttributes() ?>>
        <?= $Page->SeedVariety->selectOptionListHtml("x_SeedVariety") ?>
    </select>
    <?= $Page->SeedVariety->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->SeedVariety->getErrorMessage() ?></div>
<?= $Page->SeedVariety->Lookup->getParamTag($Page, "p_x_SeedVariety") ?>
<?php if (!$Page->SeedVariety->IsNativeSelect) { ?>
<script>
loadjs.ready("fnurseryedit", function() {
    var options = { name: "x_SeedVariety", selectId: "fnurseryedit_x_SeedVariety" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fnurseryedit.lists.SeedVariety?.lookupOptions.length) {
        options.data = { id: "x_SeedVariety", form: "fnurseryedit" };
    } else {
        options.ajax = { id: "x_SeedVariety", form: "fnurseryedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.nursery.fields.SeedVariety.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->NumberOfMembers->Visible) { // NumberOfMembers ?>
    <div id="r_NumberOfMembers"<?= $Page->NumberOfMembers->rowAttributes() ?>>
        <label id="elh_nursery_NumberOfMembers" for="x_NumberOfMembers" class="<?= $Page->LeftColumnClass ?>"><?= $Page->NumberOfMembers->caption() ?><?= $Page->NumberOfMembers->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->NumberOfMembers->cellAttributes() ?>>
<span id="el_nursery_NumberOfMembers">
<input type="<?= $Page->NumberOfMembers->getInputTextType() ?>" name="x_NumberOfMembers" id="x_NumberOfMembers" data-table="nursery" data-field="x_NumberOfMembers" value="<?= $Page->NumberOfMembers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->NumberOfMembers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NumberOfMembers->formatPattern()) ?>"<?= $Page->NumberOfMembers->editAttributes() ?> aria-describedby="x_NumberOfMembers_help">
<?= $Page->NumberOfMembers->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->NumberOfMembers->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FemaleMembers->Visible) { // FemaleMembers ?>
    <div id="r_FemaleMembers"<?= $Page->FemaleMembers->rowAttributes() ?>>
        <label id="elh_nursery_FemaleMembers" for="x_FemaleMembers" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FemaleMembers->caption() ?><?= $Page->FemaleMembers->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FemaleMembers->cellAttributes() ?>>
<span id="el_nursery_FemaleMembers">
<input type="<?= $Page->FemaleMembers->getInputTextType() ?>" name="x_FemaleMembers" id="x_FemaleMembers" data-table="nursery" data-field="x_FemaleMembers" value="<?= $Page->FemaleMembers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FemaleMembers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FemaleMembers->formatPattern()) ?>"<?= $Page->FemaleMembers->editAttributes() ?> aria-describedby="x_FemaleMembers_help">
<?= $Page->FemaleMembers->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FemaleMembers->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->MaleMembers->Visible) { // MaleMembers ?>
    <div id="r_MaleMembers"<?= $Page->MaleMembers->rowAttributes() ?>>
        <label id="elh_nursery_MaleMembers" for="x_MaleMembers" class="<?= $Page->LeftColumnClass ?>"><?= $Page->MaleMembers->caption() ?><?= $Page->MaleMembers->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->MaleMembers->cellAttributes() ?>>
<span id="el_nursery_MaleMembers">
<input type="<?= $Page->MaleMembers->getInputTextType() ?>" name="x_MaleMembers" id="x_MaleMembers" data-table="nursery" data-field="x_MaleMembers" value="<?= $Page->MaleMembers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->MaleMembers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->MaleMembers->formatPattern()) ?>"<?= $Page->MaleMembers->editAttributes() ?> aria-describedby="x_MaleMembers_help">
<?= $Page->MaleMembers->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->MaleMembers->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->YoungFemales->Visible) { // YoungFemales ?>
    <div id="r_YoungFemales"<?= $Page->YoungFemales->rowAttributes() ?>>
        <label id="elh_nursery_YoungFemales" for="x_YoungFemales" class="<?= $Page->LeftColumnClass ?>"><?= $Page->YoungFemales->caption() ?><?= $Page->YoungFemales->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->YoungFemales->cellAttributes() ?>>
<span id="el_nursery_YoungFemales">
<input type="<?= $Page->YoungFemales->getInputTextType() ?>" name="x_YoungFemales" id="x_YoungFemales" data-table="nursery" data-field="x_YoungFemales" value="<?= $Page->YoungFemales->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->YoungFemales->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->YoungFemales->formatPattern()) ?>"<?= $Page->YoungFemales->editAttributes() ?> aria-describedby="x_YoungFemales_help">
<?= $Page->YoungFemales->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->YoungFemales->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->YoungMales->Visible) { // YoungMales ?>
    <div id="r_YoungMales"<?= $Page->YoungMales->rowAttributes() ?>>
        <label id="elh_nursery_YoungMales" for="x_YoungMales" class="<?= $Page->LeftColumnClass ?>"><?= $Page->YoungMales->caption() ?><?= $Page->YoungMales->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->YoungMales->cellAttributes() ?>>
<span id="el_nursery_YoungMales">
<input type="<?= $Page->YoungMales->getInputTextType() ?>" name="x_YoungMales" id="x_YoungMales" data-table="nursery" data-field="x_YoungMales" value="<?= $Page->YoungMales->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->YoungMales->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->YoungMales->formatPattern()) ?>"<?= $Page->YoungMales->editAttributes() ?> aria-describedby="x_YoungMales_help">
<?= $Page->YoungMales->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->YoungMales->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FemalesInManagement->Visible) { // FemalesInManagement ?>
    <div id="r_FemalesInManagement"<?= $Page->FemalesInManagement->rowAttributes() ?>>
        <label id="elh_nursery_FemalesInManagement" for="x_FemalesInManagement" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FemalesInManagement->caption() ?><?= $Page->FemalesInManagement->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FemalesInManagement->cellAttributes() ?>>
<span id="el_nursery_FemalesInManagement">
<input type="<?= $Page->FemalesInManagement->getInputTextType() ?>" name="x_FemalesInManagement" id="x_FemalesInManagement" data-table="nursery" data-field="x_FemalesInManagement" value="<?= $Page->FemalesInManagement->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->FemalesInManagement->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FemalesInManagement->formatPattern()) ?>"<?= $Page->FemalesInManagement->editAttributes() ?> aria-describedby="x_FemalesInManagement_help">
<?= $Page->FemalesInManagement->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FemalesInManagement->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->MalesInManagement->Visible) { // MalesInManagement ?>
    <div id="r_MalesInManagement"<?= $Page->MalesInManagement->rowAttributes() ?>>
        <label id="elh_nursery_MalesInManagement" for="x_MalesInManagement" class="<?= $Page->LeftColumnClass ?>"><?= $Page->MalesInManagement->caption() ?><?= $Page->MalesInManagement->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->MalesInManagement->cellAttributes() ?>>
<span id="el_nursery_MalesInManagement">
<input type="<?= $Page->MalesInManagement->getInputTextType() ?>" name="x_MalesInManagement" id="x_MalesInManagement" data-table="nursery" data-field="x_MalesInManagement" value="<?= $Page->MalesInManagement->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->MalesInManagement->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->MalesInManagement->formatPattern()) ?>"<?= $Page->MalesInManagement->editAttributes() ?> aria-describedby="x_MalesInManagement_help">
<?= $Page->MalesInManagement->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->MalesInManagement->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Latitude->Visible) { // Latitude ?>
    <div id="r_Latitude"<?= $Page->Latitude->rowAttributes() ?>>
        <label id="elh_nursery_Latitude" for="x_Latitude" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Latitude->caption() ?><?= $Page->Latitude->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Latitude->cellAttributes() ?>>
<span id="el_nursery_Latitude">
<input type="<?= $Page->Latitude->getInputTextType() ?>" name="x_Latitude" id="x_Latitude" data-table="nursery" data-field="x_Latitude" value="<?= $Page->Latitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Latitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Latitude->formatPattern()) ?>"<?= $Page->Latitude->editAttributes() ?> aria-describedby="x_Latitude_help">
<?= $Page->Latitude->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Latitude->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Longitude->Visible) { // Longitude ?>
    <div id="r_Longitude"<?= $Page->Longitude->rowAttributes() ?>>
        <label id="elh_nursery_Longitude" for="x_Longitude" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Longitude->caption() ?><?= $Page->Longitude->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Longitude->cellAttributes() ?>>
<span id="el_nursery_Longitude">
<input type="<?= $Page->Longitude->getInputTextType() ?>" name="x_Longitude" id="x_Longitude" data-table="nursery" data-field="x_Longitude" value="<?= $Page->Longitude->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Longitude->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Longitude->formatPattern()) ?>"<?= $Page->Longitude->editAttributes() ?> aria-describedby="x_Longitude_help">
<?= $Page->Longitude->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Longitude->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fnurseryedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fnurseryedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php if (!$Page->IsModal) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("nursery");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
